/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LoadBalancerIngress;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="LoadBalancerStatus represents the status of a load-balancer.")
public class V1LoadBalancerStatus {
    public static final String SERIALIZED_NAME_INGRESS = "ingress";
    @SerializedName(value="ingress")
    private List<V1LoadBalancerIngress> ingress = new ArrayList<V1LoadBalancerIngress>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1LoadBalancerStatus ingress(List<V1LoadBalancerIngress> ingress) {
        this.ingress = ingress;
        return this;
    }

    public V1LoadBalancerStatus addIngressItem(V1LoadBalancerIngress ingressItem) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<V1LoadBalancerIngress>();
        }
        this.ingress.add(ingressItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Ingress is a list containing ingress points for the load-balancer. Traffic intended for the service should be sent to these ingress points.")
    public List<V1LoadBalancerIngress> getIngress() {
        return this.ingress;
    }

    public void setIngress(List<V1LoadBalancerIngress> ingress) {
        this.ingress = ingress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LoadBalancerStatus v1LoadBalancerStatus = (V1LoadBalancerStatus)o;
        return Objects.equals(this.ingress, v1LoadBalancerStatus.ingress);
    }

    public int hashCode() {
        return Objects.hash(this.ingress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LoadBalancerStatus {\n");
        sb.append("    ingress: ").append(this.toIndentedString(this.ingress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayingress;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1LoadBalancerStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1LoadBalancerStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_INGRESS) != null && !jsonObj.get(SERIALIZED_NAME_INGRESS).isJsonNull() && (jsonArrayingress = jsonObj.getAsJsonArray(SERIALIZED_NAME_INGRESS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_INGRESS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `ingress` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INGRESS).toString()));
            }
            for (int i = 0; i < jsonArrayingress.size(); ++i) {
                V1LoadBalancerIngress.validateJsonElement(jsonArrayingress.get(i));
            }
        }
    }

    public static V1LoadBalancerStatus fromJson(String jsonString) throws IOException {
        return (V1LoadBalancerStatus)JSON.getGson().fromJson(jsonString, V1LoadBalancerStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_INGRESS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1LoadBalancerStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1LoadBalancerStatus.class));
            return new TypeAdapter<V1LoadBalancerStatus>(){

                public void write(JsonWriter out, V1LoadBalancerStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1LoadBalancerStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1LoadBalancerStatus.validateJsonElement(jsonElement);
                    return (V1LoadBalancerStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

