/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="CronJobStatus represents the current state of a cron job.")
public class V1CronJobStatus {
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private List<V1ObjectReference> active = new ArrayList<V1ObjectReference>();
    public static final String SERIALIZED_NAME_LAST_SCHEDULE_TIME = "lastScheduleTime";
    @SerializedName(value="lastScheduleTime")
    private OffsetDateTime lastScheduleTime;
    public static final String SERIALIZED_NAME_LAST_SUCCESSFUL_TIME = "lastSuccessfulTime";
    @SerializedName(value="lastSuccessfulTime")
    private OffsetDateTime lastSuccessfulTime;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1CronJobStatus active(List<V1ObjectReference> active) {
        this.active = active;
        return this;
    }

    public V1CronJobStatus addActiveItem(V1ObjectReference activeItem) {
        if (this.active == null) {
            this.active = new ArrayList<V1ObjectReference>();
        }
        this.active.add(activeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of pointers to currently running jobs.")
    public List<V1ObjectReference> getActive() {
        return this.active;
    }

    public void setActive(List<V1ObjectReference> active) {
        this.active = active;
    }

    public V1CronJobStatus lastScheduleTime(OffsetDateTime lastScheduleTime) {
        this.lastScheduleTime = lastScheduleTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Information when was the last time the job was successfully scheduled.")
    public OffsetDateTime getLastScheduleTime() {
        return this.lastScheduleTime;
    }

    public void setLastScheduleTime(OffsetDateTime lastScheduleTime) {
        this.lastScheduleTime = lastScheduleTime;
    }

    public V1CronJobStatus lastSuccessfulTime(OffsetDateTime lastSuccessfulTime) {
        this.lastSuccessfulTime = lastSuccessfulTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Information when was the last time the job successfully completed.")
    public OffsetDateTime getLastSuccessfulTime() {
        return this.lastSuccessfulTime;
    }

    public void setLastSuccessfulTime(OffsetDateTime lastSuccessfulTime) {
        this.lastSuccessfulTime = lastSuccessfulTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CronJobStatus v1CronJobStatus = (V1CronJobStatus)o;
        return Objects.equals(this.active, v1CronJobStatus.active) && Objects.equals(this.lastScheduleTime, v1CronJobStatus.lastScheduleTime) && Objects.equals(this.lastSuccessfulTime, v1CronJobStatus.lastSuccessfulTime);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.lastScheduleTime, this.lastSuccessfulTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CronJobStatus {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    lastScheduleTime: ").append(this.toIndentedString(this.lastScheduleTime)).append("\n");
        sb.append("    lastSuccessfulTime: ").append(this.toIndentedString(this.lastSuccessfulTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayactive;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1CronJobStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1CronJobStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ACTIVE) != null && !jsonObj.get(SERIALIZED_NAME_ACTIVE).isJsonNull() && (jsonArrayactive = jsonObj.getAsJsonArray(SERIALIZED_NAME_ACTIVE)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ACTIVE).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `active` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTIVE).toString()));
            }
            for (int i = 0; i < jsonArrayactive.size(); ++i) {
                V1ObjectReference.validateJsonElement(jsonArrayactive.get(i));
            }
        }
    }

    public static V1CronJobStatus fromJson(String jsonString) throws IOException {
        return (V1CronJobStatus)JSON.getGson().fromJson(jsonString, V1CronJobStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTIVE);
        openapiFields.add(SERIALIZED_NAME_LAST_SCHEDULE_TIME);
        openapiFields.add(SERIALIZED_NAME_LAST_SUCCESSFUL_TIME);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1CronJobStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1CronJobStatus.class));
            return new TypeAdapter<V1CronJobStatus>(){

                public void write(JsonWriter out, V1CronJobStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1CronJobStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1CronJobStatus.validateJsonElement(jsonElement);
                    return (V1CronJobStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

