/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with \"WaitForFirstConsumer\" allocation mode.")
public class V1alpha3ResourceClaimSchedulingStatus {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_UNSUITABLE_NODES = "unsuitableNodes";
    @SerializedName(value="unsuitableNodes")
    private List<String> unsuitableNodes = null;

    public V1alpha3ResourceClaimSchedulingStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name matches the pod.spec.resourceClaims[*].Name field.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1alpha3ResourceClaimSchedulingStatus unsuitableNodes(List<String> unsuitableNodes) {
        this.unsuitableNodes = unsuitableNodes;
        return this;
    }

    public V1alpha3ResourceClaimSchedulingStatus addUnsuitableNodesItem(String unsuitableNodesItem) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        this.unsuitableNodes.add(unsuitableNodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.  The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.")
    public List<String> getUnsuitableNodes() {
        return this.unsuitableNodes;
    }

    public void setUnsuitableNodes(List<String> unsuitableNodes) {
        this.unsuitableNodes = unsuitableNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3ResourceClaimSchedulingStatus v1alpha3ResourceClaimSchedulingStatus = (V1alpha3ResourceClaimSchedulingStatus)o;
        return Objects.equals(this.name, v1alpha3ResourceClaimSchedulingStatus.name) && Objects.equals(this.unsuitableNodes, v1alpha3ResourceClaimSchedulingStatus.unsuitableNodes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.unsuitableNodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3ResourceClaimSchedulingStatus {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    unsuitableNodes: ").append(this.toIndentedString(this.unsuitableNodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

