/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.apis;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.ApiResponse;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.Pair;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V1beta1IPAddress;
import io.kubernetes.client.openapi.models.V1beta1IPAddressList;
import io.kubernetes.client.openapi.models.V1beta1ServiceCIDR;
import io.kubernetes.client.openapi.models.V1beta1ServiceCIDRList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class NetworkingV1beta1Api {
    private ApiClient localVarApiClient;

    public NetworkingV1beta1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public NetworkingV1beta1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createIPAddressCall(V1beta1IPAddress body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1beta1IPAddress localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/ipaddresses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createIPAddressValidateBeforeCall(V1beta1IPAddress body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createIPAddress(Async)");
        }
        Call localVarCall = this.createIPAddressCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1beta1IPAddress createIPAddress(V1beta1IPAddress body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1beta1IPAddress> localVarResp = this.createIPAddressWithHttpInfo(body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1beta1IPAddress> createIPAddressWithHttpInfo(V1beta1IPAddress body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.createIPAddressValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1beta1IPAddress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createIPAddressAsync(V1beta1IPAddress body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1beta1IPAddress> _callback) throws ApiException {
        Call localVarCall = this.createIPAddressValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1beta1IPAddress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createServiceCIDRCall(V1beta1ServiceCIDR body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1beta1ServiceCIDR localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/servicecidrs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createServiceCIDRValidateBeforeCall(V1beta1ServiceCIDR body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createServiceCIDR(Async)");
        }
        Call localVarCall = this.createServiceCIDRCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1beta1ServiceCIDR createServiceCIDR(V1beta1ServiceCIDR body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1beta1ServiceCIDR> localVarResp = this.createServiceCIDRWithHttpInfo(body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1beta1ServiceCIDR> createServiceCIDRWithHttpInfo(V1beta1ServiceCIDR body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.createServiceCIDRValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1beta1ServiceCIDR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createServiceCIDRAsync(V1beta1ServiceCIDR body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1beta1ServiceCIDR> _callback) throws ApiException {
        Call localVarCall = this.createServiceCIDRValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1beta1ServiceCIDR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCollectionIPAddressCall(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/ipaddresses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionIPAddressValidateBeforeCall(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionIPAddressCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        return localVarCall;
    }

    public V1Status deleteCollectionIPAddress(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        ApiResponse<V1Status> localVarResp = this.deleteCollectionIPAddressWithHttpInfo(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body);
        return localVarResp.getData();
    }

    public ApiResponse<V1Status> deleteCollectionIPAddressWithHttpInfo(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionIPAddressValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCollectionIPAddressAsync(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionIPAddressValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteCollectionServiceCIDRCall(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/servicecidrs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionServiceCIDRValidateBeforeCall(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionServiceCIDRCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        return localVarCall;
    }

    public V1Status deleteCollectionServiceCIDR(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        ApiResponse<V1Status> localVarResp = this.deleteCollectionServiceCIDRWithHttpInfo(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body);
        return localVarResp.getData();
    }

    public ApiResponse<V1Status> deleteCollectionServiceCIDRWithHttpInfo(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionServiceCIDRValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteCollectionServiceCIDRAsync(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionServiceCIDRValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteIPAddressCall(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/ipaddresses/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteIPAddressValidateBeforeCall(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteIPAddress(Async)");
        }
        Call localVarCall = this.deleteIPAddressCall(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, _callback);
        return localVarCall;
    }

    public V1Status deleteIPAddress(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        ApiResponse<V1Status> localVarResp = this.deleteIPAddressWithHttpInfo(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body);
        return localVarResp.getData();
    }

    public ApiResponse<V1Status> deleteIPAddressWithHttpInfo(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteIPAddressValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteIPAddressAsync(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteIPAddressValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteServiceCIDRCall(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/servicecidrs/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteServiceCIDRValidateBeforeCall(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteServiceCIDR(Async)");
        }
        Call localVarCall = this.deleteServiceCIDRCall(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, _callback);
        return localVarCall;
    }

    public V1Status deleteServiceCIDR(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        ApiResponse<V1Status> localVarResp = this.deleteServiceCIDRWithHttpInfo(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body);
        return localVarResp.getData();
    }

    public ApiResponse<V1Status> deleteServiceCIDRWithHttpInfo(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteServiceCIDRValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteServiceCIDRAsync(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteServiceCIDRValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAPIResourcesCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIResourcesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesCall(_callback);
        return localVarCall;
    }

    public V1APIResourceList getAPIResources() throws ApiException {
        ApiResponse<V1APIResourceList> localVarResp = this.getAPIResourcesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAPIResourcesAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listIPAddressCall(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/ipaddresses";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listIPAddressValidateBeforeCall(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listIPAddressCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        return localVarCall;
    }

    public V1beta1IPAddressList listIPAddress(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V1beta1IPAddressList> localVarResp = this.listIPAddressWithHttpInfo(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch);
        return localVarResp.getData();
    }

    public ApiResponse<V1beta1IPAddressList> listIPAddressWithHttpInfo(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listIPAddressValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1beta1IPAddressList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listIPAddressAsync(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback<V1beta1IPAddressList> _callback) throws ApiException {
        Call localVarCall = this.listIPAddressValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1beta1IPAddressList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listServiceCIDRCall(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/servicecidrs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listServiceCIDRValidateBeforeCall(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.listServiceCIDRCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        return localVarCall;
    }

    public V1beta1ServiceCIDRList listServiceCIDR(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        ApiResponse<V1beta1ServiceCIDRList> localVarResp = this.listServiceCIDRWithHttpInfo(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch);
        return localVarResp.getData();
    }

    public ApiResponse<V1beta1ServiceCIDRList> listServiceCIDRWithHttpInfo(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listServiceCIDRValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1beta1ServiceCIDRList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listServiceCIDRAsync(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback<V1beta1ServiceCIDRList> _callback) throws ApiException {
        Call localVarCall = this.listServiceCIDRValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1beta1ServiceCIDRList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchIPAddressCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/ipaddresses/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchIPAddressValidateBeforeCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchIPAddress(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchIPAddress(Async)");
        }
        Call localVarCall = this.patchIPAddressCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public V1beta1IPAddress patchIPAddress(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<V1beta1IPAddress> localVarResp = this.patchIPAddressWithHttpInfo(name, body, pretty, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<V1beta1IPAddress> patchIPAddressWithHttpInfo(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchIPAddressValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1beta1IPAddress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchIPAddressAsync(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1beta1IPAddress> _callback) throws ApiException {
        Call localVarCall = this.patchIPAddressValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1beta1IPAddress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchServiceCIDRCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/servicecidrs/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchServiceCIDRValidateBeforeCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchServiceCIDR(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchServiceCIDR(Async)");
        }
        Call localVarCall = this.patchServiceCIDRCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public V1beta1ServiceCIDR patchServiceCIDR(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<V1beta1ServiceCIDR> localVarResp = this.patchServiceCIDRWithHttpInfo(name, body, pretty, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<V1beta1ServiceCIDR> patchServiceCIDRWithHttpInfo(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchServiceCIDRValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1beta1ServiceCIDR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchServiceCIDRAsync(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1beta1ServiceCIDR> _callback) throws ApiException {
        Call localVarCall = this.patchServiceCIDRValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1beta1ServiceCIDR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchServiceCIDRStatusCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/servicecidrs/{name}/status".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchServiceCIDRStatusValidateBeforeCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchServiceCIDRStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchServiceCIDRStatus(Async)");
        }
        Call localVarCall = this.patchServiceCIDRStatusCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        return localVarCall;
    }

    public V1beta1ServiceCIDR patchServiceCIDRStatus(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        ApiResponse<V1beta1ServiceCIDR> localVarResp = this.patchServiceCIDRStatusWithHttpInfo(name, body, pretty, dryRun, fieldManager, fieldValidation, force);
        return localVarResp.getData();
    }

    public ApiResponse<V1beta1ServiceCIDR> patchServiceCIDRStatusWithHttpInfo(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchServiceCIDRStatusValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1beta1ServiceCIDR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchServiceCIDRStatusAsync(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1beta1ServiceCIDR> _callback) throws ApiException {
        Call localVarCall = this.patchServiceCIDRStatusValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1beta1ServiceCIDR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readIPAddressCall(String name, String pretty, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/ipaddresses/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readIPAddressValidateBeforeCall(String name, String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readIPAddress(Async)");
        }
        Call localVarCall = this.readIPAddressCall(name, pretty, _callback);
        return localVarCall;
    }

    public V1beta1IPAddress readIPAddress(String name, String pretty) throws ApiException {
        ApiResponse<V1beta1IPAddress> localVarResp = this.readIPAddressWithHttpInfo(name, pretty);
        return localVarResp.getData();
    }

    public ApiResponse<V1beta1IPAddress> readIPAddressWithHttpInfo(String name, String pretty) throws ApiException {
        Call localVarCall = this.readIPAddressValidateBeforeCall(name, pretty, null);
        Type localVarReturnType = new TypeToken<V1beta1IPAddress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readIPAddressAsync(String name, String pretty, ApiCallback<V1beta1IPAddress> _callback) throws ApiException {
        Call localVarCall = this.readIPAddressValidateBeforeCall(name, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1beta1IPAddress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readServiceCIDRCall(String name, String pretty, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/servicecidrs/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readServiceCIDRValidateBeforeCall(String name, String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readServiceCIDR(Async)");
        }
        Call localVarCall = this.readServiceCIDRCall(name, pretty, _callback);
        return localVarCall;
    }

    public V1beta1ServiceCIDR readServiceCIDR(String name, String pretty) throws ApiException {
        ApiResponse<V1beta1ServiceCIDR> localVarResp = this.readServiceCIDRWithHttpInfo(name, pretty);
        return localVarResp.getData();
    }

    public ApiResponse<V1beta1ServiceCIDR> readServiceCIDRWithHttpInfo(String name, String pretty) throws ApiException {
        Call localVarCall = this.readServiceCIDRValidateBeforeCall(name, pretty, null);
        Type localVarReturnType = new TypeToken<V1beta1ServiceCIDR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readServiceCIDRAsync(String name, String pretty, ApiCallback<V1beta1ServiceCIDR> _callback) throws ApiException {
        Call localVarCall = this.readServiceCIDRValidateBeforeCall(name, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1beta1ServiceCIDR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readServiceCIDRStatusCall(String name, String pretty, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/servicecidrs/{name}/status".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readServiceCIDRStatusValidateBeforeCall(String name, String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readServiceCIDRStatus(Async)");
        }
        Call localVarCall = this.readServiceCIDRStatusCall(name, pretty, _callback);
        return localVarCall;
    }

    public V1beta1ServiceCIDR readServiceCIDRStatus(String name, String pretty) throws ApiException {
        ApiResponse<V1beta1ServiceCIDR> localVarResp = this.readServiceCIDRStatusWithHttpInfo(name, pretty);
        return localVarResp.getData();
    }

    public ApiResponse<V1beta1ServiceCIDR> readServiceCIDRStatusWithHttpInfo(String name, String pretty) throws ApiException {
        Call localVarCall = this.readServiceCIDRStatusValidateBeforeCall(name, pretty, null);
        Type localVarReturnType = new TypeToken<V1beta1ServiceCIDR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readServiceCIDRStatusAsync(String name, String pretty, ApiCallback<V1beta1ServiceCIDR> _callback) throws ApiException {
        Call localVarCall = this.readServiceCIDRStatusValidateBeforeCall(name, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1beta1ServiceCIDR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceIPAddressCall(String name, V1beta1IPAddress body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1beta1IPAddress localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/ipaddresses/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceIPAddressValidateBeforeCall(String name, V1beta1IPAddress body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceIPAddress(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceIPAddress(Async)");
        }
        Call localVarCall = this.replaceIPAddressCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1beta1IPAddress replaceIPAddress(String name, V1beta1IPAddress body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1beta1IPAddress> localVarResp = this.replaceIPAddressWithHttpInfo(name, body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1beta1IPAddress> replaceIPAddressWithHttpInfo(String name, V1beta1IPAddress body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceIPAddressValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1beta1IPAddress>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceIPAddressAsync(String name, V1beta1IPAddress body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1beta1IPAddress> _callback) throws ApiException {
        Call localVarCall = this.replaceIPAddressValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1beta1IPAddress>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceServiceCIDRCall(String name, V1beta1ServiceCIDR body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1beta1ServiceCIDR localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/servicecidrs/{name}".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceServiceCIDRValidateBeforeCall(String name, V1beta1ServiceCIDR body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceServiceCIDR(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceServiceCIDR(Async)");
        }
        Call localVarCall = this.replaceServiceCIDRCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1beta1ServiceCIDR replaceServiceCIDR(String name, V1beta1ServiceCIDR body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1beta1ServiceCIDR> localVarResp = this.replaceServiceCIDRWithHttpInfo(name, body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1beta1ServiceCIDR> replaceServiceCIDRWithHttpInfo(String name, V1beta1ServiceCIDR body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceServiceCIDRValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1beta1ServiceCIDR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceServiceCIDRAsync(String name, V1beta1ServiceCIDR body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1beta1ServiceCIDR> _callback) throws ApiException {
        Call localVarCall = this.replaceServiceCIDRValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1beta1ServiceCIDR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replaceServiceCIDRStatusCall(String name, V1beta1ServiceCIDR body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        V1beta1ServiceCIDR localVarPostBody = body;
        String localVarPath = "/apis/networking.k8s.io/v1beta1/servicecidrs/{name}/status".replaceAll("\\{name\\}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceServiceCIDRStatusValidateBeforeCall(String name, V1beta1ServiceCIDR body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceServiceCIDRStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceServiceCIDRStatus(Async)");
        }
        Call localVarCall = this.replaceServiceCIDRStatusCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        return localVarCall;
    }

    public V1beta1ServiceCIDR replaceServiceCIDRStatus(String name, V1beta1ServiceCIDR body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        ApiResponse<V1beta1ServiceCIDR> localVarResp = this.replaceServiceCIDRStatusWithHttpInfo(name, body, pretty, dryRun, fieldManager, fieldValidation);
        return localVarResp.getData();
    }

    public ApiResponse<V1beta1ServiceCIDR> replaceServiceCIDRStatusWithHttpInfo(String name, V1beta1ServiceCIDR body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceServiceCIDRStatusValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1beta1ServiceCIDR>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replaceServiceCIDRStatusAsync(String name, V1beta1ServiceCIDR body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1beta1ServiceCIDR> _callback) throws ApiException {
        Call localVarCall = this.replaceServiceCIDRStatusValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1beta1ServiceCIDR>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

