/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines a set of pods (namely those matching the labelSelector relative to the given namespace(s)) that this pod should be co-located (affinity) or not co-located (anti-affinity) with, where co-located is defined as running on a node whose value of the label with key <topologyKey> matches that of any node on which a pod of the set of pods is running")
public class V1PodAffinityTerm {
    public static final String SERIALIZED_NAME_LABEL_SELECTOR = "labelSelector";
    @SerializedName(value="labelSelector")
    private V1LabelSelector labelSelector;
    public static final String SERIALIZED_NAME_MATCH_LABEL_KEYS = "matchLabelKeys";
    @SerializedName(value="matchLabelKeys")
    private List<String> matchLabelKeys = null;
    public static final String SERIALIZED_NAME_MISMATCH_LABEL_KEYS = "mismatchLabelKeys";
    @SerializedName(value="mismatchLabelKeys")
    private List<String> mismatchLabelKeys = null;
    public static final String SERIALIZED_NAME_NAMESPACE_SELECTOR = "namespaceSelector";
    @SerializedName(value="namespaceSelector")
    private V1LabelSelector namespaceSelector;
    public static final String SERIALIZED_NAME_NAMESPACES = "namespaces";
    @SerializedName(value="namespaces")
    private List<String> namespaces = null;
    public static final String SERIALIZED_NAME_TOPOLOGY_KEY = "topologyKey";
    @SerializedName(value="topologyKey")
    private String topologyKey;

    public V1PodAffinityTerm labelSelector(V1LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getLabelSelector() {
        return this.labelSelector;
    }

    public void setLabelSelector(V1LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
    }

    public V1PodAffinityTerm matchLabelKeys(List<String> matchLabelKeys) {
        this.matchLabelKeys = matchLabelKeys;
        return this;
    }

    public V1PodAffinityTerm addMatchLabelKeysItem(String matchLabelKeysItem) {
        if (this.matchLabelKeys == null) {
            this.matchLabelKeys = new ArrayList<String>();
        }
        this.matchLabelKeys.add(matchLabelKeysItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MatchLabelKeys is a set of pod label keys to select which pods will be taken into consideration. The keys are used to lookup values from the incoming pod labels, those key-value labels are merged with `labelSelector` as `key in (value)` to select the group of existing pods which pods will be taken into consideration for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming pod labels will be ignored. The default value is empty. The same key is forbidden to exist in both matchLabelKeys and labelSelector. Also, matchLabelKeys cannot be set when labelSelector isn't set. This is an alpha field and requires enabling MatchLabelKeysInPodAffinity feature gate.")
    public List<String> getMatchLabelKeys() {
        return this.matchLabelKeys;
    }

    public void setMatchLabelKeys(List<String> matchLabelKeys) {
        this.matchLabelKeys = matchLabelKeys;
    }

    public V1PodAffinityTerm mismatchLabelKeys(List<String> mismatchLabelKeys) {
        this.mismatchLabelKeys = mismatchLabelKeys;
        return this;
    }

    public V1PodAffinityTerm addMismatchLabelKeysItem(String mismatchLabelKeysItem) {
        if (this.mismatchLabelKeys == null) {
            this.mismatchLabelKeys = new ArrayList<String>();
        }
        this.mismatchLabelKeys.add(mismatchLabelKeysItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MismatchLabelKeys is a set of pod label keys to select which pods will be taken into consideration. The keys are used to lookup values from the incoming pod labels, those key-value labels are merged with `labelSelector` as `key notin (value)` to select the group of existing pods which pods will be taken into consideration for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming pod labels will be ignored. The default value is empty. The same key is forbidden to exist in both mismatchLabelKeys and labelSelector. Also, mismatchLabelKeys cannot be set when labelSelector isn't set. This is an alpha field and requires enabling MatchLabelKeysInPodAffinity feature gate.")
    public List<String> getMismatchLabelKeys() {
        return this.mismatchLabelKeys;
    }

    public void setMismatchLabelKeys(List<String> mismatchLabelKeys) {
        this.mismatchLabelKeys = mismatchLabelKeys;
    }

    public V1PodAffinityTerm namespaceSelector(V1LabelSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getNamespaceSelector() {
        return this.namespaceSelector;
    }

    public void setNamespaceSelector(V1LabelSelector namespaceSelector) {
        this.namespaceSelector = namespaceSelector;
    }

    public V1PodAffinityTerm namespaces(List<String> namespaces) {
        this.namespaces = namespaces;
        return this;
    }

    public V1PodAffinityTerm addNamespacesItem(String namespacesItem) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(namespacesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="namespaces specifies a static list of namespace names that the term applies to. The term is applied to the union of the namespaces listed in this field and the ones selected by namespaceSelector. null or empty namespaces list and null namespaceSelector means \"this pod's namespace\".")
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(List<String> namespaces) {
        this.namespaces = namespaces;
    }

    public V1PodAffinityTerm topologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
        return this;
    }

    @ApiModelProperty(required=true, value="This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.")
    public String getTopologyKey() {
        return this.topologyKey;
    }

    public void setTopologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodAffinityTerm v1PodAffinityTerm = (V1PodAffinityTerm)o;
        return Objects.equals(this.labelSelector, v1PodAffinityTerm.labelSelector) && Objects.equals(this.matchLabelKeys, v1PodAffinityTerm.matchLabelKeys) && Objects.equals(this.mismatchLabelKeys, v1PodAffinityTerm.mismatchLabelKeys) && Objects.equals(this.namespaceSelector, v1PodAffinityTerm.namespaceSelector) && Objects.equals(this.namespaces, v1PodAffinityTerm.namespaces) && Objects.equals(this.topologyKey, v1PodAffinityTerm.topologyKey);
    }

    public int hashCode() {
        return Objects.hash(this.labelSelector, this.matchLabelKeys, this.mismatchLabelKeys, this.namespaceSelector, this.namespaces, this.topologyKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodAffinityTerm {\n");
        sb.append("    labelSelector: ").append(this.toIndentedString(this.labelSelector)).append("\n");
        sb.append("    matchLabelKeys: ").append(this.toIndentedString(this.matchLabelKeys)).append("\n");
        sb.append("    mismatchLabelKeys: ").append(this.toIndentedString(this.mismatchLabelKeys)).append("\n");
        sb.append("    namespaceSelector: ").append(this.toIndentedString(this.namespaceSelector)).append("\n");
        sb.append("    namespaces: ").append(this.toIndentedString(this.namespaces)).append("\n");
        sb.append("    topologyKey: ").append(this.toIndentedString(this.topologyKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

