/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ClusterTrustBundleProjection describes how to select a set of ClusterTrustBundle objects and project their contents into the pod filesystem.")
public class V1ClusterTrustBundleProjection {
    public static final String SERIALIZED_NAME_LABEL_SELECTOR = "labelSelector";
    @SerializedName(value="labelSelector")
    private V1LabelSelector labelSelector;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_OPTIONAL = "optional";
    @SerializedName(value="optional")
    private Boolean optional;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;
    public static final String SERIALIZED_NAME_SIGNER_NAME = "signerName";
    @SerializedName(value="signerName")
    private String signerName;

    public V1ClusterTrustBundleProjection labelSelector(V1LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getLabelSelector() {
        return this.labelSelector;
    }

    public void setLabelSelector(V1LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
    }

    public V1ClusterTrustBundleProjection name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Select a single ClusterTrustBundle by object name.  Mutually-exclusive with signerName and labelSelector.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ClusterTrustBundleProjection optional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If true, don't block pod startup if the referenced ClusterTrustBundle(s) aren't available.  If using name, then the named ClusterTrustBundle is allowed not to exist.  If using signerName, then the combination of signerName and labelSelector is allowed to match zero ClusterTrustBundles.")
    public Boolean getOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    public V1ClusterTrustBundleProjection path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="Relative path from the volume root to write the bundle.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public V1ClusterTrustBundleProjection signerName(String signerName) {
        this.signerName = signerName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Select all ClusterTrustBundles that match this signer name. Mutually-exclusive with name.  The contents of all selected ClusterTrustBundles will be unified and deduplicated.")
    public String getSignerName() {
        return this.signerName;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ClusterTrustBundleProjection v1ClusterTrustBundleProjection = (V1ClusterTrustBundleProjection)o;
        return Objects.equals(this.labelSelector, v1ClusterTrustBundleProjection.labelSelector) && Objects.equals(this.name, v1ClusterTrustBundleProjection.name) && Objects.equals(this.optional, v1ClusterTrustBundleProjection.optional) && Objects.equals(this.path, v1ClusterTrustBundleProjection.path) && Objects.equals(this.signerName, v1ClusterTrustBundleProjection.signerName);
    }

    public int hashCode() {
        return Objects.hash(this.labelSelector, this.name, this.optional, this.path, this.signerName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ClusterTrustBundleProjection {\n");
        sb.append("    labelSelector: ").append(this.toIndentedString(this.labelSelector)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    optional: ").append(this.toIndentedString(this.optional)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    signerName: ").append(this.toIndentedString(this.signerName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

