/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="PodResourceClaimStatus is stored in the PodStatus for each PodResourceClaim which references a ResourceClaimTemplate. It stores the generated name for the corresponding ResourceClaim.")
public class V1PodResourceClaimStatus {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_RESOURCE_CLAIM_NAME = "resourceClaimName";
    @SerializedName(value="resourceClaimName")
    private String resourceClaimName;

    public V1PodResourceClaimStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name uniquely identifies this resource claim inside the pod. This must match the name of an entry in pod.spec.resourceClaims, which implies that the string must be a DNS_LABEL.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1PodResourceClaimStatus resourceClaimName(String resourceClaimName) {
        this.resourceClaimName = resourceClaimName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceClaimName is the name of the ResourceClaim that was generated for the Pod in the namespace of the Pod. It this is unset, then generating a ResourceClaim was not necessary. The pod.spec.resourceClaims entry can be ignored in this case.")
    public String getResourceClaimName() {
        return this.resourceClaimName;
    }

    public void setResourceClaimName(String resourceClaimName) {
        this.resourceClaimName = resourceClaimName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodResourceClaimStatus v1PodResourceClaimStatus = (V1PodResourceClaimStatus)o;
        return Objects.equals(this.name, v1PodResourceClaimStatus.name) && Objects.equals(this.resourceClaimName, v1PodResourceClaimStatus.resourceClaimName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.resourceClaimName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodResourceClaimStatus {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resourceClaimName: ").append(this.toIndentedString(this.resourceClaimName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

