/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.")
public class V1LabelSelectorRequirement {
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_OPERATOR = "operator";
    @SerializedName(value="operator")
    private String operator;
    public static final String SERIALIZED_NAME_VALUES = "values";
    @SerializedName(value="values")
    private List<String> values = null;

    public V1LabelSelectorRequirement key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="key is the label key that the selector applies to.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public V1LabelSelectorRequirement operator(String operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(required=true, value="operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.")
    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public V1LabelSelectorRequirement values(List<String> values) {
        this.values = values;
        return this;
    }

    public V1LabelSelectorRequirement addValuesItem(String valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.")
    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LabelSelectorRequirement v1LabelSelectorRequirement = (V1LabelSelectorRequirement)o;
        return Objects.equals(this.key, v1LabelSelectorRequirement.key) && Objects.equals(this.operator, v1LabelSelectorRequirement.operator) && Objects.equals(this.values, v1LabelSelectorRequirement.values);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.operator, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LabelSelectorRequirement {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString(this.operator)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

