/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ExecAction;
import io.kubernetes.client.openapi.models.V1HTTPGetAction;
import io.kubernetes.client.openapi.models.V1TCPSocketAction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.")
public class V1Probe {
    public static final String SERIALIZED_NAME_EXEC = "exec";
    @SerializedName(value="exec")
    private V1ExecAction exec;
    public static final String SERIALIZED_NAME_FAILURE_THRESHOLD = "failureThreshold";
    @SerializedName(value="failureThreshold")
    private Integer failureThreshold;
    public static final String SERIALIZED_NAME_HTTP_GET = "httpGet";
    @SerializedName(value="httpGet")
    private V1HTTPGetAction httpGet;
    public static final String SERIALIZED_NAME_INITIAL_DELAY_SECONDS = "initialDelaySeconds";
    @SerializedName(value="initialDelaySeconds")
    private Integer initialDelaySeconds;
    public static final String SERIALIZED_NAME_PERIOD_SECONDS = "periodSeconds";
    @SerializedName(value="periodSeconds")
    private Integer periodSeconds;
    public static final String SERIALIZED_NAME_SUCCESS_THRESHOLD = "successThreshold";
    @SerializedName(value="successThreshold")
    private Integer successThreshold;
    public static final String SERIALIZED_NAME_TCP_SOCKET = "tcpSocket";
    @SerializedName(value="tcpSocket")
    private V1TCPSocketAction tcpSocket;
    public static final String SERIALIZED_NAME_TERMINATION_GRACE_PERIOD_SECONDS = "terminationGracePeriodSeconds";
    @SerializedName(value="terminationGracePeriodSeconds")
    private Long terminationGracePeriodSeconds;
    public static final String SERIALIZED_NAME_TIMEOUT_SECONDS = "timeoutSeconds";
    @SerializedName(value="timeoutSeconds")
    private Integer timeoutSeconds;

    public V1Probe exec(V1ExecAction exec) {
        this.exec = exec;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ExecAction getExec() {
        return this.exec;
    }

    public void setExec(V1ExecAction exec) {
        this.exec = exec;
    }

    public V1Probe failureThreshold(Integer failureThreshold) {
        this.failureThreshold = failureThreshold;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.")
    public Integer getFailureThreshold() {
        return this.failureThreshold;
    }

    public void setFailureThreshold(Integer failureThreshold) {
        this.failureThreshold = failureThreshold;
    }

    public V1Probe httpGet(V1HTTPGetAction httpGet) {
        this.httpGet = httpGet;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1HTTPGetAction getHttpGet() {
        return this.httpGet;
    }

    public void setHttpGet(V1HTTPGetAction httpGet) {
        this.httpGet = httpGet;
    }

    public V1Probe initialDelaySeconds(Integer initialDelaySeconds) {
        this.initialDelaySeconds = initialDelaySeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes")
    public Integer getInitialDelaySeconds() {
        return this.initialDelaySeconds;
    }

    public void setInitialDelaySeconds(Integer initialDelaySeconds) {
        this.initialDelaySeconds = initialDelaySeconds;
    }

    public V1Probe periodSeconds(Integer periodSeconds) {
        this.periodSeconds = periodSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.")
    public Integer getPeriodSeconds() {
        return this.periodSeconds;
    }

    public void setPeriodSeconds(Integer periodSeconds) {
        this.periodSeconds = periodSeconds;
    }

    public V1Probe successThreshold(Integer successThreshold) {
        this.successThreshold = successThreshold;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1.")
    public Integer getSuccessThreshold() {
        return this.successThreshold;
    }

    public void setSuccessThreshold(Integer successThreshold) {
        this.successThreshold = successThreshold;
    }

    public V1Probe tcpSocket(V1TCPSocketAction tcpSocket) {
        this.tcpSocket = tcpSocket;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1TCPSocketAction getTcpSocket() {
        return this.tcpSocket;
    }

    public void setTcpSocket(V1TCPSocketAction tcpSocket) {
        this.tcpSocket = tcpSocket;
    }

    public V1Probe terminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional duration in seconds the pod needs to terminate gracefully upon probe failure. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut down). This is a beta field and requires enabling ProbeTerminationGracePeriod feature gate. Minimum value is 1. spec.terminationGracePeriodSeconds is used if unset.")
    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public void setTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
    }

    public V1Probe timeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes")
    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Probe v1Probe = (V1Probe)o;
        return Objects.equals(this.exec, v1Probe.exec) && Objects.equals(this.failureThreshold, v1Probe.failureThreshold) && Objects.equals(this.httpGet, v1Probe.httpGet) && Objects.equals(this.initialDelaySeconds, v1Probe.initialDelaySeconds) && Objects.equals(this.periodSeconds, v1Probe.periodSeconds) && Objects.equals(this.successThreshold, v1Probe.successThreshold) && Objects.equals(this.tcpSocket, v1Probe.tcpSocket) && Objects.equals(this.terminationGracePeriodSeconds, v1Probe.terminationGracePeriodSeconds) && Objects.equals(this.timeoutSeconds, v1Probe.timeoutSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.exec, this.failureThreshold, this.httpGet, this.initialDelaySeconds, this.periodSeconds, this.successThreshold, this.tcpSocket, this.terminationGracePeriodSeconds, this.timeoutSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Probe {\n");
        sb.append("    exec: ").append(this.toIndentedString(this.exec)).append("\n");
        sb.append("    failureThreshold: ").append(this.toIndentedString(this.failureThreshold)).append("\n");
        sb.append("    httpGet: ").append(this.toIndentedString(this.httpGet)).append("\n");
        sb.append("    initialDelaySeconds: ").append(this.toIndentedString(this.initialDelaySeconds)).append("\n");
        sb.append("    periodSeconds: ").append(this.toIndentedString(this.periodSeconds)).append("\n");
        sb.append("    successThreshold: ").append(this.toIndentedString(this.successThreshold)).append("\n");
        sb.append("    tcpSocket: ").append(this.toIndentedString(this.tcpSocket)).append("\n");
        sb.append("    terminationGracePeriodSeconds: ").append(this.toIndentedString(this.terminationGracePeriodSeconds)).append("\n");
        sb.append("    timeoutSeconds: ").append(this.toIndentedString(this.timeoutSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

