/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1EventSeries;
import io.kubernetes.client.openapi.models.V1EventSource;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@ApiModel(description="Event is a report of an event somewhere in the cluster.")
public class V1Event
implements KubernetesObject {
    public static final String SERIALIZED_NAME_ACTION = "action";
    @SerializedName(value="action")
    private String action;
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count;
    public static final String SERIALIZED_NAME_EVENT_TIME = "eventTime";
    @SerializedName(value="eventTime")
    private DateTime eventTime;
    public static final String SERIALIZED_NAME_FIRST_TIMESTAMP = "firstTimestamp";
    @SerializedName(value="firstTimestamp")
    private DateTime firstTimestamp;
    public static final String SERIALIZED_NAME_INVOLVED_OBJECT = "involvedObject";
    @SerializedName(value="involvedObject")
    private V1ObjectReference involvedObject;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_LAST_TIMESTAMP = "lastTimestamp";
    @SerializedName(value="lastTimestamp")
    private DateTime lastTimestamp;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_RELATED = "related";
    @SerializedName(value="related")
    private V1ObjectReference related;
    public static final String SERIALIZED_NAME_REPORTING_COMPONENT = "reportingComponent";
    @SerializedName(value="reportingComponent")
    private String reportingComponent;
    public static final String SERIALIZED_NAME_REPORTING_INSTANCE = "reportingInstance";
    @SerializedName(value="reportingInstance")
    private String reportingInstance;
    public static final String SERIALIZED_NAME_SERIES = "series";
    @SerializedName(value="series")
    private V1EventSeries series;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private V1EventSource source;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public V1Event action(String action) {
        this.action = action;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="What action was taken/failed regarding to the Regarding object.")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public V1Event apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1Event count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of times this event has occurred.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public V1Event eventTime(DateTime eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time when this Event was first observed.")
    public DateTime getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(DateTime eventTime) {
        this.eventTime = eventTime;
    }

    public V1Event firstTimestamp(DateTime firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)")
    public DateTime getFirstTimestamp() {
        return this.firstTimestamp;
    }

    public void setFirstTimestamp(DateTime firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
    }

    public V1Event involvedObject(V1ObjectReference involvedObject) {
        this.involvedObject = involvedObject;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1ObjectReference getInvolvedObject() {
        return this.involvedObject;
    }

    public void setInvolvedObject(V1ObjectReference involvedObject) {
        this.involvedObject = involvedObject;
    }

    public V1Event kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1Event lastTimestamp(DateTime lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time at which the most recent occurrence of this event was recorded.")
    public DateTime getLastTimestamp() {
        return this.lastTimestamp;
    }

    public void setLastTimestamp(DateTime lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
    }

    public V1Event message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A human-readable description of the status of this operation.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V1Event metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @ApiModelProperty(required=true, value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1Event reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This should be a short, machine understandable string that gives the reason for the transition into the object's current status.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1Event related(V1ObjectReference related) {
        this.related = related;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectReference getRelated() {
        return this.related;
    }

    public void setRelated(V1ObjectReference related) {
        this.related = related;
    }

    public V1Event reportingComponent(String reportingComponent) {
        this.reportingComponent = reportingComponent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.")
    public String getReportingComponent() {
        return this.reportingComponent;
    }

    public void setReportingComponent(String reportingComponent) {
        this.reportingComponent = reportingComponent;
    }

    public V1Event reportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the controller instance, e.g. `kubelet-xyzf`.")
    public String getReportingInstance() {
        return this.reportingInstance;
    }

    public void setReportingInstance(String reportingInstance) {
        this.reportingInstance = reportingInstance;
    }

    public V1Event series(V1EventSeries series) {
        this.series = series;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1EventSeries getSeries() {
        return this.series;
    }

    public void setSeries(V1EventSeries series) {
        this.series = series;
    }

    public V1Event source(V1EventSource source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1EventSource getSource() {
        return this.source;
    }

    public void setSource(V1EventSource source) {
        this.source = source;
    }

    public V1Event type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of this event (Normal, Warning), new types could be added in the future")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Event v1Event = (V1Event)o;
        return Objects.equals(this.action, v1Event.action) && Objects.equals(this.apiVersion, v1Event.apiVersion) && Objects.equals(this.count, v1Event.count) && Objects.equals(this.eventTime, v1Event.eventTime) && Objects.equals(this.firstTimestamp, v1Event.firstTimestamp) && Objects.equals(this.involvedObject, v1Event.involvedObject) && Objects.equals(this.kind, v1Event.kind) && Objects.equals(this.lastTimestamp, v1Event.lastTimestamp) && Objects.equals(this.message, v1Event.message) && Objects.equals(this.metadata, v1Event.metadata) && Objects.equals(this.reason, v1Event.reason) && Objects.equals(this.related, v1Event.related) && Objects.equals(this.reportingComponent, v1Event.reportingComponent) && Objects.equals(this.reportingInstance, v1Event.reportingInstance) && Objects.equals(this.series, v1Event.series) && Objects.equals(this.source, v1Event.source) && Objects.equals(this.type, v1Event.type);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.apiVersion, this.count, this.eventTime, this.firstTimestamp, this.involvedObject, this.kind, this.lastTimestamp, this.message, this.metadata, this.reason, this.related, this.reportingComponent, this.reportingInstance, this.series, this.source, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Event {\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    firstTimestamp: ").append(this.toIndentedString(this.firstTimestamp)).append("\n");
        sb.append("    involvedObject: ").append(this.toIndentedString(this.involvedObject)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    lastTimestamp: ").append(this.toIndentedString(this.lastTimestamp)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    related: ").append(this.toIndentedString(this.related)).append("\n");
        sb.append("    reportingComponent: ").append(this.toIndentedString(this.reportingComponent)).append("\n");
        sb.append("    reportingInstance: ").append(this.toIndentedString(this.reportingInstance)).append("\n");
        sb.append("    series: ").append(this.toIndentedString(this.series)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

