/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1beta2DeviceConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1beta2DeviceConstraintFluent<A extends V1beta2DeviceConstraintFluent<A>>
extends BaseFluent<A> {
    private String distinctAttribute;
    private String matchAttribute;
    private List<String> requests;

    public V1beta2DeviceConstraintFluent() {
    }

    public V1beta2DeviceConstraintFluent(V1beta2DeviceConstraint instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1beta2DeviceConstraint instance) {
        V1beta2DeviceConstraint v1beta2DeviceConstraint = instance = instance != null ? instance : new V1beta2DeviceConstraint();
        if (instance != null) {
            this.withDistinctAttribute(instance.getDistinctAttribute());
            this.withMatchAttribute(instance.getMatchAttribute());
            this.withRequests(instance.getRequests());
        }
    }

    public String getDistinctAttribute() {
        return this.distinctAttribute;
    }

    public A withDistinctAttribute(String distinctAttribute) {
        this.distinctAttribute = distinctAttribute;
        return (A)this;
    }

    public boolean hasDistinctAttribute() {
        return this.distinctAttribute != null;
    }

    public String getMatchAttribute() {
        return this.matchAttribute;
    }

    public A withMatchAttribute(String matchAttribute) {
        this.matchAttribute = matchAttribute;
        return (A)this;
    }

    public boolean hasMatchAttribute() {
        return this.matchAttribute != null;
    }

    public A addToRequests(int index, String item) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        this.requests.add(index, item);
        return (A)this;
    }

    public A setToRequests(int index, String item) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        this.requests.set(index, item);
        return (A)this;
    }

    public A addToRequests(String ... items) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        for (String item : items) {
            this.requests.add(item);
        }
        return (A)this;
    }

    public A addAllToRequests(Collection<String> items) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        for (String item : items) {
            this.requests.add(item);
        }
        return (A)this;
    }

    public A removeFromRequests(String ... items) {
        if (this.requests == null) {
            return (A)this;
        }
        for (String item : items) {
            this.requests.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromRequests(Collection<String> items) {
        if (this.requests == null) {
            return (A)this;
        }
        for (String item : items) {
            this.requests.remove(item);
        }
        return (A)this;
    }

    public List<String> getRequests() {
        return this.requests;
    }

    public String getRequest(int index) {
        return this.requests.get(index);
    }

    public String getFirstRequest() {
        return this.requests.get(0);
    }

    public String getLastRequest() {
        return this.requests.get(this.requests.size() - 1);
    }

    public String getMatchingRequest(Predicate<String> predicate) {
        for (String item : this.requests) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRequest(Predicate<String> predicate) {
        for (String item : this.requests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRequests(List<String> requests) {
        if (requests != null) {
            this.requests = new ArrayList<String>();
            for (String item : requests) {
                this.addToRequests(item);
            }
        } else {
            this.requests = null;
        }
        return (A)this;
    }

    public A withRequests(String ... requests) {
        if (this.requests != null) {
            this.requests.clear();
            this._visitables.remove("requests");
        }
        if (requests != null) {
            for (String item : requests) {
                this.addToRequests(item);
            }
        }
        return (A)this;
    }

    public boolean hasRequests() {
        return this.requests != null && !this.requests.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta2DeviceConstraintFluent that = (V1beta2DeviceConstraintFluent)o;
        if (!Objects.equals(this.distinctAttribute, that.distinctAttribute)) {
            return false;
        }
        if (!Objects.equals(this.matchAttribute, that.matchAttribute)) {
            return false;
        }
        return Objects.equals(this.requests, that.requests);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.distinctAttribute, this.matchAttribute, this.requests);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.distinctAttribute != null) {
            sb.append("distinctAttribute:");
            sb.append(this.distinctAttribute);
            sb.append(",");
        }
        if (this.matchAttribute != null) {
            sb.append("matchAttribute:");
            sb.append(this.matchAttribute);
            sb.append(",");
        }
        if (this.requests != null && !this.requests.isEmpty()) {
            sb.append("requests:");
            sb.append(this.requests);
        }
        sb.append("}");
        return sb.toString();
    }
}

