/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersion;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionStatus;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionStatusBuilder;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionStatusFluent;
import java.util.Objects;
import java.util.Optional;

public class V1alpha1StorageVersionFluent<A extends V1alpha1StorageVersionFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private Object spec;
    private V1alpha1StorageVersionStatusBuilder status;

    public V1alpha1StorageVersionFluent() {
    }

    public V1alpha1StorageVersionFluent(V1alpha1StorageVersion instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha1StorageVersion instance) {
        V1alpha1StorageVersion v1alpha1StorageVersion = instance = instance != null ? instance : new V1alpha1StorageVersion();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public Object getSpec() {
        return this.spec;
    }

    public A withSpec(Object spec) {
        this.spec = spec;
        return (A)this;
    }

    public boolean hasSpec() {
        return this.spec != null;
    }

    public V1alpha1StorageVersionStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    public A withStatus(V1alpha1StorageVersionStatus status) {
        this._visitables.remove("status");
        if (status != null) {
            this.status = new V1alpha1StorageVersionStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get("status").remove(this.status);
        }
        return (A)this;
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public StatusNested<A> withNewStatus() {
        return new StatusNested(null);
    }

    public StatusNested<A> withNewStatusLike(V1alpha1StorageVersionStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<A> editStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(null));
    }

    public StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(new V1alpha1StorageVersionStatusBuilder().build()));
    }

    public StatusNested<A> editOrNewStatusLike(V1alpha1StorageVersionStatus item) {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha1StorageVersionFluent that = (V1alpha1StorageVersionFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.spec, that.spec)) {
            return false;
        }
        return Objects.equals(this.status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
            sb.append(",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec);
            sb.append(",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha1StorageVersionFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class StatusNested<N>
    extends V1alpha1StorageVersionStatusFluent<StatusNested<N>>
    implements Nested<N> {
        V1alpha1StorageVersionStatusBuilder builder;

        StatusNested(V1alpha1StorageVersionStatus item) {
            this.builder = new V1alpha1StorageVersionStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha1StorageVersionFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }
}

