/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="VolumeError captures an error encountered during a volume operation.")
public class V1VolumeError {
    public static final String SERIALIZED_NAME_ERROR_CODE = "errorCode";
    @SerializedName(value="errorCode")
    private Integer errorCode;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_TIME = "time";
    @SerializedName(value="time")
    private OffsetDateTime time;

    public V1VolumeError errorCode(Integer errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="errorCode is a numeric gRPC code representing the error encountered during Attach or Detach operations.  This is an optional, beta field that requires the MutableCSINodeAllocatableCount feature gate being enabled to be set.")
    public Integer getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    public V1VolumeError message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="message represents the error encountered during Attach or Detach operation. This string may be logged, so it should not contain sensitive information.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V1VolumeError time(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="time represents the time the error was encountered.")
    public OffsetDateTime getTime() {
        return this.time;
    }

    public void setTime(OffsetDateTime time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1VolumeError v1VolumeError = (V1VolumeError)o;
        return Objects.equals(this.errorCode, v1VolumeError.errorCode) && Objects.equals(this.message, v1VolumeError.message) && Objects.equals(this.time, v1VolumeError.time);
    }

    public int hashCode() {
        return Objects.hash(this.errorCode, this.message, this.time);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1VolumeError {\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

