/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1Condition;
import io.kubernetes.client.openapi.models.V1TypeChecking;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ValidatingAdmissionPolicyStatus represents the status of an admission validation policy.")
public class V1ValidatingAdmissionPolicyStatus {
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1Condition> conditions = null;
    public static final String SERIALIZED_NAME_OBSERVED_GENERATION = "observedGeneration";
    @SerializedName(value="observedGeneration")
    private Long observedGeneration;
    public static final String SERIALIZED_NAME_TYPE_CHECKING = "typeChecking";
    @SerializedName(value="typeChecking")
    private V1TypeChecking typeChecking;

    public V1ValidatingAdmissionPolicyStatus conditions(List<V1Condition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1ValidatingAdmissionPolicyStatus addConditionsItem(V1Condition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1Condition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The conditions represent the latest available observations of a policy's current state.")
    public List<V1Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1Condition> conditions) {
        this.conditions = conditions;
    }

    public V1ValidatingAdmissionPolicyStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The generation observed by the controller.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1ValidatingAdmissionPolicyStatus typeChecking(V1TypeChecking typeChecking) {
        this.typeChecking = typeChecking;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1TypeChecking getTypeChecking() {
        return this.typeChecking;
    }

    public void setTypeChecking(V1TypeChecking typeChecking) {
        this.typeChecking = typeChecking;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ValidatingAdmissionPolicyStatus v1ValidatingAdmissionPolicyStatus = (V1ValidatingAdmissionPolicyStatus)o;
        return Objects.equals(this.conditions, v1ValidatingAdmissionPolicyStatus.conditions) && Objects.equals(this.observedGeneration, v1ValidatingAdmissionPolicyStatus.observedGeneration) && Objects.equals(this.typeChecking, v1ValidatingAdmissionPolicyStatus.typeChecking);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.observedGeneration, this.typeChecking);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ValidatingAdmissionPolicyStatus {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    typeChecking: ").append(this.toIndentedString(this.typeChecking)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

