/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import io.kubernetes.client.openapi.models.V1ValidatingAdmissionPolicyBinding;
import io.kubernetes.client.openapi.models.V1ValidatingAdmissionPolicyBindingSpec;
import io.kubernetes.client.openapi.models.V1ValidatingAdmissionPolicyBindingSpecBuilder;
import io.kubernetes.client.openapi.models.V1ValidatingAdmissionPolicyBindingSpecFluent;
import java.util.Objects;
import java.util.Optional;

public class V1ValidatingAdmissionPolicyBindingFluent<A extends V1ValidatingAdmissionPolicyBindingFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1ValidatingAdmissionPolicyBindingSpecBuilder spec;

    public V1ValidatingAdmissionPolicyBindingFluent() {
    }

    public V1ValidatingAdmissionPolicyBindingFluent(V1ValidatingAdmissionPolicyBinding instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1ValidatingAdmissionPolicyBinding instance) {
        V1ValidatingAdmissionPolicyBinding v1ValidatingAdmissionPolicyBinding = instance = instance != null ? instance : new V1ValidatingAdmissionPolicyBinding();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public V1ValidatingAdmissionPolicyBindingSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    public A withSpec(V1ValidatingAdmissionPolicyBindingSpec spec) {
        this._visitables.remove("spec");
        if (spec != null) {
            this.spec = new V1ValidatingAdmissionPolicyBindingSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get("spec").remove(this.spec);
        }
        return (A)this;
    }

    public boolean hasSpec() {
        return this.spec != null;
    }

    public SpecNested<A> withNewSpec() {
        return new SpecNested(null);
    }

    public SpecNested<A> withNewSpecLike(V1ValidatingAdmissionPolicyBindingSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<A> editSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(null));
    }

    public SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(new V1ValidatingAdmissionPolicyBindingSpecBuilder().build()));
    }

    public SpecNested<A> editOrNewSpecLike(V1ValidatingAdmissionPolicyBindingSpec item) {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ValidatingAdmissionPolicyBindingFluent that = (V1ValidatingAdmissionPolicyBindingFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.spec, that.spec);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
            sb.append(",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ValidatingAdmissionPolicyBindingFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class SpecNested<N>
    extends V1ValidatingAdmissionPolicyBindingSpecFluent<SpecNested<N>>
    implements Nested<N> {
        V1ValidatingAdmissionPolicyBindingSpecBuilder builder;

        SpecNested(V1ValidatingAdmissionPolicyBindingSpec item) {
            this.builder = new V1ValidatingAdmissionPolicyBindingSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ValidatingAdmissionPolicyBindingFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }
}

