/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.IntOrString;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1ServicePort;
import java.util.Objects;

public class V1ServicePortFluent<A extends V1ServicePortFluent<A>>
extends BaseFluent<A> {
    private String appProtocol;
    private String name;
    private Integer nodePort;
    private Integer port;
    private String protocol;
    private IntOrString targetPort;

    public V1ServicePortFluent() {
    }

    public V1ServicePortFluent(V1ServicePort instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1ServicePort instance) {
        V1ServicePort v1ServicePort = instance = instance != null ? instance : new V1ServicePort();
        if (instance != null) {
            this.withAppProtocol(instance.getAppProtocol());
            this.withName(instance.getName());
            this.withNodePort(instance.getNodePort());
            this.withPort(instance.getPort());
            this.withProtocol(instance.getProtocol());
            this.withTargetPort(instance.getTargetPort());
        }
    }

    public String getAppProtocol() {
        return this.appProtocol;
    }

    public A withAppProtocol(String appProtocol) {
        this.appProtocol = appProtocol;
        return (A)this;
    }

    public boolean hasAppProtocol() {
        return this.appProtocol != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Integer getNodePort() {
        return this.nodePort;
    }

    public A withNodePort(Integer nodePort) {
        this.nodePort = nodePort;
        return (A)this;
    }

    public boolean hasNodePort() {
        return this.nodePort != null;
    }

    public Integer getPort() {
        return this.port;
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)this;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public A withProtocol(String protocol) {
        this.protocol = protocol;
        return (A)this;
    }

    public boolean hasProtocol() {
        return this.protocol != null;
    }

    public IntOrString getTargetPort() {
        return this.targetPort;
    }

    public A withTargetPort(IntOrString targetPort) {
        this.targetPort = targetPort;
        return (A)this;
    }

    public boolean hasTargetPort() {
        return this.targetPort != null;
    }

    public A withNewTargetPort(int value) {
        return this.withTargetPort(new IntOrString(value));
    }

    public A withNewTargetPort(String value) {
        return this.withTargetPort(new IntOrString(value));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ServicePortFluent that = (V1ServicePortFluent)o;
        if (!Objects.equals(this.appProtocol, that.appProtocol)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.nodePort, that.nodePort)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.protocol, that.protocol)) {
            return false;
        }
        return Objects.equals(this.targetPort, that.targetPort);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.appProtocol, this.name, this.nodePort, this.port, this.protocol, this.targetPort);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.appProtocol != null) {
            sb.append("appProtocol:");
            sb.append(this.appProtocol);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.nodePort != null) {
            sb.append("nodePort:");
            sb.append(this.nodePort);
            sb.append(",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port);
            sb.append(",");
        }
        if (this.protocol != null) {
            sb.append("protocol:");
            sb.append(this.protocol);
            sb.append(",");
        }
        if (this.targetPort != null) {
            sb.append("targetPort:");
            sb.append(this.targetPort);
        }
        sb.append("}");
        return sb.toString();
    }
}

