/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1AppArmorProfile;
import io.kubernetes.client.openapi.models.V1AppArmorProfileBuilder;
import io.kubernetes.client.openapi.models.V1AppArmorProfileFluent;
import io.kubernetes.client.openapi.models.V1Capabilities;
import io.kubernetes.client.openapi.models.V1CapabilitiesBuilder;
import io.kubernetes.client.openapi.models.V1CapabilitiesFluent;
import io.kubernetes.client.openapi.models.V1SELinuxOptions;
import io.kubernetes.client.openapi.models.V1SELinuxOptionsBuilder;
import io.kubernetes.client.openapi.models.V1SELinuxOptionsFluent;
import io.kubernetes.client.openapi.models.V1SeccompProfile;
import io.kubernetes.client.openapi.models.V1SeccompProfileBuilder;
import io.kubernetes.client.openapi.models.V1SeccompProfileFluent;
import io.kubernetes.client.openapi.models.V1SecurityContext;
import io.kubernetes.client.openapi.models.V1WindowsSecurityContextOptions;
import io.kubernetes.client.openapi.models.V1WindowsSecurityContextOptionsBuilder;
import io.kubernetes.client.openapi.models.V1WindowsSecurityContextOptionsFluent;
import java.util.Objects;
import java.util.Optional;

public class V1SecurityContextFluent<A extends V1SecurityContextFluent<A>>
extends BaseFluent<A> {
    private Boolean allowPrivilegeEscalation;
    private V1AppArmorProfileBuilder appArmorProfile;
    private V1CapabilitiesBuilder capabilities;
    private Boolean privileged;
    private String procMount;
    private Boolean readOnlyRootFilesystem;
    private Long runAsGroup;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private V1SELinuxOptionsBuilder seLinuxOptions;
    private V1SeccompProfileBuilder seccompProfile;
    private V1WindowsSecurityContextOptionsBuilder windowsOptions;

    public V1SecurityContextFluent() {
    }

    public V1SecurityContextFluent(V1SecurityContext instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1SecurityContext instance) {
        V1SecurityContext v1SecurityContext = instance = instance != null ? instance : new V1SecurityContext();
        if (instance != null) {
            this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
            this.withAppArmorProfile(instance.getAppArmorProfile());
            this.withCapabilities(instance.getCapabilities());
            this.withPrivileged(instance.getPrivileged());
            this.withProcMount(instance.getProcMount());
            this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
            this.withRunAsGroup(instance.getRunAsGroup());
            this.withRunAsNonRoot(instance.getRunAsNonRoot());
            this.withRunAsUser(instance.getRunAsUser());
            this.withSeLinuxOptions(instance.getSeLinuxOptions());
            this.withSeccompProfile(instance.getSeccompProfile());
            this.withWindowsOptions(instance.getWindowsOptions());
        }
    }

    public Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return (A)this;
    }

    public boolean hasAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation != null;
    }

    public V1AppArmorProfile buildAppArmorProfile() {
        return this.appArmorProfile != null ? this.appArmorProfile.build() : null;
    }

    public A withAppArmorProfile(V1AppArmorProfile appArmorProfile) {
        this._visitables.remove("appArmorProfile");
        if (appArmorProfile != null) {
            this.appArmorProfile = new V1AppArmorProfileBuilder(appArmorProfile);
            this._visitables.get("appArmorProfile").add(this.appArmorProfile);
        } else {
            this.appArmorProfile = null;
            this._visitables.get("appArmorProfile").remove(this.appArmorProfile);
        }
        return (A)this;
    }

    public boolean hasAppArmorProfile() {
        return this.appArmorProfile != null;
    }

    public AppArmorProfileNested<A> withNewAppArmorProfile() {
        return new AppArmorProfileNested(null);
    }

    public AppArmorProfileNested<A> withNewAppArmorProfileLike(V1AppArmorProfile item) {
        return new AppArmorProfileNested(item);
    }

    public AppArmorProfileNested<A> editAppArmorProfile() {
        return this.withNewAppArmorProfileLike(Optional.ofNullable(this.buildAppArmorProfile()).orElse(null));
    }

    public AppArmorProfileNested<A> editOrNewAppArmorProfile() {
        return this.withNewAppArmorProfileLike(Optional.ofNullable(this.buildAppArmorProfile()).orElse(new V1AppArmorProfileBuilder().build()));
    }

    public AppArmorProfileNested<A> editOrNewAppArmorProfileLike(V1AppArmorProfile item) {
        return this.withNewAppArmorProfileLike(Optional.ofNullable(this.buildAppArmorProfile()).orElse(item));
    }

    public V1Capabilities buildCapabilities() {
        return this.capabilities != null ? this.capabilities.build() : null;
    }

    public A withCapabilities(V1Capabilities capabilities) {
        this._visitables.remove("capabilities");
        if (capabilities != null) {
            this.capabilities = new V1CapabilitiesBuilder(capabilities);
            this._visitables.get("capabilities").add(this.capabilities);
        } else {
            this.capabilities = null;
            this._visitables.get("capabilities").remove(this.capabilities);
        }
        return (A)this;
    }

    public boolean hasCapabilities() {
        return this.capabilities != null;
    }

    public CapabilitiesNested<A> withNewCapabilities() {
        return new CapabilitiesNested(null);
    }

    public CapabilitiesNested<A> withNewCapabilitiesLike(V1Capabilities item) {
        return new CapabilitiesNested(item);
    }

    public CapabilitiesNested<A> editCapabilities() {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(null));
    }

    public CapabilitiesNested<A> editOrNewCapabilities() {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(new V1CapabilitiesBuilder().build()));
    }

    public CapabilitiesNested<A> editOrNewCapabilitiesLike(V1Capabilities item) {
        return this.withNewCapabilitiesLike(Optional.ofNullable(this.buildCapabilities()).orElse(item));
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public A withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return (A)this;
    }

    public boolean hasPrivileged() {
        return this.privileged != null;
    }

    public String getProcMount() {
        return this.procMount;
    }

    public A withProcMount(String procMount) {
        this.procMount = procMount;
        return (A)this;
    }

    public boolean hasProcMount() {
        return this.procMount != null;
    }

    public Boolean getReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return (A)this;
    }

    public boolean hasReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem != null;
    }

    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public A withRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return (A)this;
    }

    public boolean hasRunAsGroup() {
        return this.runAsGroup != null;
    }

    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public A withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return (A)this;
    }

    public boolean hasRunAsNonRoot() {
        return this.runAsNonRoot != null;
    }

    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public A withRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return (A)this;
    }

    public boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    public V1SELinuxOptions buildSeLinuxOptions() {
        return this.seLinuxOptions != null ? this.seLinuxOptions.build() : null;
    }

    public A withSeLinuxOptions(V1SELinuxOptions seLinuxOptions) {
        this._visitables.remove("seLinuxOptions");
        if (seLinuxOptions != null) {
            this.seLinuxOptions = new V1SELinuxOptionsBuilder(seLinuxOptions);
            this._visitables.get("seLinuxOptions").add(this.seLinuxOptions);
        } else {
            this.seLinuxOptions = null;
            this._visitables.get("seLinuxOptions").remove(this.seLinuxOptions);
        }
        return (A)this;
    }

    public boolean hasSeLinuxOptions() {
        return this.seLinuxOptions != null;
    }

    public SeLinuxOptionsNested<A> withNewSeLinuxOptions() {
        return new SeLinuxOptionsNested(null);
    }

    public SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(V1SELinuxOptions item) {
        return new SeLinuxOptionsNested(item);
    }

    public SeLinuxOptionsNested<A> editSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(Optional.ofNullable(this.buildSeLinuxOptions()).orElse(null));
    }

    public SeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(Optional.ofNullable(this.buildSeLinuxOptions()).orElse(new V1SELinuxOptionsBuilder().build()));
    }

    public SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(V1SELinuxOptions item) {
        return this.withNewSeLinuxOptionsLike(Optional.ofNullable(this.buildSeLinuxOptions()).orElse(item));
    }

    public V1SeccompProfile buildSeccompProfile() {
        return this.seccompProfile != null ? this.seccompProfile.build() : null;
    }

    public A withSeccompProfile(V1SeccompProfile seccompProfile) {
        this._visitables.remove("seccompProfile");
        if (seccompProfile != null) {
            this.seccompProfile = new V1SeccompProfileBuilder(seccompProfile);
            this._visitables.get("seccompProfile").add(this.seccompProfile);
        } else {
            this.seccompProfile = null;
            this._visitables.get("seccompProfile").remove(this.seccompProfile);
        }
        return (A)this;
    }

    public boolean hasSeccompProfile() {
        return this.seccompProfile != null;
    }

    public SeccompProfileNested<A> withNewSeccompProfile() {
        return new SeccompProfileNested(null);
    }

    public SeccompProfileNested<A> withNewSeccompProfileLike(V1SeccompProfile item) {
        return new SeccompProfileNested(item);
    }

    public SeccompProfileNested<A> editSeccompProfile() {
        return this.withNewSeccompProfileLike(Optional.ofNullable(this.buildSeccompProfile()).orElse(null));
    }

    public SeccompProfileNested<A> editOrNewSeccompProfile() {
        return this.withNewSeccompProfileLike(Optional.ofNullable(this.buildSeccompProfile()).orElse(new V1SeccompProfileBuilder().build()));
    }

    public SeccompProfileNested<A> editOrNewSeccompProfileLike(V1SeccompProfile item) {
        return this.withNewSeccompProfileLike(Optional.ofNullable(this.buildSeccompProfile()).orElse(item));
    }

    public V1WindowsSecurityContextOptions buildWindowsOptions() {
        return this.windowsOptions != null ? this.windowsOptions.build() : null;
    }

    public A withWindowsOptions(V1WindowsSecurityContextOptions windowsOptions) {
        this._visitables.remove("windowsOptions");
        if (windowsOptions != null) {
            this.windowsOptions = new V1WindowsSecurityContextOptionsBuilder(windowsOptions);
            this._visitables.get("windowsOptions").add(this.windowsOptions);
        } else {
            this.windowsOptions = null;
            this._visitables.get("windowsOptions").remove(this.windowsOptions);
        }
        return (A)this;
    }

    public boolean hasWindowsOptions() {
        return this.windowsOptions != null;
    }

    public WindowsOptionsNested<A> withNewWindowsOptions() {
        return new WindowsOptionsNested(null);
    }

    public WindowsOptionsNested<A> withNewWindowsOptionsLike(V1WindowsSecurityContextOptions item) {
        return new WindowsOptionsNested(item);
    }

    public WindowsOptionsNested<A> editWindowsOptions() {
        return this.withNewWindowsOptionsLike(Optional.ofNullable(this.buildWindowsOptions()).orElse(null));
    }

    public WindowsOptionsNested<A> editOrNewWindowsOptions() {
        return this.withNewWindowsOptionsLike(Optional.ofNullable(this.buildWindowsOptions()).orElse(new V1WindowsSecurityContextOptionsBuilder().build()));
    }

    public WindowsOptionsNested<A> editOrNewWindowsOptionsLike(V1WindowsSecurityContextOptions item) {
        return this.withNewWindowsOptionsLike(Optional.ofNullable(this.buildWindowsOptions()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1SecurityContextFluent that = (V1SecurityContextFluent)o;
        if (!Objects.equals(this.allowPrivilegeEscalation, that.allowPrivilegeEscalation)) {
            return false;
        }
        if (!Objects.equals(this.appArmorProfile, that.appArmorProfile)) {
            return false;
        }
        if (!Objects.equals(this.capabilities, that.capabilities)) {
            return false;
        }
        if (!Objects.equals(this.privileged, that.privileged)) {
            return false;
        }
        if (!Objects.equals(this.procMount, that.procMount)) {
            return false;
        }
        if (!Objects.equals(this.readOnlyRootFilesystem, that.readOnlyRootFilesystem)) {
            return false;
        }
        if (!Objects.equals(this.runAsGroup, that.runAsGroup)) {
            return false;
        }
        if (!Objects.equals(this.runAsNonRoot, that.runAsNonRoot)) {
            return false;
        }
        if (!Objects.equals(this.runAsUser, that.runAsUser)) {
            return false;
        }
        if (!Objects.equals(this.seLinuxOptions, that.seLinuxOptions)) {
            return false;
        }
        if (!Objects.equals(this.seccompProfile, that.seccompProfile)) {
            return false;
        }
        return Objects.equals(this.windowsOptions, that.windowsOptions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowPrivilegeEscalation, this.appArmorProfile, this.capabilities, this.privileged, this.procMount, this.readOnlyRootFilesystem, this.runAsGroup, this.runAsNonRoot, this.runAsUser, this.seLinuxOptions, this.seccompProfile, this.windowsOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowPrivilegeEscalation != null) {
            sb.append("allowPrivilegeEscalation:");
            sb.append(this.allowPrivilegeEscalation);
            sb.append(",");
        }
        if (this.appArmorProfile != null) {
            sb.append("appArmorProfile:");
            sb.append(this.appArmorProfile);
            sb.append(",");
        }
        if (this.capabilities != null) {
            sb.append("capabilities:");
            sb.append(this.capabilities);
            sb.append(",");
        }
        if (this.privileged != null) {
            sb.append("privileged:");
            sb.append(this.privileged);
            sb.append(",");
        }
        if (this.procMount != null) {
            sb.append("procMount:");
            sb.append(this.procMount);
            sb.append(",");
        }
        if (this.readOnlyRootFilesystem != null) {
            sb.append("readOnlyRootFilesystem:");
            sb.append(this.readOnlyRootFilesystem);
            sb.append(",");
        }
        if (this.runAsGroup != null) {
            sb.append("runAsGroup:");
            sb.append(this.runAsGroup);
            sb.append(",");
        }
        if (this.runAsNonRoot != null) {
            sb.append("runAsNonRoot:");
            sb.append(this.runAsNonRoot);
            sb.append(",");
        }
        if (this.runAsUser != null) {
            sb.append("runAsUser:");
            sb.append(this.runAsUser);
            sb.append(",");
        }
        if (this.seLinuxOptions != null) {
            sb.append("seLinuxOptions:");
            sb.append(this.seLinuxOptions);
            sb.append(",");
        }
        if (this.seccompProfile != null) {
            sb.append("seccompProfile:");
            sb.append(this.seccompProfile);
            sb.append(",");
        }
        if (this.windowsOptions != null) {
            sb.append("windowsOptions:");
            sb.append(this.windowsOptions);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAllowPrivilegeEscalation() {
        return this.withAllowPrivilegeEscalation(true);
    }

    public A withPrivileged() {
        return this.withPrivileged(true);
    }

    public A withReadOnlyRootFilesystem() {
        return this.withReadOnlyRootFilesystem(true);
    }

    public A withRunAsNonRoot() {
        return this.withRunAsNonRoot(true);
    }

    public class AppArmorProfileNested<N>
    extends V1AppArmorProfileFluent<AppArmorProfileNested<N>>
    implements Nested<N> {
        V1AppArmorProfileBuilder builder;

        AppArmorProfileNested(V1AppArmorProfile item) {
            this.builder = new V1AppArmorProfileBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1SecurityContextFluent.this.withAppArmorProfile(this.builder.build());
        }

        public N endAppArmorProfile() {
            return this.and();
        }
    }

    public class CapabilitiesNested<N>
    extends V1CapabilitiesFluent<CapabilitiesNested<N>>
    implements Nested<N> {
        V1CapabilitiesBuilder builder;

        CapabilitiesNested(V1Capabilities item) {
            this.builder = new V1CapabilitiesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1SecurityContextFluent.this.withCapabilities(this.builder.build());
        }

        public N endCapabilities() {
            return this.and();
        }
    }

    public class SeLinuxOptionsNested<N>
    extends V1SELinuxOptionsFluent<SeLinuxOptionsNested<N>>
    implements Nested<N> {
        V1SELinuxOptionsBuilder builder;

        SeLinuxOptionsNested(V1SELinuxOptions item) {
            this.builder = new V1SELinuxOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1SecurityContextFluent.this.withSeLinuxOptions(this.builder.build());
        }

        public N endSeLinuxOptions() {
            return this.and();
        }
    }

    public class SeccompProfileNested<N>
    extends V1SeccompProfileFluent<SeccompProfileNested<N>>
    implements Nested<N> {
        V1SeccompProfileBuilder builder;

        SeccompProfileNested(V1SeccompProfile item) {
            this.builder = new V1SeccompProfileBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1SecurityContextFluent.this.withSeccompProfile(this.builder.build());
        }

        public N endSeccompProfile() {
            return this.and();
        }
    }

    public class WindowsOptionsNested<N>
    extends V1WindowsSecurityContextOptionsFluent<WindowsOptionsNested<N>>
    implements Nested<N> {
        V1WindowsSecurityContextOptionsBuilder builder;

        WindowsOptionsNested(V1WindowsSecurityContextOptions item) {
            this.builder = new V1WindowsSecurityContextOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1SecurityContextFluent.this.withWindowsOptions(this.builder.build());
        }

        public N endWindowsOptions() {
            return this.and();
        }
    }
}

