/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1AllocatedDeviceStatus;
import io.kubernetes.client.openapi.models.V1AllocatedDeviceStatusBuilder;
import io.kubernetes.client.openapi.models.V1AllocatedDeviceStatusFluent;
import io.kubernetes.client.openapi.models.V1AllocationResult;
import io.kubernetes.client.openapi.models.V1AllocationResultBuilder;
import io.kubernetes.client.openapi.models.V1AllocationResultFluent;
import io.kubernetes.client.openapi.models.V1ResourceClaimConsumerReference;
import io.kubernetes.client.openapi.models.V1ResourceClaimConsumerReferenceBuilder;
import io.kubernetes.client.openapi.models.V1ResourceClaimConsumerReferenceFluent;
import io.kubernetes.client.openapi.models.V1ResourceClaimStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1ResourceClaimStatusFluent<A extends V1ResourceClaimStatusFluent<A>>
extends BaseFluent<A> {
    private V1AllocationResultBuilder allocation;
    private ArrayList<V1AllocatedDeviceStatusBuilder> devices;
    private ArrayList<V1ResourceClaimConsumerReferenceBuilder> reservedFor;

    public V1ResourceClaimStatusFluent() {
    }

    public V1ResourceClaimStatusFluent(V1ResourceClaimStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1ResourceClaimStatus instance) {
        V1ResourceClaimStatus v1ResourceClaimStatus = instance = instance != null ? instance : new V1ResourceClaimStatus();
        if (instance != null) {
            this.withAllocation(instance.getAllocation());
            this.withDevices(instance.getDevices());
            this.withReservedFor(instance.getReservedFor());
        }
    }

    public V1AllocationResult buildAllocation() {
        return this.allocation != null ? this.allocation.build() : null;
    }

    public A withAllocation(V1AllocationResult allocation) {
        this._visitables.remove("allocation");
        if (allocation != null) {
            this.allocation = new V1AllocationResultBuilder(allocation);
            this._visitables.get("allocation").add(this.allocation);
        } else {
            this.allocation = null;
            this._visitables.get("allocation").remove(this.allocation);
        }
        return (A)this;
    }

    public boolean hasAllocation() {
        return this.allocation != null;
    }

    public AllocationNested<A> withNewAllocation() {
        return new AllocationNested(null);
    }

    public AllocationNested<A> withNewAllocationLike(V1AllocationResult item) {
        return new AllocationNested(item);
    }

    public AllocationNested<A> editAllocation() {
        return this.withNewAllocationLike(Optional.ofNullable(this.buildAllocation()).orElse(null));
    }

    public AllocationNested<A> editOrNewAllocation() {
        return this.withNewAllocationLike(Optional.ofNullable(this.buildAllocation()).orElse(new V1AllocationResultBuilder().build()));
    }

    public AllocationNested<A> editOrNewAllocationLike(V1AllocationResult item) {
        return this.withNewAllocationLike(Optional.ofNullable(this.buildAllocation()).orElse(item));
    }

    public A addToDevices(int index, V1AllocatedDeviceStatus item) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        V1AllocatedDeviceStatusBuilder builder = new V1AllocatedDeviceStatusBuilder(item);
        if (index < 0 || index >= this.devices.size()) {
            this._visitables.get("devices").add(builder);
            this.devices.add(builder);
        } else {
            this._visitables.get("devices").add(builder);
            this.devices.add(index, builder);
        }
        return (A)this;
    }

    public A setToDevices(int index, V1AllocatedDeviceStatus item) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        V1AllocatedDeviceStatusBuilder builder = new V1AllocatedDeviceStatusBuilder(item);
        if (index < 0 || index >= this.devices.size()) {
            this._visitables.get("devices").add(builder);
            this.devices.add(builder);
        } else {
            this._visitables.get("devices").add(builder);
            this.devices.set(index, builder);
        }
        return (A)this;
    }

    public A addToDevices(V1AllocatedDeviceStatus ... items) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        for (V1AllocatedDeviceStatus item : items) {
            V1AllocatedDeviceStatusBuilder builder = new V1AllocatedDeviceStatusBuilder(item);
            this._visitables.get("devices").add(builder);
            this.devices.add(builder);
        }
        return (A)this;
    }

    public A addAllToDevices(Collection<V1AllocatedDeviceStatus> items) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        for (V1AllocatedDeviceStatus item : items) {
            V1AllocatedDeviceStatusBuilder builder = new V1AllocatedDeviceStatusBuilder(item);
            this._visitables.get("devices").add(builder);
            this.devices.add(builder);
        }
        return (A)this;
    }

    public A removeFromDevices(V1AllocatedDeviceStatus ... items) {
        if (this.devices == null) {
            return (A)this;
        }
        for (V1AllocatedDeviceStatus item : items) {
            V1AllocatedDeviceStatusBuilder builder = new V1AllocatedDeviceStatusBuilder(item);
            this._visitables.get("devices").remove(builder);
            this.devices.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromDevices(Collection<V1AllocatedDeviceStatus> items) {
        if (this.devices == null) {
            return (A)this;
        }
        for (V1AllocatedDeviceStatus item : items) {
            V1AllocatedDeviceStatusBuilder builder = new V1AllocatedDeviceStatusBuilder(item);
            this._visitables.get("devices").remove(builder);
            this.devices.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromDevices(Predicate<V1AllocatedDeviceStatusBuilder> predicate) {
        if (this.devices == null) {
            return (A)this;
        }
        Iterator<V1AllocatedDeviceStatusBuilder> each = this.devices.iterator();
        Object visitables = this._visitables.get("devices");
        while (each.hasNext()) {
            V1AllocatedDeviceStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1AllocatedDeviceStatus> buildDevices() {
        return this.devices != null ? V1ResourceClaimStatusFluent.build(this.devices) : null;
    }

    public V1AllocatedDeviceStatus buildDevice(int index) {
        return this.devices.get(index).build();
    }

    public V1AllocatedDeviceStatus buildFirstDevice() {
        return this.devices.get(0).build();
    }

    public V1AllocatedDeviceStatus buildLastDevice() {
        return this.devices.get(this.devices.size() - 1).build();
    }

    public V1AllocatedDeviceStatus buildMatchingDevice(Predicate<V1AllocatedDeviceStatusBuilder> predicate) {
        for (V1AllocatedDeviceStatusBuilder item : this.devices) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDevice(Predicate<V1AllocatedDeviceStatusBuilder> predicate) {
        for (V1AllocatedDeviceStatusBuilder item : this.devices) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDevices(List<V1AllocatedDeviceStatus> devices) {
        if (this.devices != null) {
            this._visitables.get("devices").clear();
        }
        if (devices != null) {
            this.devices = new ArrayList();
            for (V1AllocatedDeviceStatus item : devices) {
                this.addToDevices(item);
            }
        } else {
            this.devices = null;
        }
        return (A)this;
    }

    public A withDevices(V1AllocatedDeviceStatus ... devices) {
        if (this.devices != null) {
            this.devices.clear();
            this._visitables.remove("devices");
        }
        if (devices != null) {
            for (V1AllocatedDeviceStatus item : devices) {
                this.addToDevices(item);
            }
        }
        return (A)this;
    }

    public boolean hasDevices() {
        return this.devices != null && !this.devices.isEmpty();
    }

    public DevicesNested<A> addNewDevice() {
        return new DevicesNested(-1, null);
    }

    public DevicesNested<A> addNewDeviceLike(V1AllocatedDeviceStatus item) {
        return new DevicesNested(-1, item);
    }

    public DevicesNested<A> setNewDeviceLike(int index, V1AllocatedDeviceStatus item) {
        return new DevicesNested(index, item);
    }

    public DevicesNested<A> editDevice(int index) {
        if (index <= this.devices.size()) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "devices"));
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public DevicesNested<A> editFirstDevice() {
        if (this.devices.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "devices"));
        }
        return this.setNewDeviceLike(0, this.buildDevice(0));
    }

    public DevicesNested<A> editLastDevice() {
        int index = this.devices.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "devices"));
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public DevicesNested<A> editMatchingDevice(Predicate<V1AllocatedDeviceStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!predicate.test(this.devices.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "devices"));
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public A addToReservedFor(int index, V1ResourceClaimConsumerReference item) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        V1ResourceClaimConsumerReferenceBuilder builder = new V1ResourceClaimConsumerReferenceBuilder(item);
        if (index < 0 || index >= this.reservedFor.size()) {
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        } else {
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(index, builder);
        }
        return (A)this;
    }

    public A setToReservedFor(int index, V1ResourceClaimConsumerReference item) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        V1ResourceClaimConsumerReferenceBuilder builder = new V1ResourceClaimConsumerReferenceBuilder(item);
        if (index < 0 || index >= this.reservedFor.size()) {
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        } else {
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.set(index, builder);
        }
        return (A)this;
    }

    public A addToReservedFor(V1ResourceClaimConsumerReference ... items) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        for (V1ResourceClaimConsumerReference item : items) {
            V1ResourceClaimConsumerReferenceBuilder builder = new V1ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        }
        return (A)this;
    }

    public A addAllToReservedFor(Collection<V1ResourceClaimConsumerReference> items) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList();
        }
        for (V1ResourceClaimConsumerReference item : items) {
            V1ResourceClaimConsumerReferenceBuilder builder = new V1ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").add(builder);
            this.reservedFor.add(builder);
        }
        return (A)this;
    }

    public A removeFromReservedFor(V1ResourceClaimConsumerReference ... items) {
        if (this.reservedFor == null) {
            return (A)this;
        }
        for (V1ResourceClaimConsumerReference item : items) {
            V1ResourceClaimConsumerReferenceBuilder builder = new V1ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").remove(builder);
            this.reservedFor.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromReservedFor(Collection<V1ResourceClaimConsumerReference> items) {
        if (this.reservedFor == null) {
            return (A)this;
        }
        for (V1ResourceClaimConsumerReference item : items) {
            V1ResourceClaimConsumerReferenceBuilder builder = new V1ResourceClaimConsumerReferenceBuilder(item);
            this._visitables.get("reservedFor").remove(builder);
            this.reservedFor.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromReservedFor(Predicate<V1ResourceClaimConsumerReferenceBuilder> predicate) {
        if (this.reservedFor == null) {
            return (A)this;
        }
        Iterator<V1ResourceClaimConsumerReferenceBuilder> each = this.reservedFor.iterator();
        Object visitables = this._visitables.get("reservedFor");
        while (each.hasNext()) {
            V1ResourceClaimConsumerReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1ResourceClaimConsumerReference> buildReservedFor() {
        return this.reservedFor != null ? V1ResourceClaimStatusFluent.build(this.reservedFor) : null;
    }

    public V1ResourceClaimConsumerReference buildReservedFor(int index) {
        return this.reservedFor.get(index).build();
    }

    public V1ResourceClaimConsumerReference buildFirstReservedFor() {
        return this.reservedFor.get(0).build();
    }

    public V1ResourceClaimConsumerReference buildLastReservedFor() {
        return this.reservedFor.get(this.reservedFor.size() - 1).build();
    }

    public V1ResourceClaimConsumerReference buildMatchingReservedFor(Predicate<V1ResourceClaimConsumerReferenceBuilder> predicate) {
        for (V1ResourceClaimConsumerReferenceBuilder item : this.reservedFor) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingReservedFor(Predicate<V1ResourceClaimConsumerReferenceBuilder> predicate) {
        for (V1ResourceClaimConsumerReferenceBuilder item : this.reservedFor) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withReservedFor(List<V1ResourceClaimConsumerReference> reservedFor) {
        if (this.reservedFor != null) {
            this._visitables.get("reservedFor").clear();
        }
        if (reservedFor != null) {
            this.reservedFor = new ArrayList();
            for (V1ResourceClaimConsumerReference item : reservedFor) {
                this.addToReservedFor(item);
            }
        } else {
            this.reservedFor = null;
        }
        return (A)this;
    }

    public A withReservedFor(V1ResourceClaimConsumerReference ... reservedFor) {
        if (this.reservedFor != null) {
            this.reservedFor.clear();
            this._visitables.remove("reservedFor");
        }
        if (reservedFor != null) {
            for (V1ResourceClaimConsumerReference item : reservedFor) {
                this.addToReservedFor(item);
            }
        }
        return (A)this;
    }

    public boolean hasReservedFor() {
        return this.reservedFor != null && !this.reservedFor.isEmpty();
    }

    public ReservedForNested<A> addNewReservedFor() {
        return new ReservedForNested(-1, null);
    }

    public ReservedForNested<A> addNewReservedForLike(V1ResourceClaimConsumerReference item) {
        return new ReservedForNested(-1, item);
    }

    public ReservedForNested<A> setNewReservedForLike(int index, V1ResourceClaimConsumerReference item) {
        return new ReservedForNested(index, item);
    }

    public ReservedForNested<A> editReservedFor(int index) {
        if (index <= this.reservedFor.size()) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "reservedFor"));
        }
        return this.setNewReservedForLike(index, this.buildReservedFor(index));
    }

    public ReservedForNested<A> editFirstReservedFor() {
        if (this.reservedFor.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "reservedFor"));
        }
        return this.setNewReservedForLike(0, this.buildReservedFor(0));
    }

    public ReservedForNested<A> editLastReservedFor() {
        int index = this.reservedFor.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "reservedFor"));
        }
        return this.setNewReservedForLike(index, this.buildReservedFor(index));
    }

    public ReservedForNested<A> editMatchingReservedFor(Predicate<V1ResourceClaimConsumerReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.reservedFor.size(); ++i) {
            if (!predicate.test(this.reservedFor.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "reservedFor"));
        }
        return this.setNewReservedForLike(index, this.buildReservedFor(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ResourceClaimStatusFluent that = (V1ResourceClaimStatusFluent)o;
        if (!Objects.equals(this.allocation, that.allocation)) {
            return false;
        }
        if (!Objects.equals(this.devices, that.devices)) {
            return false;
        }
        return Objects.equals(this.reservedFor, that.reservedFor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allocation, this.devices, this.reservedFor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocation != null) {
            sb.append("allocation:");
            sb.append(this.allocation);
            sb.append(",");
        }
        if (this.devices != null && !this.devices.isEmpty()) {
            sb.append("devices:");
            sb.append(this.devices);
            sb.append(",");
        }
        if (this.reservedFor != null && !this.reservedFor.isEmpty()) {
            sb.append("reservedFor:");
            sb.append(this.reservedFor);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AllocationNested<N>
    extends V1AllocationResultFluent<AllocationNested<N>>
    implements Nested<N> {
        V1AllocationResultBuilder builder;

        AllocationNested(V1AllocationResult item) {
            this.builder = new V1AllocationResultBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ResourceClaimStatusFluent.this.withAllocation(this.builder.build());
        }

        public N endAllocation() {
            return this.and();
        }
    }

    public class DevicesNested<N>
    extends V1AllocatedDeviceStatusFluent<DevicesNested<N>>
    implements Nested<N> {
        V1AllocatedDeviceStatusBuilder builder;
        int index;

        DevicesNested(int index, V1AllocatedDeviceStatus item) {
            this.index = index;
            this.builder = new V1AllocatedDeviceStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ResourceClaimStatusFluent.this.setToDevices(this.index, this.builder.build());
        }

        public N endDevice() {
            return this.and();
        }
    }

    public class ReservedForNested<N>
    extends V1ResourceClaimConsumerReferenceFluent<ReservedForNested<N>>
    implements Nested<N> {
        V1ResourceClaimConsumerReferenceBuilder builder;
        int index;

        ReservedForNested(int index, V1ResourceClaimConsumerReference item) {
            this.index = index;
            this.builder = new V1ResourceClaimConsumerReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ResourceClaimStatusFluent.this.setToReservedFor(this.index, this.builder.build());
        }

        public N endReservedFor() {
            return this.and();
        }
    }
}

