/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecBuilder;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecFluent;
import io.kubernetes.client.openapi.models.V1ReplicationControllerSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class V1ReplicationControllerSpecFluent<A extends V1ReplicationControllerSpecFluent<A>>
extends BaseFluent<A> {
    private Integer minReadySeconds;
    private Integer replicas;
    private Map<String, String> selector;
    private V1PodTemplateSpecBuilder template;

    public V1ReplicationControllerSpecFluent() {
    }

    public V1ReplicationControllerSpecFluent(V1ReplicationControllerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1ReplicationControllerSpec instance) {
        V1ReplicationControllerSpec v1ReplicationControllerSpec = instance = instance != null ? instance : new V1ReplicationControllerSpec();
        if (instance != null) {
            this.withMinReadySeconds(instance.getMinReadySeconds());
            this.withReplicas(instance.getReplicas());
            this.withSelector(instance.getSelector());
            this.withTemplate(instance.getTemplate());
        }
    }

    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    public boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public A addToSelector(String key, String value) {
        if (this.selector == null && key != null && value != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)this;
    }

    public A addToSelector(Map<String, String> map) {
        if (this.selector == null && map != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)this;
    }

    public A removeFromSelector(String key) {
        if (this.selector == null) {
            return (A)this;
        }
        if (key != null && this.selector != null) {
            this.selector.remove(key);
        }
        return (A)this;
    }

    public A removeFromSelector(Map<String, String> map) {
        if (this.selector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.selector == null) continue;
                this.selector.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getSelector() {
        return this.selector;
    }

    public <K, V> A withSelector(Map<String, String> selector) {
        this.selector = selector == null ? null : new LinkedHashMap<String, String>(selector);
        return (A)this;
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public V1PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(V1PodTemplateSpec template) {
        this._visitables.remove("template");
        if (template != null) {
            this.template = new V1PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get("template").remove(this.template);
        }
        return (A)this;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new V1PodTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ReplicationControllerSpecFluent that = (V1ReplicationControllerSpecFluent)o;
        if (!Objects.equals(this.minReadySeconds, that.minReadySeconds)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        return Objects.equals(this.template, that.template);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.replicas, this.selector, this.template);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minReadySeconds != null) {
            sb.append("minReadySeconds:");
            sb.append(this.minReadySeconds);
            sb.append(",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas);
            sb.append(",");
        }
        if (this.selector != null && !this.selector.isEmpty()) {
            sb.append("selector:");
            sb.append(this.selector);
            sb.append(",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TemplateNested<N>
    extends V1PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        V1PodTemplateSpecBuilder builder;

        TemplateNested(V1PodTemplateSpec item) {
            this.builder = new V1PodTemplateSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ReplicationControllerSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }
}

