/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ProjectedVolumeSource;
import io.kubernetes.client.openapi.models.V1VolumeProjection;
import io.kubernetes.client.openapi.models.V1VolumeProjectionBuilder;
import io.kubernetes.client.openapi.models.V1VolumeProjectionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1ProjectedVolumeSourceFluent<A extends V1ProjectedVolumeSourceFluent<A>>
extends BaseFluent<A> {
    private Integer defaultMode;
    private ArrayList<V1VolumeProjectionBuilder> sources;

    public V1ProjectedVolumeSourceFluent() {
    }

    public V1ProjectedVolumeSourceFluent(V1ProjectedVolumeSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1ProjectedVolumeSource instance) {
        V1ProjectedVolumeSource v1ProjectedVolumeSource = instance = instance != null ? instance : new V1ProjectedVolumeSource();
        if (instance != null) {
            this.withDefaultMode(instance.getDefaultMode());
            this.withSources(instance.getSources());
        }
    }

    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public A withDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return (A)this;
    }

    public boolean hasDefaultMode() {
        return this.defaultMode != null;
    }

    public A addToSources(int index, V1VolumeProjection item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        V1VolumeProjectionBuilder builder = new V1VolumeProjectionBuilder(item);
        if (index < 0 || index >= this.sources.size()) {
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        } else {
            this._visitables.get("sources").add(builder);
            this.sources.add(index, builder);
        }
        return (A)this;
    }

    public A setToSources(int index, V1VolumeProjection item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        V1VolumeProjectionBuilder builder = new V1VolumeProjectionBuilder(item);
        if (index < 0 || index >= this.sources.size()) {
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        } else {
            this._visitables.get("sources").add(builder);
            this.sources.set(index, builder);
        }
        return (A)this;
    }

    public A addToSources(V1VolumeProjection ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (V1VolumeProjection item : items) {
            V1VolumeProjectionBuilder builder = new V1VolumeProjectionBuilder(item);
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    public A addAllToSources(Collection<V1VolumeProjection> items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (V1VolumeProjection item : items) {
            V1VolumeProjectionBuilder builder = new V1VolumeProjectionBuilder(item);
            this._visitables.get("sources").add(builder);
            this.sources.add(builder);
        }
        return (A)this;
    }

    public A removeFromSources(V1VolumeProjection ... items) {
        if (this.sources == null) {
            return (A)this;
        }
        for (V1VolumeProjection item : items) {
            V1VolumeProjectionBuilder builder = new V1VolumeProjectionBuilder(item);
            this._visitables.get("sources").remove(builder);
            this.sources.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSources(Collection<V1VolumeProjection> items) {
        if (this.sources == null) {
            return (A)this;
        }
        for (V1VolumeProjection item : items) {
            V1VolumeProjectionBuilder builder = new V1VolumeProjectionBuilder(item);
            this._visitables.get("sources").remove(builder);
            this.sources.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSources(Predicate<V1VolumeProjectionBuilder> predicate) {
        if (this.sources == null) {
            return (A)this;
        }
        Iterator<V1VolumeProjectionBuilder> each = this.sources.iterator();
        Object visitables = this._visitables.get("sources");
        while (each.hasNext()) {
            V1VolumeProjectionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1VolumeProjection> buildSources() {
        return this.sources != null ? V1ProjectedVolumeSourceFluent.build(this.sources) : null;
    }

    public V1VolumeProjection buildSource(int index) {
        return this.sources.get(index).build();
    }

    public V1VolumeProjection buildFirstSource() {
        return this.sources.get(0).build();
    }

    public V1VolumeProjection buildLastSource() {
        return this.sources.get(this.sources.size() - 1).build();
    }

    public V1VolumeProjection buildMatchingSource(Predicate<V1VolumeProjectionBuilder> predicate) {
        for (V1VolumeProjectionBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSource(Predicate<V1VolumeProjectionBuilder> predicate) {
        for (V1VolumeProjectionBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSources(List<V1VolumeProjection> sources) {
        if (this.sources != null) {
            this._visitables.get("sources").clear();
        }
        if (sources != null) {
            this.sources = new ArrayList();
            for (V1VolumeProjection item : sources) {
                this.addToSources(item);
            }
        } else {
            this.sources = null;
        }
        return (A)this;
    }

    public A withSources(V1VolumeProjection ... sources) {
        if (this.sources != null) {
            this.sources.clear();
            this._visitables.remove("sources");
        }
        if (sources != null) {
            for (V1VolumeProjection item : sources) {
                this.addToSources(item);
            }
        }
        return (A)this;
    }

    public boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    public SourcesNested<A> addNewSource() {
        return new SourcesNested(-1, null);
    }

    public SourcesNested<A> addNewSourceLike(V1VolumeProjection item) {
        return new SourcesNested(-1, item);
    }

    public SourcesNested<A> setNewSourceLike(int index, V1VolumeProjection item) {
        return new SourcesNested(index, item);
    }

    public SourcesNested<A> editSource(int index) {
        if (index <= this.sources.size()) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "sources"));
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public SourcesNested<A> editFirstSource() {
        if (this.sources.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "sources"));
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    public SourcesNested<A> editLastSource() {
        int index = this.sources.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "sources"));
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public SourcesNested<A> editMatchingSource(Predicate<V1VolumeProjectionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!predicate.test(this.sources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "sources"));
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ProjectedVolumeSourceFluent that = (V1ProjectedVolumeSourceFluent)o;
        if (!Objects.equals(this.defaultMode, that.defaultMode)) {
            return false;
        }
        return Objects.equals(this.sources, that.sources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultMode, this.sources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultMode != null) {
            sb.append("defaultMode:");
            sb.append(this.defaultMode);
            sb.append(",");
        }
        if (this.sources != null && !this.sources.isEmpty()) {
            sb.append("sources:");
            sb.append(this.sources);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SourcesNested<N>
    extends V1VolumeProjectionFluent<SourcesNested<N>>
    implements Nested<N> {
        V1VolumeProjectionBuilder builder;
        int index;

        SourcesNested(int index, V1VolumeProjection item) {
            this.index = index;
            this.builder = new V1VolumeProjectionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ProjectedVolumeSourceFluent.this.setToSources(this.index, this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }
}

