/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.FlowcontrolV1Subject;
import io.kubernetes.client.openapi.models.FlowcontrolV1SubjectBuilder;
import io.kubernetes.client.openapi.models.FlowcontrolV1SubjectFluent;
import io.kubernetes.client.openapi.models.V1NonResourcePolicyRule;
import io.kubernetes.client.openapi.models.V1NonResourcePolicyRuleBuilder;
import io.kubernetes.client.openapi.models.V1NonResourcePolicyRuleFluent;
import io.kubernetes.client.openapi.models.V1PolicyRulesWithSubjects;
import io.kubernetes.client.openapi.models.V1ResourcePolicyRule;
import io.kubernetes.client.openapi.models.V1ResourcePolicyRuleBuilder;
import io.kubernetes.client.openapi.models.V1ResourcePolicyRuleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1PolicyRulesWithSubjectsFluent<A extends V1PolicyRulesWithSubjectsFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1NonResourcePolicyRuleBuilder> nonResourceRules;
    private ArrayList<V1ResourcePolicyRuleBuilder> resourceRules;
    private ArrayList<FlowcontrolV1SubjectBuilder> subjects;

    public V1PolicyRulesWithSubjectsFluent() {
    }

    public V1PolicyRulesWithSubjectsFluent(V1PolicyRulesWithSubjects instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1PolicyRulesWithSubjects instance) {
        V1PolicyRulesWithSubjects v1PolicyRulesWithSubjects = instance = instance != null ? instance : new V1PolicyRulesWithSubjects();
        if (instance != null) {
            this.withNonResourceRules(instance.getNonResourceRules());
            this.withResourceRules(instance.getResourceRules());
            this.withSubjects(instance.getSubjects());
        }
    }

    public A addToNonResourceRules(int index, V1NonResourcePolicyRule item) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        V1NonResourcePolicyRuleBuilder builder = new V1NonResourcePolicyRuleBuilder(item);
        if (index < 0 || index >= this.nonResourceRules.size()) {
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        } else {
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(index, builder);
        }
        return (A)this;
    }

    public A setToNonResourceRules(int index, V1NonResourcePolicyRule item) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        V1NonResourcePolicyRuleBuilder builder = new V1NonResourcePolicyRuleBuilder(item);
        if (index < 0 || index >= this.nonResourceRules.size()) {
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        } else {
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.set(index, builder);
        }
        return (A)this;
    }

    public A addToNonResourceRules(V1NonResourcePolicyRule ... items) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        for (V1NonResourcePolicyRule item : items) {
            V1NonResourcePolicyRuleBuilder builder = new V1NonResourcePolicyRuleBuilder(item);
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        }
        return (A)this;
    }

    public A addAllToNonResourceRules(Collection<V1NonResourcePolicyRule> items) {
        if (this.nonResourceRules == null) {
            this.nonResourceRules = new ArrayList();
        }
        for (V1NonResourcePolicyRule item : items) {
            V1NonResourcePolicyRuleBuilder builder = new V1NonResourcePolicyRuleBuilder(item);
            this._visitables.get("nonResourceRules").add(builder);
            this.nonResourceRules.add(builder);
        }
        return (A)this;
    }

    public A removeFromNonResourceRules(V1NonResourcePolicyRule ... items) {
        if (this.nonResourceRules == null) {
            return (A)this;
        }
        for (V1NonResourcePolicyRule item : items) {
            V1NonResourcePolicyRuleBuilder builder = new V1NonResourcePolicyRuleBuilder(item);
            this._visitables.get("nonResourceRules").remove(builder);
            this.nonResourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromNonResourceRules(Collection<V1NonResourcePolicyRule> items) {
        if (this.nonResourceRules == null) {
            return (A)this;
        }
        for (V1NonResourcePolicyRule item : items) {
            V1NonResourcePolicyRuleBuilder builder = new V1NonResourcePolicyRuleBuilder(item);
            this._visitables.get("nonResourceRules").remove(builder);
            this.nonResourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromNonResourceRules(Predicate<V1NonResourcePolicyRuleBuilder> predicate) {
        if (this.nonResourceRules == null) {
            return (A)this;
        }
        Iterator<V1NonResourcePolicyRuleBuilder> each = this.nonResourceRules.iterator();
        Object visitables = this._visitables.get("nonResourceRules");
        while (each.hasNext()) {
            V1NonResourcePolicyRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1NonResourcePolicyRule> buildNonResourceRules() {
        return this.nonResourceRules != null ? V1PolicyRulesWithSubjectsFluent.build(this.nonResourceRules) : null;
    }

    public V1NonResourcePolicyRule buildNonResourceRule(int index) {
        return this.nonResourceRules.get(index).build();
    }

    public V1NonResourcePolicyRule buildFirstNonResourceRule() {
        return this.nonResourceRules.get(0).build();
    }

    public V1NonResourcePolicyRule buildLastNonResourceRule() {
        return this.nonResourceRules.get(this.nonResourceRules.size() - 1).build();
    }

    public V1NonResourcePolicyRule buildMatchingNonResourceRule(Predicate<V1NonResourcePolicyRuleBuilder> predicate) {
        for (V1NonResourcePolicyRuleBuilder item : this.nonResourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingNonResourceRule(Predicate<V1NonResourcePolicyRuleBuilder> predicate) {
        for (V1NonResourcePolicyRuleBuilder item : this.nonResourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNonResourceRules(List<V1NonResourcePolicyRule> nonResourceRules) {
        if (this.nonResourceRules != null) {
            this._visitables.get("nonResourceRules").clear();
        }
        if (nonResourceRules != null) {
            this.nonResourceRules = new ArrayList();
            for (V1NonResourcePolicyRule item : nonResourceRules) {
                this.addToNonResourceRules(item);
            }
        } else {
            this.nonResourceRules = null;
        }
        return (A)this;
    }

    public A withNonResourceRules(V1NonResourcePolicyRule ... nonResourceRules) {
        if (this.nonResourceRules != null) {
            this.nonResourceRules.clear();
            this._visitables.remove("nonResourceRules");
        }
        if (nonResourceRules != null) {
            for (V1NonResourcePolicyRule item : nonResourceRules) {
                this.addToNonResourceRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasNonResourceRules() {
        return this.nonResourceRules != null && !this.nonResourceRules.isEmpty();
    }

    public NonResourceRulesNested<A> addNewNonResourceRule() {
        return new NonResourceRulesNested(-1, null);
    }

    public NonResourceRulesNested<A> addNewNonResourceRuleLike(V1NonResourcePolicyRule item) {
        return new NonResourceRulesNested(-1, item);
    }

    public NonResourceRulesNested<A> setNewNonResourceRuleLike(int index, V1NonResourcePolicyRule item) {
        return new NonResourceRulesNested(index, item);
    }

    public NonResourceRulesNested<A> editNonResourceRule(int index) {
        if (index <= this.nonResourceRules.size()) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "nonResourceRules"));
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    public NonResourceRulesNested<A> editFirstNonResourceRule() {
        if (this.nonResourceRules.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "nonResourceRules"));
        }
        return this.setNewNonResourceRuleLike(0, this.buildNonResourceRule(0));
    }

    public NonResourceRulesNested<A> editLastNonResourceRule() {
        int index = this.nonResourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "nonResourceRules"));
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    public NonResourceRulesNested<A> editMatchingNonResourceRule(Predicate<V1NonResourcePolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.nonResourceRules.size(); ++i) {
            if (!predicate.test(this.nonResourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "nonResourceRules"));
        }
        return this.setNewNonResourceRuleLike(index, this.buildNonResourceRule(index));
    }

    public A addToResourceRules(int index, V1ResourcePolicyRule item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        V1ResourcePolicyRuleBuilder builder = new V1ResourcePolicyRuleBuilder(item);
        if (index < 0 || index >= this.resourceRules.size()) {
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        } else {
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(index, builder);
        }
        return (A)this;
    }

    public A setToResourceRules(int index, V1ResourcePolicyRule item) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        V1ResourcePolicyRuleBuilder builder = new V1ResourcePolicyRuleBuilder(item);
        if (index < 0 || index >= this.resourceRules.size()) {
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        } else {
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.set(index, builder);
        }
        return (A)this;
    }

    public A addToResourceRules(V1ResourcePolicyRule ... items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        for (V1ResourcePolicyRule item : items) {
            V1ResourcePolicyRuleBuilder builder = new V1ResourcePolicyRuleBuilder(item);
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)this;
    }

    public A addAllToResourceRules(Collection<V1ResourcePolicyRule> items) {
        if (this.resourceRules == null) {
            this.resourceRules = new ArrayList();
        }
        for (V1ResourcePolicyRule item : items) {
            V1ResourcePolicyRuleBuilder builder = new V1ResourcePolicyRuleBuilder(item);
            this._visitables.get("resourceRules").add(builder);
            this.resourceRules.add(builder);
        }
        return (A)this;
    }

    public A removeFromResourceRules(V1ResourcePolicyRule ... items) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        for (V1ResourcePolicyRule item : items) {
            V1ResourcePolicyRuleBuilder builder = new V1ResourcePolicyRuleBuilder(item);
            this._visitables.get("resourceRules").remove(builder);
            this.resourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResourceRules(Collection<V1ResourcePolicyRule> items) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        for (V1ResourcePolicyRule item : items) {
            V1ResourcePolicyRuleBuilder builder = new V1ResourcePolicyRuleBuilder(item);
            this._visitables.get("resourceRules").remove(builder);
            this.resourceRules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResourceRules(Predicate<V1ResourcePolicyRuleBuilder> predicate) {
        if (this.resourceRules == null) {
            return (A)this;
        }
        Iterator<V1ResourcePolicyRuleBuilder> each = this.resourceRules.iterator();
        Object visitables = this._visitables.get("resourceRules");
        while (each.hasNext()) {
            V1ResourcePolicyRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1ResourcePolicyRule> buildResourceRules() {
        return this.resourceRules != null ? V1PolicyRulesWithSubjectsFluent.build(this.resourceRules) : null;
    }

    public V1ResourcePolicyRule buildResourceRule(int index) {
        return this.resourceRules.get(index).build();
    }

    public V1ResourcePolicyRule buildFirstResourceRule() {
        return this.resourceRules.get(0).build();
    }

    public V1ResourcePolicyRule buildLastResourceRule() {
        return this.resourceRules.get(this.resourceRules.size() - 1).build();
    }

    public V1ResourcePolicyRule buildMatchingResourceRule(Predicate<V1ResourcePolicyRuleBuilder> predicate) {
        for (V1ResourcePolicyRuleBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceRule(Predicate<V1ResourcePolicyRuleBuilder> predicate) {
        for (V1ResourcePolicyRuleBuilder item : this.resourceRules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceRules(List<V1ResourcePolicyRule> resourceRules) {
        if (this.resourceRules != null) {
            this._visitables.get("resourceRules").clear();
        }
        if (resourceRules != null) {
            this.resourceRules = new ArrayList();
            for (V1ResourcePolicyRule item : resourceRules) {
                this.addToResourceRules(item);
            }
        } else {
            this.resourceRules = null;
        }
        return (A)this;
    }

    public A withResourceRules(V1ResourcePolicyRule ... resourceRules) {
        if (this.resourceRules != null) {
            this.resourceRules.clear();
            this._visitables.remove("resourceRules");
        }
        if (resourceRules != null) {
            for (V1ResourcePolicyRule item : resourceRules) {
                this.addToResourceRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasResourceRules() {
        return this.resourceRules != null && !this.resourceRules.isEmpty();
    }

    public ResourceRulesNested<A> addNewResourceRule() {
        return new ResourceRulesNested(-1, null);
    }

    public ResourceRulesNested<A> addNewResourceRuleLike(V1ResourcePolicyRule item) {
        return new ResourceRulesNested(-1, item);
    }

    public ResourceRulesNested<A> setNewResourceRuleLike(int index, V1ResourcePolicyRule item) {
        return new ResourceRulesNested(index, item);
    }

    public ResourceRulesNested<A> editResourceRule(int index) {
        if (index <= this.resourceRules.size()) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "resourceRules"));
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public ResourceRulesNested<A> editFirstResourceRule() {
        if (this.resourceRules.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "resourceRules"));
        }
        return this.setNewResourceRuleLike(0, this.buildResourceRule(0));
    }

    public ResourceRulesNested<A> editLastResourceRule() {
        int index = this.resourceRules.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "resourceRules"));
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public ResourceRulesNested<A> editMatchingResourceRule(Predicate<V1ResourcePolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceRules.size(); ++i) {
            if (!predicate.test(this.resourceRules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "resourceRules"));
        }
        return this.setNewResourceRuleLike(index, this.buildResourceRule(index));
    }

    public A addToSubjects(int index, FlowcontrolV1Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        FlowcontrolV1SubjectBuilder builder = new FlowcontrolV1SubjectBuilder(item);
        if (index < 0 || index >= this.subjects.size()) {
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        } else {
            this._visitables.get("subjects").add(builder);
            this.subjects.add(index, builder);
        }
        return (A)this;
    }

    public A setToSubjects(int index, FlowcontrolV1Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        FlowcontrolV1SubjectBuilder builder = new FlowcontrolV1SubjectBuilder(item);
        if (index < 0 || index >= this.subjects.size()) {
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        } else {
            this._visitables.get("subjects").add(builder);
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    public A addToSubjects(FlowcontrolV1Subject ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (FlowcontrolV1Subject item : items) {
            FlowcontrolV1SubjectBuilder builder = new FlowcontrolV1SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    public A addAllToSubjects(Collection<FlowcontrolV1Subject> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (FlowcontrolV1Subject item : items) {
            FlowcontrolV1SubjectBuilder builder = new FlowcontrolV1SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    public A removeFromSubjects(FlowcontrolV1Subject ... items) {
        if (this.subjects == null) {
            return (A)this;
        }
        for (FlowcontrolV1Subject item : items) {
            FlowcontrolV1SubjectBuilder builder = new FlowcontrolV1SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSubjects(Collection<FlowcontrolV1Subject> items) {
        if (this.subjects == null) {
            return (A)this;
        }
        for (FlowcontrolV1Subject item : items) {
            FlowcontrolV1SubjectBuilder builder = new FlowcontrolV1SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSubjects(Predicate<FlowcontrolV1SubjectBuilder> predicate) {
        if (this.subjects == null) {
            return (A)this;
        }
        Iterator<FlowcontrolV1SubjectBuilder> each = this.subjects.iterator();
        Object visitables = this._visitables.get("subjects");
        while (each.hasNext()) {
            FlowcontrolV1SubjectBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<FlowcontrolV1Subject> buildSubjects() {
        return this.subjects != null ? V1PolicyRulesWithSubjectsFluent.build(this.subjects) : null;
    }

    public FlowcontrolV1Subject buildSubject(int index) {
        return this.subjects.get(index).build();
    }

    public FlowcontrolV1Subject buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    public FlowcontrolV1Subject buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    public FlowcontrolV1Subject buildMatchingSubject(Predicate<FlowcontrolV1SubjectBuilder> predicate) {
        for (FlowcontrolV1SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSubject(Predicate<FlowcontrolV1SubjectBuilder> predicate) {
        for (FlowcontrolV1SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubjects(List<FlowcontrolV1Subject> subjects) {
        if (this.subjects != null) {
            this._visitables.get("subjects").clear();
        }
        if (subjects != null) {
            this.subjects = new ArrayList();
            for (FlowcontrolV1Subject item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)this;
    }

    public A withSubjects(FlowcontrolV1Subject ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
            this._visitables.remove("subjects");
        }
        if (subjects != null) {
            for (FlowcontrolV1Subject item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    public boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    public SubjectsNested<A> addNewSubject() {
        return new SubjectsNested(-1, null);
    }

    public SubjectsNested<A> addNewSubjectLike(FlowcontrolV1Subject item) {
        return new SubjectsNested(-1, item);
    }

    public SubjectsNested<A> setNewSubjectLike(int index, FlowcontrolV1Subject item) {
        return new SubjectsNested(index, item);
    }

    public SubjectsNested<A> editSubject(int index) {
        if (index <= this.subjects.size()) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "subjects"));
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "subjects"));
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    public SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "subjects"));
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public SubjectsNested<A> editMatchingSubject(Predicate<FlowcontrolV1SubjectBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.test(this.subjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "subjects"));
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PolicyRulesWithSubjectsFluent that = (V1PolicyRulesWithSubjectsFluent)o;
        if (!Objects.equals(this.nonResourceRules, that.nonResourceRules)) {
            return false;
        }
        if (!Objects.equals(this.resourceRules, that.resourceRules)) {
            return false;
        }
        return Objects.equals(this.subjects, that.subjects);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nonResourceRules, this.resourceRules, this.subjects);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nonResourceRules != null && !this.nonResourceRules.isEmpty()) {
            sb.append("nonResourceRules:");
            sb.append(this.nonResourceRules);
            sb.append(",");
        }
        if (this.resourceRules != null && !this.resourceRules.isEmpty()) {
            sb.append("resourceRules:");
            sb.append(this.resourceRules);
            sb.append(",");
        }
        if (this.subjects != null && !this.subjects.isEmpty()) {
            sb.append("subjects:");
            sb.append(this.subjects);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NonResourceRulesNested<N>
    extends V1NonResourcePolicyRuleFluent<NonResourceRulesNested<N>>
    implements Nested<N> {
        V1NonResourcePolicyRuleBuilder builder;
        int index;

        NonResourceRulesNested(int index, V1NonResourcePolicyRule item) {
            this.index = index;
            this.builder = new V1NonResourcePolicyRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PolicyRulesWithSubjectsFluent.this.setToNonResourceRules(this.index, this.builder.build());
        }

        public N endNonResourceRule() {
            return this.and();
        }
    }

    public class ResourceRulesNested<N>
    extends V1ResourcePolicyRuleFluent<ResourceRulesNested<N>>
    implements Nested<N> {
        V1ResourcePolicyRuleBuilder builder;
        int index;

        ResourceRulesNested(int index, V1ResourcePolicyRule item) {
            this.index = index;
            this.builder = new V1ResourcePolicyRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PolicyRulesWithSubjectsFluent.this.setToResourceRules(this.index, this.builder.build());
        }

        public N endResourceRule() {
            return this.and();
        }
    }

    public class SubjectsNested<N>
    extends FlowcontrolV1SubjectFluent<SubjectsNested<N>>
    implements Nested<N> {
        FlowcontrolV1SubjectBuilder builder;
        int index;

        SubjectsNested(int index, FlowcontrolV1Subject item) {
            this.index = index;
            this.builder = new FlowcontrolV1SubjectBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PolicyRulesWithSubjectsFluent.this.setToSubjects(this.index, this.builder.build());
        }

        public N endSubject() {
            return this.and();
        }
    }
}

