/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ContainerExtendedResourceRequest;
import io.kubernetes.client.openapi.models.V1ContainerExtendedResourceRequestBuilder;
import io.kubernetes.client.openapi.models.V1ContainerExtendedResourceRequestFluent;
import io.kubernetes.client.openapi.models.V1PodExtendedResourceClaimStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1PodExtendedResourceClaimStatusFluent<A extends V1PodExtendedResourceClaimStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1ContainerExtendedResourceRequestBuilder> requestMappings;
    private String resourceClaimName;

    public V1PodExtendedResourceClaimStatusFluent() {
    }

    public V1PodExtendedResourceClaimStatusFluent(V1PodExtendedResourceClaimStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1PodExtendedResourceClaimStatus instance) {
        V1PodExtendedResourceClaimStatus v1PodExtendedResourceClaimStatus = instance = instance != null ? instance : new V1PodExtendedResourceClaimStatus();
        if (instance != null) {
            this.withRequestMappings(instance.getRequestMappings());
            this.withResourceClaimName(instance.getResourceClaimName());
        }
    }

    public A addToRequestMappings(int index, V1ContainerExtendedResourceRequest item) {
        if (this.requestMappings == null) {
            this.requestMappings = new ArrayList();
        }
        V1ContainerExtendedResourceRequestBuilder builder = new V1ContainerExtendedResourceRequestBuilder(item);
        if (index < 0 || index >= this.requestMappings.size()) {
            this._visitables.get("requestMappings").add(builder);
            this.requestMappings.add(builder);
        } else {
            this._visitables.get("requestMappings").add(builder);
            this.requestMappings.add(index, builder);
        }
        return (A)this;
    }

    public A setToRequestMappings(int index, V1ContainerExtendedResourceRequest item) {
        if (this.requestMappings == null) {
            this.requestMappings = new ArrayList();
        }
        V1ContainerExtendedResourceRequestBuilder builder = new V1ContainerExtendedResourceRequestBuilder(item);
        if (index < 0 || index >= this.requestMappings.size()) {
            this._visitables.get("requestMappings").add(builder);
            this.requestMappings.add(builder);
        } else {
            this._visitables.get("requestMappings").add(builder);
            this.requestMappings.set(index, builder);
        }
        return (A)this;
    }

    public A addToRequestMappings(V1ContainerExtendedResourceRequest ... items) {
        if (this.requestMappings == null) {
            this.requestMappings = new ArrayList();
        }
        for (V1ContainerExtendedResourceRequest item : items) {
            V1ContainerExtendedResourceRequestBuilder builder = new V1ContainerExtendedResourceRequestBuilder(item);
            this._visitables.get("requestMappings").add(builder);
            this.requestMappings.add(builder);
        }
        return (A)this;
    }

    public A addAllToRequestMappings(Collection<V1ContainerExtendedResourceRequest> items) {
        if (this.requestMappings == null) {
            this.requestMappings = new ArrayList();
        }
        for (V1ContainerExtendedResourceRequest item : items) {
            V1ContainerExtendedResourceRequestBuilder builder = new V1ContainerExtendedResourceRequestBuilder(item);
            this._visitables.get("requestMappings").add(builder);
            this.requestMappings.add(builder);
        }
        return (A)this;
    }

    public A removeFromRequestMappings(V1ContainerExtendedResourceRequest ... items) {
        if (this.requestMappings == null) {
            return (A)this;
        }
        for (V1ContainerExtendedResourceRequest item : items) {
            V1ContainerExtendedResourceRequestBuilder builder = new V1ContainerExtendedResourceRequestBuilder(item);
            this._visitables.get("requestMappings").remove(builder);
            this.requestMappings.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRequestMappings(Collection<V1ContainerExtendedResourceRequest> items) {
        if (this.requestMappings == null) {
            return (A)this;
        }
        for (V1ContainerExtendedResourceRequest item : items) {
            V1ContainerExtendedResourceRequestBuilder builder = new V1ContainerExtendedResourceRequestBuilder(item);
            this._visitables.get("requestMappings").remove(builder);
            this.requestMappings.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRequestMappings(Predicate<V1ContainerExtendedResourceRequestBuilder> predicate) {
        if (this.requestMappings == null) {
            return (A)this;
        }
        Iterator<V1ContainerExtendedResourceRequestBuilder> each = this.requestMappings.iterator();
        Object visitables = this._visitables.get("requestMappings");
        while (each.hasNext()) {
            V1ContainerExtendedResourceRequestBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1ContainerExtendedResourceRequest> buildRequestMappings() {
        return this.requestMappings != null ? V1PodExtendedResourceClaimStatusFluent.build(this.requestMappings) : null;
    }

    public V1ContainerExtendedResourceRequest buildRequestMapping(int index) {
        return this.requestMappings.get(index).build();
    }

    public V1ContainerExtendedResourceRequest buildFirstRequestMapping() {
        return this.requestMappings.get(0).build();
    }

    public V1ContainerExtendedResourceRequest buildLastRequestMapping() {
        return this.requestMappings.get(this.requestMappings.size() - 1).build();
    }

    public V1ContainerExtendedResourceRequest buildMatchingRequestMapping(Predicate<V1ContainerExtendedResourceRequestBuilder> predicate) {
        for (V1ContainerExtendedResourceRequestBuilder item : this.requestMappings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRequestMapping(Predicate<V1ContainerExtendedResourceRequestBuilder> predicate) {
        for (V1ContainerExtendedResourceRequestBuilder item : this.requestMappings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRequestMappings(List<V1ContainerExtendedResourceRequest> requestMappings) {
        if (this.requestMappings != null) {
            this._visitables.get("requestMappings").clear();
        }
        if (requestMappings != null) {
            this.requestMappings = new ArrayList();
            for (V1ContainerExtendedResourceRequest item : requestMappings) {
                this.addToRequestMappings(item);
            }
        } else {
            this.requestMappings = null;
        }
        return (A)this;
    }

    public A withRequestMappings(V1ContainerExtendedResourceRequest ... requestMappings) {
        if (this.requestMappings != null) {
            this.requestMappings.clear();
            this._visitables.remove("requestMappings");
        }
        if (requestMappings != null) {
            for (V1ContainerExtendedResourceRequest item : requestMappings) {
                this.addToRequestMappings(item);
            }
        }
        return (A)this;
    }

    public boolean hasRequestMappings() {
        return this.requestMappings != null && !this.requestMappings.isEmpty();
    }

    public RequestMappingsNested<A> addNewRequestMapping() {
        return new RequestMappingsNested(-1, null);
    }

    public RequestMappingsNested<A> addNewRequestMappingLike(V1ContainerExtendedResourceRequest item) {
        return new RequestMappingsNested(-1, item);
    }

    public RequestMappingsNested<A> setNewRequestMappingLike(int index, V1ContainerExtendedResourceRequest item) {
        return new RequestMappingsNested(index, item);
    }

    public RequestMappingsNested<A> editRequestMapping(int index) {
        if (index <= this.requestMappings.size()) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "requestMappings"));
        }
        return this.setNewRequestMappingLike(index, this.buildRequestMapping(index));
    }

    public RequestMappingsNested<A> editFirstRequestMapping() {
        if (this.requestMappings.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "requestMappings"));
        }
        return this.setNewRequestMappingLike(0, this.buildRequestMapping(0));
    }

    public RequestMappingsNested<A> editLastRequestMapping() {
        int index = this.requestMappings.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "requestMappings"));
        }
        return this.setNewRequestMappingLike(index, this.buildRequestMapping(index));
    }

    public RequestMappingsNested<A> editMatchingRequestMapping(Predicate<V1ContainerExtendedResourceRequestBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.requestMappings.size(); ++i) {
            if (!predicate.test(this.requestMappings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "requestMappings"));
        }
        return this.setNewRequestMappingLike(index, this.buildRequestMapping(index));
    }

    public String getResourceClaimName() {
        return this.resourceClaimName;
    }

    public A withResourceClaimName(String resourceClaimName) {
        this.resourceClaimName = resourceClaimName;
        return (A)this;
    }

    public boolean hasResourceClaimName() {
        return this.resourceClaimName != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PodExtendedResourceClaimStatusFluent that = (V1PodExtendedResourceClaimStatusFluent)o;
        if (!Objects.equals(this.requestMappings, that.requestMappings)) {
            return false;
        }
        return Objects.equals(this.resourceClaimName, that.resourceClaimName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.requestMappings, this.resourceClaimName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.requestMappings != null && !this.requestMappings.isEmpty()) {
            sb.append("requestMappings:");
            sb.append(this.requestMappings);
            sb.append(",");
        }
        if (this.resourceClaimName != null) {
            sb.append("resourceClaimName:");
            sb.append(this.resourceClaimName);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RequestMappingsNested<N>
    extends V1ContainerExtendedResourceRequestFluent<RequestMappingsNested<N>>
    implements Nested<N> {
        V1ContainerExtendedResourceRequestBuilder builder;
        int index;

        RequestMappingsNested(int index, V1ContainerExtendedResourceRequest item) {
            this.index = index;
            this.builder = new V1ContainerExtendedResourceRequestBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodExtendedResourceClaimStatusFluent.this.setToRequestMappings(this.index, this.builder.build());
        }

        public N endRequestMapping() {
            return this.and();
        }
    }
}

