/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="OpaqueDeviceConfiguration contains configuration parameters for a driver in a format defined by the driver vendor.")
public class V1OpaqueDeviceConfiguration {
    public static final String SERIALIZED_NAME_DRIVER = "driver";
    @SerializedName(value="driver")
    private String driver;
    public static final String SERIALIZED_NAME_PARAMETERS = "parameters";
    @SerializedName(value="parameters")
    private Object parameters;

    public V1OpaqueDeviceConfiguration driver(String driver) {
        this.driver = driver;
        return this;
    }

    @ApiModelProperty(required=true, value="Driver is used to determine which kubelet plugin needs to be passed these configuration parameters.  An admission policy provided by the driver developer could use this to decide whether it needs to validate them.  Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public V1OpaqueDeviceConfiguration parameters(Object parameters) {
        this.parameters = parameters;
        return this;
    }

    @ApiModelProperty(required=true, value="Parameters can contain arbitrary data. It is the responsibility of the driver developer to handle validation and versioning. Typically this includes self-identification and a version (\"kind\" + \"apiVersion\" for Kubernetes types), with conversion between different versions.  The length of the raw data must be smaller or equal to 10 Ki.")
    public Object getParameters() {
        return this.parameters;
    }

    public void setParameters(Object parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1OpaqueDeviceConfiguration v1OpaqueDeviceConfiguration = (V1OpaqueDeviceConfiguration)o;
        return Objects.equals(this.driver, v1OpaqueDeviceConfiguration.driver) && Objects.equals(this.parameters, v1OpaqueDeviceConfiguration.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.driver, this.parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1OpaqueDeviceConfiguration {\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

