/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Local represents directly-attached storage with node affinity")
public class V1LocalVolumeSource {
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    private String fsType;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;

    public V1LocalVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fsType is the filesystem type to mount. It applies only when the Path is a block device. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". The default value is to auto-select a filesystem if unspecified.")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1LocalVolumeSource path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="path of the full path to the volume on the node. It can be either a directory or block device (disk, partition, ...).")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LocalVolumeSource v1LocalVolumeSource = (V1LocalVolumeSource)o;
        return Objects.equals(this.fsType, v1LocalVolumeSource.fsType) && Objects.equals(this.path, v1LocalVolumeSource.path);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.path);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LocalVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

