/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1HorizontalPodAutoscalerStatus;
import java.time.OffsetDateTime;
import java.util.Objects;

public class V1HorizontalPodAutoscalerStatusFluent<A extends V1HorizontalPodAutoscalerStatusFluent<A>>
extends BaseFluent<A> {
    private Integer currentCPUUtilizationPercentage;
    private Integer currentReplicas;
    private Integer desiredReplicas;
    private OffsetDateTime lastScaleTime;
    private Long observedGeneration;

    public V1HorizontalPodAutoscalerStatusFluent() {
    }

    public V1HorizontalPodAutoscalerStatusFluent(V1HorizontalPodAutoscalerStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1HorizontalPodAutoscalerStatus instance) {
        V1HorizontalPodAutoscalerStatus v1HorizontalPodAutoscalerStatus = instance = instance != null ? instance : new V1HorizontalPodAutoscalerStatus();
        if (instance != null) {
            this.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage());
            this.withCurrentReplicas(instance.getCurrentReplicas());
            this.withDesiredReplicas(instance.getDesiredReplicas());
            this.withLastScaleTime(instance.getLastScaleTime());
            this.withObservedGeneration(instance.getObservedGeneration());
        }
    }

    public Integer getCurrentCPUUtilizationPercentage() {
        return this.currentCPUUtilizationPercentage;
    }

    public A withCurrentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage) {
        this.currentCPUUtilizationPercentage = currentCPUUtilizationPercentage;
        return (A)this;
    }

    public boolean hasCurrentCPUUtilizationPercentage() {
        return this.currentCPUUtilizationPercentage != null;
    }

    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public A withCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return (A)this;
    }

    public boolean hasCurrentReplicas() {
        return this.currentReplicas != null;
    }

    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    public A withDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return (A)this;
    }

    public boolean hasDesiredReplicas() {
        return this.desiredReplicas != null;
    }

    public OffsetDateTime getLastScaleTime() {
        return this.lastScaleTime;
    }

    public A withLastScaleTime(OffsetDateTime lastScaleTime) {
        this.lastScaleTime = lastScaleTime;
        return (A)this;
    }

    public boolean hasLastScaleTime() {
        return this.lastScaleTime != null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1HorizontalPodAutoscalerStatusFluent that = (V1HorizontalPodAutoscalerStatusFluent)o;
        if (!Objects.equals(this.currentCPUUtilizationPercentage, that.currentCPUUtilizationPercentage)) {
            return false;
        }
        if (!Objects.equals(this.currentReplicas, that.currentReplicas)) {
            return false;
        }
        if (!Objects.equals(this.desiredReplicas, that.desiredReplicas)) {
            return false;
        }
        if (!Objects.equals(this.lastScaleTime, that.lastScaleTime)) {
            return false;
        }
        return Objects.equals(this.observedGeneration, that.observedGeneration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.currentCPUUtilizationPercentage, this.currentReplicas, this.desiredReplicas, this.lastScaleTime, this.observedGeneration);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currentCPUUtilizationPercentage != null) {
            sb.append("currentCPUUtilizationPercentage:");
            sb.append(this.currentCPUUtilizationPercentage);
            sb.append(",");
        }
        if (this.currentReplicas != null) {
            sb.append("currentReplicas:");
            sb.append(this.currentReplicas);
            sb.append(",");
        }
        if (this.desiredReplicas != null) {
            sb.append("desiredReplicas:");
            sb.append(this.desiredReplicas);
            sb.append(",");
        }
        if (this.lastScaleTime != null) {
            sb.append("lastScaleTime:");
            sb.append(this.lastScaleTime);
            sb.append(",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
        }
        sb.append("}");
        return sb.toString();
    }
}

