/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ForNode;
import io.kubernetes.client.openapi.models.V1ForZone;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="EndpointHints provides hints describing how an endpoint should be consumed.")
public class V1EndpointHints {
    public static final String SERIALIZED_NAME_FOR_NODES = "forNodes";
    @SerializedName(value="forNodes")
    private List<V1ForNode> forNodes = null;
    public static final String SERIALIZED_NAME_FOR_ZONES = "forZones";
    @SerializedName(value="forZones")
    private List<V1ForZone> forZones = null;

    public V1EndpointHints forNodes(List<V1ForNode> forNodes) {
        this.forNodes = forNodes;
        return this;
    }

    public V1EndpointHints addForNodesItem(V1ForNode forNodesItem) {
        if (this.forNodes == null) {
            this.forNodes = new ArrayList<V1ForNode>();
        }
        this.forNodes.add(forNodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="forNodes indicates the node(s) this endpoint should be consumed by when using topology aware routing. May contain a maximum of 8 entries. This is an Alpha feature and is only used when the PreferSameTrafficDistribution feature gate is enabled.")
    public List<V1ForNode> getForNodes() {
        return this.forNodes;
    }

    public void setForNodes(List<V1ForNode> forNodes) {
        this.forNodes = forNodes;
    }

    public V1EndpointHints forZones(List<V1ForZone> forZones) {
        this.forZones = forZones;
        return this;
    }

    public V1EndpointHints addForZonesItem(V1ForZone forZonesItem) {
        if (this.forZones == null) {
            this.forZones = new ArrayList<V1ForZone>();
        }
        this.forZones.add(forZonesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="forZones indicates the zone(s) this endpoint should be consumed by when using topology aware routing. May contain a maximum of 8 entries.")
    public List<V1ForZone> getForZones() {
        return this.forZones;
    }

    public void setForZones(List<V1ForZone> forZones) {
        this.forZones = forZones;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EndpointHints v1EndpointHints = (V1EndpointHints)o;
        return Objects.equals(this.forNodes, v1EndpointHints.forNodes) && Objects.equals(this.forZones, v1EndpointHints.forZones);
    }

    public int hashCode() {
        return Objects.hash(this.forNodes, this.forZones);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1EndpointHints {\n");
        sb.append("    forNodes: ").append(this.toIndentedString(this.forNodes)).append("\n");
        sb.append("    forZones: ").append(this.toIndentedString(this.forZones)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

