/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.kubernetes.client.openapi.models.V1ObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1ObjectReferenceFluent;
import java.util.Objects;
import java.util.Optional;

public class V1EndpointAddressFluent<A extends V1EndpointAddressFluent<A>>
extends BaseFluent<A> {
    private String hostname;
    private String ip;
    private String nodeName;
    private V1ObjectReferenceBuilder targetRef;

    public V1EndpointAddressFluent() {
    }

    public V1EndpointAddressFluent(V1EndpointAddress instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1EndpointAddress instance) {
        V1EndpointAddress v1EndpointAddress = instance = instance != null ? instance : new V1EndpointAddress();
        if (instance != null) {
            this.withHostname(instance.getHostname());
            this.withIp(instance.getIp());
            this.withNodeName(instance.getNodeName());
            this.withTargetRef(instance.getTargetRef());
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    public boolean hasHostname() {
        return this.hostname != null;
    }

    public String getIp() {
        return this.ip;
    }

    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    public boolean hasIp() {
        return this.ip != null;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    public V1ObjectReference buildTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    public A withTargetRef(V1ObjectReference targetRef) {
        this._visitables.remove("targetRef");
        if (targetRef != null) {
            this.targetRef = new V1ObjectReferenceBuilder(targetRef);
            this._visitables.get("targetRef").add(this.targetRef);
        } else {
            this.targetRef = null;
            this._visitables.get("targetRef").remove(this.targetRef);
        }
        return (A)this;
    }

    public boolean hasTargetRef() {
        return this.targetRef != null;
    }

    public TargetRefNested<A> withNewTargetRef() {
        return new TargetRefNested(null);
    }

    public TargetRefNested<A> withNewTargetRefLike(V1ObjectReference item) {
        return new TargetRefNested(item);
    }

    public TargetRefNested<A> editTargetRef() {
        return this.withNewTargetRefLike(Optional.ofNullable(this.buildTargetRef()).orElse(null));
    }

    public TargetRefNested<A> editOrNewTargetRef() {
        return this.withNewTargetRefLike(Optional.ofNullable(this.buildTargetRef()).orElse(new V1ObjectReferenceBuilder().build()));
    }

    public TargetRefNested<A> editOrNewTargetRefLike(V1ObjectReference item) {
        return this.withNewTargetRefLike(Optional.ofNullable(this.buildTargetRef()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1EndpointAddressFluent that = (V1EndpointAddressFluent)o;
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.ip, that.ip)) {
            return false;
        }
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        return Objects.equals(this.targetRef, that.targetRef);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostname, this.ip, this.nodeName, this.targetRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname);
            sb.append(",");
        }
        if (this.ip != null) {
            sb.append("ip:");
            sb.append(this.ip);
            sb.append(",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName);
            sb.append(",");
        }
        if (this.targetRef != null) {
            sb.append("targetRef:");
            sb.append(this.targetRef);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetRefNested<N>
    extends V1ObjectReferenceFluent<TargetRefNested<N>>
    implements Nested<N> {
        V1ObjectReferenceBuilder builder;

        TargetRefNested(V1ObjectReference item) {
            this.builder = new V1ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1EndpointAddressFluent.this.withTargetRef(this.builder.build());
        }

        public N endTargetRef() {
            return this.and();
        }
    }
}

