/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1DeviceSubRequest;
import io.kubernetes.client.openapi.models.V1ExactDeviceRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DeviceRequest is a request for devices required for a claim. This is typically a request for a single resource like a device, but can also ask for several identical devices. With FirstAvailable it is also possible to provide a prioritized list of requests.")
public class V1DeviceRequest {
    public static final String SERIALIZED_NAME_EXACTLY = "exactly";
    @SerializedName(value="exactly")
    private V1ExactDeviceRequest exactly;
    public static final String SERIALIZED_NAME_FIRST_AVAILABLE = "firstAvailable";
    @SerializedName(value="firstAvailable")
    private List<V1DeviceSubRequest> firstAvailable = null;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;

    public V1DeviceRequest exactly(V1ExactDeviceRequest exactly) {
        this.exactly = exactly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ExactDeviceRequest getExactly() {
        return this.exactly;
    }

    public void setExactly(V1ExactDeviceRequest exactly) {
        this.exactly = exactly;
    }

    public V1DeviceRequest firstAvailable(List<V1DeviceSubRequest> firstAvailable) {
        this.firstAvailable = firstAvailable;
        return this;
    }

    public V1DeviceRequest addFirstAvailableItem(V1DeviceSubRequest firstAvailableItem) {
        if (this.firstAvailable == null) {
            this.firstAvailable = new ArrayList<V1DeviceSubRequest>();
        }
        this.firstAvailable.add(firstAvailableItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="FirstAvailable contains subrequests, of which exactly one will be selected by the scheduler. It tries to satisfy them in the order in which they are listed here. So if there are two entries in the list, the scheduler will only check the second one if it determines that the first one can not be used.  DRA does not yet implement scoring, so the scheduler will select the first set of devices that satisfies all the requests in the claim. And if the requirements can be satisfied on more than one node, other scheduling features will determine which node is chosen. This means that the set of devices allocated to a claim might not be the optimal set available to the cluster. Scoring will be implemented later.")
    public List<V1DeviceSubRequest> getFirstAvailable() {
        return this.firstAvailable;
    }

    public void setFirstAvailable(List<V1DeviceSubRequest> firstAvailable) {
        this.firstAvailable = firstAvailable;
    }

    public V1DeviceRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name can be used to reference this request in a pod.spec.containers[].resources.claims entry and in a constraint of the claim.  References using the name in the DeviceRequest will uniquely identify a request when the Exactly field is set. When the FirstAvailable field is set, a reference to the name of the DeviceRequest will match whatever subrequest is chosen by the scheduler.  Must be a DNS label.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1DeviceRequest v1DeviceRequest = (V1DeviceRequest)o;
        return Objects.equals(this.exactly, v1DeviceRequest.exactly) && Objects.equals(this.firstAvailable, v1DeviceRequest.firstAvailable) && Objects.equals(this.name, v1DeviceRequest.name);
    }

    public int hashCode() {
        return Objects.hash(this.exactly, this.firstAvailable, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1DeviceRequest {\n");
        sb.append("    exactly: ").append(this.toIndentedString(this.exactly)).append("\n");
        sb.append("    firstAvailable: ").append(this.toIndentedString(this.firstAvailable)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

