/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1DeploymentSpec;
import io.kubernetes.client.openapi.models.V1DeploymentStrategy;
import io.kubernetes.client.openapi.models.V1DeploymentStrategyBuilder;
import io.kubernetes.client.openapi.models.V1DeploymentStrategyFluent;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluent;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecBuilder;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecFluent;
import java.util.Objects;
import java.util.Optional;

public class V1DeploymentSpecFluent<A extends V1DeploymentSpecFluent<A>>
extends BaseFluent<A> {
    private Integer minReadySeconds;
    private Boolean paused;
    private Integer progressDeadlineSeconds;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private V1LabelSelectorBuilder selector;
    private V1DeploymentStrategyBuilder strategy;
    private V1PodTemplateSpecBuilder template;

    public V1DeploymentSpecFluent() {
    }

    public V1DeploymentSpecFluent(V1DeploymentSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1DeploymentSpec instance) {
        V1DeploymentSpec v1DeploymentSpec = instance = instance != null ? instance : new V1DeploymentSpec();
        if (instance != null) {
            this.withMinReadySeconds(instance.getMinReadySeconds());
            this.withPaused(instance.getPaused());
            this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
            this.withReplicas(instance.getReplicas());
            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
            this.withSelector(instance.getSelector());
            this.withStrategy(instance.getStrategy());
            this.withTemplate(instance.getTemplate());
        }
    }

    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    public boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    public Boolean getPaused() {
        return this.paused;
    }

    public A withPaused(Boolean paused) {
        this.paused = paused;
        return (A)this;
    }

    public boolean hasPaused() {
        return this.paused != null;
    }

    public Integer getProgressDeadlineSeconds() {
        return this.progressDeadlineSeconds;
    }

    public A withProgressDeadlineSeconds(Integer progressDeadlineSeconds) {
        this.progressDeadlineSeconds = progressDeadlineSeconds;
        return (A)this;
    }

    public boolean hasProgressDeadlineSeconds() {
        return this.progressDeadlineSeconds != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)this;
    }

    public boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    public V1LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(V1LabelSelector selector) {
        this._visitables.remove("selector");
        if (selector != null) {
            this.selector = new V1LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get("selector").remove(this.selector);
        }
        return (A)this;
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(V1LabelSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new V1LabelSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public V1DeploymentStrategy buildStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    public A withStrategy(V1DeploymentStrategy strategy) {
        this._visitables.remove("strategy");
        if (strategy != null) {
            this.strategy = new V1DeploymentStrategyBuilder(strategy);
            this._visitables.get("strategy").add(this.strategy);
        } else {
            this.strategy = null;
            this._visitables.get("strategy").remove(this.strategy);
        }
        return (A)this;
    }

    public boolean hasStrategy() {
        return this.strategy != null;
    }

    public StrategyNested<A> withNewStrategy() {
        return new StrategyNested(null);
    }

    public StrategyNested<A> withNewStrategyLike(V1DeploymentStrategy item) {
        return new StrategyNested(item);
    }

    public StrategyNested<A> editStrategy() {
        return this.withNewStrategyLike(Optional.ofNullable(this.buildStrategy()).orElse(null));
    }

    public StrategyNested<A> editOrNewStrategy() {
        return this.withNewStrategyLike(Optional.ofNullable(this.buildStrategy()).orElse(new V1DeploymentStrategyBuilder().build()));
    }

    public StrategyNested<A> editOrNewStrategyLike(V1DeploymentStrategy item) {
        return this.withNewStrategyLike(Optional.ofNullable(this.buildStrategy()).orElse(item));
    }

    public V1PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(V1PodTemplateSpec template) {
        this._visitables.remove("template");
        if (template != null) {
            this.template = new V1PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get("template").remove(this.template);
        }
        return (A)this;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new V1PodTemplateSpecBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1DeploymentSpecFluent that = (V1DeploymentSpecFluent)o;
        if (!Objects.equals(this.minReadySeconds, that.minReadySeconds)) {
            return false;
        }
        if (!Objects.equals(this.paused, that.paused)) {
            return false;
        }
        if (!Objects.equals(this.progressDeadlineSeconds, that.progressDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.revisionHistoryLimit, that.revisionHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.strategy, that.strategy)) {
            return false;
        }
        return Objects.equals(this.template, that.template);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.paused, this.progressDeadlineSeconds, this.replicas, this.revisionHistoryLimit, this.selector, this.strategy, this.template);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minReadySeconds != null) {
            sb.append("minReadySeconds:");
            sb.append(this.minReadySeconds);
            sb.append(",");
        }
        if (this.paused != null) {
            sb.append("paused:");
            sb.append(this.paused);
            sb.append(",");
        }
        if (this.progressDeadlineSeconds != null) {
            sb.append("progressDeadlineSeconds:");
            sb.append(this.progressDeadlineSeconds);
            sb.append(",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas);
            sb.append(",");
        }
        if (this.revisionHistoryLimit != null) {
            sb.append("revisionHistoryLimit:");
            sb.append(this.revisionHistoryLimit);
            sb.append(",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector);
            sb.append(",");
        }
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append(this.strategy);
            sb.append(",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withPaused() {
        return this.withPaused(true);
    }

    public class SelectorNested<N>
    extends V1LabelSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        V1LabelSelectorBuilder builder;

        SelectorNested(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1DeploymentSpecFluent.this.withSelector(this.builder.build());
        }

        public N endSelector() {
            return this.and();
        }
    }

    public class StrategyNested<N>
    extends V1DeploymentStrategyFluent<StrategyNested<N>>
    implements Nested<N> {
        V1DeploymentStrategyBuilder builder;

        StrategyNested(V1DeploymentStrategy item) {
            this.builder = new V1DeploymentStrategyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1DeploymentSpecFluent.this.withStrategy(this.builder.build());
        }

        public N endStrategy() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends V1PodTemplateSpecFluent<TemplateNested<N>>
    implements Nested<N> {
        V1PodTemplateSpecBuilder builder;

        TemplateNested(V1PodTemplateSpec item) {
            this.builder = new V1PodTemplateSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1DeploymentSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endTemplate() {
            return this.and();
        }
    }
}

