/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Preconditions;
import io.kubernetes.client.openapi.models.V1PreconditionsBuilder;
import io.kubernetes.client.openapi.models.V1PreconditionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1DeleteOptionsFluent<A extends V1DeleteOptionsFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private List<String> dryRun;
    private Long gracePeriodSeconds;
    private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
    private String kind;
    private Boolean orphanDependents;
    private V1PreconditionsBuilder preconditions;
    private String propagationPolicy;

    public V1DeleteOptionsFluent() {
    }

    public V1DeleteOptionsFluent(V1DeleteOptions instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1DeleteOptions instance) {
        V1DeleteOptions v1DeleteOptions = instance = instance != null ? instance : new V1DeleteOptions();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDryRun(instance.getDryRun());
            this.withGracePeriodSeconds(instance.getGracePeriodSeconds());
            this.withIgnoreStoreReadErrorWithClusterBreakingPotential(instance.getIgnoreStoreReadErrorWithClusterBreakingPotential());
            this.withKind(instance.getKind());
            this.withOrphanDependents(instance.getOrphanDependents());
            this.withPreconditions(instance.getPreconditions());
            this.withPropagationPolicy(instance.getPropagationPolicy());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToDryRun(int index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.add(index, item);
        return (A)this;
    }

    public A setToDryRun(int index, String item) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        this.dryRun.set(index, item);
        return (A)this;
    }

    public A addToDryRun(String ... items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)this;
    }

    public A addAllToDryRun(Collection<String> items) {
        if (this.dryRun == null) {
            this.dryRun = new ArrayList<String>();
        }
        for (String item : items) {
            this.dryRun.add(item);
        }
        return (A)this;
    }

    public A removeFromDryRun(String ... items) {
        if (this.dryRun == null) {
            return (A)this;
        }
        for (String item : items) {
            this.dryRun.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromDryRun(Collection<String> items) {
        if (this.dryRun == null) {
            return (A)this;
        }
        for (String item : items) {
            this.dryRun.remove(item);
        }
        return (A)this;
    }

    public List<String> getDryRun() {
        return this.dryRun;
    }

    public String getDryRun(int index) {
        return this.dryRun.get(index);
    }

    public String getFirstDryRun() {
        return this.dryRun.get(0);
    }

    public String getLastDryRun() {
        return this.dryRun.get(this.dryRun.size() - 1);
    }

    public String getMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDryRun(Predicate<String> predicate) {
        for (String item : this.dryRun) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDryRun(List<String> dryRun) {
        if (dryRun != null) {
            this.dryRun = new ArrayList<String>();
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        } else {
            this.dryRun = null;
        }
        return (A)this;
    }

    public A withDryRun(String ... dryRun) {
        if (this.dryRun != null) {
            this.dryRun.clear();
            this._visitables.remove("dryRun");
        }
        if (dryRun != null) {
            for (String item : dryRun) {
                this.addToDryRun(item);
            }
        }
        return (A)this;
    }

    public boolean hasDryRun() {
        return this.dryRun != null && !this.dryRun.isEmpty();
    }

    public Long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    public A withGracePeriodSeconds(Long gracePeriodSeconds) {
        this.gracePeriodSeconds = gracePeriodSeconds;
        return (A)this;
    }

    public boolean hasGracePeriodSeconds() {
        return this.gracePeriodSeconds != null;
    }

    public Boolean getIgnoreStoreReadErrorWithClusterBreakingPotential() {
        return this.ignoreStoreReadErrorWithClusterBreakingPotential;
    }

    public A withIgnoreStoreReadErrorWithClusterBreakingPotential(Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
        this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
        return (A)this;
    }

    public boolean hasIgnoreStoreReadErrorWithClusterBreakingPotential() {
        return this.ignoreStoreReadErrorWithClusterBreakingPotential != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public Boolean getOrphanDependents() {
        return this.orphanDependents;
    }

    public A withOrphanDependents(Boolean orphanDependents) {
        this.orphanDependents = orphanDependents;
        return (A)this;
    }

    public boolean hasOrphanDependents() {
        return this.orphanDependents != null;
    }

    public V1Preconditions buildPreconditions() {
        return this.preconditions != null ? this.preconditions.build() : null;
    }

    public A withPreconditions(V1Preconditions preconditions) {
        this._visitables.remove("preconditions");
        if (preconditions != null) {
            this.preconditions = new V1PreconditionsBuilder(preconditions);
            this._visitables.get("preconditions").add(this.preconditions);
        } else {
            this.preconditions = null;
            this._visitables.get("preconditions").remove(this.preconditions);
        }
        return (A)this;
    }

    public boolean hasPreconditions() {
        return this.preconditions != null;
    }

    public PreconditionsNested<A> withNewPreconditions() {
        return new PreconditionsNested(null);
    }

    public PreconditionsNested<A> withNewPreconditionsLike(V1Preconditions item) {
        return new PreconditionsNested(item);
    }

    public PreconditionsNested<A> editPreconditions() {
        return this.withNewPreconditionsLike(Optional.ofNullable(this.buildPreconditions()).orElse(null));
    }

    public PreconditionsNested<A> editOrNewPreconditions() {
        return this.withNewPreconditionsLike(Optional.ofNullable(this.buildPreconditions()).orElse(new V1PreconditionsBuilder().build()));
    }

    public PreconditionsNested<A> editOrNewPreconditionsLike(V1Preconditions item) {
        return this.withNewPreconditionsLike(Optional.ofNullable(this.buildPreconditions()).orElse(item));
    }

    public String getPropagationPolicy() {
        return this.propagationPolicy;
    }

    public A withPropagationPolicy(String propagationPolicy) {
        this.propagationPolicy = propagationPolicy;
        return (A)this;
    }

    public boolean hasPropagationPolicy() {
        return this.propagationPolicy != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1DeleteOptionsFluent that = (V1DeleteOptionsFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.dryRun, that.dryRun)) {
            return false;
        }
        if (!Objects.equals(this.gracePeriodSeconds, that.gracePeriodSeconds)) {
            return false;
        }
        if (!Objects.equals(this.ignoreStoreReadErrorWithClusterBreakingPotential, that.ignoreStoreReadErrorWithClusterBreakingPotential)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.orphanDependents, that.orphanDependents)) {
            return false;
        }
        if (!Objects.equals(this.preconditions, that.preconditions)) {
            return false;
        }
        return Objects.equals(this.propagationPolicy, that.propagationPolicy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.kind, this.orphanDependents, this.preconditions, this.propagationPolicy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.dryRun != null && !this.dryRun.isEmpty()) {
            sb.append("dryRun:");
            sb.append(this.dryRun);
            sb.append(",");
        }
        if (this.gracePeriodSeconds != null) {
            sb.append("gracePeriodSeconds:");
            sb.append(this.gracePeriodSeconds);
            sb.append(",");
        }
        if (this.ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            sb.append("ignoreStoreReadErrorWithClusterBreakingPotential:");
            sb.append(this.ignoreStoreReadErrorWithClusterBreakingPotential);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.orphanDependents != null) {
            sb.append("orphanDependents:");
            sb.append(this.orphanDependents);
            sb.append(",");
        }
        if (this.preconditions != null) {
            sb.append("preconditions:");
            sb.append(this.preconditions);
            sb.append(",");
        }
        if (this.propagationPolicy != null) {
            sb.append("propagationPolicy:");
            sb.append(this.propagationPolicy);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withIgnoreStoreReadErrorWithClusterBreakingPotential() {
        return this.withIgnoreStoreReadErrorWithClusterBreakingPotential(true);
    }

    public A withOrphanDependents() {
        return this.withOrphanDependents(true);
    }

    public class PreconditionsNested<N>
    extends V1PreconditionsFluent<PreconditionsNested<N>>
    implements Nested<N> {
        V1PreconditionsBuilder builder;

        PreconditionsNested(V1Preconditions item) {
            this.builder = new V1PreconditionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1DeleteOptionsFluent.this.withPreconditions(this.builder.build());
        }

        public N endPreconditions() {
            return this.and();
        }
    }
}

