/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ContainerExtendedResourceRequest has the mapping of container name, extended resource name to the device request name.")
public class V1ContainerExtendedResourceRequest {
    public static final String SERIALIZED_NAME_CONTAINER_NAME = "containerName";
    @SerializedName(value="containerName")
    private String containerName;
    public static final String SERIALIZED_NAME_REQUEST_NAME = "requestName";
    @SerializedName(value="requestName")
    private String requestName;
    public static final String SERIALIZED_NAME_RESOURCE_NAME = "resourceName";
    @SerializedName(value="resourceName")
    private String resourceName;

    public V1ContainerExtendedResourceRequest containerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the container requesting resources.")
    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public V1ContainerExtendedResourceRequest requestName(String requestName) {
        this.requestName = requestName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the request in the special ResourceClaim which corresponds to the extended resource.")
    public String getRequestName() {
        return this.requestName;
    }

    public void setRequestName(String requestName) {
        this.requestName = requestName;
    }

    public V1ContainerExtendedResourceRequest resourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the extended resource in that container which gets backed by DRA.")
    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerExtendedResourceRequest v1ContainerExtendedResourceRequest = (V1ContainerExtendedResourceRequest)o;
        return Objects.equals(this.containerName, v1ContainerExtendedResourceRequest.containerName) && Objects.equals(this.requestName, v1ContainerExtendedResourceRequest.requestName) && Objects.equals(this.resourceName, v1ContainerExtendedResourceRequest.resourceName);
    }

    public int hashCode() {
        return Objects.hash(this.containerName, this.requestName, this.resourceName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ContainerExtendedResourceRequest {\n");
        sb.append("    containerName: ").append(this.toIndentedString(this.containerName)).append("\n");
        sb.append("    requestName: ").append(this.toIndentedString(this.requestName)).append("\n");
        sb.append("    resourceName: ").append(this.toIndentedString(this.resourceName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

