/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CSIVolumeSource;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class V1CSIVolumeSourceFluent<A extends V1CSIVolumeSourceFluent<A>>
extends BaseFluent<A> {
    private String driver;
    private String fsType;
    private V1LocalObjectReferenceBuilder nodePublishSecretRef;
    private Boolean readOnly;
    private Map<String, String> volumeAttributes;

    public V1CSIVolumeSourceFluent() {
    }

    public V1CSIVolumeSourceFluent(V1CSIVolumeSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1CSIVolumeSource instance) {
        V1CSIVolumeSource v1CSIVolumeSource = instance = instance != null ? instance : new V1CSIVolumeSource();
        if (instance != null) {
            this.withDriver(instance.getDriver());
            this.withFsType(instance.getFsType());
            this.withNodePublishSecretRef(instance.getNodePublishSecretRef());
            this.withReadOnly(instance.getReadOnly());
            this.withVolumeAttributes(instance.getVolumeAttributes());
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public A withDriver(String driver) {
        this.driver = driver;
        return (A)this;
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    public boolean hasFsType() {
        return this.fsType != null;
    }

    public V1LocalObjectReference buildNodePublishSecretRef() {
        return this.nodePublishSecretRef != null ? this.nodePublishSecretRef.build() : null;
    }

    public A withNodePublishSecretRef(V1LocalObjectReference nodePublishSecretRef) {
        this._visitables.remove("nodePublishSecretRef");
        if (nodePublishSecretRef != null) {
            this.nodePublishSecretRef = new V1LocalObjectReferenceBuilder(nodePublishSecretRef);
            this._visitables.get("nodePublishSecretRef").add(this.nodePublishSecretRef);
        } else {
            this.nodePublishSecretRef = null;
            this._visitables.get("nodePublishSecretRef").remove(this.nodePublishSecretRef);
        }
        return (A)this;
    }

    public boolean hasNodePublishSecretRef() {
        return this.nodePublishSecretRef != null;
    }

    public NodePublishSecretRefNested<A> withNewNodePublishSecretRef() {
        return new NodePublishSecretRefNested(null);
    }

    public NodePublishSecretRefNested<A> withNewNodePublishSecretRefLike(V1LocalObjectReference item) {
        return new NodePublishSecretRefNested(item);
    }

    public NodePublishSecretRefNested<A> editNodePublishSecretRef() {
        return this.withNewNodePublishSecretRefLike(Optional.ofNullable(this.buildNodePublishSecretRef()).orElse(null));
    }

    public NodePublishSecretRefNested<A> editOrNewNodePublishSecretRef() {
        return this.withNewNodePublishSecretRefLike(Optional.ofNullable(this.buildNodePublishSecretRef()).orElse(new V1LocalObjectReferenceBuilder().build()));
    }

    public NodePublishSecretRefNested<A> editOrNewNodePublishSecretRefLike(V1LocalObjectReference item) {
        return this.withNewNodePublishSecretRefLike(Optional.ofNullable(this.buildNodePublishSecretRef()).orElse(item));
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public A addToVolumeAttributes(String key, String value) {
        if (this.volumeAttributes == null && key != null && value != null) {
            this.volumeAttributes = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.volumeAttributes.put(key, value);
        }
        return (A)this;
    }

    public A addToVolumeAttributes(Map<String, String> map) {
        if (this.volumeAttributes == null && map != null) {
            this.volumeAttributes = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.volumeAttributes.putAll(map);
        }
        return (A)this;
    }

    public A removeFromVolumeAttributes(String key) {
        if (this.volumeAttributes == null) {
            return (A)this;
        }
        if (key != null && this.volumeAttributes != null) {
            this.volumeAttributes.remove(key);
        }
        return (A)this;
    }

    public A removeFromVolumeAttributes(Map<String, String> map) {
        if (this.volumeAttributes == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.volumeAttributes == null) continue;
                this.volumeAttributes.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getVolumeAttributes() {
        return this.volumeAttributes;
    }

    public <K, V> A withVolumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes == null ? null : new LinkedHashMap<String, String>(volumeAttributes);
        return (A)this;
    }

    public boolean hasVolumeAttributes() {
        return this.volumeAttributes != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1CSIVolumeSourceFluent that = (V1CSIVolumeSourceFluent)o;
        if (!Objects.equals(this.driver, that.driver)) {
            return false;
        }
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.nodePublishSecretRef, that.nodePublishSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        return Objects.equals(this.volumeAttributes, that.volumeAttributes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.driver, this.fsType, this.nodePublishSecretRef, this.readOnly, this.volumeAttributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver);
            sb.append(",");
        }
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType);
            sb.append(",");
        }
        if (this.nodePublishSecretRef != null) {
            sb.append("nodePublishSecretRef:");
            sb.append(this.nodePublishSecretRef);
            sb.append(",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly);
            sb.append(",");
        }
        if (this.volumeAttributes != null && !this.volumeAttributes.isEmpty()) {
            sb.append("volumeAttributes:");
            sb.append(this.volumeAttributes);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public class NodePublishSecretRefNested<N>
    extends V1LocalObjectReferenceFluent<NodePublishSecretRefNested<N>>
    implements Nested<N> {
        V1LocalObjectReferenceBuilder builder;

        NodePublishSecretRefNested(V1LocalObjectReference item) {
            this.builder = new V1LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1CSIVolumeSourceFluent.this.withNodePublishSecretRef(this.builder.build());
        }

        public N endNodePublishSecretRef() {
            return this.and();
        }
    }
}

