/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V2CrossVersionObjectReference;
import io.kubernetes.client.openapi.models.V2CrossVersionObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V2CrossVersionObjectReferenceFluent;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerBehavior;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerBehaviorBuilder;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerBehaviorFluent;
import io.kubernetes.client.openapi.models.V2HorizontalPodAutoscalerSpec;
import io.kubernetes.client.openapi.models.V2MetricSpec;
import io.kubernetes.client.openapi.models.V2MetricSpecBuilder;
import io.kubernetes.client.openapi.models.V2MetricSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V2HorizontalPodAutoscalerSpecFluent<A extends V2HorizontalPodAutoscalerSpecFluent<A>>
extends BaseFluent<A> {
    private V2HorizontalPodAutoscalerBehaviorBuilder behavior;
    private Integer maxReplicas;
    private ArrayList<V2MetricSpecBuilder> metrics;
    private Integer minReplicas;
    private V2CrossVersionObjectReferenceBuilder scaleTargetRef;

    public V2HorizontalPodAutoscalerSpecFluent() {
    }

    public V2HorizontalPodAutoscalerSpecFluent(V2HorizontalPodAutoscalerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V2HorizontalPodAutoscalerSpec instance) {
        V2HorizontalPodAutoscalerSpec v2HorizontalPodAutoscalerSpec = instance = instance != null ? instance : new V2HorizontalPodAutoscalerSpec();
        if (instance != null) {
            this.withBehavior(instance.getBehavior());
            this.withMaxReplicas(instance.getMaxReplicas());
            this.withMetrics(instance.getMetrics());
            this.withMinReplicas(instance.getMinReplicas());
            this.withScaleTargetRef(instance.getScaleTargetRef());
        }
    }

    public V2HorizontalPodAutoscalerBehavior buildBehavior() {
        return this.behavior != null ? this.behavior.build() : null;
    }

    public A withBehavior(V2HorizontalPodAutoscalerBehavior behavior) {
        this._visitables.remove("behavior");
        if (behavior != null) {
            this.behavior = new V2HorizontalPodAutoscalerBehaviorBuilder(behavior);
            this._visitables.get("behavior").add(this.behavior);
        } else {
            this.behavior = null;
            this._visitables.get("behavior").remove(this.behavior);
        }
        return (A)this;
    }

    public boolean hasBehavior() {
        return this.behavior != null;
    }

    public BehaviorNested<A> withNewBehavior() {
        return new BehaviorNested(null);
    }

    public BehaviorNested<A> withNewBehaviorLike(V2HorizontalPodAutoscalerBehavior item) {
        return new BehaviorNested(item);
    }

    public BehaviorNested<A> editBehavior() {
        return this.withNewBehaviorLike(Optional.ofNullable(this.buildBehavior()).orElse(null));
    }

    public BehaviorNested<A> editOrNewBehavior() {
        return this.withNewBehaviorLike(Optional.ofNullable(this.buildBehavior()).orElse(new V2HorizontalPodAutoscalerBehaviorBuilder().build()));
    }

    public BehaviorNested<A> editOrNewBehaviorLike(V2HorizontalPodAutoscalerBehavior item) {
        return this.withNewBehaviorLike(Optional.ofNullable(this.buildBehavior()).orElse(item));
    }

    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public A withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return (A)this;
    }

    public boolean hasMaxReplicas() {
        return this.maxReplicas != null;
    }

    public A addToMetrics(int index, V2MetricSpec item) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        V2MetricSpecBuilder builder = new V2MetricSpecBuilder(item);
        if (index < 0 || index >= this.metrics.size()) {
            this._visitables.get("metrics").add(builder);
            this.metrics.add(builder);
        } else {
            this._visitables.get("metrics").add(builder);
            this.metrics.add(index, builder);
        }
        return (A)this;
    }

    public A setToMetrics(int index, V2MetricSpec item) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        V2MetricSpecBuilder builder = new V2MetricSpecBuilder(item);
        if (index < 0 || index >= this.metrics.size()) {
            this._visitables.get("metrics").add(builder);
            this.metrics.add(builder);
        } else {
            this._visitables.get("metrics").add(builder);
            this.metrics.set(index, builder);
        }
        return (A)this;
    }

    public A addToMetrics(V2MetricSpec ... items) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        for (V2MetricSpec item : items) {
            V2MetricSpecBuilder builder = new V2MetricSpecBuilder(item);
            this._visitables.get("metrics").add(builder);
            this.metrics.add(builder);
        }
        return (A)this;
    }

    public A addAllToMetrics(Collection<V2MetricSpec> items) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        for (V2MetricSpec item : items) {
            V2MetricSpecBuilder builder = new V2MetricSpecBuilder(item);
            this._visitables.get("metrics").add(builder);
            this.metrics.add(builder);
        }
        return (A)this;
    }

    public A removeFromMetrics(V2MetricSpec ... items) {
        if (this.metrics == null) {
            return (A)this;
        }
        for (V2MetricSpec item : items) {
            V2MetricSpecBuilder builder = new V2MetricSpecBuilder(item);
            this._visitables.get("metrics").remove(builder);
            this.metrics.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromMetrics(Collection<V2MetricSpec> items) {
        if (this.metrics == null) {
            return (A)this;
        }
        for (V2MetricSpec item : items) {
            V2MetricSpecBuilder builder = new V2MetricSpecBuilder(item);
            this._visitables.get("metrics").remove(builder);
            this.metrics.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromMetrics(Predicate<V2MetricSpecBuilder> predicate) {
        if (this.metrics == null) {
            return (A)this;
        }
        Iterator<V2MetricSpecBuilder> each = this.metrics.iterator();
        Object visitables = this._visitables.get("metrics");
        while (each.hasNext()) {
            V2MetricSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V2MetricSpec> buildMetrics() {
        return this.metrics != null ? V2HorizontalPodAutoscalerSpecFluent.build(this.metrics) : null;
    }

    public V2MetricSpec buildMetric(int index) {
        return this.metrics.get(index).build();
    }

    public V2MetricSpec buildFirstMetric() {
        return this.metrics.get(0).build();
    }

    public V2MetricSpec buildLastMetric() {
        return this.metrics.get(this.metrics.size() - 1).build();
    }

    public V2MetricSpec buildMatchingMetric(Predicate<V2MetricSpecBuilder> predicate) {
        for (V2MetricSpecBuilder item : this.metrics) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMetric(Predicate<V2MetricSpecBuilder> predicate) {
        for (V2MetricSpecBuilder item : this.metrics) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMetrics(List<V2MetricSpec> metrics) {
        if (this.metrics != null) {
            this._visitables.get("metrics").clear();
        }
        if (metrics != null) {
            this.metrics = new ArrayList();
            for (V2MetricSpec item : metrics) {
                this.addToMetrics(item);
            }
        } else {
            this.metrics = null;
        }
        return (A)this;
    }

    public A withMetrics(V2MetricSpec ... metrics) {
        if (this.metrics != null) {
            this.metrics.clear();
            this._visitables.remove("metrics");
        }
        if (metrics != null) {
            for (V2MetricSpec item : metrics) {
                this.addToMetrics(item);
            }
        }
        return (A)this;
    }

    public boolean hasMetrics() {
        return this.metrics != null && !this.metrics.isEmpty();
    }

    public MetricsNested<A> addNewMetric() {
        return new MetricsNested(-1, null);
    }

    public MetricsNested<A> addNewMetricLike(V2MetricSpec item) {
        return new MetricsNested(-1, item);
    }

    public MetricsNested<A> setNewMetricLike(int index, V2MetricSpec item) {
        return new MetricsNested(index, item);
    }

    public MetricsNested<A> editMetric(int index) {
        if (this.metrics.size() <= index) {
            throw new RuntimeException("Can't edit metrics. Index exceeds size.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    public MetricsNested<A> editFirstMetric() {
        if (this.metrics.size() == 0) {
            throw new RuntimeException("Can't edit first metrics. The list is empty.");
        }
        return this.setNewMetricLike(0, this.buildMetric(0));
    }

    public MetricsNested<A> editLastMetric() {
        int index = this.metrics.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last metrics. The list is empty.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    public MetricsNested<A> editMatchingMetric(Predicate<V2MetricSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.metrics.size(); ++i) {
            if (!predicate.test(this.metrics.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching metrics. No match found.");
        }
        return this.setNewMetricLike(index, this.buildMetric(index));
    }

    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (A)this;
    }

    public boolean hasMinReplicas() {
        return this.minReplicas != null;
    }

    public V2CrossVersionObjectReference buildScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    public A withScaleTargetRef(V2CrossVersionObjectReference scaleTargetRef) {
        this._visitables.remove("scaleTargetRef");
        if (scaleTargetRef != null) {
            this.scaleTargetRef = new V2CrossVersionObjectReferenceBuilder(scaleTargetRef);
            this._visitables.get("scaleTargetRef").add(this.scaleTargetRef);
        } else {
            this.scaleTargetRef = null;
            this._visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
        }
        return (A)this;
    }

    public boolean hasScaleTargetRef() {
        return this.scaleTargetRef != null;
    }

    public ScaleTargetRefNested<A> withNewScaleTargetRef() {
        return new ScaleTargetRefNested(null);
    }

    public ScaleTargetRefNested<A> withNewScaleTargetRefLike(V2CrossVersionObjectReference item) {
        return new ScaleTargetRefNested(item);
    }

    public ScaleTargetRefNested<A> editScaleTargetRef() {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(null));
    }

    public ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(new V2CrossVersionObjectReferenceBuilder().build()));
    }

    public ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(V2CrossVersionObjectReference item) {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V2HorizontalPodAutoscalerSpecFluent that = (V2HorizontalPodAutoscalerSpecFluent)o;
        if (!Objects.equals(this.behavior, that.behavior)) {
            return false;
        }
        if (!Objects.equals(this.maxReplicas, that.maxReplicas)) {
            return false;
        }
        if (!Objects.equals(this.metrics, that.metrics)) {
            return false;
        }
        if (!Objects.equals(this.minReplicas, that.minReplicas)) {
            return false;
        }
        return Objects.equals(this.scaleTargetRef, that.scaleTargetRef);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.behavior, this.maxReplicas, this.metrics, this.minReplicas, this.scaleTargetRef, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.behavior != null) {
            sb.append("behavior:");
            sb.append(this.behavior + ",");
        }
        if (this.maxReplicas != null) {
            sb.append("maxReplicas:");
            sb.append(this.maxReplicas + ",");
        }
        if (this.metrics != null && !this.metrics.isEmpty()) {
            sb.append("metrics:");
            sb.append(this.metrics + ",");
        }
        if (this.minReplicas != null) {
            sb.append("minReplicas:");
            sb.append(this.minReplicas + ",");
        }
        if (this.scaleTargetRef != null) {
            sb.append("scaleTargetRef:");
            sb.append(this.scaleTargetRef);
        }
        sb.append("}");
        return sb.toString();
    }

    public class BehaviorNested<N>
    extends V2HorizontalPodAutoscalerBehaviorFluent<BehaviorNested<N>>
    implements Nested<N> {
        V2HorizontalPodAutoscalerBehaviorBuilder builder;

        BehaviorNested(V2HorizontalPodAutoscalerBehavior item) {
            this.builder = new V2HorizontalPodAutoscalerBehaviorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V2HorizontalPodAutoscalerSpecFluent.this.withBehavior(this.builder.build());
        }

        public N endBehavior() {
            return this.and();
        }
    }

    public class MetricsNested<N>
    extends V2MetricSpecFluent<MetricsNested<N>>
    implements Nested<N> {
        V2MetricSpecBuilder builder;
        int index;

        MetricsNested(int index, V2MetricSpec item) {
            this.index = index;
            this.builder = new V2MetricSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V2HorizontalPodAutoscalerSpecFluent.this.setToMetrics(this.index, this.builder.build());
        }

        public N endMetric() {
            return this.and();
        }
    }

    public class ScaleTargetRefNested<N>
    extends V2CrossVersionObjectReferenceFluent<ScaleTargetRefNested<N>>
    implements Nested<N> {
        V2CrossVersionObjectReferenceBuilder builder;

        ScaleTargetRefNested(V2CrossVersionObjectReference item) {
            this.builder = new V2CrossVersionObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V2HorizontalPodAutoscalerSpecFluent.this.withScaleTargetRef(this.builder.build());
        }

        public N endScaleTargetRef() {
            return this.and();
        }
    }
}

