/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V2HPAScalingPolicy;
import io.kubernetes.client.openapi.models.V2HPAScalingPolicyBuilder;
import io.kubernetes.client.openapi.models.V2HPAScalingPolicyFluent;
import io.kubernetes.client.openapi.models.V2HPAScalingRules;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V2HPAScalingRulesFluent<A extends V2HPAScalingRulesFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V2HPAScalingPolicyBuilder> policies;
    private String selectPolicy;
    private Integer stabilizationWindowSeconds;
    private Quantity tolerance;

    public V2HPAScalingRulesFluent() {
    }

    public V2HPAScalingRulesFluent(V2HPAScalingRules instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V2HPAScalingRules instance) {
        V2HPAScalingRules v2HPAScalingRules = instance = instance != null ? instance : new V2HPAScalingRules();
        if (instance != null) {
            this.withPolicies(instance.getPolicies());
            this.withSelectPolicy(instance.getSelectPolicy());
            this.withStabilizationWindowSeconds(instance.getStabilizationWindowSeconds());
            this.withTolerance(instance.getTolerance());
        }
    }

    public A addToPolicies(int index, V2HPAScalingPolicy item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        V2HPAScalingPolicyBuilder builder = new V2HPAScalingPolicyBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get("policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get("policies").add(builder);
            this.policies.add(index, builder);
        }
        return (A)this;
    }

    public A setToPolicies(int index, V2HPAScalingPolicy item) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        V2HPAScalingPolicyBuilder builder = new V2HPAScalingPolicyBuilder(item);
        if (index < 0 || index >= this.policies.size()) {
            this._visitables.get("policies").add(builder);
            this.policies.add(builder);
        } else {
            this._visitables.get("policies").add(builder);
            this.policies.set(index, builder);
        }
        return (A)this;
    }

    public A addToPolicies(V2HPAScalingPolicy ... items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (V2HPAScalingPolicy item : items) {
            V2HPAScalingPolicyBuilder builder = new V2HPAScalingPolicyBuilder(item);
            this._visitables.get("policies").add(builder);
            this.policies.add(builder);
        }
        return (A)this;
    }

    public A addAllToPolicies(Collection<V2HPAScalingPolicy> items) {
        if (this.policies == null) {
            this.policies = new ArrayList();
        }
        for (V2HPAScalingPolicy item : items) {
            V2HPAScalingPolicyBuilder builder = new V2HPAScalingPolicyBuilder(item);
            this._visitables.get("policies").add(builder);
            this.policies.add(builder);
        }
        return (A)this;
    }

    public A removeFromPolicies(V2HPAScalingPolicy ... items) {
        if (this.policies == null) {
            return (A)this;
        }
        for (V2HPAScalingPolicy item : items) {
            V2HPAScalingPolicyBuilder builder = new V2HPAScalingPolicyBuilder(item);
            this._visitables.get("policies").remove(builder);
            this.policies.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPolicies(Collection<V2HPAScalingPolicy> items) {
        if (this.policies == null) {
            return (A)this;
        }
        for (V2HPAScalingPolicy item : items) {
            V2HPAScalingPolicyBuilder builder = new V2HPAScalingPolicyBuilder(item);
            this._visitables.get("policies").remove(builder);
            this.policies.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPolicies(Predicate<V2HPAScalingPolicyBuilder> predicate) {
        if (this.policies == null) {
            return (A)this;
        }
        Iterator<V2HPAScalingPolicyBuilder> each = this.policies.iterator();
        Object visitables = this._visitables.get("policies");
        while (each.hasNext()) {
            V2HPAScalingPolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V2HPAScalingPolicy> buildPolicies() {
        return this.policies != null ? V2HPAScalingRulesFluent.build(this.policies) : null;
    }

    public V2HPAScalingPolicy buildPolicy(int index) {
        return this.policies.get(index).build();
    }

    public V2HPAScalingPolicy buildFirstPolicy() {
        return this.policies.get(0).build();
    }

    public V2HPAScalingPolicy buildLastPolicy() {
        return this.policies.get(this.policies.size() - 1).build();
    }

    public V2HPAScalingPolicy buildMatchingPolicy(Predicate<V2HPAScalingPolicyBuilder> predicate) {
        for (V2HPAScalingPolicyBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPolicy(Predicate<V2HPAScalingPolicyBuilder> predicate) {
        for (V2HPAScalingPolicyBuilder item : this.policies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPolicies(List<V2HPAScalingPolicy> policies) {
        if (this.policies != null) {
            this._visitables.get("policies").clear();
        }
        if (policies != null) {
            this.policies = new ArrayList();
            for (V2HPAScalingPolicy item : policies) {
                this.addToPolicies(item);
            }
        } else {
            this.policies = null;
        }
        return (A)this;
    }

    public A withPolicies(V2HPAScalingPolicy ... policies) {
        if (this.policies != null) {
            this.policies.clear();
            this._visitables.remove("policies");
        }
        if (policies != null) {
            for (V2HPAScalingPolicy item : policies) {
                this.addToPolicies(item);
            }
        }
        return (A)this;
    }

    public boolean hasPolicies() {
        return this.policies != null && !this.policies.isEmpty();
    }

    public PoliciesNested<A> addNewPolicy() {
        return new PoliciesNested(-1, null);
    }

    public PoliciesNested<A> addNewPolicyLike(V2HPAScalingPolicy item) {
        return new PoliciesNested(-1, item);
    }

    public PoliciesNested<A> setNewPolicyLike(int index, V2HPAScalingPolicy item) {
        return new PoliciesNested(index, item);
    }

    public PoliciesNested<A> editPolicy(int index) {
        if (this.policies.size() <= index) {
            throw new RuntimeException("Can't edit policies. Index exceeds size.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public PoliciesNested<A> editFirstPolicy() {
        if (this.policies.size() == 0) {
            throw new RuntimeException("Can't edit first policies. The list is empty.");
        }
        return this.setNewPolicyLike(0, this.buildPolicy(0));
    }

    public PoliciesNested<A> editLastPolicy() {
        int index = this.policies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last policies. The list is empty.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public PoliciesNested<A> editMatchingPolicy(Predicate<V2HPAScalingPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.policies.size(); ++i) {
            if (!predicate.test(this.policies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching policies. No match found.");
        }
        return this.setNewPolicyLike(index, this.buildPolicy(index));
    }

    public String getSelectPolicy() {
        return this.selectPolicy;
    }

    public A withSelectPolicy(String selectPolicy) {
        this.selectPolicy = selectPolicy;
        return (A)this;
    }

    public boolean hasSelectPolicy() {
        return this.selectPolicy != null;
    }

    public Integer getStabilizationWindowSeconds() {
        return this.stabilizationWindowSeconds;
    }

    public A withStabilizationWindowSeconds(Integer stabilizationWindowSeconds) {
        this.stabilizationWindowSeconds = stabilizationWindowSeconds;
        return (A)this;
    }

    public boolean hasStabilizationWindowSeconds() {
        return this.stabilizationWindowSeconds != null;
    }

    public Quantity getTolerance() {
        return this.tolerance;
    }

    public A withTolerance(Quantity tolerance) {
        this.tolerance = tolerance;
        return (A)this;
    }

    public boolean hasTolerance() {
        return this.tolerance != null;
    }

    public A withNewTolerance(String value) {
        return this.withTolerance(new Quantity(value));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V2HPAScalingRulesFluent that = (V2HPAScalingRulesFluent)o;
        if (!Objects.equals(this.policies, that.policies)) {
            return false;
        }
        if (!Objects.equals(this.selectPolicy, that.selectPolicy)) {
            return false;
        }
        if (!Objects.equals(this.stabilizationWindowSeconds, that.stabilizationWindowSeconds)) {
            return false;
        }
        return Objects.equals(this.tolerance, that.tolerance);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.policies, this.selectPolicy, this.stabilizationWindowSeconds, this.tolerance, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policies != null && !this.policies.isEmpty()) {
            sb.append("policies:");
            sb.append(this.policies + ",");
        }
        if (this.selectPolicy != null) {
            sb.append("selectPolicy:");
            sb.append(this.selectPolicy + ",");
        }
        if (this.stabilizationWindowSeconds != null) {
            sb.append("stabilizationWindowSeconds:");
            sb.append(this.stabilizationWindowSeconds + ",");
        }
        if (this.tolerance != null) {
            sb.append("tolerance:");
            sb.append(this.tolerance);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PoliciesNested<N>
    extends V2HPAScalingPolicyFluent<PoliciesNested<N>>
    implements Nested<N> {
        V2HPAScalingPolicyBuilder builder;
        int index;

        PoliciesNested(int index, V2HPAScalingPolicy item) {
            this.index = index;
            this.builder = new V2HPAScalingPolicyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V2HPAScalingRulesFluent.this.setToPolicies(this.index, this.builder.build());
        }

        public N endPolicy() {
            return this.and();
        }
    }
}

