/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1NodeSelectorBuilder;
import io.kubernetes.client.openapi.models.V1NodeSelectorFluent;
import io.kubernetes.client.openapi.models.V1beta1BasicDevice;
import io.kubernetes.client.openapi.models.V1beta1DeviceAttribute;
import io.kubernetes.client.openapi.models.V1beta1DeviceCapacity;
import io.kubernetes.client.openapi.models.V1beta1DeviceCounterConsumption;
import io.kubernetes.client.openapi.models.V1beta1DeviceCounterConsumptionBuilder;
import io.kubernetes.client.openapi.models.V1beta1DeviceCounterConsumptionFluent;
import io.kubernetes.client.openapi.models.V1beta1DeviceTaint;
import io.kubernetes.client.openapi.models.V1beta1DeviceTaintBuilder;
import io.kubernetes.client.openapi.models.V1beta1DeviceTaintFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1beta1BasicDeviceFluent<A extends V1beta1BasicDeviceFluent<A>>
extends BaseFluent<A> {
    private Boolean allNodes;
    private Map<String, V1beta1DeviceAttribute> attributes;
    private Map<String, V1beta1DeviceCapacity> capacity;
    private ArrayList<V1beta1DeviceCounterConsumptionBuilder> consumesCounters;
    private String nodeName;
    private V1NodeSelectorBuilder nodeSelector;
    private ArrayList<V1beta1DeviceTaintBuilder> taints;

    public V1beta1BasicDeviceFluent() {
    }

    public V1beta1BasicDeviceFluent(V1beta1BasicDevice instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1beta1BasicDevice instance) {
        V1beta1BasicDevice v1beta1BasicDevice = instance = instance != null ? instance : new V1beta1BasicDevice();
        if (instance != null) {
            this.withAllNodes(instance.getAllNodes());
            this.withAttributes(instance.getAttributes());
            this.withCapacity(instance.getCapacity());
            this.withConsumesCounters(instance.getConsumesCounters());
            this.withNodeName(instance.getNodeName());
            this.withNodeSelector(instance.getNodeSelector());
            this.withTaints(instance.getTaints());
        }
    }

    public Boolean getAllNodes() {
        return this.allNodes;
    }

    public A withAllNodes(Boolean allNodes) {
        this.allNodes = allNodes;
        return (A)this;
    }

    public boolean hasAllNodes() {
        return this.allNodes != null;
    }

    public A addToAttributes(String key, V1beta1DeviceAttribute value) {
        if (this.attributes == null && key != null && value != null) {
            this.attributes = new LinkedHashMap<String, V1beta1DeviceAttribute>();
        }
        if (key != null && value != null) {
            this.attributes.put(key, value);
        }
        return (A)this;
    }

    public A addToAttributes(Map<String, V1beta1DeviceAttribute> map) {
        if (this.attributes == null && map != null) {
            this.attributes = new LinkedHashMap<String, V1beta1DeviceAttribute>();
        }
        if (map != null) {
            this.attributes.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAttributes(String key) {
        if (this.attributes == null) {
            return (A)this;
        }
        if (key != null && this.attributes != null) {
            this.attributes.remove(key);
        }
        return (A)this;
    }

    public A removeFromAttributes(Map<String, V1beta1DeviceAttribute> map) {
        if (this.attributes == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.attributes == null) continue;
                this.attributes.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, V1beta1DeviceAttribute> getAttributes() {
        return this.attributes;
    }

    public <K, V> A withAttributes(Map<String, V1beta1DeviceAttribute> attributes) {
        this.attributes = attributes == null ? null : new LinkedHashMap<String, V1beta1DeviceAttribute>(attributes);
        return (A)this;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public A addToCapacity(String key, V1beta1DeviceCapacity value) {
        if (this.capacity == null && key != null && value != null) {
            this.capacity = new LinkedHashMap<String, V1beta1DeviceCapacity>();
        }
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (A)this;
    }

    public A addToCapacity(Map<String, V1beta1DeviceCapacity> map) {
        if (this.capacity == null && map != null) {
            this.capacity = new LinkedHashMap<String, V1beta1DeviceCapacity>();
        }
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (A)this;
    }

    public A removeFromCapacity(String key) {
        if (this.capacity == null) {
            return (A)this;
        }
        if (key != null && this.capacity != null) {
            this.capacity.remove(key);
        }
        return (A)this;
    }

    public A removeFromCapacity(Map<String, V1beta1DeviceCapacity> map) {
        if (this.capacity == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.capacity == null) continue;
                this.capacity.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, V1beta1DeviceCapacity> getCapacity() {
        return this.capacity;
    }

    public <K, V> A withCapacity(Map<String, V1beta1DeviceCapacity> capacity) {
        this.capacity = capacity == null ? null : new LinkedHashMap<String, V1beta1DeviceCapacity>(capacity);
        return (A)this;
    }

    public boolean hasCapacity() {
        return this.capacity != null;
    }

    public A addToConsumesCounters(int index, V1beta1DeviceCounterConsumption item) {
        if (this.consumesCounters == null) {
            this.consumesCounters = new ArrayList();
        }
        V1beta1DeviceCounterConsumptionBuilder builder = new V1beta1DeviceCounterConsumptionBuilder(item);
        if (index < 0 || index >= this.consumesCounters.size()) {
            this._visitables.get("consumesCounters").add(builder);
            this.consumesCounters.add(builder);
        } else {
            this._visitables.get("consumesCounters").add(builder);
            this.consumesCounters.add(index, builder);
        }
        return (A)this;
    }

    public A setToConsumesCounters(int index, V1beta1DeviceCounterConsumption item) {
        if (this.consumesCounters == null) {
            this.consumesCounters = new ArrayList();
        }
        V1beta1DeviceCounterConsumptionBuilder builder = new V1beta1DeviceCounterConsumptionBuilder(item);
        if (index < 0 || index >= this.consumesCounters.size()) {
            this._visitables.get("consumesCounters").add(builder);
            this.consumesCounters.add(builder);
        } else {
            this._visitables.get("consumesCounters").add(builder);
            this.consumesCounters.set(index, builder);
        }
        return (A)this;
    }

    public A addToConsumesCounters(V1beta1DeviceCounterConsumption ... items) {
        if (this.consumesCounters == null) {
            this.consumesCounters = new ArrayList();
        }
        for (V1beta1DeviceCounterConsumption item : items) {
            V1beta1DeviceCounterConsumptionBuilder builder = new V1beta1DeviceCounterConsumptionBuilder(item);
            this._visitables.get("consumesCounters").add(builder);
            this.consumesCounters.add(builder);
        }
        return (A)this;
    }

    public A addAllToConsumesCounters(Collection<V1beta1DeviceCounterConsumption> items) {
        if (this.consumesCounters == null) {
            this.consumesCounters = new ArrayList();
        }
        for (V1beta1DeviceCounterConsumption item : items) {
            V1beta1DeviceCounterConsumptionBuilder builder = new V1beta1DeviceCounterConsumptionBuilder(item);
            this._visitables.get("consumesCounters").add(builder);
            this.consumesCounters.add(builder);
        }
        return (A)this;
    }

    public A removeFromConsumesCounters(V1beta1DeviceCounterConsumption ... items) {
        if (this.consumesCounters == null) {
            return (A)this;
        }
        for (V1beta1DeviceCounterConsumption item : items) {
            V1beta1DeviceCounterConsumptionBuilder builder = new V1beta1DeviceCounterConsumptionBuilder(item);
            this._visitables.get("consumesCounters").remove(builder);
            this.consumesCounters.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConsumesCounters(Collection<V1beta1DeviceCounterConsumption> items) {
        if (this.consumesCounters == null) {
            return (A)this;
        }
        for (V1beta1DeviceCounterConsumption item : items) {
            V1beta1DeviceCounterConsumptionBuilder builder = new V1beta1DeviceCounterConsumptionBuilder(item);
            this._visitables.get("consumesCounters").remove(builder);
            this.consumesCounters.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConsumesCounters(Predicate<V1beta1DeviceCounterConsumptionBuilder> predicate) {
        if (this.consumesCounters == null) {
            return (A)this;
        }
        Iterator<V1beta1DeviceCounterConsumptionBuilder> each = this.consumesCounters.iterator();
        Object visitables = this._visitables.get("consumesCounters");
        while (each.hasNext()) {
            V1beta1DeviceCounterConsumptionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1beta1DeviceCounterConsumption> buildConsumesCounters() {
        return this.consumesCounters != null ? V1beta1BasicDeviceFluent.build(this.consumesCounters) : null;
    }

    public V1beta1DeviceCounterConsumption buildConsumesCounter(int index) {
        return this.consumesCounters.get(index).build();
    }

    public V1beta1DeviceCounterConsumption buildFirstConsumesCounter() {
        return this.consumesCounters.get(0).build();
    }

    public V1beta1DeviceCounterConsumption buildLastConsumesCounter() {
        return this.consumesCounters.get(this.consumesCounters.size() - 1).build();
    }

    public V1beta1DeviceCounterConsumption buildMatchingConsumesCounter(Predicate<V1beta1DeviceCounterConsumptionBuilder> predicate) {
        for (V1beta1DeviceCounterConsumptionBuilder item : this.consumesCounters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConsumesCounter(Predicate<V1beta1DeviceCounterConsumptionBuilder> predicate) {
        for (V1beta1DeviceCounterConsumptionBuilder item : this.consumesCounters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConsumesCounters(List<V1beta1DeviceCounterConsumption> consumesCounters) {
        if (this.consumesCounters != null) {
            this._visitables.get("consumesCounters").clear();
        }
        if (consumesCounters != null) {
            this.consumesCounters = new ArrayList();
            for (V1beta1DeviceCounterConsumption item : consumesCounters) {
                this.addToConsumesCounters(item);
            }
        } else {
            this.consumesCounters = null;
        }
        return (A)this;
    }

    public A withConsumesCounters(V1beta1DeviceCounterConsumption ... consumesCounters) {
        if (this.consumesCounters != null) {
            this.consumesCounters.clear();
            this._visitables.remove("consumesCounters");
        }
        if (consumesCounters != null) {
            for (V1beta1DeviceCounterConsumption item : consumesCounters) {
                this.addToConsumesCounters(item);
            }
        }
        return (A)this;
    }

    public boolean hasConsumesCounters() {
        return this.consumesCounters != null && !this.consumesCounters.isEmpty();
    }

    public ConsumesCountersNested<A> addNewConsumesCounter() {
        return new ConsumesCountersNested(-1, null);
    }

    public ConsumesCountersNested<A> addNewConsumesCounterLike(V1beta1DeviceCounterConsumption item) {
        return new ConsumesCountersNested(-1, item);
    }

    public ConsumesCountersNested<A> setNewConsumesCounterLike(int index, V1beta1DeviceCounterConsumption item) {
        return new ConsumesCountersNested(index, item);
    }

    public ConsumesCountersNested<A> editConsumesCounter(int index) {
        if (this.consumesCounters.size() <= index) {
            throw new RuntimeException("Can't edit consumesCounters. Index exceeds size.");
        }
        return this.setNewConsumesCounterLike(index, this.buildConsumesCounter(index));
    }

    public ConsumesCountersNested<A> editFirstConsumesCounter() {
        if (this.consumesCounters.size() == 0) {
            throw new RuntimeException("Can't edit first consumesCounters. The list is empty.");
        }
        return this.setNewConsumesCounterLike(0, this.buildConsumesCounter(0));
    }

    public ConsumesCountersNested<A> editLastConsumesCounter() {
        int index = this.consumesCounters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last consumesCounters. The list is empty.");
        }
        return this.setNewConsumesCounterLike(index, this.buildConsumesCounter(index));
    }

    public ConsumesCountersNested<A> editMatchingConsumesCounter(Predicate<V1beta1DeviceCounterConsumptionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.consumesCounters.size(); ++i) {
            if (!predicate.test(this.consumesCounters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching consumesCounters. No match found.");
        }
        return this.setNewConsumesCounterLike(index, this.buildConsumesCounter(index));
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    public V1NodeSelector buildNodeSelector() {
        return this.nodeSelector != null ? this.nodeSelector.build() : null;
    }

    public A withNodeSelector(V1NodeSelector nodeSelector) {
        this._visitables.remove("nodeSelector");
        if (nodeSelector != null) {
            this.nodeSelector = new V1NodeSelectorBuilder(nodeSelector);
            this._visitables.get("nodeSelector").add(this.nodeSelector);
        } else {
            this.nodeSelector = null;
            this._visitables.get("nodeSelector").remove(this.nodeSelector);
        }
        return (A)this;
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public NodeSelectorNested<A> withNewNodeSelector() {
        return new NodeSelectorNested(null);
    }

    public NodeSelectorNested<A> withNewNodeSelectorLike(V1NodeSelector item) {
        return new NodeSelectorNested(item);
    }

    public NodeSelectorNested<A> editNodeSelector() {
        return this.withNewNodeSelectorLike(Optional.ofNullable(this.buildNodeSelector()).orElse(null));
    }

    public NodeSelectorNested<A> editOrNewNodeSelector() {
        return this.withNewNodeSelectorLike(Optional.ofNullable(this.buildNodeSelector()).orElse(new V1NodeSelectorBuilder().build()));
    }

    public NodeSelectorNested<A> editOrNewNodeSelectorLike(V1NodeSelector item) {
        return this.withNewNodeSelectorLike(Optional.ofNullable(this.buildNodeSelector()).orElse(item));
    }

    public A addToTaints(int index, V1beta1DeviceTaint item) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        V1beta1DeviceTaintBuilder builder = new V1beta1DeviceTaintBuilder(item);
        if (index < 0 || index >= this.taints.size()) {
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        } else {
            this._visitables.get("taints").add(builder);
            this.taints.add(index, builder);
        }
        return (A)this;
    }

    public A setToTaints(int index, V1beta1DeviceTaint item) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        V1beta1DeviceTaintBuilder builder = new V1beta1DeviceTaintBuilder(item);
        if (index < 0 || index >= this.taints.size()) {
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        } else {
            this._visitables.get("taints").add(builder);
            this.taints.set(index, builder);
        }
        return (A)this;
    }

    public A addToTaints(V1beta1DeviceTaint ... items) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        for (V1beta1DeviceTaint item : items) {
            V1beta1DeviceTaintBuilder builder = new V1beta1DeviceTaintBuilder(item);
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        }
        return (A)this;
    }

    public A addAllToTaints(Collection<V1beta1DeviceTaint> items) {
        if (this.taints == null) {
            this.taints = new ArrayList();
        }
        for (V1beta1DeviceTaint item : items) {
            V1beta1DeviceTaintBuilder builder = new V1beta1DeviceTaintBuilder(item);
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        }
        return (A)this;
    }

    public A removeFromTaints(V1beta1DeviceTaint ... items) {
        if (this.taints == null) {
            return (A)this;
        }
        for (V1beta1DeviceTaint item : items) {
            V1beta1DeviceTaintBuilder builder = new V1beta1DeviceTaintBuilder(item);
            this._visitables.get("taints").remove(builder);
            this.taints.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTaints(Collection<V1beta1DeviceTaint> items) {
        if (this.taints == null) {
            return (A)this;
        }
        for (V1beta1DeviceTaint item : items) {
            V1beta1DeviceTaintBuilder builder = new V1beta1DeviceTaintBuilder(item);
            this._visitables.get("taints").remove(builder);
            this.taints.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTaints(Predicate<V1beta1DeviceTaintBuilder> predicate) {
        if (this.taints == null) {
            return (A)this;
        }
        Iterator<V1beta1DeviceTaintBuilder> each = this.taints.iterator();
        Object visitables = this._visitables.get("taints");
        while (each.hasNext()) {
            V1beta1DeviceTaintBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1beta1DeviceTaint> buildTaints() {
        return this.taints != null ? V1beta1BasicDeviceFluent.build(this.taints) : null;
    }

    public V1beta1DeviceTaint buildTaint(int index) {
        return this.taints.get(index).build();
    }

    public V1beta1DeviceTaint buildFirstTaint() {
        return this.taints.get(0).build();
    }

    public V1beta1DeviceTaint buildLastTaint() {
        return this.taints.get(this.taints.size() - 1).build();
    }

    public V1beta1DeviceTaint buildMatchingTaint(Predicate<V1beta1DeviceTaintBuilder> predicate) {
        for (V1beta1DeviceTaintBuilder item : this.taints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTaint(Predicate<V1beta1DeviceTaintBuilder> predicate) {
        for (V1beta1DeviceTaintBuilder item : this.taints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTaints(List<V1beta1DeviceTaint> taints) {
        if (this.taints != null) {
            this._visitables.get("taints").clear();
        }
        if (taints != null) {
            this.taints = new ArrayList();
            for (V1beta1DeviceTaint item : taints) {
                this.addToTaints(item);
            }
        } else {
            this.taints = null;
        }
        return (A)this;
    }

    public A withTaints(V1beta1DeviceTaint ... taints) {
        if (this.taints != null) {
            this.taints.clear();
            this._visitables.remove("taints");
        }
        if (taints != null) {
            for (V1beta1DeviceTaint item : taints) {
                this.addToTaints(item);
            }
        }
        return (A)this;
    }

    public boolean hasTaints() {
        return this.taints != null && !this.taints.isEmpty();
    }

    public TaintsNested<A> addNewTaint() {
        return new TaintsNested(-1, null);
    }

    public TaintsNested<A> addNewTaintLike(V1beta1DeviceTaint item) {
        return new TaintsNested(-1, item);
    }

    public TaintsNested<A> setNewTaintLike(int index, V1beta1DeviceTaint item) {
        return new TaintsNested(index, item);
    }

    public TaintsNested<A> editTaint(int index) {
        if (this.taints.size() <= index) {
            throw new RuntimeException("Can't edit taints. Index exceeds size.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    public TaintsNested<A> editFirstTaint() {
        if (this.taints.size() == 0) {
            throw new RuntimeException("Can't edit first taints. The list is empty.");
        }
        return this.setNewTaintLike(0, this.buildTaint(0));
    }

    public TaintsNested<A> editLastTaint() {
        int index = this.taints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last taints. The list is empty.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    public TaintsNested<A> editMatchingTaint(Predicate<V1beta1DeviceTaintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.taints.size(); ++i) {
            if (!predicate.test(this.taints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching taints. No match found.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta1BasicDeviceFluent that = (V1beta1BasicDeviceFluent)o;
        if (!Objects.equals(this.allNodes, that.allNodes)) {
            return false;
        }
        if (!Objects.equals(this.attributes, that.attributes)) {
            return false;
        }
        if (!Objects.equals(this.capacity, that.capacity)) {
            return false;
        }
        if (!Objects.equals(this.consumesCounters, that.consumesCounters)) {
            return false;
        }
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        return Objects.equals(this.taints, that.taints);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allNodes, this.attributes, this.capacity, this.consumesCounters, this.nodeName, this.nodeSelector, this.taints, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allNodes != null) {
            sb.append("allNodes:");
            sb.append(this.allNodes + ",");
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            sb.append("attributes:");
            sb.append(this.attributes + ",");
        }
        if (this.capacity != null && !this.capacity.isEmpty()) {
            sb.append("capacity:");
            sb.append(this.capacity + ",");
        }
        if (this.consumesCounters != null && !this.consumesCounters.isEmpty()) {
            sb.append("consumesCounters:");
            sb.append(this.consumesCounters + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.nodeSelector != null) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.taints != null && !this.taints.isEmpty()) {
            sb.append("taints:");
            sb.append(this.taints);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAllNodes() {
        return this.withAllNodes(true);
    }

    public class ConsumesCountersNested<N>
    extends V1beta1DeviceCounterConsumptionFluent<ConsumesCountersNested<N>>
    implements Nested<N> {
        V1beta1DeviceCounterConsumptionBuilder builder;
        int index;

        ConsumesCountersNested(int index, V1beta1DeviceCounterConsumption item) {
            this.index = index;
            this.builder = new V1beta1DeviceCounterConsumptionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta1BasicDeviceFluent.this.setToConsumesCounters(this.index, this.builder.build());
        }

        public N endConsumesCounter() {
            return this.and();
        }
    }

    public class NodeSelectorNested<N>
    extends V1NodeSelectorFluent<NodeSelectorNested<N>>
    implements Nested<N> {
        V1NodeSelectorBuilder builder;

        NodeSelectorNested(V1NodeSelector item) {
            this.builder = new V1NodeSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta1BasicDeviceFluent.this.withNodeSelector(this.builder.build());
        }

        public N endNodeSelector() {
            return this.and();
        }
    }

    public class TaintsNested<N>
    extends V1beta1DeviceTaintFluent<TaintsNested<N>>
    implements Nested<N> {
        V1beta1DeviceTaintBuilder builder;
        int index;

        TaintsNested(int index, V1beta1DeviceTaint item) {
            this.index = index;
            this.builder = new V1beta1DeviceTaintBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta1BasicDeviceFluent.this.setToTaints(this.index, this.builder.build());
        }

        public N endTaint() {
            return this.and();
        }
    }
}

