/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1alpha1ApplyConfiguration;
import io.kubernetes.client.openapi.models.V1alpha1ApplyConfigurationBuilder;
import io.kubernetes.client.openapi.models.V1alpha1ApplyConfigurationFluent;
import io.kubernetes.client.openapi.models.V1alpha1JSONPatch;
import io.kubernetes.client.openapi.models.V1alpha1JSONPatchBuilder;
import io.kubernetes.client.openapi.models.V1alpha1JSONPatchFluent;
import io.kubernetes.client.openapi.models.V1alpha1Mutation;
import java.util.Objects;
import java.util.Optional;

public class V1alpha1MutationFluent<A extends V1alpha1MutationFluent<A>>
extends BaseFluent<A> {
    private V1alpha1ApplyConfigurationBuilder applyConfiguration;
    private V1alpha1JSONPatchBuilder jsonPatch;
    private String patchType;

    public V1alpha1MutationFluent() {
    }

    public V1alpha1MutationFluent(V1alpha1Mutation instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1alpha1Mutation instance) {
        V1alpha1Mutation v1alpha1Mutation = instance = instance != null ? instance : new V1alpha1Mutation();
        if (instance != null) {
            this.withApplyConfiguration(instance.getApplyConfiguration());
            this.withJsonPatch(instance.getJsonPatch());
            this.withPatchType(instance.getPatchType());
        }
    }

    public V1alpha1ApplyConfiguration buildApplyConfiguration() {
        return this.applyConfiguration != null ? this.applyConfiguration.build() : null;
    }

    public A withApplyConfiguration(V1alpha1ApplyConfiguration applyConfiguration) {
        this._visitables.remove("applyConfiguration");
        if (applyConfiguration != null) {
            this.applyConfiguration = new V1alpha1ApplyConfigurationBuilder(applyConfiguration);
            this._visitables.get("applyConfiguration").add(this.applyConfiguration);
        } else {
            this.applyConfiguration = null;
            this._visitables.get("applyConfiguration").remove(this.applyConfiguration);
        }
        return (A)this;
    }

    public boolean hasApplyConfiguration() {
        return this.applyConfiguration != null;
    }

    public ApplyConfigurationNested<A> withNewApplyConfiguration() {
        return new ApplyConfigurationNested(null);
    }

    public ApplyConfigurationNested<A> withNewApplyConfigurationLike(V1alpha1ApplyConfiguration item) {
        return new ApplyConfigurationNested(item);
    }

    public ApplyConfigurationNested<A> editApplyConfiguration() {
        return this.withNewApplyConfigurationLike(Optional.ofNullable(this.buildApplyConfiguration()).orElse(null));
    }

    public ApplyConfigurationNested<A> editOrNewApplyConfiguration() {
        return this.withNewApplyConfigurationLike(Optional.ofNullable(this.buildApplyConfiguration()).orElse(new V1alpha1ApplyConfigurationBuilder().build()));
    }

    public ApplyConfigurationNested<A> editOrNewApplyConfigurationLike(V1alpha1ApplyConfiguration item) {
        return this.withNewApplyConfigurationLike(Optional.ofNullable(this.buildApplyConfiguration()).orElse(item));
    }

    public V1alpha1JSONPatch buildJsonPatch() {
        return this.jsonPatch != null ? this.jsonPatch.build() : null;
    }

    public A withJsonPatch(V1alpha1JSONPatch jsonPatch) {
        this._visitables.remove("jsonPatch");
        if (jsonPatch != null) {
            this.jsonPatch = new V1alpha1JSONPatchBuilder(jsonPatch);
            this._visitables.get("jsonPatch").add(this.jsonPatch);
        } else {
            this.jsonPatch = null;
            this._visitables.get("jsonPatch").remove(this.jsonPatch);
        }
        return (A)this;
    }

    public boolean hasJsonPatch() {
        return this.jsonPatch != null;
    }

    public JsonPatchNested<A> withNewJsonPatch() {
        return new JsonPatchNested(null);
    }

    public JsonPatchNested<A> withNewJsonPatchLike(V1alpha1JSONPatch item) {
        return new JsonPatchNested(item);
    }

    public JsonPatchNested<A> editJsonPatch() {
        return this.withNewJsonPatchLike(Optional.ofNullable(this.buildJsonPatch()).orElse(null));
    }

    public JsonPatchNested<A> editOrNewJsonPatch() {
        return this.withNewJsonPatchLike(Optional.ofNullable(this.buildJsonPatch()).orElse(new V1alpha1JSONPatchBuilder().build()));
    }

    public JsonPatchNested<A> editOrNewJsonPatchLike(V1alpha1JSONPatch item) {
        return this.withNewJsonPatchLike(Optional.ofNullable(this.buildJsonPatch()).orElse(item));
    }

    public String getPatchType() {
        return this.patchType;
    }

    public A withPatchType(String patchType) {
        this.patchType = patchType;
        return (A)this;
    }

    public boolean hasPatchType() {
        return this.patchType != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha1MutationFluent that = (V1alpha1MutationFluent)o;
        if (!Objects.equals(this.applyConfiguration, that.applyConfiguration)) {
            return false;
        }
        if (!Objects.equals(this.jsonPatch, that.jsonPatch)) {
            return false;
        }
        return Objects.equals(this.patchType, that.patchType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.applyConfiguration, this.jsonPatch, this.patchType, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applyConfiguration != null) {
            sb.append("applyConfiguration:");
            sb.append(this.applyConfiguration + ",");
        }
        if (this.jsonPatch != null) {
            sb.append("jsonPatch:");
            sb.append(this.jsonPatch + ",");
        }
        if (this.patchType != null) {
            sb.append("patchType:");
            sb.append(this.patchType);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ApplyConfigurationNested<N>
    extends V1alpha1ApplyConfigurationFluent<ApplyConfigurationNested<N>>
    implements Nested<N> {
        V1alpha1ApplyConfigurationBuilder builder;

        ApplyConfigurationNested(V1alpha1ApplyConfiguration item) {
            this.builder = new V1alpha1ApplyConfigurationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha1MutationFluent.this.withApplyConfiguration(this.builder.build());
        }

        public N endApplyConfiguration() {
            return this.and();
        }
    }

    public class JsonPatchNested<N>
    extends V1alpha1JSONPatchFluent<JsonPatchNested<N>>
    implements Nested<N> {
        V1alpha1JSONPatchBuilder builder;

        JsonPatchNested(V1alpha1JSONPatch item) {
            this.builder = new V1alpha1JSONPatchBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1alpha1MutationFluent.this.withJsonPatch(this.builder.build());
        }

        public N endJsonPatch() {
            return this.and();
        }
    }
}

