/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.CoreV1EndpointPort;
import io.kubernetes.client.openapi.models.CoreV1EndpointPortBuilder;
import io.kubernetes.client.openapi.models.CoreV1EndpointPortFluent;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.kubernetes.client.openapi.models.V1EndpointAddressBuilder;
import io.kubernetes.client.openapi.models.V1EndpointAddressFluent;
import io.kubernetes.client.openapi.models.V1EndpointSubset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1EndpointSubsetFluent<A extends V1EndpointSubsetFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1EndpointAddressBuilder> addresses;
    private ArrayList<V1EndpointAddressBuilder> notReadyAddresses;
    private ArrayList<CoreV1EndpointPortBuilder> ports;

    public V1EndpointSubsetFluent() {
    }

    public V1EndpointSubsetFluent(V1EndpointSubset instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1EndpointSubset instance) {
        V1EndpointSubset v1EndpointSubset = instance = instance != null ? instance : new V1EndpointSubset();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withNotReadyAddresses(instance.getNotReadyAddresses());
            this.withPorts(instance.getPorts());
        }
    }

    public A addToAddresses(int index, V1EndpointAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(index, builder);
        }
        return (A)this;
    }

    public A setToAddresses(int index, V1EndpointAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get("addresses").add(builder);
            this.addresses.set(index, builder);
        }
        return (A)this;
    }

    public A addToAddresses(V1EndpointAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    public A addAllToAddresses(Collection<V1EndpointAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    public A removeFromAddresses(V1EndpointAddress ... items) {
        if (this.addresses == null) {
            return (A)this;
        }
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAddresses(Collection<V1EndpointAddress> items) {
        if (this.addresses == null) {
            return (A)this;
        }
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAddresses(Predicate<V1EndpointAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)this;
        }
        Iterator<V1EndpointAddressBuilder> each = this.addresses.iterator();
        Object visitables = this._visitables.get("addresses");
        while (each.hasNext()) {
            V1EndpointAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1EndpointAddress> buildAddresses() {
        return this.addresses != null ? V1EndpointSubsetFluent.build(this.addresses) : null;
    }

    public V1EndpointAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public V1EndpointAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public V1EndpointAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public V1EndpointAddress buildMatchingAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        for (V1EndpointAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        for (V1EndpointAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAddresses(List<V1EndpointAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get("addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (V1EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    public A withAddresses(V1EndpointAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove("addresses");
        }
        if (addresses != null) {
            for (V1EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public AddressesNested<A> addNewAddressLike(V1EndpointAddress item) {
        return new AddressesNested(-1, item);
    }

    public AddressesNested<A> setNewAddressLike(int index, V1EndpointAddress item) {
        return new AddressesNested(index, item);
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public A addToNotReadyAddresses(int index, V1EndpointAddress item) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
        if (index < 0 || index >= this.notReadyAddresses.size()) {
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        } else {
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(index, builder);
        }
        return (A)this;
    }

    public A setToNotReadyAddresses(int index, V1EndpointAddress item) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
        if (index < 0 || index >= this.notReadyAddresses.size()) {
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        } else {
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.set(index, builder);
        }
        return (A)this;
    }

    public A addToNotReadyAddresses(V1EndpointAddress ... items) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        }
        return (A)this;
    }

    public A addAllToNotReadyAddresses(Collection<V1EndpointAddress> items) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList();
        }
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        }
        return (A)this;
    }

    public A removeFromNotReadyAddresses(V1EndpointAddress ... items) {
        if (this.notReadyAddresses == null) {
            return (A)this;
        }
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").remove(builder);
            this.notReadyAddresses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromNotReadyAddresses(Collection<V1EndpointAddress> items) {
        if (this.notReadyAddresses == null) {
            return (A)this;
        }
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").remove(builder);
            this.notReadyAddresses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromNotReadyAddresses(Predicate<V1EndpointAddressBuilder> predicate) {
        if (this.notReadyAddresses == null) {
            return (A)this;
        }
        Iterator<V1EndpointAddressBuilder> each = this.notReadyAddresses.iterator();
        Object visitables = this._visitables.get("notReadyAddresses");
        while (each.hasNext()) {
            V1EndpointAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1EndpointAddress> buildNotReadyAddresses() {
        return this.notReadyAddresses != null ? V1EndpointSubsetFluent.build(this.notReadyAddresses) : null;
    }

    public V1EndpointAddress buildNotReadyAddress(int index) {
        return this.notReadyAddresses.get(index).build();
    }

    public V1EndpointAddress buildFirstNotReadyAddress() {
        return this.notReadyAddresses.get(0).build();
    }

    public V1EndpointAddress buildLastNotReadyAddress() {
        return this.notReadyAddresses.get(this.notReadyAddresses.size() - 1).build();
    }

    public V1EndpointAddress buildMatchingNotReadyAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        for (V1EndpointAddressBuilder item : this.notReadyAddresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingNotReadyAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        for (V1EndpointAddressBuilder item : this.notReadyAddresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNotReadyAddresses(List<V1EndpointAddress> notReadyAddresses) {
        if (this.notReadyAddresses != null) {
            this._visitables.get("notReadyAddresses").clear();
        }
        if (notReadyAddresses != null) {
            this.notReadyAddresses = new ArrayList();
            for (V1EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        } else {
            this.notReadyAddresses = null;
        }
        return (A)this;
    }

    public A withNotReadyAddresses(V1EndpointAddress ... notReadyAddresses) {
        if (this.notReadyAddresses != null) {
            this.notReadyAddresses.clear();
            this._visitables.remove("notReadyAddresses");
        }
        if (notReadyAddresses != null) {
            for (V1EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        }
        return (A)this;
    }

    public boolean hasNotReadyAddresses() {
        return this.notReadyAddresses != null && !this.notReadyAddresses.isEmpty();
    }

    public NotReadyAddressesNested<A> addNewNotReadyAddress() {
        return new NotReadyAddressesNested(-1, null);
    }

    public NotReadyAddressesNested<A> addNewNotReadyAddressLike(V1EndpointAddress item) {
        return new NotReadyAddressesNested(-1, item);
    }

    public NotReadyAddressesNested<A> setNewNotReadyAddressLike(int index, V1EndpointAddress item) {
        return new NotReadyAddressesNested(index, item);
    }

    public NotReadyAddressesNested<A> editNotReadyAddress(int index) {
        if (this.notReadyAddresses.size() <= index) {
            throw new RuntimeException("Can't edit notReadyAddresses. Index exceeds size.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    public NotReadyAddressesNested<A> editFirstNotReadyAddress() {
        if (this.notReadyAddresses.size() == 0) {
            throw new RuntimeException("Can't edit first notReadyAddresses. The list is empty.");
        }
        return this.setNewNotReadyAddressLike(0, this.buildNotReadyAddress(0));
    }

    public NotReadyAddressesNested<A> editLastNotReadyAddress() {
        int index = this.notReadyAddresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last notReadyAddresses. The list is empty.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    public NotReadyAddressesNested<A> editMatchingNotReadyAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.notReadyAddresses.size(); ++i) {
            if (!predicate.test(this.notReadyAddresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching notReadyAddresses. No match found.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    public A addToPorts(int index, CoreV1EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        CoreV1EndpointPortBuilder builder = new CoreV1EndpointPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(builder);
            this.ports.add(index, builder);
        }
        return (A)this;
    }

    public A setToPorts(int index, CoreV1EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        CoreV1EndpointPortBuilder builder = new CoreV1EndpointPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(builder);
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    public A addToPorts(CoreV1EndpointPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (CoreV1EndpointPort item : items) {
            CoreV1EndpointPortBuilder builder = new CoreV1EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A addAllToPorts(Collection<CoreV1EndpointPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (CoreV1EndpointPort item : items) {
            CoreV1EndpointPortBuilder builder = new CoreV1EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A removeFromPorts(CoreV1EndpointPort ... items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (CoreV1EndpointPort item : items) {
            CoreV1EndpointPortBuilder builder = new CoreV1EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPorts(Collection<CoreV1EndpointPort> items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (CoreV1EndpointPort item : items) {
            CoreV1EndpointPortBuilder builder = new CoreV1EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPorts(Predicate<CoreV1EndpointPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<CoreV1EndpointPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            CoreV1EndpointPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<CoreV1EndpointPort> buildPorts() {
        return this.ports != null ? V1EndpointSubsetFluent.build(this.ports) : null;
    }

    public CoreV1EndpointPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public CoreV1EndpointPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public CoreV1EndpointPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public CoreV1EndpointPort buildMatchingPort(Predicate<CoreV1EndpointPortBuilder> predicate) {
        for (CoreV1EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<CoreV1EndpointPortBuilder> predicate) {
        for (CoreV1EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPorts(List<CoreV1EndpointPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (CoreV1EndpointPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    public A withPorts(CoreV1EndpointPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove("ports");
        }
        if (ports != null) {
            for (CoreV1EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(CoreV1EndpointPort item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, CoreV1EndpointPort item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<CoreV1EndpointPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1EndpointSubsetFluent that = (V1EndpointSubsetFluent)o;
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.notReadyAddresses, that.notReadyAddresses)) {
            return false;
        }
        return Objects.equals(this.ports, that.ports);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.addresses, this.notReadyAddresses, this.ports, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.notReadyAddresses != null && !this.notReadyAddresses.isEmpty()) {
            sb.append("notReadyAddresses:");
            sb.append(this.notReadyAddresses + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports);
        }
        sb.append("}");
        return sb.toString();
    }

    public class AddressesNested<N>
    extends V1EndpointAddressFluent<AddressesNested<N>>
    implements Nested<N> {
        V1EndpointAddressBuilder builder;
        int index;

        AddressesNested(int index, V1EndpointAddress item) {
            this.index = index;
            this.builder = new V1EndpointAddressBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1EndpointSubsetFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }

    public class NotReadyAddressesNested<N>
    extends V1EndpointAddressFluent<NotReadyAddressesNested<N>>
    implements Nested<N> {
        V1EndpointAddressBuilder builder;
        int index;

        NotReadyAddressesNested(int index, V1EndpointAddress item) {
            this.index = index;
            this.builder = new V1EndpointAddressBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1EndpointSubsetFluent.this.setToNotReadyAddresses(this.index, this.builder.build());
        }

        public N endNotReadyAddress() {
            return this.and();
        }
    }

    public class PortsNested<N>
    extends CoreV1EndpointPortFluent<PortsNested<N>>
    implements Nested<N> {
        CoreV1EndpointPortBuilder builder;
        int index;

        PortsNested(int index, CoreV1EndpointPort item) {
            this.index = index;
            this.builder = new CoreV1EndpointPortBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1EndpointSubsetFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

