/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort;
import io.kubernetes.client.openapi.models.DiscoveryV1EndpointPortBuilder;
import io.kubernetes.client.openapi.models.DiscoveryV1EndpointPortFluent;
import io.kubernetes.client.openapi.models.V1Endpoint;
import io.kubernetes.client.openapi.models.V1EndpointBuilder;
import io.kubernetes.client.openapi.models.V1EndpointFluent;
import io.kubernetes.client.openapi.models.V1EndpointSlice;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1EndpointSliceFluent<A extends V1EndpointSliceFluent<A>>
extends BaseFluent<A> {
    private String addressType;
    private String apiVersion;
    private ArrayList<V1EndpointBuilder> endpoints;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private ArrayList<DiscoveryV1EndpointPortBuilder> ports;

    public V1EndpointSliceFluent() {
    }

    public V1EndpointSliceFluent(V1EndpointSlice instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1EndpointSlice instance) {
        V1EndpointSlice v1EndpointSlice = instance = instance != null ? instance : new V1EndpointSlice();
        if (instance != null) {
            this.withAddressType(instance.getAddressType());
            this.withApiVersion(instance.getApiVersion());
            this.withEndpoints(instance.getEndpoints());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withPorts(instance.getPorts());
        }
    }

    public String getAddressType() {
        return this.addressType;
    }

    public A withAddressType(String addressType) {
        this.addressType = addressType;
        return (A)this;
    }

    public boolean hasAddressType() {
        return this.addressType != null;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToEndpoints(int index, V1Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        V1EndpointBuilder builder = new V1EndpointBuilder(item);
        if (index < 0 || index >= this.endpoints.size()) {
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(builder);
        } else {
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(index, builder);
        }
        return (A)this;
    }

    public A setToEndpoints(int index, V1Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        V1EndpointBuilder builder = new V1EndpointBuilder(item);
        if (index < 0 || index >= this.endpoints.size()) {
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(builder);
        } else {
            this._visitables.get("endpoints").add(builder);
            this.endpoints.set(index, builder);
        }
        return (A)this;
    }

    public A addToEndpoints(V1Endpoint ... items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        for (V1Endpoint item : items) {
            V1EndpointBuilder builder = new V1EndpointBuilder(item);
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    public A addAllToEndpoints(Collection<V1Endpoint> items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList();
        }
        for (V1Endpoint item : items) {
            V1EndpointBuilder builder = new V1EndpointBuilder(item);
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    public A removeFromEndpoints(V1Endpoint ... items) {
        if (this.endpoints == null) {
            return (A)this;
        }
        for (V1Endpoint item : items) {
            V1EndpointBuilder builder = new V1EndpointBuilder(item);
            this._visitables.get("endpoints").remove(builder);
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromEndpoints(Collection<V1Endpoint> items) {
        if (this.endpoints == null) {
            return (A)this;
        }
        for (V1Endpoint item : items) {
            V1EndpointBuilder builder = new V1EndpointBuilder(item);
            this._visitables.get("endpoints").remove(builder);
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromEndpoints(Predicate<V1EndpointBuilder> predicate) {
        if (this.endpoints == null) {
            return (A)this;
        }
        Iterator<V1EndpointBuilder> each = this.endpoints.iterator();
        Object visitables = this._visitables.get("endpoints");
        while (each.hasNext()) {
            V1EndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1Endpoint> buildEndpoints() {
        return this.endpoints != null ? V1EndpointSliceFluent.build(this.endpoints) : null;
    }

    public V1Endpoint buildEndpoint(int index) {
        return this.endpoints.get(index).build();
    }

    public V1Endpoint buildFirstEndpoint() {
        return this.endpoints.get(0).build();
    }

    public V1Endpoint buildLastEndpoint() {
        return this.endpoints.get(this.endpoints.size() - 1).build();
    }

    public V1Endpoint buildMatchingEndpoint(Predicate<V1EndpointBuilder> predicate) {
        for (V1EndpointBuilder item : this.endpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEndpoint(Predicate<V1EndpointBuilder> predicate) {
        for (V1EndpointBuilder item : this.endpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEndpoints(List<V1Endpoint> endpoints) {
        if (this.endpoints != null) {
            this._visitables.get("endpoints").clear();
        }
        if (endpoints != null) {
            this.endpoints = new ArrayList();
            for (V1Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        } else {
            this.endpoints = null;
        }
        return (A)this;
    }

    public A withEndpoints(V1Endpoint ... endpoints) {
        if (this.endpoints != null) {
            this.endpoints.clear();
            this._visitables.remove("endpoints");
        }
        if (endpoints != null) {
            for (V1Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        }
        return (A)this;
    }

    public boolean hasEndpoints() {
        return this.endpoints != null && !this.endpoints.isEmpty();
    }

    public EndpointsNested<A> addNewEndpoint() {
        return new EndpointsNested(-1, null);
    }

    public EndpointsNested<A> addNewEndpointLike(V1Endpoint item) {
        return new EndpointsNested(-1, item);
    }

    public EndpointsNested<A> setNewEndpointLike(int index, V1Endpoint item) {
        return new EndpointsNested(index, item);
    }

    public EndpointsNested<A> editEndpoint(int index) {
        if (this.endpoints.size() <= index) {
            throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    public EndpointsNested<A> editFirstEndpoint() {
        if (this.endpoints.size() == 0) {
            throw new RuntimeException("Can't edit first endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(0, this.buildEndpoint(0));
    }

    public EndpointsNested<A> editLastEndpoint() {
        int index = this.endpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    public EndpointsNested<A> editMatchingEndpoint(Predicate<V1EndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            if (!predicate.test(this.endpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching endpoints. No match found.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public A addToPorts(int index, DiscoveryV1EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        DiscoveryV1EndpointPortBuilder builder = new DiscoveryV1EndpointPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(builder);
            this.ports.add(index, builder);
        }
        return (A)this;
    }

    public A setToPorts(int index, DiscoveryV1EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        DiscoveryV1EndpointPortBuilder builder = new DiscoveryV1EndpointPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(builder);
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    public A addToPorts(DiscoveryV1EndpointPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (DiscoveryV1EndpointPort item : items) {
            DiscoveryV1EndpointPortBuilder builder = new DiscoveryV1EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A addAllToPorts(Collection<DiscoveryV1EndpointPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (DiscoveryV1EndpointPort item : items) {
            DiscoveryV1EndpointPortBuilder builder = new DiscoveryV1EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A removeFromPorts(DiscoveryV1EndpointPort ... items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (DiscoveryV1EndpointPort item : items) {
            DiscoveryV1EndpointPortBuilder builder = new DiscoveryV1EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPorts(Collection<DiscoveryV1EndpointPort> items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (DiscoveryV1EndpointPort item : items) {
            DiscoveryV1EndpointPortBuilder builder = new DiscoveryV1EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPorts(Predicate<DiscoveryV1EndpointPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<DiscoveryV1EndpointPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            DiscoveryV1EndpointPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DiscoveryV1EndpointPort> buildPorts() {
        return this.ports != null ? V1EndpointSliceFluent.build(this.ports) : null;
    }

    public DiscoveryV1EndpointPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public DiscoveryV1EndpointPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public DiscoveryV1EndpointPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public DiscoveryV1EndpointPort buildMatchingPort(Predicate<DiscoveryV1EndpointPortBuilder> predicate) {
        for (DiscoveryV1EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<DiscoveryV1EndpointPortBuilder> predicate) {
        for (DiscoveryV1EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPorts(List<DiscoveryV1EndpointPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (DiscoveryV1EndpointPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    public A withPorts(DiscoveryV1EndpointPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove("ports");
        }
        if (ports != null) {
            for (DiscoveryV1EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(DiscoveryV1EndpointPort item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, DiscoveryV1EndpointPort item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<DiscoveryV1EndpointPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1EndpointSliceFluent that = (V1EndpointSliceFluent)o;
        if (!Objects.equals(this.addressType, that.addressType)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.endpoints, that.endpoints)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.ports, that.ports);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.addressType, this.apiVersion, this.endpoints, this.kind, this.metadata, this.ports, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addressType != null) {
            sb.append("addressType:");
            sb.append(this.addressType + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.endpoints != null && !this.endpoints.isEmpty()) {
            sb.append("endpoints:");
            sb.append(this.endpoints + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EndpointsNested<N>
    extends V1EndpointFluent<EndpointsNested<N>>
    implements Nested<N> {
        V1EndpointBuilder builder;
        int index;

        EndpointsNested(int index, V1Endpoint item) {
            this.index = index;
            this.builder = new V1EndpointBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1EndpointSliceFluent.this.setToEndpoints(this.index, this.builder.build());
        }

        public N endEndpoint() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1EndpointSliceFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class PortsNested<N>
    extends DiscoveryV1EndpointPortFluent<PortsNested<N>>
    implements Nested<N> {
        DiscoveryV1EndpointPortBuilder builder;
        int index;

        PortsNested(int index, DiscoveryV1EndpointPort item) {
            this.index = index;
            this.builder = new DiscoveryV1EndpointPortBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1EndpointSliceFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }
}

