/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CronJobStatus;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.kubernetes.client.openapi.models.V1ObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1ObjectReferenceFluent;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1CronJobStatusFluent<A extends V1CronJobStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1ObjectReferenceBuilder> active;
    private OffsetDateTime lastScheduleTime;
    private OffsetDateTime lastSuccessfulTime;

    public V1CronJobStatusFluent() {
    }

    public V1CronJobStatusFluent(V1CronJobStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1CronJobStatus instance) {
        V1CronJobStatus v1CronJobStatus = instance = instance != null ? instance : new V1CronJobStatus();
        if (instance != null) {
            this.withActive(instance.getActive());
            this.withLastScheduleTime(instance.getLastScheduleTime());
            this.withLastSuccessfulTime(instance.getLastSuccessfulTime());
        }
    }

    public A addToActive(int index, V1ObjectReference item) {
        if (this.active == null) {
            this.active = new ArrayList();
        }
        V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.active.size()) {
            this._visitables.get("active").add(builder);
            this.active.add(builder);
        } else {
            this._visitables.get("active").add(builder);
            this.active.add(index, builder);
        }
        return (A)this;
    }

    public A setToActive(int index, V1ObjectReference item) {
        if (this.active == null) {
            this.active = new ArrayList();
        }
        V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.active.size()) {
            this._visitables.get("active").add(builder);
            this.active.add(builder);
        } else {
            this._visitables.get("active").add(builder);
            this.active.set(index, builder);
        }
        return (A)this;
    }

    public A addToActive(V1ObjectReference ... items) {
        if (this.active == null) {
            this.active = new ArrayList();
        }
        for (V1ObjectReference item : items) {
            V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
            this._visitables.get("active").add(builder);
            this.active.add(builder);
        }
        return (A)this;
    }

    public A addAllToActive(Collection<V1ObjectReference> items) {
        if (this.active == null) {
            this.active = new ArrayList();
        }
        for (V1ObjectReference item : items) {
            V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
            this._visitables.get("active").add(builder);
            this.active.add(builder);
        }
        return (A)this;
    }

    public A removeFromActive(V1ObjectReference ... items) {
        if (this.active == null) {
            return (A)this;
        }
        for (V1ObjectReference item : items) {
            V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
            this._visitables.get("active").remove(builder);
            this.active.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromActive(Collection<V1ObjectReference> items) {
        if (this.active == null) {
            return (A)this;
        }
        for (V1ObjectReference item : items) {
            V1ObjectReferenceBuilder builder = new V1ObjectReferenceBuilder(item);
            this._visitables.get("active").remove(builder);
            this.active.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromActive(Predicate<V1ObjectReferenceBuilder> predicate) {
        if (this.active == null) {
            return (A)this;
        }
        Iterator<V1ObjectReferenceBuilder> each = this.active.iterator();
        Object visitables = this._visitables.get("active");
        while (each.hasNext()) {
            V1ObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1ObjectReference> buildActive() {
        return this.active != null ? V1CronJobStatusFluent.build(this.active) : null;
    }

    public V1ObjectReference buildActive(int index) {
        return this.active.get(index).build();
    }

    public V1ObjectReference buildFirstActive() {
        return this.active.get(0).build();
    }

    public V1ObjectReference buildLastActive() {
        return this.active.get(this.active.size() - 1).build();
    }

    public V1ObjectReference buildMatchingActive(Predicate<V1ObjectReferenceBuilder> predicate) {
        for (V1ObjectReferenceBuilder item : this.active) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingActive(Predicate<V1ObjectReferenceBuilder> predicate) {
        for (V1ObjectReferenceBuilder item : this.active) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withActive(List<V1ObjectReference> active) {
        if (this.active != null) {
            this._visitables.get("active").clear();
        }
        if (active != null) {
            this.active = new ArrayList();
            for (V1ObjectReference item : active) {
                this.addToActive(item);
            }
        } else {
            this.active = null;
        }
        return (A)this;
    }

    public A withActive(V1ObjectReference ... active) {
        if (this.active != null) {
            this.active.clear();
            this._visitables.remove("active");
        }
        if (active != null) {
            for (V1ObjectReference item : active) {
                this.addToActive(item);
            }
        }
        return (A)this;
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public ActiveNested<A> addNewActive() {
        return new ActiveNested(-1, null);
    }

    public ActiveNested<A> addNewActiveLike(V1ObjectReference item) {
        return new ActiveNested(-1, item);
    }

    public ActiveNested<A> setNewActiveLike(int index, V1ObjectReference item) {
        return new ActiveNested(index, item);
    }

    public ActiveNested<A> editActive(int index) {
        if (this.active.size() <= index) {
            throw new RuntimeException("Can't edit active. Index exceeds size.");
        }
        return this.setNewActiveLike(index, this.buildActive(index));
    }

    public ActiveNested<A> editFirstActive() {
        if (this.active.size() == 0) {
            throw new RuntimeException("Can't edit first active. The list is empty.");
        }
        return this.setNewActiveLike(0, this.buildActive(0));
    }

    public ActiveNested<A> editLastActive() {
        int index = this.active.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last active. The list is empty.");
        }
        return this.setNewActiveLike(index, this.buildActive(index));
    }

    public ActiveNested<A> editMatchingActive(Predicate<V1ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.active.size(); ++i) {
            if (!predicate.test(this.active.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching active. No match found.");
        }
        return this.setNewActiveLike(index, this.buildActive(index));
    }

    public OffsetDateTime getLastScheduleTime() {
        return this.lastScheduleTime;
    }

    public A withLastScheduleTime(OffsetDateTime lastScheduleTime) {
        this.lastScheduleTime = lastScheduleTime;
        return (A)this;
    }

    public boolean hasLastScheduleTime() {
        return this.lastScheduleTime != null;
    }

    public OffsetDateTime getLastSuccessfulTime() {
        return this.lastSuccessfulTime;
    }

    public A withLastSuccessfulTime(OffsetDateTime lastSuccessfulTime) {
        this.lastSuccessfulTime = lastSuccessfulTime;
        return (A)this;
    }

    public boolean hasLastSuccessfulTime() {
        return this.lastSuccessfulTime != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1CronJobStatusFluent that = (V1CronJobStatusFluent)o;
        if (!Objects.equals(this.active, that.active)) {
            return false;
        }
        if (!Objects.equals(this.lastScheduleTime, that.lastScheduleTime)) {
            return false;
        }
        return Objects.equals(this.lastSuccessfulTime, that.lastSuccessfulTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.active, this.lastScheduleTime, this.lastSuccessfulTime, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.active != null && !this.active.isEmpty()) {
            sb.append("active:");
            sb.append(this.active + ",");
        }
        if (this.lastScheduleTime != null) {
            sb.append("lastScheduleTime:");
            sb.append(this.lastScheduleTime + ",");
        }
        if (this.lastSuccessfulTime != null) {
            sb.append("lastSuccessfulTime:");
            sb.append(this.lastSuccessfulTime);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ActiveNested<N>
    extends V1ObjectReferenceFluent<ActiveNested<N>>
    implements Nested<N> {
        V1ObjectReferenceBuilder builder;
        int index;

        ActiveNested(int index, V1ObjectReference item) {
            this.index = index;
            this.builder = new V1ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1CronJobStatusFluent.this.setToActive(this.index, this.builder.build());
        }

        public N endActive() {
            return this.and();
        }
    }
}

