/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V2ContainerResourceMetricSource;
import io.kubernetes.client.openapi.models.V2ExternalMetricSource;
import io.kubernetes.client.openapi.models.V2ObjectMetricSource;
import io.kubernetes.client.openapi.models.V2PodsMetricSource;
import io.kubernetes.client.openapi.models.V2ResourceMetricSource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).")
public class V2MetricSpec {
    public static final String SERIALIZED_NAME_CONTAINER_RESOURCE = "containerResource";
    @SerializedName(value="containerResource")
    private V2ContainerResourceMetricSource containerResource;
    public static final String SERIALIZED_NAME_EXTERNAL = "external";
    @SerializedName(value="external")
    private V2ExternalMetricSource external;
    public static final String SERIALIZED_NAME_OBJECT = "object";
    @SerializedName(value="object")
    private V2ObjectMetricSource _object;
    public static final String SERIALIZED_NAME_PODS = "pods";
    @SerializedName(value="pods")
    private V2PodsMetricSource pods;
    public static final String SERIALIZED_NAME_RESOURCE = "resource";
    @SerializedName(value="resource")
    private V2ResourceMetricSource resource;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public V2MetricSpec containerResource(V2ContainerResourceMetricSource containerResource) {
        this.containerResource = containerResource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V2ContainerResourceMetricSource getContainerResource() {
        return this.containerResource;
    }

    public void setContainerResource(V2ContainerResourceMetricSource containerResource) {
        this.containerResource = containerResource;
    }

    public V2MetricSpec external(V2ExternalMetricSource external) {
        this.external = external;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V2ExternalMetricSource getExternal() {
        return this.external;
    }

    public void setExternal(V2ExternalMetricSource external) {
        this.external = external;
    }

    public V2MetricSpec _object(V2ObjectMetricSource _object) {
        this._object = _object;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V2ObjectMetricSource getObject() {
        return this._object;
    }

    public void setObject(V2ObjectMetricSource _object) {
        this._object = _object;
    }

    public V2MetricSpec pods(V2PodsMetricSource pods) {
        this.pods = pods;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V2PodsMetricSource getPods() {
        return this.pods;
    }

    public void setPods(V2PodsMetricSource pods) {
        this.pods = pods;
    }

    public V2MetricSpec resource(V2ResourceMetricSource resource) {
        this.resource = resource;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V2ResourceMetricSource getResource() {
        return this.resource;
    }

    public void setResource(V2ResourceMetricSource resource) {
        this.resource = resource;
    }

    public V2MetricSpec type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="type is the type of metric source.  It should be one of \"ContainerResource\", \"External\", \"Object\", \"Pods\" or \"Resource\", each mapping to a matching field in the object.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2MetricSpec v2MetricSpec = (V2MetricSpec)o;
        return Objects.equals(this.containerResource, v2MetricSpec.containerResource) && Objects.equals(this.external, v2MetricSpec.external) && Objects.equals(this._object, v2MetricSpec._object) && Objects.equals(this.pods, v2MetricSpec.pods) && Objects.equals(this.resource, v2MetricSpec.resource) && Objects.equals(this.type, v2MetricSpec.type);
    }

    public int hashCode() {
        return Objects.hash(this.containerResource, this.external, this._object, this.pods, this.resource, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2MetricSpec {\n");
        sb.append("    containerResource: ").append(this.toIndentedString(this.containerResource)).append("\n");
        sb.append("    external: ").append(this.toIndentedString(this.external)).append("\n");
        sb.append("    _object: ").append(this.toIndentedString(this._object)).append("\n");
        sb.append("    pods: ").append(this.toIndentedString(this.pods)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

