/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An API server instance reports the version it can decode and the version it encodes objects to when persisting objects in the backend.")
public class V1alpha1ServerStorageVersion {
    public static final String SERIALIZED_NAME_API_SERVER_I_D = "apiServerID";
    @SerializedName(value="apiServerID")
    private String apiServerID;
    public static final String SERIALIZED_NAME_DECODABLE_VERSIONS = "decodableVersions";
    @SerializedName(value="decodableVersions")
    private List<String> decodableVersions = null;
    public static final String SERIALIZED_NAME_ENCODING_VERSION = "encodingVersion";
    @SerializedName(value="encodingVersion")
    private String encodingVersion;
    public static final String SERIALIZED_NAME_SERVED_VERSIONS = "servedVersions";
    @SerializedName(value="servedVersions")
    private List<String> servedVersions = null;

    public V1alpha1ServerStorageVersion apiServerID(String apiServerID) {
        this.apiServerID = apiServerID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the reporting API server.")
    public String getApiServerID() {
        return this.apiServerID;
    }

    public void setApiServerID(String apiServerID) {
        this.apiServerID = apiServerID;
    }

    public V1alpha1ServerStorageVersion decodableVersions(List<String> decodableVersions) {
        this.decodableVersions = decodableVersions;
        return this;
    }

    public V1alpha1ServerStorageVersion addDecodableVersionsItem(String decodableVersionsItem) {
        if (this.decodableVersions == null) {
            this.decodableVersions = new ArrayList<String>();
        }
        this.decodableVersions.add(decodableVersionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The API server can decode objects encoded in these versions. The encodingVersion must be included in the decodableVersions.")
    public List<String> getDecodableVersions() {
        return this.decodableVersions;
    }

    public void setDecodableVersions(List<String> decodableVersions) {
        this.decodableVersions = decodableVersions;
    }

    public V1alpha1ServerStorageVersion encodingVersion(String encodingVersion) {
        this.encodingVersion = encodingVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The API server encodes the object to this version when persisting it in the backend (e.g., etcd).")
    public String getEncodingVersion() {
        return this.encodingVersion;
    }

    public void setEncodingVersion(String encodingVersion) {
        this.encodingVersion = encodingVersion;
    }

    public V1alpha1ServerStorageVersion servedVersions(List<String> servedVersions) {
        this.servedVersions = servedVersions;
        return this;
    }

    public V1alpha1ServerStorageVersion addServedVersionsItem(String servedVersionsItem) {
        if (this.servedVersions == null) {
            this.servedVersions = new ArrayList<String>();
        }
        this.servedVersions.add(servedVersionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The API server can serve these versions. DecodableVersions must include all ServedVersions.")
    public List<String> getServedVersions() {
        return this.servedVersions;
    }

    public void setServedVersions(List<String> servedVersions) {
        this.servedVersions = servedVersions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1ServerStorageVersion v1alpha1ServerStorageVersion = (V1alpha1ServerStorageVersion)o;
        return Objects.equals(this.apiServerID, v1alpha1ServerStorageVersion.apiServerID) && Objects.equals(this.decodableVersions, v1alpha1ServerStorageVersion.decodableVersions) && Objects.equals(this.encodingVersion, v1alpha1ServerStorageVersion.encodingVersion) && Objects.equals(this.servedVersions, v1alpha1ServerStorageVersion.servedVersions);
    }

    public int hashCode() {
        return Objects.hash(this.apiServerID, this.decodableVersions, this.encodingVersion, this.servedVersions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1ServerStorageVersion {\n");
        sb.append("    apiServerID: ").append(this.toIndentedString(this.apiServerID)).append("\n");
        sb.append("    decodableVersions: ").append(this.toIndentedString(this.decodableVersions)).append("\n");
        sb.append("    encodingVersion: ").append(this.toIndentedString(this.encodingVersion)).append("\n");
        sb.append("    servedVersions: ").append(this.toIndentedString(this.servedVersions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

