/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1Affinity;
import io.kubernetes.client.openapi.models.V1AffinityBuilder;
import io.kubernetes.client.openapi.models.V1AffinityFluent;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerBuilder;
import io.kubernetes.client.openapi.models.V1ContainerFluent;
import io.kubernetes.client.openapi.models.V1EphemeralContainer;
import io.kubernetes.client.openapi.models.V1EphemeralContainerBuilder;
import io.kubernetes.client.openapi.models.V1EphemeralContainerFluent;
import io.kubernetes.client.openapi.models.V1HostAlias;
import io.kubernetes.client.openapi.models.V1HostAliasBuilder;
import io.kubernetes.client.openapi.models.V1HostAliasFluent;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceFluent;
import io.kubernetes.client.openapi.models.V1PodDNSConfig;
import io.kubernetes.client.openapi.models.V1PodDNSConfigBuilder;
import io.kubernetes.client.openapi.models.V1PodDNSConfigFluent;
import io.kubernetes.client.openapi.models.V1PodOS;
import io.kubernetes.client.openapi.models.V1PodOSBuilder;
import io.kubernetes.client.openapi.models.V1PodOSFluent;
import io.kubernetes.client.openapi.models.V1PodReadinessGate;
import io.kubernetes.client.openapi.models.V1PodReadinessGateBuilder;
import io.kubernetes.client.openapi.models.V1PodReadinessGateFluent;
import io.kubernetes.client.openapi.models.V1PodResourceClaim;
import io.kubernetes.client.openapi.models.V1PodResourceClaimBuilder;
import io.kubernetes.client.openapi.models.V1PodResourceClaimFluent;
import io.kubernetes.client.openapi.models.V1PodSchedulingGate;
import io.kubernetes.client.openapi.models.V1PodSchedulingGateBuilder;
import io.kubernetes.client.openapi.models.V1PodSchedulingGateFluent;
import io.kubernetes.client.openapi.models.V1PodSecurityContext;
import io.kubernetes.client.openapi.models.V1PodSecurityContextBuilder;
import io.kubernetes.client.openapi.models.V1PodSecurityContextFluent;
import io.kubernetes.client.openapi.models.V1PodSpec;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1ResourceRequirementsBuilder;
import io.kubernetes.client.openapi.models.V1ResourceRequirementsFluent;
import io.kubernetes.client.openapi.models.V1Toleration;
import io.kubernetes.client.openapi.models.V1TolerationBuilder;
import io.kubernetes.client.openapi.models.V1TolerationFluent;
import io.kubernetes.client.openapi.models.V1TopologySpreadConstraint;
import io.kubernetes.client.openapi.models.V1TopologySpreadConstraintBuilder;
import io.kubernetes.client.openapi.models.V1TopologySpreadConstraintFluent;
import io.kubernetes.client.openapi.models.V1Volume;
import io.kubernetes.client.openapi.models.V1VolumeBuilder;
import io.kubernetes.client.openapi.models.V1VolumeFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1PodSpecFluent<A extends V1PodSpecFluent<A>>
extends BaseFluent<A> {
    private Long activeDeadlineSeconds;
    private V1AffinityBuilder affinity;
    private Boolean automountServiceAccountToken;
    private ArrayList<V1ContainerBuilder> containers;
    private V1PodDNSConfigBuilder dnsConfig;
    private String dnsPolicy;
    private Boolean enableServiceLinks;
    private ArrayList<V1EphemeralContainerBuilder> ephemeralContainers;
    private ArrayList<V1HostAliasBuilder> hostAliases;
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private Boolean hostUsers;
    private String hostname;
    private ArrayList<V1LocalObjectReferenceBuilder> imagePullSecrets;
    private ArrayList<V1ContainerBuilder> initContainers;
    private String nodeName;
    private Map<String, String> nodeSelector;
    private V1PodOSBuilder os;
    private Map<String, Quantity> overhead;
    private String preemptionPolicy;
    private Integer priority;
    private String priorityClassName;
    private ArrayList<V1PodReadinessGateBuilder> readinessGates;
    private ArrayList<V1PodResourceClaimBuilder> resourceClaims;
    private V1ResourceRequirementsBuilder resources;
    private String restartPolicy;
    private String runtimeClassName;
    private String schedulerName;
    private ArrayList<V1PodSchedulingGateBuilder> schedulingGates;
    private V1PodSecurityContextBuilder securityContext;
    private String serviceAccount;
    private String serviceAccountName;
    private Boolean setHostnameAsFQDN;
    private Boolean shareProcessNamespace;
    private String subdomain;
    private Long terminationGracePeriodSeconds;
    private ArrayList<V1TolerationBuilder> tolerations;
    private ArrayList<V1TopologySpreadConstraintBuilder> topologySpreadConstraints;
    private ArrayList<V1VolumeBuilder> volumes;

    public V1PodSpecFluent() {
    }

    public V1PodSpecFluent(V1PodSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1PodSpec instance) {
        V1PodSpec v1PodSpec = instance = instance != null ? instance : new V1PodSpec();
        if (instance != null) {
            this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
            this.withAffinity(instance.getAffinity());
            this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
            this.withContainers(instance.getContainers());
            this.withDnsConfig(instance.getDnsConfig());
            this.withDnsPolicy(instance.getDnsPolicy());
            this.withEnableServiceLinks(instance.getEnableServiceLinks());
            this.withEphemeralContainers(instance.getEphemeralContainers());
            this.withHostAliases(instance.getHostAliases());
            this.withHostIPC(instance.getHostIPC());
            this.withHostNetwork(instance.getHostNetwork());
            this.withHostPID(instance.getHostPID());
            this.withHostUsers(instance.getHostUsers());
            this.withHostname(instance.getHostname());
            this.withImagePullSecrets(instance.getImagePullSecrets());
            this.withInitContainers(instance.getInitContainers());
            this.withNodeName(instance.getNodeName());
            this.withNodeSelector(instance.getNodeSelector());
            this.withOs(instance.getOs());
            this.withOverhead(instance.getOverhead());
            this.withPreemptionPolicy(instance.getPreemptionPolicy());
            this.withPriority(instance.getPriority());
            this.withPriorityClassName(instance.getPriorityClassName());
            this.withReadinessGates(instance.getReadinessGates());
            this.withResourceClaims(instance.getResourceClaims());
            this.withResources(instance.getResources());
            this.withRestartPolicy(instance.getRestartPolicy());
            this.withRuntimeClassName(instance.getRuntimeClassName());
            this.withSchedulerName(instance.getSchedulerName());
            this.withSchedulingGates(instance.getSchedulingGates());
            this.withSecurityContext(instance.getSecurityContext());
            this.withServiceAccount(instance.getServiceAccount());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withSetHostnameAsFQDN(instance.getSetHostnameAsFQDN());
            this.withShareProcessNamespace(instance.getShareProcessNamespace());
            this.withSubdomain(instance.getSubdomain());
            this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
            this.withTolerations(instance.getTolerations());
            this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
            this.withVolumes(instance.getVolumes());
        }
    }

    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)this;
    }

    public boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    public V1Affinity buildAffinity() {
        return this.affinity != null ? this.affinity.build() : null;
    }

    public A withAffinity(V1Affinity affinity) {
        this._visitables.remove("affinity");
        if (affinity != null) {
            this.affinity = new V1AffinityBuilder(affinity);
            this._visitables.get("affinity").add(this.affinity);
        } else {
            this.affinity = null;
            this._visitables.get("affinity").remove(this.affinity);
        }
        return (A)this;
    }

    public boolean hasAffinity() {
        return this.affinity != null;
    }

    public AffinityNested<A> withNewAffinity() {
        return new AffinityNested(null);
    }

    public AffinityNested<A> withNewAffinityLike(V1Affinity item) {
        return new AffinityNested(item);
    }

    public AffinityNested<A> editAffinity() {
        return this.withNewAffinityLike(Optional.ofNullable(this.buildAffinity()).orElse(null));
    }

    public AffinityNested<A> editOrNewAffinity() {
        return this.withNewAffinityLike(Optional.ofNullable(this.buildAffinity()).orElse(new V1AffinityBuilder().build()));
    }

    public AffinityNested<A> editOrNewAffinityLike(V1Affinity item) {
        return this.withNewAffinityLike(Optional.ofNullable(this.buildAffinity()).orElse(item));
    }

    public Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return (A)this;
    }

    public boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    public A addToContainers(int index, V1Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        V1ContainerBuilder builder = new V1ContainerBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get("containers").add(index, builder);
            this.containers.add(index, builder);
        }
        return (A)this;
    }

    public A setToContainers(int index, V1Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        V1ContainerBuilder builder = new V1ContainerBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get("containers").set(index, builder);
            this.containers.set(index, builder);
        }
        return (A)this;
    }

    public A addToContainers(V1Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (V1Container item : items) {
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    public A addAllToContainers(Collection<V1Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (V1Container item : items) {
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    public A removeFromContainers(V1Container ... items) {
        if (this.containers == null) {
            return (A)this;
        }
        for (V1Container item : items) {
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            this._visitables.get("containers").remove(builder);
            this.containers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromContainers(Collection<V1Container> items) {
        if (this.containers == null) {
            return (A)this;
        }
        for (V1Container item : items) {
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            this._visitables.get("containers").remove(builder);
            this.containers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromContainers(Predicate<V1ContainerBuilder> predicate) {
        if (this.containers == null) {
            return (A)this;
        }
        Iterator<V1ContainerBuilder> each = this.containers.iterator();
        Object visitables = this._visitables.get("containers");
        while (each.hasNext()) {
            V1ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1Container> buildContainers() {
        return this.containers != null ? V1PodSpecFluent.build(this.containers) : null;
    }

    public V1Container buildContainer(int index) {
        return this.containers.get(index).build();
    }

    public V1Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    public V1Container buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    public V1Container buildMatchingContainer(Predicate<V1ContainerBuilder> predicate) {
        for (V1ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContainer(Predicate<V1ContainerBuilder> predicate) {
        for (V1ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContainers(List<V1Container> containers) {
        if (this.containers != null) {
            this._visitables.get("containers").clear();
        }
        if (containers != null) {
            this.containers = new ArrayList();
            for (V1Container item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)this;
    }

    public A withContainers(V1Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
            this._visitables.remove("containers");
        }
        if (containers != null) {
            for (V1Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    public boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    public ContainersNested<A> addNewContainer() {
        return new ContainersNested(-1, null);
    }

    public ContainersNested<A> addNewContainerLike(V1Container item) {
        return new ContainersNested(-1, item);
    }

    public ContainersNested<A> setNewContainerLike(int index, V1Container item) {
        return new ContainersNested(index, item);
    }

    public ContainersNested<A> editContainer(int index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    public ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editMatchingContainer(Predicate<V1ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.test(this.containers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public V1PodDNSConfig buildDnsConfig() {
        return this.dnsConfig != null ? this.dnsConfig.build() : null;
    }

    public A withDnsConfig(V1PodDNSConfig dnsConfig) {
        this._visitables.remove("dnsConfig");
        if (dnsConfig != null) {
            this.dnsConfig = new V1PodDNSConfigBuilder(dnsConfig);
            this._visitables.get("dnsConfig").add(this.dnsConfig);
        } else {
            this.dnsConfig = null;
            this._visitables.get("dnsConfig").remove(this.dnsConfig);
        }
        return (A)this;
    }

    public boolean hasDnsConfig() {
        return this.dnsConfig != null;
    }

    public DnsConfigNested<A> withNewDnsConfig() {
        return new DnsConfigNested(null);
    }

    public DnsConfigNested<A> withNewDnsConfigLike(V1PodDNSConfig item) {
        return new DnsConfigNested(item);
    }

    public DnsConfigNested<A> editDnsConfig() {
        return this.withNewDnsConfigLike(Optional.ofNullable(this.buildDnsConfig()).orElse(null));
    }

    public DnsConfigNested<A> editOrNewDnsConfig() {
        return this.withNewDnsConfigLike(Optional.ofNullable(this.buildDnsConfig()).orElse(new V1PodDNSConfigBuilder().build()));
    }

    public DnsConfigNested<A> editOrNewDnsConfigLike(V1PodDNSConfig item) {
        return this.withNewDnsConfigLike(Optional.ofNullable(this.buildDnsConfig()).orElse(item));
    }

    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    public A withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (A)this;
    }

    public boolean hasDnsPolicy() {
        return this.dnsPolicy != null;
    }

    public Boolean getEnableServiceLinks() {
        return this.enableServiceLinks;
    }

    public A withEnableServiceLinks(Boolean enableServiceLinks) {
        this.enableServiceLinks = enableServiceLinks;
        return (A)this;
    }

    public boolean hasEnableServiceLinks() {
        return this.enableServiceLinks != null;
    }

    public A addToEphemeralContainers(int index, V1EphemeralContainer item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList();
        }
        V1EphemeralContainerBuilder builder = new V1EphemeralContainerBuilder(item);
        if (index < 0 || index >= this.ephemeralContainers.size()) {
            this._visitables.get("ephemeralContainers").add(builder);
            this.ephemeralContainers.add(builder);
        } else {
            this._visitables.get("ephemeralContainers").add(index, builder);
            this.ephemeralContainers.add(index, builder);
        }
        return (A)this;
    }

    public A setToEphemeralContainers(int index, V1EphemeralContainer item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList();
        }
        V1EphemeralContainerBuilder builder = new V1EphemeralContainerBuilder(item);
        if (index < 0 || index >= this.ephemeralContainers.size()) {
            this._visitables.get("ephemeralContainers").add(builder);
            this.ephemeralContainers.add(builder);
        } else {
            this._visitables.get("ephemeralContainers").set(index, builder);
            this.ephemeralContainers.set(index, builder);
        }
        return (A)this;
    }

    public A addToEphemeralContainers(V1EphemeralContainer ... items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList();
        }
        for (V1EphemeralContainer item : items) {
            V1EphemeralContainerBuilder builder = new V1EphemeralContainerBuilder(item);
            this._visitables.get("ephemeralContainers").add(builder);
            this.ephemeralContainers.add(builder);
        }
        return (A)this;
    }

    public A addAllToEphemeralContainers(Collection<V1EphemeralContainer> items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList();
        }
        for (V1EphemeralContainer item : items) {
            V1EphemeralContainerBuilder builder = new V1EphemeralContainerBuilder(item);
            this._visitables.get("ephemeralContainers").add(builder);
            this.ephemeralContainers.add(builder);
        }
        return (A)this;
    }

    public A removeFromEphemeralContainers(V1EphemeralContainer ... items) {
        if (this.ephemeralContainers == null) {
            return (A)this;
        }
        for (V1EphemeralContainer item : items) {
            V1EphemeralContainerBuilder builder = new V1EphemeralContainerBuilder(item);
            this._visitables.get("ephemeralContainers").remove(builder);
            this.ephemeralContainers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromEphemeralContainers(Collection<V1EphemeralContainer> items) {
        if (this.ephemeralContainers == null) {
            return (A)this;
        }
        for (V1EphemeralContainer item : items) {
            V1EphemeralContainerBuilder builder = new V1EphemeralContainerBuilder(item);
            this._visitables.get("ephemeralContainers").remove(builder);
            this.ephemeralContainers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromEphemeralContainers(Predicate<V1EphemeralContainerBuilder> predicate) {
        if (this.ephemeralContainers == null) {
            return (A)this;
        }
        Iterator<V1EphemeralContainerBuilder> each = this.ephemeralContainers.iterator();
        Object visitables = this._visitables.get("ephemeralContainers");
        while (each.hasNext()) {
            V1EphemeralContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1EphemeralContainer> buildEphemeralContainers() {
        return this.ephemeralContainers != null ? V1PodSpecFluent.build(this.ephemeralContainers) : null;
    }

    public V1EphemeralContainer buildEphemeralContainer(int index) {
        return this.ephemeralContainers.get(index).build();
    }

    public V1EphemeralContainer buildFirstEphemeralContainer() {
        return this.ephemeralContainers.get(0).build();
    }

    public V1EphemeralContainer buildLastEphemeralContainer() {
        return this.ephemeralContainers.get(this.ephemeralContainers.size() - 1).build();
    }

    public V1EphemeralContainer buildMatchingEphemeralContainer(Predicate<V1EphemeralContainerBuilder> predicate) {
        for (V1EphemeralContainerBuilder item : this.ephemeralContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEphemeralContainer(Predicate<V1EphemeralContainerBuilder> predicate) {
        for (V1EphemeralContainerBuilder item : this.ephemeralContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEphemeralContainers(List<V1EphemeralContainer> ephemeralContainers) {
        if (this.ephemeralContainers != null) {
            this._visitables.get("ephemeralContainers").clear();
        }
        if (ephemeralContainers != null) {
            this.ephemeralContainers = new ArrayList();
            for (V1EphemeralContainer item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        } else {
            this.ephemeralContainers = null;
        }
        return (A)this;
    }

    public A withEphemeralContainers(V1EphemeralContainer ... ephemeralContainers) {
        if (this.ephemeralContainers != null) {
            this.ephemeralContainers.clear();
            this._visitables.remove("ephemeralContainers");
        }
        if (ephemeralContainers != null) {
            for (V1EphemeralContainer item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        }
        return (A)this;
    }

    public boolean hasEphemeralContainers() {
        return this.ephemeralContainers != null && !this.ephemeralContainers.isEmpty();
    }

    public EphemeralContainersNested<A> addNewEphemeralContainer() {
        return new EphemeralContainersNested(-1, null);
    }

    public EphemeralContainersNested<A> addNewEphemeralContainerLike(V1EphemeralContainer item) {
        return new EphemeralContainersNested(-1, item);
    }

    public EphemeralContainersNested<A> setNewEphemeralContainerLike(int index, V1EphemeralContainer item) {
        return new EphemeralContainersNested(index, item);
    }

    public EphemeralContainersNested<A> editEphemeralContainer(int index) {
        if (this.ephemeralContainers.size() <= index) {
            throw new RuntimeException("Can't edit ephemeralContainers. Index exceeds size.");
        }
        return this.setNewEphemeralContainerLike(index, this.buildEphemeralContainer(index));
    }

    public EphemeralContainersNested<A> editFirstEphemeralContainer() {
        if (this.ephemeralContainers.size() == 0) {
            throw new RuntimeException("Can't edit first ephemeralContainers. The list is empty.");
        }
        return this.setNewEphemeralContainerLike(0, this.buildEphemeralContainer(0));
    }

    public EphemeralContainersNested<A> editLastEphemeralContainer() {
        int index = this.ephemeralContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ephemeralContainers. The list is empty.");
        }
        return this.setNewEphemeralContainerLike(index, this.buildEphemeralContainer(index));
    }

    public EphemeralContainersNested<A> editMatchingEphemeralContainer(Predicate<V1EphemeralContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ephemeralContainers.size(); ++i) {
            if (!predicate.test(this.ephemeralContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ephemeralContainers. No match found.");
        }
        return this.setNewEphemeralContainerLike(index, this.buildEphemeralContainer(index));
    }

    public A addToHostAliases(int index, V1HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        V1HostAliasBuilder builder = new V1HostAliasBuilder(item);
        if (index < 0 || index >= this.hostAliases.size()) {
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        } else {
            this._visitables.get("hostAliases").add(index, builder);
            this.hostAliases.add(index, builder);
        }
        return (A)this;
    }

    public A setToHostAliases(int index, V1HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        V1HostAliasBuilder builder = new V1HostAliasBuilder(item);
        if (index < 0 || index >= this.hostAliases.size()) {
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        } else {
            this._visitables.get("hostAliases").set(index, builder);
            this.hostAliases.set(index, builder);
        }
        return (A)this;
    }

    public A addToHostAliases(V1HostAlias ... items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        for (V1HostAlias item : items) {
            V1HostAliasBuilder builder = new V1HostAliasBuilder(item);
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        }
        return (A)this;
    }

    public A addAllToHostAliases(Collection<V1HostAlias> items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        for (V1HostAlias item : items) {
            V1HostAliasBuilder builder = new V1HostAliasBuilder(item);
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        }
        return (A)this;
    }

    public A removeFromHostAliases(V1HostAlias ... items) {
        if (this.hostAliases == null) {
            return (A)this;
        }
        for (V1HostAlias item : items) {
            V1HostAliasBuilder builder = new V1HostAliasBuilder(item);
            this._visitables.get("hostAliases").remove(builder);
            this.hostAliases.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromHostAliases(Collection<V1HostAlias> items) {
        if (this.hostAliases == null) {
            return (A)this;
        }
        for (V1HostAlias item : items) {
            V1HostAliasBuilder builder = new V1HostAliasBuilder(item);
            this._visitables.get("hostAliases").remove(builder);
            this.hostAliases.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromHostAliases(Predicate<V1HostAliasBuilder> predicate) {
        if (this.hostAliases == null) {
            return (A)this;
        }
        Iterator<V1HostAliasBuilder> each = this.hostAliases.iterator();
        Object visitables = this._visitables.get("hostAliases");
        while (each.hasNext()) {
            V1HostAliasBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1HostAlias> buildHostAliases() {
        return this.hostAliases != null ? V1PodSpecFluent.build(this.hostAliases) : null;
    }

    public V1HostAlias buildHostAlias(int index) {
        return this.hostAliases.get(index).build();
    }

    public V1HostAlias buildFirstHostAlias() {
        return this.hostAliases.get(0).build();
    }

    public V1HostAlias buildLastHostAlias() {
        return this.hostAliases.get(this.hostAliases.size() - 1).build();
    }

    public V1HostAlias buildMatchingHostAlias(Predicate<V1HostAliasBuilder> predicate) {
        for (V1HostAliasBuilder item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHostAlias(Predicate<V1HostAliasBuilder> predicate) {
        for (V1HostAliasBuilder item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHostAliases(List<V1HostAlias> hostAliases) {
        if (this.hostAliases != null) {
            this._visitables.get("hostAliases").clear();
        }
        if (hostAliases != null) {
            this.hostAliases = new ArrayList();
            for (V1HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        } else {
            this.hostAliases = null;
        }
        return (A)this;
    }

    public A withHostAliases(V1HostAlias ... hostAliases) {
        if (this.hostAliases != null) {
            this.hostAliases.clear();
            this._visitables.remove("hostAliases");
        }
        if (hostAliases != null) {
            for (V1HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        }
        return (A)this;
    }

    public boolean hasHostAliases() {
        return this.hostAliases != null && !this.hostAliases.isEmpty();
    }

    public HostAliasesNested<A> addNewHostAlias() {
        return new HostAliasesNested(-1, null);
    }

    public HostAliasesNested<A> addNewHostAliasLike(V1HostAlias item) {
        return new HostAliasesNested(-1, item);
    }

    public HostAliasesNested<A> setNewHostAliasLike(int index, V1HostAlias item) {
        return new HostAliasesNested(index, item);
    }

    public HostAliasesNested<A> editHostAlias(int index) {
        if (this.hostAliases.size() <= index) {
            throw new RuntimeException("Can't edit hostAliases. Index exceeds size.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    public HostAliasesNested<A> editFirstHostAlias() {
        if (this.hostAliases.size() == 0) {
            throw new RuntimeException("Can't edit first hostAliases. The list is empty.");
        }
        return this.setNewHostAliasLike(0, this.buildHostAlias(0));
    }

    public HostAliasesNested<A> editLastHostAlias() {
        int index = this.hostAliases.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hostAliases. The list is empty.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    public HostAliasesNested<A> editMatchingHostAlias(Predicate<V1HostAliasBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hostAliases.size(); ++i) {
            if (!predicate.test(this.hostAliases.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hostAliases. No match found.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    public Boolean getHostIPC() {
        return this.hostIPC;
    }

    public A withHostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
        return (A)this;
    }

    public boolean hasHostIPC() {
        return this.hostIPC != null;
    }

    public Boolean getHostNetwork() {
        return this.hostNetwork;
    }

    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (A)this;
    }

    public boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    public Boolean getHostPID() {
        return this.hostPID;
    }

    public A withHostPID(Boolean hostPID) {
        this.hostPID = hostPID;
        return (A)this;
    }

    public boolean hasHostPID() {
        return this.hostPID != null;
    }

    public Boolean getHostUsers() {
        return this.hostUsers;
    }

    public A withHostUsers(Boolean hostUsers) {
        this.hostUsers = hostUsers;
        return (A)this;
    }

    public boolean hasHostUsers() {
        return this.hostUsers != null;
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    public boolean hasHostname() {
        return this.hostname != null;
    }

    public A addToImagePullSecrets(int index, V1LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get("imagePullSecrets").add(index, builder);
            this.imagePullSecrets.add(index, builder);
        }
        return (A)this;
    }

    public A setToImagePullSecrets(int index, V1LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get("imagePullSecrets").set(index, builder);
            this.imagePullSecrets.set(index, builder);
        }
        return (A)this;
    }

    public A addToImagePullSecrets(V1LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (V1LocalObjectReference item : items) {
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    public A addAllToImagePullSecrets(Collection<V1LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (V1LocalObjectReference item : items) {
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    public A removeFromImagePullSecrets(V1LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        for (V1LocalObjectReference item : items) {
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromImagePullSecrets(Collection<V1LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        for (V1LocalObjectReference item : items) {
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromImagePullSecrets(Predicate<V1LocalObjectReferenceBuilder> predicate) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        Iterator<V1LocalObjectReferenceBuilder> each = this.imagePullSecrets.iterator();
        Object visitables = this._visitables.get("imagePullSecrets");
        while (each.hasNext()) {
            V1LocalObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1LocalObjectReference> buildImagePullSecrets() {
        return this.imagePullSecrets != null ? V1PodSpecFluent.build(this.imagePullSecrets) : null;
    }

    public V1LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    public V1LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    public V1LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1).build();
    }

    public V1LocalObjectReference buildMatchingImagePullSecret(Predicate<V1LocalObjectReferenceBuilder> predicate) {
        for (V1LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingImagePullSecret(Predicate<V1LocalObjectReferenceBuilder> predicate) {
        for (V1LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withImagePullSecrets(List<V1LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this._visitables.get("imagePullSecrets").clear();
        }
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList();
            for (V1LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = null;
        }
        return (A)this;
    }

    public A withImagePullSecrets(V1LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
            this._visitables.remove("imagePullSecrets");
        }
        if (imagePullSecrets != null) {
            for (V1LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    public boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    public ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNested(-1, null);
    }

    public ImagePullSecretsNested<A> addNewImagePullSecretLike(V1LocalObjectReference item) {
        return new ImagePullSecretsNested(-1, item);
    }

    public ImagePullSecretsNested<A> setNewImagePullSecretLike(int index, V1LocalObjectReference item) {
        return new ImagePullSecretsNested(index, item);
    }

    public ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (this.imagePullSecrets.size() <= index) {
            throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (this.imagePullSecrets.size() == 0) {
            throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(0, this.buildImagePullSecret(0));
    }

    public ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = this.imagePullSecrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<V1LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imagePullSecrets.size(); ++i) {
            if (!predicate.test(this.imagePullSecrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public A addToInitContainers(int index, V1Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        V1ContainerBuilder builder = new V1ContainerBuilder(item);
        if (index < 0 || index >= this.initContainers.size()) {
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        } else {
            this._visitables.get("initContainers").add(index, builder);
            this.initContainers.add(index, builder);
        }
        return (A)this;
    }

    public A setToInitContainers(int index, V1Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        V1ContainerBuilder builder = new V1ContainerBuilder(item);
        if (index < 0 || index >= this.initContainers.size()) {
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        } else {
            this._visitables.get("initContainers").set(index, builder);
            this.initContainers.set(index, builder);
        }
        return (A)this;
    }

    public A addToInitContainers(V1Container ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (V1Container item : items) {
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    public A addAllToInitContainers(Collection<V1Container> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (V1Container item : items) {
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    public A removeFromInitContainers(V1Container ... items) {
        if (this.initContainers == null) {
            return (A)this;
        }
        for (V1Container item : items) {
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            this._visitables.get("initContainers").remove(builder);
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromInitContainers(Collection<V1Container> items) {
        if (this.initContainers == null) {
            return (A)this;
        }
        for (V1Container item : items) {
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            this._visitables.get("initContainers").remove(builder);
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromInitContainers(Predicate<V1ContainerBuilder> predicate) {
        if (this.initContainers == null) {
            return (A)this;
        }
        Iterator<V1ContainerBuilder> each = this.initContainers.iterator();
        Object visitables = this._visitables.get("initContainers");
        while (each.hasNext()) {
            V1ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1Container> buildInitContainers() {
        return this.initContainers != null ? V1PodSpecFluent.build(this.initContainers) : null;
    }

    public V1Container buildInitContainer(int index) {
        return this.initContainers.get(index).build();
    }

    public V1Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    public V1Container buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    public V1Container buildMatchingInitContainer(Predicate<V1ContainerBuilder> predicate) {
        for (V1ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInitContainer(Predicate<V1ContainerBuilder> predicate) {
        for (V1ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInitContainers(List<V1Container> initContainers) {
        if (this.initContainers != null) {
            this._visitables.get("initContainers").clear();
        }
        if (initContainers != null) {
            this.initContainers = new ArrayList();
            for (V1Container item : initContainers) {
                this.addToInitContainers(item);
            }
        } else {
            this.initContainers = null;
        }
        return (A)this;
    }

    public A withInitContainers(V1Container ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
            this._visitables.remove("initContainers");
        }
        if (initContainers != null) {
            for (V1Container item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)this;
    }

    public boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    public InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNested(-1, null);
    }

    public InitContainersNested<A> addNewInitContainerLike(V1Container item) {
        return new InitContainersNested(-1, item);
    }

    public InitContainersNested<A> setNewInitContainerLike(int index, V1Container item) {
        return new InitContainersNested(index, item);
    }

    public InitContainersNested<A> editInitContainer(int index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    public InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public InitContainersNested<A> editMatchingInitContainer(Predicate<V1ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.test(this.initContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public V1PodOS buildOs() {
        return this.os != null ? this.os.build() : null;
    }

    public A withOs(V1PodOS os) {
        this._visitables.remove("os");
        if (os != null) {
            this.os = new V1PodOSBuilder(os);
            this._visitables.get("os").add(this.os);
        } else {
            this.os = null;
            this._visitables.get("os").remove(this.os);
        }
        return (A)this;
    }

    public boolean hasOs() {
        return this.os != null;
    }

    public OsNested<A> withNewOs() {
        return new OsNested(null);
    }

    public OsNested<A> withNewOsLike(V1PodOS item) {
        return new OsNested(item);
    }

    public OsNested<A> editOs() {
        return this.withNewOsLike(Optional.ofNullable(this.buildOs()).orElse(null));
    }

    public OsNested<A> editOrNewOs() {
        return this.withNewOsLike(Optional.ofNullable(this.buildOs()).orElse(new V1PodOSBuilder().build()));
    }

    public OsNested<A> editOrNewOsLike(V1PodOS item) {
        return this.withNewOsLike(Optional.ofNullable(this.buildOs()).orElse(item));
    }

    public A addToOverhead(String key, Quantity value) {
        if (this.overhead == null && key != null && value != null) {
            this.overhead = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.overhead.put(key, value);
        }
        return (A)this;
    }

    public A addToOverhead(Map<String, Quantity> map) {
        if (this.overhead == null && map != null) {
            this.overhead = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.overhead.putAll(map);
        }
        return (A)this;
    }

    public A removeFromOverhead(String key) {
        if (this.overhead == null) {
            return (A)this;
        }
        if (key != null && this.overhead != null) {
            this.overhead.remove(key);
        }
        return (A)this;
    }

    public A removeFromOverhead(Map<String, Quantity> map) {
        if (this.overhead == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.overhead == null) continue;
                this.overhead.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Quantity> getOverhead() {
        return this.overhead;
    }

    public <K, V> A withOverhead(Map<String, Quantity> overhead) {
        this.overhead = overhead == null ? null : new LinkedHashMap<String, Quantity>(overhead);
        return (A)this;
    }

    public boolean hasOverhead() {
        return this.overhead != null;
    }

    public String getPreemptionPolicy() {
        return this.preemptionPolicy;
    }

    public A withPreemptionPolicy(String preemptionPolicy) {
        this.preemptionPolicy = preemptionPolicy;
        return (A)this;
    }

    public boolean hasPreemptionPolicy() {
        return this.preemptionPolicy != null;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public A withPriority(Integer priority) {
        this.priority = priority;
        return (A)this;
    }

    public boolean hasPriority() {
        return this.priority != null;
    }

    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)this;
    }

    public boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    public A addToReadinessGates(int index, V1PodReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList();
        }
        V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);
        if (index < 0 || index >= this.readinessGates.size()) {
            this._visitables.get("readinessGates").add(builder);
            this.readinessGates.add(builder);
        } else {
            this._visitables.get("readinessGates").add(index, builder);
            this.readinessGates.add(index, builder);
        }
        return (A)this;
    }

    public A setToReadinessGates(int index, V1PodReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList();
        }
        V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);
        if (index < 0 || index >= this.readinessGates.size()) {
            this._visitables.get("readinessGates").add(builder);
            this.readinessGates.add(builder);
        } else {
            this._visitables.get("readinessGates").set(index, builder);
            this.readinessGates.set(index, builder);
        }
        return (A)this;
    }

    public A addToReadinessGates(V1PodReadinessGate ... items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList();
        }
        for (V1PodReadinessGate item : items) {
            V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").add(builder);
            this.readinessGates.add(builder);
        }
        return (A)this;
    }

    public A addAllToReadinessGates(Collection<V1PodReadinessGate> items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList();
        }
        for (V1PodReadinessGate item : items) {
            V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").add(builder);
            this.readinessGates.add(builder);
        }
        return (A)this;
    }

    public A removeFromReadinessGates(V1PodReadinessGate ... items) {
        if (this.readinessGates == null) {
            return (A)this;
        }
        for (V1PodReadinessGate item : items) {
            V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").remove(builder);
            this.readinessGates.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromReadinessGates(Collection<V1PodReadinessGate> items) {
        if (this.readinessGates == null) {
            return (A)this;
        }
        for (V1PodReadinessGate item : items) {
            V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").remove(builder);
            this.readinessGates.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromReadinessGates(Predicate<V1PodReadinessGateBuilder> predicate) {
        if (this.readinessGates == null) {
            return (A)this;
        }
        Iterator<V1PodReadinessGateBuilder> each = this.readinessGates.iterator();
        Object visitables = this._visitables.get("readinessGates");
        while (each.hasNext()) {
            V1PodReadinessGateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1PodReadinessGate> buildReadinessGates() {
        return this.readinessGates != null ? V1PodSpecFluent.build(this.readinessGates) : null;
    }

    public V1PodReadinessGate buildReadinessGate(int index) {
        return this.readinessGates.get(index).build();
    }

    public V1PodReadinessGate buildFirstReadinessGate() {
        return this.readinessGates.get(0).build();
    }

    public V1PodReadinessGate buildLastReadinessGate() {
        return this.readinessGates.get(this.readinessGates.size() - 1).build();
    }

    public V1PodReadinessGate buildMatchingReadinessGate(Predicate<V1PodReadinessGateBuilder> predicate) {
        for (V1PodReadinessGateBuilder item : this.readinessGates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingReadinessGate(Predicate<V1PodReadinessGateBuilder> predicate) {
        for (V1PodReadinessGateBuilder item : this.readinessGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withReadinessGates(List<V1PodReadinessGate> readinessGates) {
        if (this.readinessGates != null) {
            this._visitables.get("readinessGates").clear();
        }
        if (readinessGates != null) {
            this.readinessGates = new ArrayList();
            for (V1PodReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        } else {
            this.readinessGates = null;
        }
        return (A)this;
    }

    public A withReadinessGates(V1PodReadinessGate ... readinessGates) {
        if (this.readinessGates != null) {
            this.readinessGates.clear();
            this._visitables.remove("readinessGates");
        }
        if (readinessGates != null) {
            for (V1PodReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        }
        return (A)this;
    }

    public boolean hasReadinessGates() {
        return this.readinessGates != null && !this.readinessGates.isEmpty();
    }

    public ReadinessGatesNested<A> addNewReadinessGate() {
        return new ReadinessGatesNested(-1, null);
    }

    public ReadinessGatesNested<A> addNewReadinessGateLike(V1PodReadinessGate item) {
        return new ReadinessGatesNested(-1, item);
    }

    public ReadinessGatesNested<A> setNewReadinessGateLike(int index, V1PodReadinessGate item) {
        return new ReadinessGatesNested(index, item);
    }

    public ReadinessGatesNested<A> editReadinessGate(int index) {
        if (this.readinessGates.size() <= index) {
            throw new RuntimeException("Can't edit readinessGates. Index exceeds size.");
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    public ReadinessGatesNested<A> editFirstReadinessGate() {
        if (this.readinessGates.size() == 0) {
            throw new RuntimeException("Can't edit first readinessGates. The list is empty.");
        }
        return this.setNewReadinessGateLike(0, this.buildReadinessGate(0));
    }

    public ReadinessGatesNested<A> editLastReadinessGate() {
        int index = this.readinessGates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last readinessGates. The list is empty.");
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    public ReadinessGatesNested<A> editMatchingReadinessGate(Predicate<V1PodReadinessGateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.readinessGates.size(); ++i) {
            if (!predicate.test(this.readinessGates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching readinessGates. No match found.");
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    public A addToResourceClaims(int index, V1PodResourceClaim item) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList();
        }
        V1PodResourceClaimBuilder builder = new V1PodResourceClaimBuilder(item);
        if (index < 0 || index >= this.resourceClaims.size()) {
            this._visitables.get("resourceClaims").add(builder);
            this.resourceClaims.add(builder);
        } else {
            this._visitables.get("resourceClaims").add(index, builder);
            this.resourceClaims.add(index, builder);
        }
        return (A)this;
    }

    public A setToResourceClaims(int index, V1PodResourceClaim item) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList();
        }
        V1PodResourceClaimBuilder builder = new V1PodResourceClaimBuilder(item);
        if (index < 0 || index >= this.resourceClaims.size()) {
            this._visitables.get("resourceClaims").add(builder);
            this.resourceClaims.add(builder);
        } else {
            this._visitables.get("resourceClaims").set(index, builder);
            this.resourceClaims.set(index, builder);
        }
        return (A)this;
    }

    public A addToResourceClaims(V1PodResourceClaim ... items) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList();
        }
        for (V1PodResourceClaim item : items) {
            V1PodResourceClaimBuilder builder = new V1PodResourceClaimBuilder(item);
            this._visitables.get("resourceClaims").add(builder);
            this.resourceClaims.add(builder);
        }
        return (A)this;
    }

    public A addAllToResourceClaims(Collection<V1PodResourceClaim> items) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList();
        }
        for (V1PodResourceClaim item : items) {
            V1PodResourceClaimBuilder builder = new V1PodResourceClaimBuilder(item);
            this._visitables.get("resourceClaims").add(builder);
            this.resourceClaims.add(builder);
        }
        return (A)this;
    }

    public A removeFromResourceClaims(V1PodResourceClaim ... items) {
        if (this.resourceClaims == null) {
            return (A)this;
        }
        for (V1PodResourceClaim item : items) {
            V1PodResourceClaimBuilder builder = new V1PodResourceClaimBuilder(item);
            this._visitables.get("resourceClaims").remove(builder);
            this.resourceClaims.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResourceClaims(Collection<V1PodResourceClaim> items) {
        if (this.resourceClaims == null) {
            return (A)this;
        }
        for (V1PodResourceClaim item : items) {
            V1PodResourceClaimBuilder builder = new V1PodResourceClaimBuilder(item);
            this._visitables.get("resourceClaims").remove(builder);
            this.resourceClaims.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResourceClaims(Predicate<V1PodResourceClaimBuilder> predicate) {
        if (this.resourceClaims == null) {
            return (A)this;
        }
        Iterator<V1PodResourceClaimBuilder> each = this.resourceClaims.iterator();
        Object visitables = this._visitables.get("resourceClaims");
        while (each.hasNext()) {
            V1PodResourceClaimBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1PodResourceClaim> buildResourceClaims() {
        return this.resourceClaims != null ? V1PodSpecFluent.build(this.resourceClaims) : null;
    }

    public V1PodResourceClaim buildResourceClaim(int index) {
        return this.resourceClaims.get(index).build();
    }

    public V1PodResourceClaim buildFirstResourceClaim() {
        return this.resourceClaims.get(0).build();
    }

    public V1PodResourceClaim buildLastResourceClaim() {
        return this.resourceClaims.get(this.resourceClaims.size() - 1).build();
    }

    public V1PodResourceClaim buildMatchingResourceClaim(Predicate<V1PodResourceClaimBuilder> predicate) {
        for (V1PodResourceClaimBuilder item : this.resourceClaims) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceClaim(Predicate<V1PodResourceClaimBuilder> predicate) {
        for (V1PodResourceClaimBuilder item : this.resourceClaims) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceClaims(List<V1PodResourceClaim> resourceClaims) {
        if (this.resourceClaims != null) {
            this._visitables.get("resourceClaims").clear();
        }
        if (resourceClaims != null) {
            this.resourceClaims = new ArrayList();
            for (V1PodResourceClaim item : resourceClaims) {
                this.addToResourceClaims(item);
            }
        } else {
            this.resourceClaims = null;
        }
        return (A)this;
    }

    public A withResourceClaims(V1PodResourceClaim ... resourceClaims) {
        if (this.resourceClaims != null) {
            this.resourceClaims.clear();
            this._visitables.remove("resourceClaims");
        }
        if (resourceClaims != null) {
            for (V1PodResourceClaim item : resourceClaims) {
                this.addToResourceClaims(item);
            }
        }
        return (A)this;
    }

    public boolean hasResourceClaims() {
        return this.resourceClaims != null && !this.resourceClaims.isEmpty();
    }

    public ResourceClaimsNested<A> addNewResourceClaim() {
        return new ResourceClaimsNested(-1, null);
    }

    public ResourceClaimsNested<A> addNewResourceClaimLike(V1PodResourceClaim item) {
        return new ResourceClaimsNested(-1, item);
    }

    public ResourceClaimsNested<A> setNewResourceClaimLike(int index, V1PodResourceClaim item) {
        return new ResourceClaimsNested(index, item);
    }

    public ResourceClaimsNested<A> editResourceClaim(int index) {
        if (this.resourceClaims.size() <= index) {
            throw new RuntimeException("Can't edit resourceClaims. Index exceeds size.");
        }
        return this.setNewResourceClaimLike(index, this.buildResourceClaim(index));
    }

    public ResourceClaimsNested<A> editFirstResourceClaim() {
        if (this.resourceClaims.size() == 0) {
            throw new RuntimeException("Can't edit first resourceClaims. The list is empty.");
        }
        return this.setNewResourceClaimLike(0, this.buildResourceClaim(0));
    }

    public ResourceClaimsNested<A> editLastResourceClaim() {
        int index = this.resourceClaims.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceClaims. The list is empty.");
        }
        return this.setNewResourceClaimLike(index, this.buildResourceClaim(index));
    }

    public ResourceClaimsNested<A> editMatchingResourceClaim(Predicate<V1PodResourceClaimBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceClaims.size(); ++i) {
            if (!predicate.test(this.resourceClaims.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceClaims. No match found.");
        }
        return this.setNewResourceClaimLike(index, this.buildResourceClaim(index));
    }

    public V1ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(V1ResourceRequirements resources) {
        this._visitables.remove("resources");
        if (resources != null) {
            this.resources = new V1ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get("resources").remove(this.resources);
        }
        return (A)this;
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(V1ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new V1ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(V1ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)this;
    }

    public boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    public A withRuntimeClassName(String runtimeClassName) {
        this.runtimeClassName = runtimeClassName;
        return (A)this;
    }

    public boolean hasRuntimeClassName() {
        return this.runtimeClassName != null;
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public A withSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
        return (A)this;
    }

    public boolean hasSchedulerName() {
        return this.schedulerName != null;
    }

    public A addToSchedulingGates(int index, V1PodSchedulingGate item) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList();
        }
        V1PodSchedulingGateBuilder builder = new V1PodSchedulingGateBuilder(item);
        if (index < 0 || index >= this.schedulingGates.size()) {
            this._visitables.get("schedulingGates").add(builder);
            this.schedulingGates.add(builder);
        } else {
            this._visitables.get("schedulingGates").add(index, builder);
            this.schedulingGates.add(index, builder);
        }
        return (A)this;
    }

    public A setToSchedulingGates(int index, V1PodSchedulingGate item) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList();
        }
        V1PodSchedulingGateBuilder builder = new V1PodSchedulingGateBuilder(item);
        if (index < 0 || index >= this.schedulingGates.size()) {
            this._visitables.get("schedulingGates").add(builder);
            this.schedulingGates.add(builder);
        } else {
            this._visitables.get("schedulingGates").set(index, builder);
            this.schedulingGates.set(index, builder);
        }
        return (A)this;
    }

    public A addToSchedulingGates(V1PodSchedulingGate ... items) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList();
        }
        for (V1PodSchedulingGate item : items) {
            V1PodSchedulingGateBuilder builder = new V1PodSchedulingGateBuilder(item);
            this._visitables.get("schedulingGates").add(builder);
            this.schedulingGates.add(builder);
        }
        return (A)this;
    }

    public A addAllToSchedulingGates(Collection<V1PodSchedulingGate> items) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList();
        }
        for (V1PodSchedulingGate item : items) {
            V1PodSchedulingGateBuilder builder = new V1PodSchedulingGateBuilder(item);
            this._visitables.get("schedulingGates").add(builder);
            this.schedulingGates.add(builder);
        }
        return (A)this;
    }

    public A removeFromSchedulingGates(V1PodSchedulingGate ... items) {
        if (this.schedulingGates == null) {
            return (A)this;
        }
        for (V1PodSchedulingGate item : items) {
            V1PodSchedulingGateBuilder builder = new V1PodSchedulingGateBuilder(item);
            this._visitables.get("schedulingGates").remove(builder);
            this.schedulingGates.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSchedulingGates(Collection<V1PodSchedulingGate> items) {
        if (this.schedulingGates == null) {
            return (A)this;
        }
        for (V1PodSchedulingGate item : items) {
            V1PodSchedulingGateBuilder builder = new V1PodSchedulingGateBuilder(item);
            this._visitables.get("schedulingGates").remove(builder);
            this.schedulingGates.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSchedulingGates(Predicate<V1PodSchedulingGateBuilder> predicate) {
        if (this.schedulingGates == null) {
            return (A)this;
        }
        Iterator<V1PodSchedulingGateBuilder> each = this.schedulingGates.iterator();
        Object visitables = this._visitables.get("schedulingGates");
        while (each.hasNext()) {
            V1PodSchedulingGateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1PodSchedulingGate> buildSchedulingGates() {
        return this.schedulingGates != null ? V1PodSpecFluent.build(this.schedulingGates) : null;
    }

    public V1PodSchedulingGate buildSchedulingGate(int index) {
        return this.schedulingGates.get(index).build();
    }

    public V1PodSchedulingGate buildFirstSchedulingGate() {
        return this.schedulingGates.get(0).build();
    }

    public V1PodSchedulingGate buildLastSchedulingGate() {
        return this.schedulingGates.get(this.schedulingGates.size() - 1).build();
    }

    public V1PodSchedulingGate buildMatchingSchedulingGate(Predicate<V1PodSchedulingGateBuilder> predicate) {
        for (V1PodSchedulingGateBuilder item : this.schedulingGates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSchedulingGate(Predicate<V1PodSchedulingGateBuilder> predicate) {
        for (V1PodSchedulingGateBuilder item : this.schedulingGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSchedulingGates(List<V1PodSchedulingGate> schedulingGates) {
        if (this.schedulingGates != null) {
            this._visitables.get("schedulingGates").clear();
        }
        if (schedulingGates != null) {
            this.schedulingGates = new ArrayList();
            for (V1PodSchedulingGate item : schedulingGates) {
                this.addToSchedulingGates(item);
            }
        } else {
            this.schedulingGates = null;
        }
        return (A)this;
    }

    public A withSchedulingGates(V1PodSchedulingGate ... schedulingGates) {
        if (this.schedulingGates != null) {
            this.schedulingGates.clear();
            this._visitables.remove("schedulingGates");
        }
        if (schedulingGates != null) {
            for (V1PodSchedulingGate item : schedulingGates) {
                this.addToSchedulingGates(item);
            }
        }
        return (A)this;
    }

    public boolean hasSchedulingGates() {
        return this.schedulingGates != null && !this.schedulingGates.isEmpty();
    }

    public SchedulingGatesNested<A> addNewSchedulingGate() {
        return new SchedulingGatesNested(-1, null);
    }

    public SchedulingGatesNested<A> addNewSchedulingGateLike(V1PodSchedulingGate item) {
        return new SchedulingGatesNested(-1, item);
    }

    public SchedulingGatesNested<A> setNewSchedulingGateLike(int index, V1PodSchedulingGate item) {
        return new SchedulingGatesNested(index, item);
    }

    public SchedulingGatesNested<A> editSchedulingGate(int index) {
        if (this.schedulingGates.size() <= index) {
            throw new RuntimeException("Can't edit schedulingGates. Index exceeds size.");
        }
        return this.setNewSchedulingGateLike(index, this.buildSchedulingGate(index));
    }

    public SchedulingGatesNested<A> editFirstSchedulingGate() {
        if (this.schedulingGates.size() == 0) {
            throw new RuntimeException("Can't edit first schedulingGates. The list is empty.");
        }
        return this.setNewSchedulingGateLike(0, this.buildSchedulingGate(0));
    }

    public SchedulingGatesNested<A> editLastSchedulingGate() {
        int index = this.schedulingGates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last schedulingGates. The list is empty.");
        }
        return this.setNewSchedulingGateLike(index, this.buildSchedulingGate(index));
    }

    public SchedulingGatesNested<A> editMatchingSchedulingGate(Predicate<V1PodSchedulingGateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.schedulingGates.size(); ++i) {
            if (!predicate.test(this.schedulingGates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching schedulingGates. No match found.");
        }
        return this.setNewSchedulingGateLike(index, this.buildSchedulingGate(index));
    }

    public V1PodSecurityContext buildSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    public A withSecurityContext(V1PodSecurityContext securityContext) {
        this._visitables.remove("securityContext");
        if (securityContext != null) {
            this.securityContext = new V1PodSecurityContextBuilder(securityContext);
            this._visitables.get("securityContext").add(this.securityContext);
        } else {
            this.securityContext = null;
            this._visitables.get("securityContext").remove(this.securityContext);
        }
        return (A)this;
    }

    public boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public SecurityContextNested<A> withNewSecurityContext() {
        return new SecurityContextNested(null);
    }

    public SecurityContextNested<A> withNewSecurityContextLike(V1PodSecurityContext item) {
        return new SecurityContextNested(item);
    }

    public SecurityContextNested<A> editSecurityContext() {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(null));
    }

    public SecurityContextNested<A> editOrNewSecurityContext() {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(new V1PodSecurityContextBuilder().build()));
    }

    public SecurityContextNested<A> editOrNewSecurityContextLike(V1PodSecurityContext item) {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(item));
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    public boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public Boolean getSetHostnameAsFQDN() {
        return this.setHostnameAsFQDN;
    }

    public A withSetHostnameAsFQDN(Boolean setHostnameAsFQDN) {
        this.setHostnameAsFQDN = setHostnameAsFQDN;
        return (A)this;
    }

    public boolean hasSetHostnameAsFQDN() {
        return this.setHostnameAsFQDN != null;
    }

    public Boolean getShareProcessNamespace() {
        return this.shareProcessNamespace;
    }

    public A withShareProcessNamespace(Boolean shareProcessNamespace) {
        this.shareProcessNamespace = shareProcessNamespace;
        return (A)this;
    }

    public boolean hasShareProcessNamespace() {
        return this.shareProcessNamespace != null;
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public A withSubdomain(String subdomain) {
        this.subdomain = subdomain;
        return (A)this;
    }

    public boolean hasSubdomain() {
        return this.subdomain != null;
    }

    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return (A)this;
    }

    public boolean hasTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds != null;
    }

    public A addToTolerations(int index, V1Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        V1TolerationBuilder builder = new V1TolerationBuilder(item);
        if (index < 0 || index >= this.tolerations.size()) {
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        } else {
            this._visitables.get("tolerations").add(index, builder);
            this.tolerations.add(index, builder);
        }
        return (A)this;
    }

    public A setToTolerations(int index, V1Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        V1TolerationBuilder builder = new V1TolerationBuilder(item);
        if (index < 0 || index >= this.tolerations.size()) {
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        } else {
            this._visitables.get("tolerations").set(index, builder);
            this.tolerations.set(index, builder);
        }
        return (A)this;
    }

    public A addToTolerations(V1Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (V1Toleration item : items) {
            V1TolerationBuilder builder = new V1TolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    public A addAllToTolerations(Collection<V1Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (V1Toleration item : items) {
            V1TolerationBuilder builder = new V1TolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    public A removeFromTolerations(V1Toleration ... items) {
        if (this.tolerations == null) {
            return (A)this;
        }
        for (V1Toleration item : items) {
            V1TolerationBuilder builder = new V1TolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTolerations(Collection<V1Toleration> items) {
        if (this.tolerations == null) {
            return (A)this;
        }
        for (V1Toleration item : items) {
            V1TolerationBuilder builder = new V1TolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTolerations(Predicate<V1TolerationBuilder> predicate) {
        if (this.tolerations == null) {
            return (A)this;
        }
        Iterator<V1TolerationBuilder> each = this.tolerations.iterator();
        Object visitables = this._visitables.get("tolerations");
        while (each.hasNext()) {
            V1TolerationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1Toleration> buildTolerations() {
        return this.tolerations != null ? V1PodSpecFluent.build(this.tolerations) : null;
    }

    public V1Toleration buildToleration(int index) {
        return this.tolerations.get(index).build();
    }

    public V1Toleration buildFirstToleration() {
        return this.tolerations.get(0).build();
    }

    public V1Toleration buildLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1).build();
    }

    public V1Toleration buildMatchingToleration(Predicate<V1TolerationBuilder> predicate) {
        for (V1TolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingToleration(Predicate<V1TolerationBuilder> predicate) {
        for (V1TolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTolerations(List<V1Toleration> tolerations) {
        if (this.tolerations != null) {
            this._visitables.get("tolerations").clear();
        }
        if (tolerations != null) {
            this.tolerations = new ArrayList();
            for (V1Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    public A withTolerations(V1Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove("tolerations");
        }
        if (tolerations != null) {
            for (V1Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public TolerationsNested<A> addNewToleration() {
        return new TolerationsNested(-1, null);
    }

    public TolerationsNested<A> addNewTolerationLike(V1Toleration item) {
        return new TolerationsNested(-1, item);
    }

    public TolerationsNested<A> setNewTolerationLike(int index, V1Toleration item) {
        return new TolerationsNested(index, item);
    }

    public TolerationsNested<A> editToleration(int index) {
        if (this.tolerations.size() <= index) {
            throw new RuntimeException("Can't edit tolerations. Index exceeds size.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public TolerationsNested<A> editFirstToleration() {
        if (this.tolerations.size() == 0) {
            throw new RuntimeException("Can't edit first tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(0, this.buildToleration(0));
    }

    public TolerationsNested<A> editLastToleration() {
        int index = this.tolerations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public TolerationsNested<A> editMatchingToleration(Predicate<V1TolerationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tolerations.size(); ++i) {
            if (!predicate.test(this.tolerations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tolerations. No match found.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public A addToTopologySpreadConstraints(int index, V1TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList();
        }
        V1TopologySpreadConstraintBuilder builder = new V1TopologySpreadConstraintBuilder(item);
        if (index < 0 || index >= this.topologySpreadConstraints.size()) {
            this._visitables.get("topologySpreadConstraints").add(builder);
            this.topologySpreadConstraints.add(builder);
        } else {
            this._visitables.get("topologySpreadConstraints").add(index, builder);
            this.topologySpreadConstraints.add(index, builder);
        }
        return (A)this;
    }

    public A setToTopologySpreadConstraints(int index, V1TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList();
        }
        V1TopologySpreadConstraintBuilder builder = new V1TopologySpreadConstraintBuilder(item);
        if (index < 0 || index >= this.topologySpreadConstraints.size()) {
            this._visitables.get("topologySpreadConstraints").add(builder);
            this.topologySpreadConstraints.add(builder);
        } else {
            this._visitables.get("topologySpreadConstraints").set(index, builder);
            this.topologySpreadConstraints.set(index, builder);
        }
        return (A)this;
    }

    public A addToTopologySpreadConstraints(V1TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList();
        }
        for (V1TopologySpreadConstraint item : items) {
            V1TopologySpreadConstraintBuilder builder = new V1TopologySpreadConstraintBuilder(item);
            this._visitables.get("topologySpreadConstraints").add(builder);
            this.topologySpreadConstraints.add(builder);
        }
        return (A)this;
    }

    public A addAllToTopologySpreadConstraints(Collection<V1TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList();
        }
        for (V1TopologySpreadConstraint item : items) {
            V1TopologySpreadConstraintBuilder builder = new V1TopologySpreadConstraintBuilder(item);
            this._visitables.get("topologySpreadConstraints").add(builder);
            this.topologySpreadConstraints.add(builder);
        }
        return (A)this;
    }

    public A removeFromTopologySpreadConstraints(V1TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            return (A)this;
        }
        for (V1TopologySpreadConstraint item : items) {
            V1TopologySpreadConstraintBuilder builder = new V1TopologySpreadConstraintBuilder(item);
            this._visitables.get("topologySpreadConstraints").remove(builder);
            this.topologySpreadConstraints.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTopologySpreadConstraints(Collection<V1TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            return (A)this;
        }
        for (V1TopologySpreadConstraint item : items) {
            V1TopologySpreadConstraintBuilder builder = new V1TopologySpreadConstraintBuilder(item);
            this._visitables.get("topologySpreadConstraints").remove(builder);
            this.topologySpreadConstraints.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTopologySpreadConstraints(Predicate<V1TopologySpreadConstraintBuilder> predicate) {
        if (this.topologySpreadConstraints == null) {
            return (A)this;
        }
        Iterator<V1TopologySpreadConstraintBuilder> each = this.topologySpreadConstraints.iterator();
        Object visitables = this._visitables.get("topologySpreadConstraints");
        while (each.hasNext()) {
            V1TopologySpreadConstraintBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1TopologySpreadConstraint> buildTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null ? V1PodSpecFluent.build(this.topologySpreadConstraints) : null;
    }

    public V1TopologySpreadConstraint buildTopologySpreadConstraint(int index) {
        return this.topologySpreadConstraints.get(index).build();
    }

    public V1TopologySpreadConstraint buildFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0).build();
    }

    public V1TopologySpreadConstraint buildLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(this.topologySpreadConstraints.size() - 1).build();
    }

    public V1TopologySpreadConstraint buildMatchingTopologySpreadConstraint(Predicate<V1TopologySpreadConstraintBuilder> predicate) {
        for (V1TopologySpreadConstraintBuilder item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTopologySpreadConstraint(Predicate<V1TopologySpreadConstraintBuilder> predicate) {
        for (V1TopologySpreadConstraintBuilder item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTopologySpreadConstraints(List<V1TopologySpreadConstraint> topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this._visitables.get("topologySpreadConstraints").clear();
        }
        if (topologySpreadConstraints != null) {
            this.topologySpreadConstraints = new ArrayList();
            for (V1TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        } else {
            this.topologySpreadConstraints = null;
        }
        return (A)this;
    }

    public A withTopologySpreadConstraints(V1TopologySpreadConstraint ... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this.topologySpreadConstraints.clear();
            this._visitables.remove("topologySpreadConstraints");
        }
        if (topologySpreadConstraints != null) {
            for (V1TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        }
        return (A)this;
    }

    public boolean hasTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty();
    }

    public TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraint() {
        return new TopologySpreadConstraintsNested(-1, null);
    }

    public TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraintLike(V1TopologySpreadConstraint item) {
        return new TopologySpreadConstraintsNested(-1, item);
    }

    public TopologySpreadConstraintsNested<A> setNewTopologySpreadConstraintLike(int index, V1TopologySpreadConstraint item) {
        return new TopologySpreadConstraintsNested(index, item);
    }

    public TopologySpreadConstraintsNested<A> editTopologySpreadConstraint(int index) {
        if (this.topologySpreadConstraints.size() <= index) {
            throw new RuntimeException("Can't edit topologySpreadConstraints. Index exceeds size.");
        }
        return this.setNewTopologySpreadConstraintLike(index, this.buildTopologySpreadConstraint(index));
    }

    public TopologySpreadConstraintsNested<A> editFirstTopologySpreadConstraint() {
        if (this.topologySpreadConstraints.size() == 0) {
            throw new RuntimeException("Can't edit first topologySpreadConstraints. The list is empty.");
        }
        return this.setNewTopologySpreadConstraintLike(0, this.buildTopologySpreadConstraint(0));
    }

    public TopologySpreadConstraintsNested<A> editLastTopologySpreadConstraint() {
        int index = this.topologySpreadConstraints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last topologySpreadConstraints. The list is empty.");
        }
        return this.setNewTopologySpreadConstraintLike(index, this.buildTopologySpreadConstraint(index));
    }

    public TopologySpreadConstraintsNested<A> editMatchingTopologySpreadConstraint(Predicate<V1TopologySpreadConstraintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.topologySpreadConstraints.size(); ++i) {
            if (!predicate.test(this.topologySpreadConstraints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching topologySpreadConstraints. No match found.");
        }
        return this.setNewTopologySpreadConstraintLike(index, this.buildTopologySpreadConstraint(index));
    }

    public A addToVolumes(int index, V1Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        V1VolumeBuilder builder = new V1VolumeBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get("volumes").add(index, builder);
            this.volumes.add(index, builder);
        }
        return (A)this;
    }

    public A setToVolumes(int index, V1Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        V1VolumeBuilder builder = new V1VolumeBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get("volumes").set(index, builder);
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    public A addToVolumes(V1Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (V1Volume item : items) {
            V1VolumeBuilder builder = new V1VolumeBuilder(item);
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    public A addAllToVolumes(Collection<V1Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (V1Volume item : items) {
            V1VolumeBuilder builder = new V1VolumeBuilder(item);
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    public A removeFromVolumes(V1Volume ... items) {
        if (this.volumes == null) {
            return (A)this;
        }
        for (V1Volume item : items) {
            V1VolumeBuilder builder = new V1VolumeBuilder(item);
            this._visitables.get("volumes").remove(builder);
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVolumes(Collection<V1Volume> items) {
        if (this.volumes == null) {
            return (A)this;
        }
        for (V1Volume item : items) {
            V1VolumeBuilder builder = new V1VolumeBuilder(item);
            this._visitables.get("volumes").remove(builder);
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVolumes(Predicate<V1VolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)this;
        }
        Iterator<V1VolumeBuilder> each = this.volumes.iterator();
        Object visitables = this._visitables.get("volumes");
        while (each.hasNext()) {
            V1VolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1Volume> buildVolumes() {
        return this.volumes != null ? V1PodSpecFluent.build(this.volumes) : null;
    }

    public V1Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public V1Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public V1Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    public V1Volume buildMatchingVolume(Predicate<V1VolumeBuilder> predicate) {
        for (V1VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolume(Predicate<V1VolumeBuilder> predicate) {
        for (V1VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumes(List<V1Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get("volumes").clear();
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (V1Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    public A withVolumes(V1Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove("volumes");
        }
        if (volumes != null) {
            for (V1Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    public boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public VolumesNested<A> addNewVolume() {
        return new VolumesNested(-1, null);
    }

    public VolumesNested<A> addNewVolumeLike(V1Volume item) {
        return new VolumesNested(-1, item);
    }

    public VolumesNested<A> setNewVolumeLike(int index, V1Volume item) {
        return new VolumesNested(index, item);
    }

    public VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    public VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editMatchingVolume(Predicate<V1VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PodSpecFluent that = (V1PodSpecFluent)o;
        if (!Objects.equals(this.activeDeadlineSeconds, that.activeDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.affinity, that.affinity)) {
            return false;
        }
        if (!Objects.equals(this.automountServiceAccountToken, that.automountServiceAccountToken)) {
            return false;
        }
        if (!Objects.equals(this.containers, that.containers)) {
            return false;
        }
        if (!Objects.equals(this.dnsConfig, that.dnsConfig)) {
            return false;
        }
        if (!Objects.equals(this.dnsPolicy, that.dnsPolicy)) {
            return false;
        }
        if (!Objects.equals(this.enableServiceLinks, that.enableServiceLinks)) {
            return false;
        }
        if (!Objects.equals(this.ephemeralContainers, that.ephemeralContainers)) {
            return false;
        }
        if (!Objects.equals(this.hostAliases, that.hostAliases)) {
            return false;
        }
        if (!Objects.equals(this.hostIPC, that.hostIPC)) {
            return false;
        }
        if (!Objects.equals(this.hostNetwork, that.hostNetwork)) {
            return false;
        }
        if (!Objects.equals(this.hostPID, that.hostPID)) {
            return false;
        }
        if (!Objects.equals(this.hostUsers, that.hostUsers)) {
            return false;
        }
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSecrets, that.imagePullSecrets)) {
            return false;
        }
        if (!Objects.equals(this.initContainers, that.initContainers)) {
            return false;
        }
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.os, that.os)) {
            return false;
        }
        if (!Objects.equals(this.overhead, that.overhead)) {
            return false;
        }
        if (!Objects.equals(this.preemptionPolicy, that.preemptionPolicy)) {
            return false;
        }
        if (!Objects.equals(this.priority, that.priority)) {
            return false;
        }
        if (!Objects.equals(this.priorityClassName, that.priorityClassName)) {
            return false;
        }
        if (!Objects.equals(this.readinessGates, that.readinessGates)) {
            return false;
        }
        if (!Objects.equals(this.resourceClaims, that.resourceClaims)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.restartPolicy, that.restartPolicy)) {
            return false;
        }
        if (!Objects.equals(this.runtimeClassName, that.runtimeClassName)) {
            return false;
        }
        if (!Objects.equals(this.schedulerName, that.schedulerName)) {
            return false;
        }
        if (!Objects.equals(this.schedulingGates, that.schedulingGates)) {
            return false;
        }
        if (!Objects.equals(this.securityContext, that.securityContext)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccount, that.serviceAccount)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        if (!Objects.equals(this.setHostnameAsFQDN, that.setHostnameAsFQDN)) {
            return false;
        }
        if (!Objects.equals(this.shareProcessNamespace, that.shareProcessNamespace)) {
            return false;
        }
        if (!Objects.equals(this.subdomain, that.subdomain)) {
            return false;
        }
        if (!Objects.equals(this.terminationGracePeriodSeconds, that.terminationGracePeriodSeconds)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        if (!Objects.equals(this.topologySpreadConstraints, that.topologySpreadConstraints)) {
            return false;
        }
        return Objects.equals(this.volumes, that.volumes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.affinity, this.automountServiceAccountToken, this.containers, this.dnsConfig, this.dnsPolicy, this.enableServiceLinks, this.ephemeralContainers, this.hostAliases, this.hostIPC, this.hostNetwork, this.hostPID, this.hostUsers, this.hostname, this.imagePullSecrets, this.initContainers, this.nodeName, this.nodeSelector, this.os, this.overhead, this.preemptionPolicy, this.priority, this.priorityClassName, this.readinessGates, this.resourceClaims, this.resources, this.restartPolicy, this.runtimeClassName, this.schedulerName, this.schedulingGates, this.securityContext, this.serviceAccount, this.serviceAccountName, this.setHostnameAsFQDN, this.shareProcessNamespace, this.subdomain, this.terminationGracePeriodSeconds, this.tolerations, this.topologySpreadConstraints, this.volumes, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activeDeadlineSeconds != null) {
            sb.append("activeDeadlineSeconds:");
            sb.append(this.activeDeadlineSeconds + ",");
        }
        if (this.affinity != null) {
            sb.append("affinity:");
            sb.append(this.affinity + ",");
        }
        if (this.automountServiceAccountToken != null) {
            sb.append("automountServiceAccountToken:");
            sb.append(this.automountServiceAccountToken + ",");
        }
        if (this.containers != null && !this.containers.isEmpty()) {
            sb.append("containers:");
            sb.append(this.containers + ",");
        }
        if (this.dnsConfig != null) {
            sb.append("dnsConfig:");
            sb.append(this.dnsConfig + ",");
        }
        if (this.dnsPolicy != null) {
            sb.append("dnsPolicy:");
            sb.append(this.dnsPolicy + ",");
        }
        if (this.enableServiceLinks != null) {
            sb.append("enableServiceLinks:");
            sb.append(this.enableServiceLinks + ",");
        }
        if (this.ephemeralContainers != null && !this.ephemeralContainers.isEmpty()) {
            sb.append("ephemeralContainers:");
            sb.append(this.ephemeralContainers + ",");
        }
        if (this.hostAliases != null && !this.hostAliases.isEmpty()) {
            sb.append("hostAliases:");
            sb.append(this.hostAliases + ",");
        }
        if (this.hostIPC != null) {
            sb.append("hostIPC:");
            sb.append(this.hostIPC + ",");
        }
        if (this.hostNetwork != null) {
            sb.append("hostNetwork:");
            sb.append(this.hostNetwork + ",");
        }
        if (this.hostPID != null) {
            sb.append("hostPID:");
            sb.append(this.hostPID + ",");
        }
        if (this.hostUsers != null) {
            sb.append("hostUsers:");
            sb.append(this.hostUsers + ",");
        }
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty()) {
            sb.append("imagePullSecrets:");
            sb.append(this.imagePullSecrets + ",");
        }
        if (this.initContainers != null && !this.initContainers.isEmpty()) {
            sb.append("initContainers:");
            sb.append(this.initContainers + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.os != null) {
            sb.append("os:");
            sb.append(this.os + ",");
        }
        if (this.overhead != null && !this.overhead.isEmpty()) {
            sb.append("overhead:");
            sb.append(this.overhead + ",");
        }
        if (this.preemptionPolicy != null) {
            sb.append("preemptionPolicy:");
            sb.append(this.preemptionPolicy + ",");
        }
        if (this.priority != null) {
            sb.append("priority:");
            sb.append(this.priority + ",");
        }
        if (this.priorityClassName != null) {
            sb.append("priorityClassName:");
            sb.append(this.priorityClassName + ",");
        }
        if (this.readinessGates != null && !this.readinessGates.isEmpty()) {
            sb.append("readinessGates:");
            sb.append(this.readinessGates + ",");
        }
        if (this.resourceClaims != null && !this.resourceClaims.isEmpty()) {
            sb.append("resourceClaims:");
            sb.append(this.resourceClaims + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.restartPolicy != null) {
            sb.append("restartPolicy:");
            sb.append(this.restartPolicy + ",");
        }
        if (this.runtimeClassName != null) {
            sb.append("runtimeClassName:");
            sb.append(this.runtimeClassName + ",");
        }
        if (this.schedulerName != null) {
            sb.append("schedulerName:");
            sb.append(this.schedulerName + ",");
        }
        if (this.schedulingGates != null && !this.schedulingGates.isEmpty()) {
            sb.append("schedulingGates:");
            sb.append(this.schedulingGates + ",");
        }
        if (this.securityContext != null) {
            sb.append("securityContext:");
            sb.append(this.securityContext + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append(this.serviceAccount + ",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.setHostnameAsFQDN != null) {
            sb.append("setHostnameAsFQDN:");
            sb.append(this.setHostnameAsFQDN + ",");
        }
        if (this.shareProcessNamespace != null) {
            sb.append("shareProcessNamespace:");
            sb.append(this.shareProcessNamespace + ",");
        }
        if (this.subdomain != null) {
            sb.append("subdomain:");
            sb.append(this.subdomain + ",");
        }
        if (this.terminationGracePeriodSeconds != null) {
            sb.append("terminationGracePeriodSeconds:");
            sb.append(this.terminationGracePeriodSeconds + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations + ",");
        }
        if (this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty()) {
            sb.append("topologySpreadConstraints:");
            sb.append(this.topologySpreadConstraints + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAutomountServiceAccountToken() {
        return this.withAutomountServiceAccountToken(true);
    }

    public A withEnableServiceLinks() {
        return this.withEnableServiceLinks(true);
    }

    public A withHostIPC() {
        return this.withHostIPC(true);
    }

    public A withHostNetwork() {
        return this.withHostNetwork(true);
    }

    public A withHostPID() {
        return this.withHostPID(true);
    }

    public A withHostUsers() {
        return this.withHostUsers(true);
    }

    public A withSetHostnameAsFQDN() {
        return this.withSetHostnameAsFQDN(true);
    }

    public A withShareProcessNamespace() {
        return this.withShareProcessNamespace(true);
    }

    public class AffinityNested<N>
    extends V1AffinityFluent<AffinityNested<N>>
    implements Nested<N> {
        V1AffinityBuilder builder;

        AffinityNested(V1Affinity item) {
            this.builder = new V1AffinityBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluent.this.withAffinity(this.builder.build());
        }

        public N endAffinity() {
            return this.and();
        }
    }

    public class ContainersNested<N>
    extends V1ContainerFluent<ContainersNested<N>>
    implements Nested<N> {
        V1ContainerBuilder builder;
        int index;

        ContainersNested(int index, V1Container item) {
            this.index = index;
            this.builder = new V1ContainerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluent.this.setToContainers(this.index, this.builder.build());
        }

        public N endContainer() {
            return this.and();
        }
    }

    public class DnsConfigNested<N>
    extends V1PodDNSConfigFluent<DnsConfigNested<N>>
    implements Nested<N> {
        V1PodDNSConfigBuilder builder;

        DnsConfigNested(V1PodDNSConfig item) {
            this.builder = new V1PodDNSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluent.this.withDnsConfig(this.builder.build());
        }

        public N endDnsConfig() {
            return this.and();
        }
    }

    public class EphemeralContainersNested<N>
    extends V1EphemeralContainerFluent<EphemeralContainersNested<N>>
    implements Nested<N> {
        V1EphemeralContainerBuilder builder;
        int index;

        EphemeralContainersNested(int index, V1EphemeralContainer item) {
            this.index = index;
            this.builder = new V1EphemeralContainerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluent.this.setToEphemeralContainers(this.index, this.builder.build());
        }

        public N endEphemeralContainer() {
            return this.and();
        }
    }

    public class HostAliasesNested<N>
    extends V1HostAliasFluent<HostAliasesNested<N>>
    implements Nested<N> {
        V1HostAliasBuilder builder;
        int index;

        HostAliasesNested(int index, V1HostAlias item) {
            this.index = index;
            this.builder = new V1HostAliasBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluent.this.setToHostAliases(this.index, this.builder.build());
        }

        public N endHostAlias() {
            return this.and();
        }
    }

    public class ImagePullSecretsNested<N>
    extends V1LocalObjectReferenceFluent<ImagePullSecretsNested<N>>
    implements Nested<N> {
        V1LocalObjectReferenceBuilder builder;
        int index;

        ImagePullSecretsNested(int index, V1LocalObjectReference item) {
            this.index = index;
            this.builder = new V1LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluent.this.setToImagePullSecrets(this.index, this.builder.build());
        }

        public N endImagePullSecret() {
            return this.and();
        }
    }

    public class InitContainersNested<N>
    extends V1ContainerFluent<InitContainersNested<N>>
    implements Nested<N> {
        V1ContainerBuilder builder;
        int index;

        InitContainersNested(int index, V1Container item) {
            this.index = index;
            this.builder = new V1ContainerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluent.this.setToInitContainers(this.index, this.builder.build());
        }

        public N endInitContainer() {
            return this.and();
        }
    }

    public class OsNested<N>
    extends V1PodOSFluent<OsNested<N>>
    implements Nested<N> {
        V1PodOSBuilder builder;

        OsNested(V1PodOS item) {
            this.builder = new V1PodOSBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluent.this.withOs(this.builder.build());
        }

        public N endOs() {
            return this.and();
        }
    }

    public class ReadinessGatesNested<N>
    extends V1PodReadinessGateFluent<ReadinessGatesNested<N>>
    implements Nested<N> {
        V1PodReadinessGateBuilder builder;
        int index;

        ReadinessGatesNested(int index, V1PodReadinessGate item) {
            this.index = index;
            this.builder = new V1PodReadinessGateBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluent.this.setToReadinessGates(this.index, this.builder.build());
        }

        public N endReadinessGate() {
            return this.and();
        }
    }

    public class ResourceClaimsNested<N>
    extends V1PodResourceClaimFluent<ResourceClaimsNested<N>>
    implements Nested<N> {
        V1PodResourceClaimBuilder builder;
        int index;

        ResourceClaimsNested(int index, V1PodResourceClaim item) {
            this.index = index;
            this.builder = new V1PodResourceClaimBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluent.this.setToResourceClaims(this.index, this.builder.build());
        }

        public N endResourceClaim() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends V1ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        V1ResourceRequirementsBuilder builder;

        ResourcesNested(V1ResourceRequirements item) {
            this.builder = new V1ResourceRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class SchedulingGatesNested<N>
    extends V1PodSchedulingGateFluent<SchedulingGatesNested<N>>
    implements Nested<N> {
        V1PodSchedulingGateBuilder builder;
        int index;

        SchedulingGatesNested(int index, V1PodSchedulingGate item) {
            this.index = index;
            this.builder = new V1PodSchedulingGateBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluent.this.setToSchedulingGates(this.index, this.builder.build());
        }

        public N endSchedulingGate() {
            return this.and();
        }
    }

    public class SecurityContextNested<N>
    extends V1PodSecurityContextFluent<SecurityContextNested<N>>
    implements Nested<N> {
        V1PodSecurityContextBuilder builder;

        SecurityContextNested(V1PodSecurityContext item) {
            this.builder = new V1PodSecurityContextBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluent.this.withSecurityContext(this.builder.build());
        }

        public N endSecurityContext() {
            return this.and();
        }
    }

    public class TolerationsNested<N>
    extends V1TolerationFluent<TolerationsNested<N>>
    implements Nested<N> {
        V1TolerationBuilder builder;
        int index;

        TolerationsNested(int index, V1Toleration item) {
            this.index = index;
            this.builder = new V1TolerationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluent.this.setToTolerations(this.index, this.builder.build());
        }

        public N endToleration() {
            return this.and();
        }
    }

    public class TopologySpreadConstraintsNested<N>
    extends V1TopologySpreadConstraintFluent<TopologySpreadConstraintsNested<N>>
    implements Nested<N> {
        V1TopologySpreadConstraintBuilder builder;
        int index;

        TopologySpreadConstraintsNested(int index, V1TopologySpreadConstraint item) {
            this.index = index;
            this.builder = new V1TopologySpreadConstraintBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluent.this.setToTopologySpreadConstraints(this.index, this.builder.build());
        }

        public N endTopologySpreadConstraint() {
            return this.and();
        }
    }

    public class VolumesNested<N>
    extends V1VolumeFluent<VolumesNested<N>>
    implements Nested<N> {
        V1VolumeBuilder builder;
        int index;

        VolumesNested(int index, V1Volume item) {
            this.index = index;
            this.builder = new V1VolumeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSpecFluent.this.setToVolumes(this.index, this.builder.build());
        }

        public N endVolume() {
            return this.and();
        }
    }
}

