/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1AppArmorProfile;
import io.kubernetes.client.openapi.models.V1AppArmorProfileBuilder;
import io.kubernetes.client.openapi.models.V1AppArmorProfileFluent;
import io.kubernetes.client.openapi.models.V1PodSecurityContext;
import io.kubernetes.client.openapi.models.V1SELinuxOptions;
import io.kubernetes.client.openapi.models.V1SELinuxOptionsBuilder;
import io.kubernetes.client.openapi.models.V1SELinuxOptionsFluent;
import io.kubernetes.client.openapi.models.V1SeccompProfile;
import io.kubernetes.client.openapi.models.V1SeccompProfileBuilder;
import io.kubernetes.client.openapi.models.V1SeccompProfileFluent;
import io.kubernetes.client.openapi.models.V1Sysctl;
import io.kubernetes.client.openapi.models.V1SysctlBuilder;
import io.kubernetes.client.openapi.models.V1SysctlFluent;
import io.kubernetes.client.openapi.models.V1WindowsSecurityContextOptions;
import io.kubernetes.client.openapi.models.V1WindowsSecurityContextOptionsBuilder;
import io.kubernetes.client.openapi.models.V1WindowsSecurityContextOptionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1PodSecurityContextFluent<A extends V1PodSecurityContextFluent<A>>
extends BaseFluent<A> {
    private V1AppArmorProfileBuilder appArmorProfile;
    private Long fsGroup;
    private String fsGroupChangePolicy;
    private Long runAsGroup;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private String seLinuxChangePolicy;
    private V1SELinuxOptionsBuilder seLinuxOptions;
    private V1SeccompProfileBuilder seccompProfile;
    private List<Long> supplementalGroups;
    private String supplementalGroupsPolicy;
    private ArrayList<V1SysctlBuilder> sysctls;
    private V1WindowsSecurityContextOptionsBuilder windowsOptions;

    public V1PodSecurityContextFluent() {
    }

    public V1PodSecurityContextFluent(V1PodSecurityContext instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1PodSecurityContext instance) {
        V1PodSecurityContext v1PodSecurityContext = instance = instance != null ? instance : new V1PodSecurityContext();
        if (instance != null) {
            this.withAppArmorProfile(instance.getAppArmorProfile());
            this.withFsGroup(instance.getFsGroup());
            this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());
            this.withRunAsGroup(instance.getRunAsGroup());
            this.withRunAsNonRoot(instance.getRunAsNonRoot());
            this.withRunAsUser(instance.getRunAsUser());
            this.withSeLinuxChangePolicy(instance.getSeLinuxChangePolicy());
            this.withSeLinuxOptions(instance.getSeLinuxOptions());
            this.withSeccompProfile(instance.getSeccompProfile());
            this.withSupplementalGroups(instance.getSupplementalGroups());
            this.withSupplementalGroupsPolicy(instance.getSupplementalGroupsPolicy());
            this.withSysctls(instance.getSysctls());
            this.withWindowsOptions(instance.getWindowsOptions());
        }
    }

    public V1AppArmorProfile buildAppArmorProfile() {
        return this.appArmorProfile != null ? this.appArmorProfile.build() : null;
    }

    public A withAppArmorProfile(V1AppArmorProfile appArmorProfile) {
        this._visitables.remove("appArmorProfile");
        if (appArmorProfile != null) {
            this.appArmorProfile = new V1AppArmorProfileBuilder(appArmorProfile);
            this._visitables.get("appArmorProfile").add(this.appArmorProfile);
        } else {
            this.appArmorProfile = null;
            this._visitables.get("appArmorProfile").remove(this.appArmorProfile);
        }
        return (A)this;
    }

    public boolean hasAppArmorProfile() {
        return this.appArmorProfile != null;
    }

    public AppArmorProfileNested<A> withNewAppArmorProfile() {
        return new AppArmorProfileNested(null);
    }

    public AppArmorProfileNested<A> withNewAppArmorProfileLike(V1AppArmorProfile item) {
        return new AppArmorProfileNested(item);
    }

    public AppArmorProfileNested<A> editAppArmorProfile() {
        return this.withNewAppArmorProfileLike(Optional.ofNullable(this.buildAppArmorProfile()).orElse(null));
    }

    public AppArmorProfileNested<A> editOrNewAppArmorProfile() {
        return this.withNewAppArmorProfileLike(Optional.ofNullable(this.buildAppArmorProfile()).orElse(new V1AppArmorProfileBuilder().build()));
    }

    public AppArmorProfileNested<A> editOrNewAppArmorProfileLike(V1AppArmorProfile item) {
        return this.withNewAppArmorProfileLike(Optional.ofNullable(this.buildAppArmorProfile()).orElse(item));
    }

    public Long getFsGroup() {
        return this.fsGroup;
    }

    public A withFsGroup(Long fsGroup) {
        this.fsGroup = fsGroup;
        return (A)this;
    }

    public boolean hasFsGroup() {
        return this.fsGroup != null;
    }

    public String getFsGroupChangePolicy() {
        return this.fsGroupChangePolicy;
    }

    public A withFsGroupChangePolicy(String fsGroupChangePolicy) {
        this.fsGroupChangePolicy = fsGroupChangePolicy;
        return (A)this;
    }

    public boolean hasFsGroupChangePolicy() {
        return this.fsGroupChangePolicy != null;
    }

    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public A withRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return (A)this;
    }

    public boolean hasRunAsGroup() {
        return this.runAsGroup != null;
    }

    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public A withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return (A)this;
    }

    public boolean hasRunAsNonRoot() {
        return this.runAsNonRoot != null;
    }

    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public A withRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return (A)this;
    }

    public boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    public String getSeLinuxChangePolicy() {
        return this.seLinuxChangePolicy;
    }

    public A withSeLinuxChangePolicy(String seLinuxChangePolicy) {
        this.seLinuxChangePolicy = seLinuxChangePolicy;
        return (A)this;
    }

    public boolean hasSeLinuxChangePolicy() {
        return this.seLinuxChangePolicy != null;
    }

    public V1SELinuxOptions buildSeLinuxOptions() {
        return this.seLinuxOptions != null ? this.seLinuxOptions.build() : null;
    }

    public A withSeLinuxOptions(V1SELinuxOptions seLinuxOptions) {
        this._visitables.remove("seLinuxOptions");
        if (seLinuxOptions != null) {
            this.seLinuxOptions = new V1SELinuxOptionsBuilder(seLinuxOptions);
            this._visitables.get("seLinuxOptions").add(this.seLinuxOptions);
        } else {
            this.seLinuxOptions = null;
            this._visitables.get("seLinuxOptions").remove(this.seLinuxOptions);
        }
        return (A)this;
    }

    public boolean hasSeLinuxOptions() {
        return this.seLinuxOptions != null;
    }

    public SeLinuxOptionsNested<A> withNewSeLinuxOptions() {
        return new SeLinuxOptionsNested(null);
    }

    public SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(V1SELinuxOptions item) {
        return new SeLinuxOptionsNested(item);
    }

    public SeLinuxOptionsNested<A> editSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(Optional.ofNullable(this.buildSeLinuxOptions()).orElse(null));
    }

    public SeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(Optional.ofNullable(this.buildSeLinuxOptions()).orElse(new V1SELinuxOptionsBuilder().build()));
    }

    public SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(V1SELinuxOptions item) {
        return this.withNewSeLinuxOptionsLike(Optional.ofNullable(this.buildSeLinuxOptions()).orElse(item));
    }

    public V1SeccompProfile buildSeccompProfile() {
        return this.seccompProfile != null ? this.seccompProfile.build() : null;
    }

    public A withSeccompProfile(V1SeccompProfile seccompProfile) {
        this._visitables.remove("seccompProfile");
        if (seccompProfile != null) {
            this.seccompProfile = new V1SeccompProfileBuilder(seccompProfile);
            this._visitables.get("seccompProfile").add(this.seccompProfile);
        } else {
            this.seccompProfile = null;
            this._visitables.get("seccompProfile").remove(this.seccompProfile);
        }
        return (A)this;
    }

    public boolean hasSeccompProfile() {
        return this.seccompProfile != null;
    }

    public SeccompProfileNested<A> withNewSeccompProfile() {
        return new SeccompProfileNested(null);
    }

    public SeccompProfileNested<A> withNewSeccompProfileLike(V1SeccompProfile item) {
        return new SeccompProfileNested(item);
    }

    public SeccompProfileNested<A> editSeccompProfile() {
        return this.withNewSeccompProfileLike(Optional.ofNullable(this.buildSeccompProfile()).orElse(null));
    }

    public SeccompProfileNested<A> editOrNewSeccompProfile() {
        return this.withNewSeccompProfileLike(Optional.ofNullable(this.buildSeccompProfile()).orElse(new V1SeccompProfileBuilder().build()));
    }

    public SeccompProfileNested<A> editOrNewSeccompProfileLike(V1SeccompProfile item) {
        return this.withNewSeccompProfileLike(Optional.ofNullable(this.buildSeccompProfile()).orElse(item));
    }

    public A addToSupplementalGroups(int index, Long item) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.add(index, item);
        return (A)this;
    }

    public A setToSupplementalGroups(int index, Long item) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.set(index, item);
        return (A)this;
    }

    public A addToSupplementalGroups(Long ... items) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        for (Long item : items) {
            this.supplementalGroups.add(item);
        }
        return (A)this;
    }

    public A addAllToSupplementalGroups(Collection<Long> items) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        for (Long item : items) {
            this.supplementalGroups.add(item);
        }
        return (A)this;
    }

    public A removeFromSupplementalGroups(Long ... items) {
        if (this.supplementalGroups == null) {
            return (A)this;
        }
        for (Long item : items) {
            this.supplementalGroups.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromSupplementalGroups(Collection<Long> items) {
        if (this.supplementalGroups == null) {
            return (A)this;
        }
        for (Long item : items) {
            this.supplementalGroups.remove(item);
        }
        return (A)this;
    }

    public List<Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    public Long getSupplementalGroup(int index) {
        return this.supplementalGroups.get(index);
    }

    public Long getFirstSupplementalGroup() {
        return this.supplementalGroups.get(0);
    }

    public Long getLastSupplementalGroup() {
        return this.supplementalGroups.get(this.supplementalGroups.size() - 1);
    }

    public Long getMatchingSupplementalGroup(Predicate<Long> predicate) {
        for (Long item : this.supplementalGroups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSupplementalGroup(Predicate<Long> predicate) {
        for (Long item : this.supplementalGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSupplementalGroups(List<Long> supplementalGroups) {
        if (supplementalGroups != null) {
            this.supplementalGroups = new ArrayList<Long>();
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        } else {
            this.supplementalGroups = null;
        }
        return (A)this;
    }

    public A withSupplementalGroups(Long ... supplementalGroups) {
        if (this.supplementalGroups != null) {
            this.supplementalGroups.clear();
            this._visitables.remove("supplementalGroups");
        }
        if (supplementalGroups != null) {
            for (Long item : supplementalGroups) {
                this.addToSupplementalGroups(item);
            }
        }
        return (A)this;
    }

    public boolean hasSupplementalGroups() {
        return this.supplementalGroups != null && !this.supplementalGroups.isEmpty();
    }

    public String getSupplementalGroupsPolicy() {
        return this.supplementalGroupsPolicy;
    }

    public A withSupplementalGroupsPolicy(String supplementalGroupsPolicy) {
        this.supplementalGroupsPolicy = supplementalGroupsPolicy;
        return (A)this;
    }

    public boolean hasSupplementalGroupsPolicy() {
        return this.supplementalGroupsPolicy != null;
    }

    public A addToSysctls(int index, V1Sysctl item) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList();
        }
        V1SysctlBuilder builder = new V1SysctlBuilder(item);
        if (index < 0 || index >= this.sysctls.size()) {
            this._visitables.get("sysctls").add(builder);
            this.sysctls.add(builder);
        } else {
            this._visitables.get("sysctls").add(index, builder);
            this.sysctls.add(index, builder);
        }
        return (A)this;
    }

    public A setToSysctls(int index, V1Sysctl item) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList();
        }
        V1SysctlBuilder builder = new V1SysctlBuilder(item);
        if (index < 0 || index >= this.sysctls.size()) {
            this._visitables.get("sysctls").add(builder);
            this.sysctls.add(builder);
        } else {
            this._visitables.get("sysctls").set(index, builder);
            this.sysctls.set(index, builder);
        }
        return (A)this;
    }

    public A addToSysctls(V1Sysctl ... items) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList();
        }
        for (V1Sysctl item : items) {
            V1SysctlBuilder builder = new V1SysctlBuilder(item);
            this._visitables.get("sysctls").add(builder);
            this.sysctls.add(builder);
        }
        return (A)this;
    }

    public A addAllToSysctls(Collection<V1Sysctl> items) {
        if (this.sysctls == null) {
            this.sysctls = new ArrayList();
        }
        for (V1Sysctl item : items) {
            V1SysctlBuilder builder = new V1SysctlBuilder(item);
            this._visitables.get("sysctls").add(builder);
            this.sysctls.add(builder);
        }
        return (A)this;
    }

    public A removeFromSysctls(V1Sysctl ... items) {
        if (this.sysctls == null) {
            return (A)this;
        }
        for (V1Sysctl item : items) {
            V1SysctlBuilder builder = new V1SysctlBuilder(item);
            this._visitables.get("sysctls").remove(builder);
            this.sysctls.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSysctls(Collection<V1Sysctl> items) {
        if (this.sysctls == null) {
            return (A)this;
        }
        for (V1Sysctl item : items) {
            V1SysctlBuilder builder = new V1SysctlBuilder(item);
            this._visitables.get("sysctls").remove(builder);
            this.sysctls.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSysctls(Predicate<V1SysctlBuilder> predicate) {
        if (this.sysctls == null) {
            return (A)this;
        }
        Iterator<V1SysctlBuilder> each = this.sysctls.iterator();
        Object visitables = this._visitables.get("sysctls");
        while (each.hasNext()) {
            V1SysctlBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1Sysctl> buildSysctls() {
        return this.sysctls != null ? V1PodSecurityContextFluent.build(this.sysctls) : null;
    }

    public V1Sysctl buildSysctl(int index) {
        return this.sysctls.get(index).build();
    }

    public V1Sysctl buildFirstSysctl() {
        return this.sysctls.get(0).build();
    }

    public V1Sysctl buildLastSysctl() {
        return this.sysctls.get(this.sysctls.size() - 1).build();
    }

    public V1Sysctl buildMatchingSysctl(Predicate<V1SysctlBuilder> predicate) {
        for (V1SysctlBuilder item : this.sysctls) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSysctl(Predicate<V1SysctlBuilder> predicate) {
        for (V1SysctlBuilder item : this.sysctls) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSysctls(List<V1Sysctl> sysctls) {
        if (this.sysctls != null) {
            this._visitables.get("sysctls").clear();
        }
        if (sysctls != null) {
            this.sysctls = new ArrayList();
            for (V1Sysctl item : sysctls) {
                this.addToSysctls(item);
            }
        } else {
            this.sysctls = null;
        }
        return (A)this;
    }

    public A withSysctls(V1Sysctl ... sysctls) {
        if (this.sysctls != null) {
            this.sysctls.clear();
            this._visitables.remove("sysctls");
        }
        if (sysctls != null) {
            for (V1Sysctl item : sysctls) {
                this.addToSysctls(item);
            }
        }
        return (A)this;
    }

    public boolean hasSysctls() {
        return this.sysctls != null && !this.sysctls.isEmpty();
    }

    public SysctlsNested<A> addNewSysctl() {
        return new SysctlsNested(-1, null);
    }

    public SysctlsNested<A> addNewSysctlLike(V1Sysctl item) {
        return new SysctlsNested(-1, item);
    }

    public SysctlsNested<A> setNewSysctlLike(int index, V1Sysctl item) {
        return new SysctlsNested(index, item);
    }

    public SysctlsNested<A> editSysctl(int index) {
        if (this.sysctls.size() <= index) {
            throw new RuntimeException("Can't edit sysctls. Index exceeds size.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    public SysctlsNested<A> editFirstSysctl() {
        if (this.sysctls.size() == 0) {
            throw new RuntimeException("Can't edit first sysctls. The list is empty.");
        }
        return this.setNewSysctlLike(0, this.buildSysctl(0));
    }

    public SysctlsNested<A> editLastSysctl() {
        int index = this.sysctls.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sysctls. The list is empty.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    public SysctlsNested<A> editMatchingSysctl(Predicate<V1SysctlBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sysctls.size(); ++i) {
            if (!predicate.test(this.sysctls.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sysctls. No match found.");
        }
        return this.setNewSysctlLike(index, this.buildSysctl(index));
    }

    public V1WindowsSecurityContextOptions buildWindowsOptions() {
        return this.windowsOptions != null ? this.windowsOptions.build() : null;
    }

    public A withWindowsOptions(V1WindowsSecurityContextOptions windowsOptions) {
        this._visitables.remove("windowsOptions");
        if (windowsOptions != null) {
            this.windowsOptions = new V1WindowsSecurityContextOptionsBuilder(windowsOptions);
            this._visitables.get("windowsOptions").add(this.windowsOptions);
        } else {
            this.windowsOptions = null;
            this._visitables.get("windowsOptions").remove(this.windowsOptions);
        }
        return (A)this;
    }

    public boolean hasWindowsOptions() {
        return this.windowsOptions != null;
    }

    public WindowsOptionsNested<A> withNewWindowsOptions() {
        return new WindowsOptionsNested(null);
    }

    public WindowsOptionsNested<A> withNewWindowsOptionsLike(V1WindowsSecurityContextOptions item) {
        return new WindowsOptionsNested(item);
    }

    public WindowsOptionsNested<A> editWindowsOptions() {
        return this.withNewWindowsOptionsLike(Optional.ofNullable(this.buildWindowsOptions()).orElse(null));
    }

    public WindowsOptionsNested<A> editOrNewWindowsOptions() {
        return this.withNewWindowsOptionsLike(Optional.ofNullable(this.buildWindowsOptions()).orElse(new V1WindowsSecurityContextOptionsBuilder().build()));
    }

    public WindowsOptionsNested<A> editOrNewWindowsOptionsLike(V1WindowsSecurityContextOptions item) {
        return this.withNewWindowsOptionsLike(Optional.ofNullable(this.buildWindowsOptions()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PodSecurityContextFluent that = (V1PodSecurityContextFluent)o;
        if (!Objects.equals(this.appArmorProfile, that.appArmorProfile)) {
            return false;
        }
        if (!Objects.equals(this.fsGroup, that.fsGroup)) {
            return false;
        }
        if (!Objects.equals(this.fsGroupChangePolicy, that.fsGroupChangePolicy)) {
            return false;
        }
        if (!Objects.equals(this.runAsGroup, that.runAsGroup)) {
            return false;
        }
        if (!Objects.equals(this.runAsNonRoot, that.runAsNonRoot)) {
            return false;
        }
        if (!Objects.equals(this.runAsUser, that.runAsUser)) {
            return false;
        }
        if (!Objects.equals(this.seLinuxChangePolicy, that.seLinuxChangePolicy)) {
            return false;
        }
        if (!Objects.equals(this.seLinuxOptions, that.seLinuxOptions)) {
            return false;
        }
        if (!Objects.equals(this.seccompProfile, that.seccompProfile)) {
            return false;
        }
        if (!Objects.equals(this.supplementalGroups, that.supplementalGroups)) {
            return false;
        }
        if (!Objects.equals(this.supplementalGroupsPolicy, that.supplementalGroupsPolicy)) {
            return false;
        }
        if (!Objects.equals(this.sysctls, that.sysctls)) {
            return false;
        }
        return Objects.equals(this.windowsOptions, that.windowsOptions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.appArmorProfile, this.fsGroup, this.fsGroupChangePolicy, this.runAsGroup, this.runAsNonRoot, this.runAsUser, this.seLinuxChangePolicy, this.seLinuxOptions, this.seccompProfile, this.supplementalGroups, this.supplementalGroupsPolicy, this.sysctls, this.windowsOptions, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.appArmorProfile != null) {
            sb.append("appArmorProfile:");
            sb.append(this.appArmorProfile + ",");
        }
        if (this.fsGroup != null) {
            sb.append("fsGroup:");
            sb.append(this.fsGroup + ",");
        }
        if (this.fsGroupChangePolicy != null) {
            sb.append("fsGroupChangePolicy:");
            sb.append(this.fsGroupChangePolicy + ",");
        }
        if (this.runAsGroup != null) {
            sb.append("runAsGroup:");
            sb.append(this.runAsGroup + ",");
        }
        if (this.runAsNonRoot != null) {
            sb.append("runAsNonRoot:");
            sb.append(this.runAsNonRoot + ",");
        }
        if (this.runAsUser != null) {
            sb.append("runAsUser:");
            sb.append(this.runAsUser + ",");
        }
        if (this.seLinuxChangePolicy != null) {
            sb.append("seLinuxChangePolicy:");
            sb.append(this.seLinuxChangePolicy + ",");
        }
        if (this.seLinuxOptions != null) {
            sb.append("seLinuxOptions:");
            sb.append(this.seLinuxOptions + ",");
        }
        if (this.seccompProfile != null) {
            sb.append("seccompProfile:");
            sb.append(this.seccompProfile + ",");
        }
        if (this.supplementalGroups != null && !this.supplementalGroups.isEmpty()) {
            sb.append("supplementalGroups:");
            sb.append(this.supplementalGroups + ",");
        }
        if (this.supplementalGroupsPolicy != null) {
            sb.append("supplementalGroupsPolicy:");
            sb.append(this.supplementalGroupsPolicy + ",");
        }
        if (this.sysctls != null && !this.sysctls.isEmpty()) {
            sb.append("sysctls:");
            sb.append(this.sysctls + ",");
        }
        if (this.windowsOptions != null) {
            sb.append("windowsOptions:");
            sb.append(this.windowsOptions);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withRunAsNonRoot() {
        return this.withRunAsNonRoot(true);
    }

    public class AppArmorProfileNested<N>
    extends V1AppArmorProfileFluent<AppArmorProfileNested<N>>
    implements Nested<N> {
        V1AppArmorProfileBuilder builder;

        AppArmorProfileNested(V1AppArmorProfile item) {
            this.builder = new V1AppArmorProfileBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSecurityContextFluent.this.withAppArmorProfile(this.builder.build());
        }

        public N endAppArmorProfile() {
            return this.and();
        }
    }

    public class SeLinuxOptionsNested<N>
    extends V1SELinuxOptionsFluent<SeLinuxOptionsNested<N>>
    implements Nested<N> {
        V1SELinuxOptionsBuilder builder;

        SeLinuxOptionsNested(V1SELinuxOptions item) {
            this.builder = new V1SELinuxOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSecurityContextFluent.this.withSeLinuxOptions(this.builder.build());
        }

        public N endSeLinuxOptions() {
            return this.and();
        }
    }

    public class SeccompProfileNested<N>
    extends V1SeccompProfileFluent<SeccompProfileNested<N>>
    implements Nested<N> {
        V1SeccompProfileBuilder builder;

        SeccompProfileNested(V1SeccompProfile item) {
            this.builder = new V1SeccompProfileBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSecurityContextFluent.this.withSeccompProfile(this.builder.build());
        }

        public N endSeccompProfile() {
            return this.and();
        }
    }

    public class SysctlsNested<N>
    extends V1SysctlFluent<SysctlsNested<N>>
    implements Nested<N> {
        V1SysctlBuilder builder;
        int index;

        SysctlsNested(int index, V1Sysctl item) {
            this.index = index;
            this.builder = new V1SysctlBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSecurityContextFluent.this.setToSysctls(this.index, this.builder.build());
        }

        public N endSysctl() {
            return this.and();
        }
    }

    public class WindowsOptionsNested<N>
    extends V1WindowsSecurityContextOptionsFluent<WindowsOptionsNested<N>>
    implements Nested<N> {
        V1WindowsSecurityContextOptionsBuilder builder;

        WindowsOptionsNested(V1WindowsSecurityContextOptions item) {
            this.builder = new V1WindowsSecurityContextOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodSecurityContextFluent.this.withWindowsOptions(this.builder.build());
        }

        public N endWindowsOptions() {
            return this.and();
        }
    }
}

