/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.IntOrString;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1HTTPGetAction;
import io.kubernetes.client.openapi.models.V1HTTPHeader;
import io.kubernetes.client.openapi.models.V1HTTPHeaderBuilder;
import io.kubernetes.client.openapi.models.V1HTTPHeaderFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1HTTPGetActionFluent<A extends V1HTTPGetActionFluent<A>>
extends BaseFluent<A> {
    private String host;
    private ArrayList<V1HTTPHeaderBuilder> httpHeaders;
    private String path;
    private IntOrString port;
    private String scheme;

    public V1HTTPGetActionFluent() {
    }

    public V1HTTPGetActionFluent(V1HTTPGetAction instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1HTTPGetAction instance) {
        V1HTTPGetAction v1HTTPGetAction = instance = instance != null ? instance : new V1HTTPGetAction();
        if (instance != null) {
            this.withHost(instance.getHost());
            this.withHttpHeaders(instance.getHttpHeaders());
            this.withPath(instance.getPath());
            this.withPort(instance.getPort());
            this.withScheme(instance.getScheme());
        }
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public A addToHttpHeaders(int index, V1HTTPHeader item) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        V1HTTPHeaderBuilder builder = new V1HTTPHeaderBuilder(item);
        if (index < 0 || index >= this.httpHeaders.size()) {
            this._visitables.get("httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        } else {
            this._visitables.get("httpHeaders").add(index, builder);
            this.httpHeaders.add(index, builder);
        }
        return (A)this;
    }

    public A setToHttpHeaders(int index, V1HTTPHeader item) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        V1HTTPHeaderBuilder builder = new V1HTTPHeaderBuilder(item);
        if (index < 0 || index >= this.httpHeaders.size()) {
            this._visitables.get("httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        } else {
            this._visitables.get("httpHeaders").set(index, builder);
            this.httpHeaders.set(index, builder);
        }
        return (A)this;
    }

    public A addToHttpHeaders(V1HTTPHeader ... items) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        for (V1HTTPHeader item : items) {
            V1HTTPHeaderBuilder builder = new V1HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)this;
    }

    public A addAllToHttpHeaders(Collection<V1HTTPHeader> items) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        for (V1HTTPHeader item : items) {
            V1HTTPHeaderBuilder builder = new V1HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)this;
    }

    public A removeFromHttpHeaders(V1HTTPHeader ... items) {
        if (this.httpHeaders == null) {
            return (A)this;
        }
        for (V1HTTPHeader item : items) {
            V1HTTPHeaderBuilder builder = new V1HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").remove(builder);
            this.httpHeaders.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromHttpHeaders(Collection<V1HTTPHeader> items) {
        if (this.httpHeaders == null) {
            return (A)this;
        }
        for (V1HTTPHeader item : items) {
            V1HTTPHeaderBuilder builder = new V1HTTPHeaderBuilder(item);
            this._visitables.get("httpHeaders").remove(builder);
            this.httpHeaders.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromHttpHeaders(Predicate<V1HTTPHeaderBuilder> predicate) {
        if (this.httpHeaders == null) {
            return (A)this;
        }
        Iterator<V1HTTPHeaderBuilder> each = this.httpHeaders.iterator();
        Object visitables = this._visitables.get("httpHeaders");
        while (each.hasNext()) {
            V1HTTPHeaderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1HTTPHeader> buildHttpHeaders() {
        return this.httpHeaders != null ? V1HTTPGetActionFluent.build(this.httpHeaders) : null;
    }

    public V1HTTPHeader buildHttpHeader(int index) {
        return this.httpHeaders.get(index).build();
    }

    public V1HTTPHeader buildFirstHttpHeader() {
        return this.httpHeaders.get(0).build();
    }

    public V1HTTPHeader buildLastHttpHeader() {
        return this.httpHeaders.get(this.httpHeaders.size() - 1).build();
    }

    public V1HTTPHeader buildMatchingHttpHeader(Predicate<V1HTTPHeaderBuilder> predicate) {
        for (V1HTTPHeaderBuilder item : this.httpHeaders) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHttpHeader(Predicate<V1HTTPHeaderBuilder> predicate) {
        for (V1HTTPHeaderBuilder item : this.httpHeaders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHttpHeaders(List<V1HTTPHeader> httpHeaders) {
        if (this.httpHeaders != null) {
            this._visitables.get("httpHeaders").clear();
        }
        if (httpHeaders != null) {
            this.httpHeaders = new ArrayList();
            for (V1HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        } else {
            this.httpHeaders = null;
        }
        return (A)this;
    }

    public A withHttpHeaders(V1HTTPHeader ... httpHeaders) {
        if (this.httpHeaders != null) {
            this.httpHeaders.clear();
            this._visitables.remove("httpHeaders");
        }
        if (httpHeaders != null) {
            for (V1HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        }
        return (A)this;
    }

    public boolean hasHttpHeaders() {
        return this.httpHeaders != null && !this.httpHeaders.isEmpty();
    }

    public HttpHeadersNested<A> addNewHttpHeader() {
        return new HttpHeadersNested(-1, null);
    }

    public HttpHeadersNested<A> addNewHttpHeaderLike(V1HTTPHeader item) {
        return new HttpHeadersNested(-1, item);
    }

    public HttpHeadersNested<A> setNewHttpHeaderLike(int index, V1HTTPHeader item) {
        return new HttpHeadersNested(index, item);
    }

    public HttpHeadersNested<A> editHttpHeader(int index) {
        if (this.httpHeaders.size() <= index) {
            throw new RuntimeException("Can't edit httpHeaders. Index exceeds size.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    public HttpHeadersNested<A> editFirstHttpHeader() {
        if (this.httpHeaders.size() == 0) {
            throw new RuntimeException("Can't edit first httpHeaders. The list is empty.");
        }
        return this.setNewHttpHeaderLike(0, this.buildHttpHeader(0));
    }

    public HttpHeadersNested<A> editLastHttpHeader() {
        int index = this.httpHeaders.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last httpHeaders. The list is empty.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    public HttpHeadersNested<A> editMatchingHttpHeader(Predicate<V1HTTPHeaderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.httpHeaders.size(); ++i) {
            if (!predicate.test(this.httpHeaders.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching httpHeaders. No match found.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public IntOrString getPort() {
        return this.port;
    }

    public A withPort(IntOrString port) {
        this.port = port;
        return (A)this;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(int value) {
        return this.withPort(new IntOrString(value));
    }

    public A withNewPort(String value) {
        return this.withPort(new IntOrString(value));
    }

    public String getScheme() {
        return this.scheme;
    }

    public A withScheme(String scheme) {
        this.scheme = scheme;
        return (A)this;
    }

    public boolean hasScheme() {
        return this.scheme != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1HTTPGetActionFluent that = (V1HTTPGetActionFluent)o;
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.httpHeaders, that.httpHeaders)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        return Objects.equals(this.scheme, that.scheme);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.host, this.httpHeaders, this.path, this.port, this.scheme, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.httpHeaders != null && !this.httpHeaders.isEmpty()) {
            sb.append("httpHeaders:");
            sb.append(this.httpHeaders + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.scheme != null) {
            sb.append("scheme:");
            sb.append(this.scheme);
        }
        sb.append("}");
        return sb.toString();
    }

    public class HttpHeadersNested<N>
    extends V1HTTPHeaderFluent<HttpHeadersNested<N>>
    implements Nested<N> {
        V1HTTPHeaderBuilder builder;
        int index;

        HttpHeadersNested(int index, V1HTTPHeader item) {
            this.index = index;
            this.builder = new V1HTTPHeaderBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1HTTPGetActionFluent.this.setToHttpHeaders(this.index, this.builder.build());
        }

        public N endHttpHeader() {
            return this.and();
        }
    }
}

