/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1FlexVolumeSource;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class V1FlexVolumeSourceFluent<A extends V1FlexVolumeSourceFluent<A>>
extends BaseFluent<A> {
    private String driver;
    private String fsType;
    private Map<String, String> options;
    private Boolean readOnly;
    private V1LocalObjectReferenceBuilder secretRef;

    public V1FlexVolumeSourceFluent() {
    }

    public V1FlexVolumeSourceFluent(V1FlexVolumeSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1FlexVolumeSource instance) {
        V1FlexVolumeSource v1FlexVolumeSource = instance = instance != null ? instance : new V1FlexVolumeSource();
        if (instance != null) {
            this.withDriver(instance.getDriver());
            this.withFsType(instance.getFsType());
            this.withOptions(instance.getOptions());
            this.withReadOnly(instance.getReadOnly());
            this.withSecretRef(instance.getSecretRef());
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public A withDriver(String driver) {
        this.driver = driver;
        return (A)this;
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    public boolean hasFsType() {
        return this.fsType != null;
    }

    public A addToOptions(String key, String value) {
        if (this.options == null && key != null && value != null) {
            this.options = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.options.put(key, value);
        }
        return (A)this;
    }

    public A addToOptions(Map<String, String> map) {
        if (this.options == null && map != null) {
            this.options = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.options.putAll(map);
        }
        return (A)this;
    }

    public A removeFromOptions(String key) {
        if (this.options == null) {
            return (A)this;
        }
        if (key != null && this.options != null) {
            this.options.remove(key);
        }
        return (A)this;
    }

    public A removeFromOptions(Map<String, String> map) {
        if (this.options == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.options == null) continue;
                this.options.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public <K, V> A withOptions(Map<String, String> options) {
        this.options = options == null ? null : new LinkedHashMap<String, String>(options);
        return (A)this;
    }

    public boolean hasOptions() {
        return this.options != null;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    public boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public V1LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(V1LocalObjectReference secretRef) {
        this._visitables.remove("secretRef");
        if (secretRef != null) {
            this.secretRef = new V1LocalObjectReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get("secretRef").remove(this.secretRef);
        }
        return (A)this;
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public SecretRefNested<A> withNewSecretRefLike(V1LocalObjectReference item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new V1LocalObjectReferenceBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(V1LocalObjectReference item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1FlexVolumeSourceFluent that = (V1FlexVolumeSourceFluent)o;
        if (!Objects.equals(this.driver, that.driver)) {
            return false;
        }
        if (!Objects.equals(this.fsType, that.fsType)) {
            return false;
        }
        if (!Objects.equals(this.options, that.options)) {
            return false;
        }
        if (!Objects.equals(this.readOnly, that.readOnly)) {
            return false;
        }
        return Objects.equals(this.secretRef, that.secretRef);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.driver, this.fsType, this.options, this.readOnly, this.secretRef, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver + ",");
        }
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.options != null && !this.options.isEmpty()) {
            sb.append("options:");
            sb.append(this.options + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append(this.secretRef);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    public class SecretRefNested<N>
    extends V1LocalObjectReferenceFluent<SecretRefNested<N>>
    implements Nested<N> {
        V1LocalObjectReferenceBuilder builder;

        SecretRefNested(V1LocalObjectReference item) {
            this.builder = new V1LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1FlexVolumeSourceFluent.this.withSecretRef(this.builder.build());
        }

        public N endSecretRef() {
            return this.and();
        }
    }
}

