/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1DeleteOptionsBuilder;
import io.kubernetes.client.openapi.models.V1DeleteOptionsFluent;
import io.kubernetes.client.openapi.models.V1Eviction;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import java.util.Objects;
import java.util.Optional;

public class V1EvictionFluent<A extends V1EvictionFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private V1DeleteOptionsBuilder deleteOptions;
    private String kind;
    private V1ObjectMetaBuilder metadata;

    public V1EvictionFluent() {
    }

    public V1EvictionFluent(V1Eviction instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1Eviction instance) {
        V1Eviction v1Eviction = instance = instance != null ? instance : new V1Eviction();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDeleteOptions(instance.getDeleteOptions());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public V1DeleteOptions buildDeleteOptions() {
        return this.deleteOptions != null ? this.deleteOptions.build() : null;
    }

    public A withDeleteOptions(V1DeleteOptions deleteOptions) {
        this._visitables.remove("deleteOptions");
        if (deleteOptions != null) {
            this.deleteOptions = new V1DeleteOptionsBuilder(deleteOptions);
            this._visitables.get("deleteOptions").add(this.deleteOptions);
        } else {
            this.deleteOptions = null;
            this._visitables.get("deleteOptions").remove(this.deleteOptions);
        }
        return (A)this;
    }

    public boolean hasDeleteOptions() {
        return this.deleteOptions != null;
    }

    public DeleteOptionsNested<A> withNewDeleteOptions() {
        return new DeleteOptionsNested(null);
    }

    public DeleteOptionsNested<A> withNewDeleteOptionsLike(V1DeleteOptions item) {
        return new DeleteOptionsNested(item);
    }

    public DeleteOptionsNested<A> editDeleteOptions() {
        return this.withNewDeleteOptionsLike(Optional.ofNullable(this.buildDeleteOptions()).orElse(null));
    }

    public DeleteOptionsNested<A> editOrNewDeleteOptions() {
        return this.withNewDeleteOptionsLike(Optional.ofNullable(this.buildDeleteOptions()).orElse(new V1DeleteOptionsBuilder().build()));
    }

    public DeleteOptionsNested<A> editOrNewDeleteOptionsLike(V1DeleteOptions item) {
        return this.withNewDeleteOptionsLike(Optional.ofNullable(this.buildDeleteOptions()).orElse(item));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1EvictionFluent that = (V1EvictionFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.deleteOptions, that.deleteOptions)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.metadata, that.metadata);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.deleteOptions, this.kind, this.metadata, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.deleteOptions != null) {
            sb.append("deleteOptions:");
            sb.append(this.deleteOptions + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DeleteOptionsNested<N>
    extends V1DeleteOptionsFluent<DeleteOptionsNested<N>>
    implements Nested<N> {
        V1DeleteOptionsBuilder builder;

        DeleteOptionsNested(V1DeleteOptions item) {
            this.builder = new V1DeleteOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1EvictionFluent.this.withDeleteOptions(this.builder.build());
        }

        public N endDeleteOptions() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1EvictionFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

