/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CustomResourceConversion;
import io.kubernetes.client.openapi.models.V1CustomResourceConversionBuilder;
import io.kubernetes.client.openapi.models.V1CustomResourceConversionFluent;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionNames;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionNamesBuilder;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionNamesFluent;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionSpec;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionVersion;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionVersionBuilder;
import io.kubernetes.client.openapi.models.V1CustomResourceDefinitionVersionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1CustomResourceDefinitionSpecFluent<A extends V1CustomResourceDefinitionSpecFluent<A>>
extends BaseFluent<A> {
    private V1CustomResourceConversionBuilder conversion;
    private String group;
    private V1CustomResourceDefinitionNamesBuilder names;
    private Boolean preserveUnknownFields;
    private String scope;
    private ArrayList<V1CustomResourceDefinitionVersionBuilder> versions;

    public V1CustomResourceDefinitionSpecFluent() {
    }

    public V1CustomResourceDefinitionSpecFluent(V1CustomResourceDefinitionSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1CustomResourceDefinitionSpec instance) {
        V1CustomResourceDefinitionSpec v1CustomResourceDefinitionSpec = instance = instance != null ? instance : new V1CustomResourceDefinitionSpec();
        if (instance != null) {
            this.withConversion(instance.getConversion());
            this.withGroup(instance.getGroup());
            this.withNames(instance.getNames());
            this.withPreserveUnknownFields(instance.getPreserveUnknownFields());
            this.withScope(instance.getScope());
            this.withVersions(instance.getVersions());
        }
    }

    public V1CustomResourceConversion buildConversion() {
        return this.conversion != null ? this.conversion.build() : null;
    }

    public A withConversion(V1CustomResourceConversion conversion) {
        this._visitables.remove("conversion");
        if (conversion != null) {
            this.conversion = new V1CustomResourceConversionBuilder(conversion);
            this._visitables.get("conversion").add(this.conversion);
        } else {
            this.conversion = null;
            this._visitables.get("conversion").remove(this.conversion);
        }
        return (A)this;
    }

    public boolean hasConversion() {
        return this.conversion != null;
    }

    public ConversionNested<A> withNewConversion() {
        return new ConversionNested(null);
    }

    public ConversionNested<A> withNewConversionLike(V1CustomResourceConversion item) {
        return new ConversionNested(item);
    }

    public ConversionNested<A> editConversion() {
        return this.withNewConversionLike(Optional.ofNullable(this.buildConversion()).orElse(null));
    }

    public ConversionNested<A> editOrNewConversion() {
        return this.withNewConversionLike(Optional.ofNullable(this.buildConversion()).orElse(new V1CustomResourceConversionBuilder().build()));
    }

    public ConversionNested<A> editOrNewConversionLike(V1CustomResourceConversion item) {
        return this.withNewConversionLike(Optional.ofNullable(this.buildConversion()).orElse(item));
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public V1CustomResourceDefinitionNames buildNames() {
        return this.names != null ? this.names.build() : null;
    }

    public A withNames(V1CustomResourceDefinitionNames names) {
        this._visitables.remove("names");
        if (names != null) {
            this.names = new V1CustomResourceDefinitionNamesBuilder(names);
            this._visitables.get("names").add(this.names);
        } else {
            this.names = null;
            this._visitables.get("names").remove(this.names);
        }
        return (A)this;
    }

    public boolean hasNames() {
        return this.names != null;
    }

    public NamesNested<A> withNewNames() {
        return new NamesNested(null);
    }

    public NamesNested<A> withNewNamesLike(V1CustomResourceDefinitionNames item) {
        return new NamesNested(item);
    }

    public NamesNested<A> editNames() {
        return this.withNewNamesLike(Optional.ofNullable(this.buildNames()).orElse(null));
    }

    public NamesNested<A> editOrNewNames() {
        return this.withNewNamesLike(Optional.ofNullable(this.buildNames()).orElse(new V1CustomResourceDefinitionNamesBuilder().build()));
    }

    public NamesNested<A> editOrNewNamesLike(V1CustomResourceDefinitionNames item) {
        return this.withNewNamesLike(Optional.ofNullable(this.buildNames()).orElse(item));
    }

    public Boolean getPreserveUnknownFields() {
        return this.preserveUnknownFields;
    }

    public A withPreserveUnknownFields(Boolean preserveUnknownFields) {
        this.preserveUnknownFields = preserveUnknownFields;
        return (A)this;
    }

    public boolean hasPreserveUnknownFields() {
        return this.preserveUnknownFields != null;
    }

    public String getScope() {
        return this.scope;
    }

    public A withScope(String scope) {
        this.scope = scope;
        return (A)this;
    }

    public boolean hasScope() {
        return this.scope != null;
    }

    public A addToVersions(int index, V1CustomResourceDefinitionVersion item) {
        if (this.versions == null) {
            this.versions = new ArrayList();
        }
        V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);
        if (index < 0 || index >= this.versions.size()) {
            this._visitables.get("versions").add(builder);
            this.versions.add(builder);
        } else {
            this._visitables.get("versions").add(index, builder);
            this.versions.add(index, builder);
        }
        return (A)this;
    }

    public A setToVersions(int index, V1CustomResourceDefinitionVersion item) {
        if (this.versions == null) {
            this.versions = new ArrayList();
        }
        V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);
        if (index < 0 || index >= this.versions.size()) {
            this._visitables.get("versions").add(builder);
            this.versions.add(builder);
        } else {
            this._visitables.get("versions").set(index, builder);
            this.versions.set(index, builder);
        }
        return (A)this;
    }

    public A addToVersions(V1CustomResourceDefinitionVersion ... items) {
        if (this.versions == null) {
            this.versions = new ArrayList();
        }
        for (V1CustomResourceDefinitionVersion item : items) {
            V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);
            this._visitables.get("versions").add(builder);
            this.versions.add(builder);
        }
        return (A)this;
    }

    public A addAllToVersions(Collection<V1CustomResourceDefinitionVersion> items) {
        if (this.versions == null) {
            this.versions = new ArrayList();
        }
        for (V1CustomResourceDefinitionVersion item : items) {
            V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);
            this._visitables.get("versions").add(builder);
            this.versions.add(builder);
        }
        return (A)this;
    }

    public A removeFromVersions(V1CustomResourceDefinitionVersion ... items) {
        if (this.versions == null) {
            return (A)this;
        }
        for (V1CustomResourceDefinitionVersion item : items) {
            V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);
            this._visitables.get("versions").remove(builder);
            this.versions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVersions(Collection<V1CustomResourceDefinitionVersion> items) {
        if (this.versions == null) {
            return (A)this;
        }
        for (V1CustomResourceDefinitionVersion item : items) {
            V1CustomResourceDefinitionVersionBuilder builder = new V1CustomResourceDefinitionVersionBuilder(item);
            this._visitables.get("versions").remove(builder);
            this.versions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVersions(Predicate<V1CustomResourceDefinitionVersionBuilder> predicate) {
        if (this.versions == null) {
            return (A)this;
        }
        Iterator<V1CustomResourceDefinitionVersionBuilder> each = this.versions.iterator();
        Object visitables = this._visitables.get("versions");
        while (each.hasNext()) {
            V1CustomResourceDefinitionVersionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1CustomResourceDefinitionVersion> buildVersions() {
        return this.versions != null ? V1CustomResourceDefinitionSpecFluent.build(this.versions) : null;
    }

    public V1CustomResourceDefinitionVersion buildVersion(int index) {
        return this.versions.get(index).build();
    }

    public V1CustomResourceDefinitionVersion buildFirstVersion() {
        return this.versions.get(0).build();
    }

    public V1CustomResourceDefinitionVersion buildLastVersion() {
        return this.versions.get(this.versions.size() - 1).build();
    }

    public V1CustomResourceDefinitionVersion buildMatchingVersion(Predicate<V1CustomResourceDefinitionVersionBuilder> predicate) {
        for (V1CustomResourceDefinitionVersionBuilder item : this.versions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVersion(Predicate<V1CustomResourceDefinitionVersionBuilder> predicate) {
        for (V1CustomResourceDefinitionVersionBuilder item : this.versions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVersions(List<V1CustomResourceDefinitionVersion> versions) {
        if (this.versions != null) {
            this._visitables.get("versions").clear();
        }
        if (versions != null) {
            this.versions = new ArrayList();
            for (V1CustomResourceDefinitionVersion item : versions) {
                this.addToVersions(item);
            }
        } else {
            this.versions = null;
        }
        return (A)this;
    }

    public A withVersions(V1CustomResourceDefinitionVersion ... versions) {
        if (this.versions != null) {
            this.versions.clear();
            this._visitables.remove("versions");
        }
        if (versions != null) {
            for (V1CustomResourceDefinitionVersion item : versions) {
                this.addToVersions(item);
            }
        }
        return (A)this;
    }

    public boolean hasVersions() {
        return this.versions != null && !this.versions.isEmpty();
    }

    public VersionsNested<A> addNewVersion() {
        return new VersionsNested(-1, null);
    }

    public VersionsNested<A> addNewVersionLike(V1CustomResourceDefinitionVersion item) {
        return new VersionsNested(-1, item);
    }

    public VersionsNested<A> setNewVersionLike(int index, V1CustomResourceDefinitionVersion item) {
        return new VersionsNested(index, item);
    }

    public VersionsNested<A> editVersion(int index) {
        if (this.versions.size() <= index) {
            throw new RuntimeException("Can't edit versions. Index exceeds size.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    public VersionsNested<A> editFirstVersion() {
        if (this.versions.size() == 0) {
            throw new RuntimeException("Can't edit first versions. The list is empty.");
        }
        return this.setNewVersionLike(0, this.buildVersion(0));
    }

    public VersionsNested<A> editLastVersion() {
        int index = this.versions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last versions. The list is empty.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    public VersionsNested<A> editMatchingVersion(Predicate<V1CustomResourceDefinitionVersionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.versions.size(); ++i) {
            if (!predicate.test(this.versions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching versions. No match found.");
        }
        return this.setNewVersionLike(index, this.buildVersion(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1CustomResourceDefinitionSpecFluent that = (V1CustomResourceDefinitionSpecFluent)o;
        if (!Objects.equals(this.conversion, that.conversion)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.names, that.names)) {
            return false;
        }
        if (!Objects.equals(this.preserveUnknownFields, that.preserveUnknownFields)) {
            return false;
        }
        if (!Objects.equals(this.scope, that.scope)) {
            return false;
        }
        return Objects.equals(this.versions, that.versions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conversion, this.group, this.names, this.preserveUnknownFields, this.scope, this.versions, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conversion != null) {
            sb.append("conversion:");
            sb.append(this.conversion + ",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.names != null) {
            sb.append("names:");
            sb.append(this.names + ",");
        }
        if (this.preserveUnknownFields != null) {
            sb.append("preserveUnknownFields:");
            sb.append(this.preserveUnknownFields + ",");
        }
        if (this.scope != null) {
            sb.append("scope:");
            sb.append(this.scope + ",");
        }
        if (this.versions != null && !this.versions.isEmpty()) {
            sb.append("versions:");
            sb.append(this.versions);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withPreserveUnknownFields() {
        return this.withPreserveUnknownFields(true);
    }

    public class ConversionNested<N>
    extends V1CustomResourceConversionFluent<ConversionNested<N>>
    implements Nested<N> {
        V1CustomResourceConversionBuilder builder;

        ConversionNested(V1CustomResourceConversion item) {
            this.builder = new V1CustomResourceConversionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1CustomResourceDefinitionSpecFluent.this.withConversion(this.builder.build());
        }

        public N endConversion() {
            return this.and();
        }
    }

    public class NamesNested<N>
    extends V1CustomResourceDefinitionNamesFluent<NamesNested<N>>
    implements Nested<N> {
        V1CustomResourceDefinitionNamesBuilder builder;

        NamesNested(V1CustomResourceDefinitionNames item) {
            this.builder = new V1CustomResourceDefinitionNamesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1CustomResourceDefinitionSpecFluent.this.withNames(this.builder.build());
        }

        public N endNames() {
            return this.and();
        }
    }

    public class VersionsNested<N>
    extends V1CustomResourceDefinitionVersionFluent<VersionsNested<N>>
    implements Nested<N> {
        V1CustomResourceDefinitionVersionBuilder builder;
        int index;

        VersionsNested(int index, V1CustomResourceDefinitionVersion item) {
            this.index = index;
            this.builder = new V1CustomResourceDefinitionVersionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1CustomResourceDefinitionSpecFluent.this.setToVersions(this.index, this.builder.build());
        }

        public N endVersion() {
            return this.and();
        }
    }
}

