/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ContainerState;
import io.kubernetes.client.openapi.models.V1ContainerStateBuilder;
import io.kubernetes.client.openapi.models.V1ContainerStateFluent;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1ContainerUser;
import io.kubernetes.client.openapi.models.V1ContainerUserBuilder;
import io.kubernetes.client.openapi.models.V1ContainerUserFluent;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1ResourceRequirementsBuilder;
import io.kubernetes.client.openapi.models.V1ResourceRequirementsFluent;
import io.kubernetes.client.openapi.models.V1ResourceStatus;
import io.kubernetes.client.openapi.models.V1ResourceStatusBuilder;
import io.kubernetes.client.openapi.models.V1ResourceStatusFluent;
import io.kubernetes.client.openapi.models.V1VolumeMountStatus;
import io.kubernetes.client.openapi.models.V1VolumeMountStatusBuilder;
import io.kubernetes.client.openapi.models.V1VolumeMountStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1ContainerStatusFluent<A extends V1ContainerStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Quantity> allocatedResources;
    private ArrayList<V1ResourceStatusBuilder> allocatedResourcesStatus;
    private String containerID;
    private String image;
    private String imageID;
    private V1ContainerStateBuilder lastState;
    private String name;
    private Boolean ready;
    private V1ResourceRequirementsBuilder resources;
    private Integer restartCount;
    private Boolean started;
    private V1ContainerStateBuilder state;
    private V1ContainerUserBuilder user;
    private ArrayList<V1VolumeMountStatusBuilder> volumeMounts;

    public V1ContainerStatusFluent() {
    }

    public V1ContainerStatusFluent(V1ContainerStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1ContainerStatus instance) {
        V1ContainerStatus v1ContainerStatus = instance = instance != null ? instance : new V1ContainerStatus();
        if (instance != null) {
            this.withAllocatedResources(instance.getAllocatedResources());
            this.withAllocatedResourcesStatus(instance.getAllocatedResourcesStatus());
            this.withContainerID(instance.getContainerID());
            this.withImage(instance.getImage());
            this.withImageID(instance.getImageID());
            this.withLastState(instance.getLastState());
            this.withName(instance.getName());
            this.withReady(instance.getReady());
            this.withResources(instance.getResources());
            this.withRestartCount(instance.getRestartCount());
            this.withStarted(instance.getStarted());
            this.withState(instance.getState());
            this.withUser(instance.getUser());
            this.withVolumeMounts(instance.getVolumeMounts());
        }
    }

    public A addToAllocatedResources(String key, Quantity value) {
        if (this.allocatedResources == null && key != null && value != null) {
            this.allocatedResources = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.allocatedResources.put(key, value);
        }
        return (A)this;
    }

    public A addToAllocatedResources(Map<String, Quantity> map) {
        if (this.allocatedResources == null && map != null) {
            this.allocatedResources = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.allocatedResources.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAllocatedResources(String key) {
        if (this.allocatedResources == null) {
            return (A)this;
        }
        if (key != null && this.allocatedResources != null) {
            this.allocatedResources.remove(key);
        }
        return (A)this;
    }

    public A removeFromAllocatedResources(Map<String, Quantity> map) {
        if (this.allocatedResources == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.allocatedResources == null) continue;
                this.allocatedResources.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Quantity> getAllocatedResources() {
        return this.allocatedResources;
    }

    public <K, V> A withAllocatedResources(Map<String, Quantity> allocatedResources) {
        this.allocatedResources = allocatedResources == null ? null : new LinkedHashMap<String, Quantity>(allocatedResources);
        return (A)this;
    }

    public boolean hasAllocatedResources() {
        return this.allocatedResources != null;
    }

    public A addToAllocatedResourcesStatus(int index, V1ResourceStatus item) {
        if (this.allocatedResourcesStatus == null) {
            this.allocatedResourcesStatus = new ArrayList();
        }
        V1ResourceStatusBuilder builder = new V1ResourceStatusBuilder(item);
        if (index < 0 || index >= this.allocatedResourcesStatus.size()) {
            this._visitables.get("allocatedResourcesStatus").add(builder);
            this.allocatedResourcesStatus.add(builder);
        } else {
            this._visitables.get("allocatedResourcesStatus").add(index, builder);
            this.allocatedResourcesStatus.add(index, builder);
        }
        return (A)this;
    }

    public A setToAllocatedResourcesStatus(int index, V1ResourceStatus item) {
        if (this.allocatedResourcesStatus == null) {
            this.allocatedResourcesStatus = new ArrayList();
        }
        V1ResourceStatusBuilder builder = new V1ResourceStatusBuilder(item);
        if (index < 0 || index >= this.allocatedResourcesStatus.size()) {
            this._visitables.get("allocatedResourcesStatus").add(builder);
            this.allocatedResourcesStatus.add(builder);
        } else {
            this._visitables.get("allocatedResourcesStatus").set(index, builder);
            this.allocatedResourcesStatus.set(index, builder);
        }
        return (A)this;
    }

    public A addToAllocatedResourcesStatus(V1ResourceStatus ... items) {
        if (this.allocatedResourcesStatus == null) {
            this.allocatedResourcesStatus = new ArrayList();
        }
        for (V1ResourceStatus item : items) {
            V1ResourceStatusBuilder builder = new V1ResourceStatusBuilder(item);
            this._visitables.get("allocatedResourcesStatus").add(builder);
            this.allocatedResourcesStatus.add(builder);
        }
        return (A)this;
    }

    public A addAllToAllocatedResourcesStatus(Collection<V1ResourceStatus> items) {
        if (this.allocatedResourcesStatus == null) {
            this.allocatedResourcesStatus = new ArrayList();
        }
        for (V1ResourceStatus item : items) {
            V1ResourceStatusBuilder builder = new V1ResourceStatusBuilder(item);
            this._visitables.get("allocatedResourcesStatus").add(builder);
            this.allocatedResourcesStatus.add(builder);
        }
        return (A)this;
    }

    public A removeFromAllocatedResourcesStatus(V1ResourceStatus ... items) {
        if (this.allocatedResourcesStatus == null) {
            return (A)this;
        }
        for (V1ResourceStatus item : items) {
            V1ResourceStatusBuilder builder = new V1ResourceStatusBuilder(item);
            this._visitables.get("allocatedResourcesStatus").remove(builder);
            this.allocatedResourcesStatus.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAllocatedResourcesStatus(Collection<V1ResourceStatus> items) {
        if (this.allocatedResourcesStatus == null) {
            return (A)this;
        }
        for (V1ResourceStatus item : items) {
            V1ResourceStatusBuilder builder = new V1ResourceStatusBuilder(item);
            this._visitables.get("allocatedResourcesStatus").remove(builder);
            this.allocatedResourcesStatus.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAllocatedResourcesStatus(Predicate<V1ResourceStatusBuilder> predicate) {
        if (this.allocatedResourcesStatus == null) {
            return (A)this;
        }
        Iterator<V1ResourceStatusBuilder> each = this.allocatedResourcesStatus.iterator();
        Object visitables = this._visitables.get("allocatedResourcesStatus");
        while (each.hasNext()) {
            V1ResourceStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1ResourceStatus> buildAllocatedResourcesStatus() {
        return this.allocatedResourcesStatus != null ? V1ContainerStatusFluent.build(this.allocatedResourcesStatus) : null;
    }

    public V1ResourceStatus buildAllocatedResourcesStatus(int index) {
        return this.allocatedResourcesStatus.get(index).build();
    }

    public V1ResourceStatus buildFirstAllocatedResourcesStatus() {
        return this.allocatedResourcesStatus.get(0).build();
    }

    public V1ResourceStatus buildLastAllocatedResourcesStatus() {
        return this.allocatedResourcesStatus.get(this.allocatedResourcesStatus.size() - 1).build();
    }

    public V1ResourceStatus buildMatchingAllocatedResourcesStatus(Predicate<V1ResourceStatusBuilder> predicate) {
        for (V1ResourceStatusBuilder item : this.allocatedResourcesStatus) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAllocatedResourcesStatus(Predicate<V1ResourceStatusBuilder> predicate) {
        for (V1ResourceStatusBuilder item : this.allocatedResourcesStatus) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAllocatedResourcesStatus(List<V1ResourceStatus> allocatedResourcesStatus) {
        if (this.allocatedResourcesStatus != null) {
            this._visitables.get("allocatedResourcesStatus").clear();
        }
        if (allocatedResourcesStatus != null) {
            this.allocatedResourcesStatus = new ArrayList();
            for (V1ResourceStatus item : allocatedResourcesStatus) {
                this.addToAllocatedResourcesStatus(item);
            }
        } else {
            this.allocatedResourcesStatus = null;
        }
        return (A)this;
    }

    public A withAllocatedResourcesStatus(V1ResourceStatus ... allocatedResourcesStatus) {
        if (this.allocatedResourcesStatus != null) {
            this.allocatedResourcesStatus.clear();
            this._visitables.remove("allocatedResourcesStatus");
        }
        if (allocatedResourcesStatus != null) {
            for (V1ResourceStatus item : allocatedResourcesStatus) {
                this.addToAllocatedResourcesStatus(item);
            }
        }
        return (A)this;
    }

    public boolean hasAllocatedResourcesStatus() {
        return this.allocatedResourcesStatus != null && !this.allocatedResourcesStatus.isEmpty();
    }

    public AllocatedResourcesStatusNested<A> addNewAllocatedResourcesStatus() {
        return new AllocatedResourcesStatusNested(-1, null);
    }

    public AllocatedResourcesStatusNested<A> addNewAllocatedResourcesStatusLike(V1ResourceStatus item) {
        return new AllocatedResourcesStatusNested(-1, item);
    }

    public AllocatedResourcesStatusNested<A> setNewAllocatedResourcesStatusLike(int index, V1ResourceStatus item) {
        return new AllocatedResourcesStatusNested(index, item);
    }

    public AllocatedResourcesStatusNested<A> editAllocatedResourcesStatus(int index) {
        if (this.allocatedResourcesStatus.size() <= index) {
            throw new RuntimeException("Can't edit allocatedResourcesStatus. Index exceeds size.");
        }
        return this.setNewAllocatedResourcesStatusLike(index, this.buildAllocatedResourcesStatus(index));
    }

    public AllocatedResourcesStatusNested<A> editFirstAllocatedResourcesStatus() {
        if (this.allocatedResourcesStatus.size() == 0) {
            throw new RuntimeException("Can't edit first allocatedResourcesStatus. The list is empty.");
        }
        return this.setNewAllocatedResourcesStatusLike(0, this.buildAllocatedResourcesStatus(0));
    }

    public AllocatedResourcesStatusNested<A> editLastAllocatedResourcesStatus() {
        int index = this.allocatedResourcesStatus.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last allocatedResourcesStatus. The list is empty.");
        }
        return this.setNewAllocatedResourcesStatusLike(index, this.buildAllocatedResourcesStatus(index));
    }

    public AllocatedResourcesStatusNested<A> editMatchingAllocatedResourcesStatus(Predicate<V1ResourceStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.allocatedResourcesStatus.size(); ++i) {
            if (!predicate.test(this.allocatedResourcesStatus.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching allocatedResourcesStatus. No match found.");
        }
        return this.setNewAllocatedResourcesStatusLike(index, this.buildAllocatedResourcesStatus(index));
    }

    public String getContainerID() {
        return this.containerID;
    }

    public A withContainerID(String containerID) {
        this.containerID = containerID;
        return (A)this;
    }

    public boolean hasContainerID() {
        return this.containerID != null;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getImageID() {
        return this.imageID;
    }

    public A withImageID(String imageID) {
        this.imageID = imageID;
        return (A)this;
    }

    public boolean hasImageID() {
        return this.imageID != null;
    }

    public V1ContainerState buildLastState() {
        return this.lastState != null ? this.lastState.build() : null;
    }

    public A withLastState(V1ContainerState lastState) {
        this._visitables.remove("lastState");
        if (lastState != null) {
            this.lastState = new V1ContainerStateBuilder(lastState);
            this._visitables.get("lastState").add(this.lastState);
        } else {
            this.lastState = null;
            this._visitables.get("lastState").remove(this.lastState);
        }
        return (A)this;
    }

    public boolean hasLastState() {
        return this.lastState != null;
    }

    public LastStateNested<A> withNewLastState() {
        return new LastStateNested(null);
    }

    public LastStateNested<A> withNewLastStateLike(V1ContainerState item) {
        return new LastStateNested(item);
    }

    public LastStateNested<A> editLastState() {
        return this.withNewLastStateLike(Optional.ofNullable(this.buildLastState()).orElse(null));
    }

    public LastStateNested<A> editOrNewLastState() {
        return this.withNewLastStateLike(Optional.ofNullable(this.buildLastState()).orElse(new V1ContainerStateBuilder().build()));
    }

    public LastStateNested<A> editOrNewLastStateLike(V1ContainerState item) {
        return this.withNewLastStateLike(Optional.ofNullable(this.buildLastState()).orElse(item));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Boolean getReady() {
        return this.ready;
    }

    public A withReady(Boolean ready) {
        this.ready = ready;
        return (A)this;
    }

    public boolean hasReady() {
        return this.ready != null;
    }

    public V1ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(V1ResourceRequirements resources) {
        this._visitables.remove("resources");
        if (resources != null) {
            this.resources = new V1ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get("resources").remove(this.resources);
        }
        return (A)this;
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(V1ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new V1ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(V1ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public Integer getRestartCount() {
        return this.restartCount;
    }

    public A withRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return (A)this;
    }

    public boolean hasRestartCount() {
        return this.restartCount != null;
    }

    public Boolean getStarted() {
        return this.started;
    }

    public A withStarted(Boolean started) {
        this.started = started;
        return (A)this;
    }

    public boolean hasStarted() {
        return this.started != null;
    }

    public V1ContainerState buildState() {
        return this.state != null ? this.state.build() : null;
    }

    public A withState(V1ContainerState state) {
        this._visitables.remove("state");
        if (state != null) {
            this.state = new V1ContainerStateBuilder(state);
            this._visitables.get("state").add(this.state);
        } else {
            this.state = null;
            this._visitables.get("state").remove(this.state);
        }
        return (A)this;
    }

    public boolean hasState() {
        return this.state != null;
    }

    public StateNested<A> withNewState() {
        return new StateNested(null);
    }

    public StateNested<A> withNewStateLike(V1ContainerState item) {
        return new StateNested(item);
    }

    public StateNested<A> editState() {
        return this.withNewStateLike(Optional.ofNullable(this.buildState()).orElse(null));
    }

    public StateNested<A> editOrNewState() {
        return this.withNewStateLike(Optional.ofNullable(this.buildState()).orElse(new V1ContainerStateBuilder().build()));
    }

    public StateNested<A> editOrNewStateLike(V1ContainerState item) {
        return this.withNewStateLike(Optional.ofNullable(this.buildState()).orElse(item));
    }

    public V1ContainerUser buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    public A withUser(V1ContainerUser user) {
        this._visitables.remove("user");
        if (user != null) {
            this.user = new V1ContainerUserBuilder(user);
            this._visitables.get("user").add(this.user);
        } else {
            this.user = null;
            this._visitables.get("user").remove(this.user);
        }
        return (A)this;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public UserNested<A> withNewUser() {
        return new UserNested(null);
    }

    public UserNested<A> withNewUserLike(V1ContainerUser item) {
        return new UserNested(item);
    }

    public UserNested<A> editUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(null));
    }

    public UserNested<A> editOrNewUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(new V1ContainerUserBuilder().build()));
    }

    public UserNested<A> editOrNewUserLike(V1ContainerUser item) {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(item));
    }

    public A addToVolumeMounts(int index, V1VolumeMountStatus item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        V1VolumeMountStatusBuilder builder = new V1VolumeMountStatusBuilder(item);
        if (index < 0 || index >= this.volumeMounts.size()) {
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        } else {
            this._visitables.get("volumeMounts").add(index, builder);
            this.volumeMounts.add(index, builder);
        }
        return (A)this;
    }

    public A setToVolumeMounts(int index, V1VolumeMountStatus item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        V1VolumeMountStatusBuilder builder = new V1VolumeMountStatusBuilder(item);
        if (index < 0 || index >= this.volumeMounts.size()) {
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        } else {
            this._visitables.get("volumeMounts").set(index, builder);
            this.volumeMounts.set(index, builder);
        }
        return (A)this;
    }

    public A addToVolumeMounts(V1VolumeMountStatus ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (V1VolumeMountStatus item : items) {
            V1VolumeMountStatusBuilder builder = new V1VolumeMountStatusBuilder(item);
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    public A addAllToVolumeMounts(Collection<V1VolumeMountStatus> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (V1VolumeMountStatus item : items) {
            V1VolumeMountStatusBuilder builder = new V1VolumeMountStatusBuilder(item);
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    public A removeFromVolumeMounts(V1VolumeMountStatus ... items) {
        if (this.volumeMounts == null) {
            return (A)this;
        }
        for (V1VolumeMountStatus item : items) {
            V1VolumeMountStatusBuilder builder = new V1VolumeMountStatusBuilder(item);
            this._visitables.get("volumeMounts").remove(builder);
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVolumeMounts(Collection<V1VolumeMountStatus> items) {
        if (this.volumeMounts == null) {
            return (A)this;
        }
        for (V1VolumeMountStatus item : items) {
            V1VolumeMountStatusBuilder builder = new V1VolumeMountStatusBuilder(item);
            this._visitables.get("volumeMounts").remove(builder);
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVolumeMounts(Predicate<V1VolumeMountStatusBuilder> predicate) {
        if (this.volumeMounts == null) {
            return (A)this;
        }
        Iterator<V1VolumeMountStatusBuilder> each = this.volumeMounts.iterator();
        Object visitables = this._visitables.get("volumeMounts");
        while (each.hasNext()) {
            V1VolumeMountStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1VolumeMountStatus> buildVolumeMounts() {
        return this.volumeMounts != null ? V1ContainerStatusFluent.build(this.volumeMounts) : null;
    }

    public V1VolumeMountStatus buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    public V1VolumeMountStatus buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    public V1VolumeMountStatus buildLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1).build();
    }

    public V1VolumeMountStatus buildMatchingVolumeMount(Predicate<V1VolumeMountStatusBuilder> predicate) {
        for (V1VolumeMountStatusBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolumeMount(Predicate<V1VolumeMountStatusBuilder> predicate) {
        for (V1VolumeMountStatusBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumeMounts(List<V1VolumeMountStatus> volumeMounts) {
        if (this.volumeMounts != null) {
            this._visitables.get("volumeMounts").clear();
        }
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList();
            for (V1VolumeMountStatus item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = null;
        }
        return (A)this;
    }

    public A withVolumeMounts(V1VolumeMountStatus ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
            this._visitables.remove("volumeMounts");
        }
        if (volumeMounts != null) {
            for (V1VolumeMountStatus item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)this;
    }

    public boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    public VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNested(-1, null);
    }

    public VolumeMountsNested<A> addNewVolumeMountLike(V1VolumeMountStatus item) {
        return new VolumeMountsNested(-1, item);
    }

    public VolumeMountsNested<A> setNewVolumeMountLike(int index, V1VolumeMountStatus item) {
        return new VolumeMountsNested(index, item);
    }

    public VolumeMountsNested<A> editVolumeMount(int index) {
        if (this.volumeMounts.size() <= index) {
            throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public VolumeMountsNested<A> editFirstVolumeMount() {
        if (this.volumeMounts.size() == 0) {
            throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(0, this.buildVolumeMount(0));
    }

    public VolumeMountsNested<A> editLastVolumeMount() {
        int index = this.volumeMounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public VolumeMountsNested<A> editMatchingVolumeMount(Predicate<V1VolumeMountStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeMounts.size(); ++i) {
            if (!predicate.test(this.volumeMounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ContainerStatusFluent that = (V1ContainerStatusFluent)o;
        if (!Objects.equals(this.allocatedResources, that.allocatedResources)) {
            return false;
        }
        if (!Objects.equals(this.allocatedResourcesStatus, that.allocatedResourcesStatus)) {
            return false;
        }
        if (!Objects.equals(this.containerID, that.containerID)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.imageID, that.imageID)) {
            return false;
        }
        if (!Objects.equals(this.lastState, that.lastState)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.ready, that.ready)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.restartCount, that.restartCount)) {
            return false;
        }
        if (!Objects.equals(this.started, that.started)) {
            return false;
        }
        if (!Objects.equals(this.state, that.state)) {
            return false;
        }
        if (!Objects.equals(this.user, that.user)) {
            return false;
        }
        return Objects.equals(this.volumeMounts, that.volumeMounts);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allocatedResources, this.allocatedResourcesStatus, this.containerID, this.image, this.imageID, this.lastState, this.name, this.ready, this.resources, this.restartCount, this.started, this.state, this.user, this.volumeMounts, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocatedResources != null && !this.allocatedResources.isEmpty()) {
            sb.append("allocatedResources:");
            sb.append(this.allocatedResources + ",");
        }
        if (this.allocatedResourcesStatus != null && !this.allocatedResourcesStatus.isEmpty()) {
            sb.append("allocatedResourcesStatus:");
            sb.append(this.allocatedResourcesStatus + ",");
        }
        if (this.containerID != null) {
            sb.append("containerID:");
            sb.append(this.containerID + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.imageID != null) {
            sb.append("imageID:");
            sb.append(this.imageID + ",");
        }
        if (this.lastState != null) {
            sb.append("lastState:");
            sb.append(this.lastState + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.ready != null) {
            sb.append("ready:");
            sb.append(this.ready + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.restartCount != null) {
            sb.append("restartCount:");
            sb.append(this.restartCount + ",");
        }
        if (this.started != null) {
            sb.append("started:");
            sb.append(this.started + ",");
        }
        if (this.state != null) {
            sb.append("state:");
            sb.append(this.state + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user + ",");
        }
        if (this.volumeMounts != null && !this.volumeMounts.isEmpty()) {
            sb.append("volumeMounts:");
            sb.append(this.volumeMounts);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withReady() {
        return this.withReady(true);
    }

    public A withStarted() {
        return this.withStarted(true);
    }

    public class AllocatedResourcesStatusNested<N>
    extends V1ResourceStatusFluent<AllocatedResourcesStatusNested<N>>
    implements Nested<N> {
        V1ResourceStatusBuilder builder;
        int index;

        AllocatedResourcesStatusNested(int index, V1ResourceStatus item) {
            this.index = index;
            this.builder = new V1ResourceStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerStatusFluent.this.setToAllocatedResourcesStatus(this.index, this.builder.build());
        }

        public N endAllocatedResourcesStatus() {
            return this.and();
        }
    }

    public class LastStateNested<N>
    extends V1ContainerStateFluent<LastStateNested<N>>
    implements Nested<N> {
        V1ContainerStateBuilder builder;

        LastStateNested(V1ContainerState item) {
            this.builder = new V1ContainerStateBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerStatusFluent.this.withLastState(this.builder.build());
        }

        public N endLastState() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends V1ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        V1ResourceRequirementsBuilder builder;

        ResourcesNested(V1ResourceRequirements item) {
            this.builder = new V1ResourceRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerStatusFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class StateNested<N>
    extends V1ContainerStateFluent<StateNested<N>>
    implements Nested<N> {
        V1ContainerStateBuilder builder;

        StateNested(V1ContainerState item) {
            this.builder = new V1ContainerStateBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerStatusFluent.this.withState(this.builder.build());
        }

        public N endState() {
            return this.and();
        }
    }

    public class UserNested<N>
    extends V1ContainerUserFluent<UserNested<N>>
    implements Nested<N> {
        V1ContainerUserBuilder builder;

        UserNested(V1ContainerUser item) {
            this.builder = new V1ContainerUserBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerStatusFluent.this.withUser(this.builder.build());
        }

        public N endUser() {
            return this.and();
        }
    }

    public class VolumeMountsNested<N>
    extends V1VolumeMountStatusFluent<VolumeMountsNested<N>>
    implements Nested<N> {
        V1VolumeMountStatusBuilder builder;
        int index;

        VolumeMountsNested(int index, V1VolumeMountStatus item) {
            this.index = index;
            this.builder = new V1VolumeMountStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerStatusFluent.this.setToVolumeMounts(this.index, this.builder.build());
        }

        public N endVolumeMount() {
            return this.and();
        }
    }
}

