/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1APIGroup;
import io.kubernetes.client.openapi.models.V1APIGroupBuilder;
import io.kubernetes.client.openapi.models.V1APIGroupFluent;
import io.kubernetes.client.openapi.models.V1APIGroupList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1APIGroupListFluent<A extends V1APIGroupListFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private ArrayList<V1APIGroupBuilder> groups;
    private String kind;

    public V1APIGroupListFluent() {
    }

    public V1APIGroupListFluent(V1APIGroupList instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1APIGroupList instance) {
        V1APIGroupList v1APIGroupList = instance = instance != null ? instance : new V1APIGroupList();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withGroups(instance.getGroups());
            this.withKind(instance.getKind());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToGroups(int index, V1APIGroup item) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
        if (index < 0 || index >= this.groups.size()) {
            this._visitables.get("groups").add(builder);
            this.groups.add(builder);
        } else {
            this._visitables.get("groups").add(index, builder);
            this.groups.add(index, builder);
        }
        return (A)this;
    }

    public A setToGroups(int index, V1APIGroup item) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
        if (index < 0 || index >= this.groups.size()) {
            this._visitables.get("groups").add(builder);
            this.groups.add(builder);
        } else {
            this._visitables.get("groups").set(index, builder);
            this.groups.set(index, builder);
        }
        return (A)this;
    }

    public A addToGroups(V1APIGroup ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        for (V1APIGroup item : items) {
            V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
            this._visitables.get("groups").add(builder);
            this.groups.add(builder);
        }
        return (A)this;
    }

    public A addAllToGroups(Collection<V1APIGroup> items) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        for (V1APIGroup item : items) {
            V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
            this._visitables.get("groups").add(builder);
            this.groups.add(builder);
        }
        return (A)this;
    }

    public A removeFromGroups(V1APIGroup ... items) {
        if (this.groups == null) {
            return (A)this;
        }
        for (V1APIGroup item : items) {
            V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
            this._visitables.get("groups").remove(builder);
            this.groups.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromGroups(Collection<V1APIGroup> items) {
        if (this.groups == null) {
            return (A)this;
        }
        for (V1APIGroup item : items) {
            V1APIGroupBuilder builder = new V1APIGroupBuilder(item);
            this._visitables.get("groups").remove(builder);
            this.groups.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromGroups(Predicate<V1APIGroupBuilder> predicate) {
        if (this.groups == null) {
            return (A)this;
        }
        Iterator<V1APIGroupBuilder> each = this.groups.iterator();
        Object visitables = this._visitables.get("groups");
        while (each.hasNext()) {
            V1APIGroupBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1APIGroup> buildGroups() {
        return this.groups != null ? V1APIGroupListFluent.build(this.groups) : null;
    }

    public V1APIGroup buildGroup(int index) {
        return this.groups.get(index).build();
    }

    public V1APIGroup buildFirstGroup() {
        return this.groups.get(0).build();
    }

    public V1APIGroup buildLastGroup() {
        return this.groups.get(this.groups.size() - 1).build();
    }

    public V1APIGroup buildMatchingGroup(Predicate<V1APIGroupBuilder> predicate) {
        for (V1APIGroupBuilder item : this.groups) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingGroup(Predicate<V1APIGroupBuilder> predicate) {
        for (V1APIGroupBuilder item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGroups(List<V1APIGroup> groups) {
        if (this.groups != null) {
            this._visitables.get("groups").clear();
        }
        if (groups != null) {
            this.groups = new ArrayList();
            for (V1APIGroup item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)this;
    }

    public A withGroups(V1APIGroup ... groups) {
        if (this.groups != null) {
            this.groups.clear();
            this._visitables.remove("groups");
        }
        if (groups != null) {
            for (V1APIGroup item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    public boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    public GroupsNested<A> addNewGroup() {
        return new GroupsNested(-1, null);
    }

    public GroupsNested<A> addNewGroupLike(V1APIGroup item) {
        return new GroupsNested(-1, item);
    }

    public GroupsNested<A> setNewGroupLike(int index, V1APIGroup item) {
        return new GroupsNested(index, item);
    }

    public GroupsNested<A> editGroup(int index) {
        if (this.groups.size() <= index) {
            throw new RuntimeException("Can't edit groups. Index exceeds size.");
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    public GroupsNested<A> editFirstGroup() {
        if (this.groups.size() == 0) {
            throw new RuntimeException("Can't edit first groups. The list is empty.");
        }
        return this.setNewGroupLike(0, this.buildGroup(0));
    }

    public GroupsNested<A> editLastGroup() {
        int index = this.groups.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last groups. The list is empty.");
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    public GroupsNested<A> editMatchingGroup(Predicate<V1APIGroupBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!predicate.test(this.groups.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching groups. No match found.");
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1APIGroupListFluent that = (V1APIGroupListFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.groups, that.groups)) {
            return false;
        }
        return Objects.equals(this.kind, that.kind);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.groups, this.kind, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            sb.append("groups:");
            sb.append(this.groups + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
        }
        sb.append("}");
        return sb.toString();
    }

    public class GroupsNested<N>
    extends V1APIGroupFluent<GroupsNested<N>>
    implements Nested<N> {
        V1APIGroupBuilder builder;
        int index;

        GroupsNested(int index, V1APIGroup item) {
            this.index = index;
            this.builder = new V1APIGroupBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1APIGroupListFluent.this.setToGroups(this.index, this.builder.build());
        }

        public N endGroup() {
            return this.and();
        }
    }
}

