/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.test;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.hypersistence.utils.common.ReflectionUtils;
import io.hypersistence.utils.logging.InlineQueryLogEntryCreator;
import io.hypersistence.utils.test.providers.DataSourceProvider;
import io.hypersistence.utils.test.providers.DataSourceProviderSupplier;
import io.hypersistence.utils.test.transaction.ConnectionTransactionConsumer;
import io.hypersistence.utils.test.transaction.ConnectionTransactionFunction;
import io.hypersistence.utils.test.transaction.EntityManagerTransactionConsumer;
import io.hypersistence.utils.test.transaction.EntityManagerTransactionFunction;
import io.hypersistence.utils.test.transaction.SessionTransactionConsumer;
import io.hypersistence.utils.test.transaction.SessionTransactionFunction;
import io.hypersistence.utils.test.transaction.VoidCallable;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.listener.ChainListener;
import net.ttddyy.dsproxy.listener.DataSourceQueryCountListener;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.listener.logging.QueryLogEntryCreator;
import net.ttddyy.dsproxy.listener.logging.SLF4JQueryLoggingListener;
import net.ttddyy.dsproxy.support.ProxyDataSourceBuilder;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitNamingStrategyLegacyJpaImpl;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Database;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.internal.EntityManagerFactoryBuilderImpl;
import org.hibernate.jpa.boot.internal.PersistenceUnitInfoDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.usertype.UserType;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHibernateTest {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final ServiceLoader<DataSourceProviderSupplier> DATA_SOURCE_PROVIDER_FACTORIES = ServiceLoader.load(DataSourceProviderSupplier.class);
    public static Map<Database, DataSourceProvider> dataSourceProviderMap;
    protected final ExecutorService executorService = Executors.newSingleThreadExecutor(r -> {
        Thread bob = new Thread(r);
        bob.setName("Bob");
        return bob;
    });
    private Database database = Database.HSQL;
    private DataSource dataSource;
    private EntityManagerFactory emf;
    private SessionFactory sf;
    private List<Closeable> closeables = new ArrayList<Closeable>();

    @Before
    public void init() {
        this.beforeInit();
        if (this.nativeHibernateSessionFactoryBootstrap()) {
            this.sf = this.newSessionFactory();
        } else {
            this.emf = this.newEntityManagerFactory();
        }
        this.afterInit();
    }

    protected void beforeInit() {
    }

    protected void afterInit() {
    }

    @After
    public void destroy() {
        if (this.nativeHibernateSessionFactoryBootstrap()) {
            this.sf.close();
        } else {
            this.emf.close();
        }
        for (Closeable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.LOGGER.error("Failure", (Throwable)e);
            }
        }
        this.closeables.clear();
    }

    public EntityManagerFactory entityManagerFactory() {
        return this.nativeHibernateSessionFactoryBootstrap() ? this.sf : this.emf;
    }

    public SessionFactory sessionFactory() {
        if (this.nativeHibernateSessionFactoryBootstrap()) {
            return this.sf;
        }
        EntityManagerFactory entityManagerFactory = this.entityManagerFactory();
        if (entityManagerFactory == null) {
            return null;
        }
        return (SessionFactory)entityManagerFactory.unwrap(SessionFactory.class);
    }

    protected boolean nativeHibernateSessionFactoryBootstrap() {
        return false;
    }

    protected Class<?>[] entities() {
        return new Class[0];
    }

    protected List<String> entityClassNames() {
        return Arrays.asList(this.entities()).stream().map(Class::getName).collect(Collectors.toList());
    }

    protected String[] packages() {
        return null;
    }

    protected String[] resources() {
        return null;
    }

    protected Interceptor interceptor() {
        return null;
    }

    private SessionFactory newSessionFactory() {
        String[] resources;
        BootstrapServiceRegistryBuilder bsrb = new BootstrapServiceRegistryBuilder().enableAutoClose();
        Integrator integrator = this.integrator();
        if (integrator != null) {
            bsrb.applyIntegrator(integrator);
        }
        BootstrapServiceRegistry bsr = bsrb.build();
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder(bsr).applySettings(this.properties()).build();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry);
        for (Class<?> annotatedClass : this.entities()) {
            metadataSources.addAnnotatedClass(annotatedClass);
        }
        String[] packages = this.packages();
        if (packages != null) {
            for (String annotatedPackage : packages) {
                metadataSources.addPackage(annotatedPackage);
            }
        }
        if ((resources = this.resources()) != null) {
            for (String resource : resources) {
                metadataSources.addResource(resource);
            }
        }
        MetadataBuilder metadataBuilder = metadataSources.getMetadataBuilder();
        metadataBuilder.applyImplicitNamingStrategy((ImplicitNamingStrategy)ImplicitNamingStrategyLegacyJpaImpl.INSTANCE);
        List<?> additionalTypes = this.additionalTypes();
        if (additionalTypes != null) {
            additionalTypes.stream().forEach(type -> metadataBuilder.applyTypes((typeContributions, serviceRegistry1) -> {
                if (type instanceof BasicType) {
                    typeContributions.contributeType((BasicType)type);
                } else if (type instanceof UserType) {
                    typeContributions.contributeType((UserType)type);
                }
            }));
        }
        MetadataImplementor metadata = (MetadataImplementor)metadataBuilder.build();
        SessionFactoryBuilder sfb = metadata.getSessionFactoryBuilder();
        Interceptor interceptor = this.interceptor();
        if (interceptor != null) {
            sfb.applyInterceptor(interceptor);
        }
        return sfb.build();
    }

    protected EntityManagerFactory newEntityManagerFactory() {
        List<?> additionalTypes;
        PersistenceUnitInfoImpl persistenceUnitInfo = this.persistenceUnitInfo(this.getClass().getSimpleName());
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("hibernate.session_factory.interceptor", this.interceptor());
        Integrator integrator = this.integrator();
        if (integrator != null) {
            configuration.put("hibernate.integrator_provider", () -> Collections.singletonList(integrator));
        }
        if ((additionalTypes = this.additionalTypes()) != null) {
            configuration.put("hibernate.type_contributors", () -> {
                ArrayList<TypeContributor> typeContributors = new ArrayList<TypeContributor>();
                for (Object additionalType : additionalTypes) {
                    if (additionalType instanceof BasicType) {
                        typeContributors.add((typeContributions, serviceRegistry) -> typeContributions.contributeType((BasicType)additionalType));
                        continue;
                    }
                    if (!(additionalType instanceof UserType)) continue;
                    typeContributors.add((typeContributions, serviceRegistry) -> typeContributions.contributeType((UserType)additionalType));
                }
                return typeContributors;
            });
        }
        EntityManagerFactoryBuilderImpl entityManagerFactoryBuilder = new EntityManagerFactoryBuilderImpl((PersistenceUnitDescriptor)new PersistenceUnitInfoDescriptor((PersistenceUnitInfo)persistenceUnitInfo), configuration);
        return entityManagerFactoryBuilder.build();
    }

    protected Integrator integrator() {
        return null;
    }

    protected PersistenceUnitInfoImpl persistenceUnitInfo(String name) {
        PersistenceUnitInfoImpl persistenceUnitInfo = new PersistenceUnitInfoImpl(name, this.entityClassNames(), this.properties());
        String[] resources = this.resources();
        if (resources != null) {
            persistenceUnitInfo.getMappingFileNames().addAll(Arrays.asList(resources));
        }
        return persistenceUnitInfo;
    }

    protected Properties properties() {
        Properties properties = new Properties();
        properties.put("hibernate.dialect", this.dataSourceProvider().hibernateDialect());
        properties.put("hibernate.hbm2ddl.auto", "create-drop");
        DataSource dataSource = this.newDataSource();
        if (dataSource != null) {
            properties.put("hibernate.connection.datasource", dataSource);
        }
        properties.put("hibernate.cache.ehcache.missing_cache_strategy", "create");
        this.additionalProperties(properties);
        return properties;
    }

    protected Dialect dialect() {
        SessionFactory sessionFactory = this.sessionFactory();
        return sessionFactory != null ? ((SessionFactoryImplementor)sessionFactory.unwrap(SessionFactoryImplementor.class)).getJdbcServices().getDialect() : (Dialect)ReflectionUtils.newInstance(this.dataSourceProvider().hibernateDialect());
    }

    protected void additionalProperties(Properties properties) {
    }

    protected DataSource dataSource() {
        if (this.dataSource == null) {
            this.dataSource = this.newDataSource();
        }
        return this.dataSource;
    }

    protected DataSource newDataSource() {
        DataSource dataSource = this.dataSourceProvider().dataSource();
        if (this.proxyDataSource()) {
            ChainListener listener = new ChainListener();
            SLF4JQueryLoggingListener loggingListener = new SLF4JQueryLoggingListener();
            loggingListener.setQueryLogEntryCreator((QueryLogEntryCreator)new InlineQueryLogEntryCreator());
            listener.addListener((QueryExecutionListener)loggingListener);
            listener.addListener((QueryExecutionListener)new DataSourceQueryCountListener());
            dataSource = ProxyDataSourceBuilder.create((DataSource)dataSource).name("DATA_SOURCE_PROXY").listener((QueryExecutionListener)listener).build();
        }
        if (this.connectionPooling()) {
            HikariDataSource poolingDataSource = this.connectionPoolDataSource(dataSource);
            this.closeables.add(() -> ((HikariDataSource)poolingDataSource).close());
            return poolingDataSource;
        }
        return dataSource;
    }

    protected boolean proxyDataSource() {
        return true;
    }

    protected HikariDataSource connectionPoolDataSource(DataSource dataSource) {
        return new HikariDataSource(this.hikariConfig(dataSource));
    }

    protected HikariConfig hikariConfig(DataSource dataSource) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setMaximumPoolSize(this.connectionPoolSize());
        hikariConfig.setDataSource(dataSource);
        return hikariConfig;
    }

    protected boolean connectionPooling() {
        return false;
    }

    protected int connectionPoolSize() {
        int cpuCores = Runtime.getRuntime().availableProcessors();
        return cpuCores * 4;
    }

    protected Database database() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    protected DataSourceProvider dataSourceProvider() {
        return dataSourceProviderMap.get(this.database());
    }

    protected List<?> additionalTypes() {
        return null;
    }

    protected <T> T doInHibernate(SessionTransactionFunction<T> callable) {
        Object result;
        Session session = null;
        Transaction txn = null;
        try {
            session = this.sessionFactory().openSession();
            callable.beforeTransactionCompletion();
            txn = session.beginTransaction();
            result = callable.apply(session);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            callable.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
        return (T)result;
    }

    protected void doInHibernate(SessionTransactionConsumer callable) {
        Session session = null;
        Transaction txn = null;
        try {
            session = this.sessionFactory().openSession();
            callable.beforeTransactionCompletion();
            txn = session.beginTransaction();
            callable.accept(session);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            callable.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
    }

    protected <T> T doInJPA(EntityManagerTransactionFunction<T> function) {
        T result = null;
        EntityManager entityManager = null;
        EntityTransaction txn = null;
        try {
            entityManager = this.entityManagerFactory().createEntityManager();
            function.beforeTransactionCompletion();
            txn = entityManager.getTransaction();
            txn.begin();
            result = (T)function.apply(entityManager);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            function.afterTransactionCompletion();
            if (entityManager != null) {
                entityManager.close();
            }
        }
        return result;
    }

    protected void doInJPA(EntityManagerTransactionConsumer function) {
        EntityManager entityManager = null;
        EntityTransaction txn = null;
        try {
            entityManager = this.entityManagerFactory().createEntityManager();
            function.beforeTransactionCompletion();
            txn = entityManager.getTransaction();
            txn.begin();
            function.accept(entityManager);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            function.afterTransactionCompletion();
            if (entityManager != null) {
                entityManager.close();
            }
        }
    }

    protected <T> T doInJDBC(ConnectionTransactionFunction<T> function) {
        AtomicReference result = new AtomicReference();
        Session session = null;
        Transaction txn = null;
        try {
            session = this.sessionFactory().openSession();
            function.beforeTransactionCompletion();
            txn = session.beginTransaction();
            session.doWork(connection -> result.set(function.execute(connection)));
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            function.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
        return (T)result.get();
    }

    protected void doInJDBC(ConnectionTransactionConsumer function) {
        Session session = null;
        Transaction txn = null;
        try {
            session = this.sessionFactory().openSession();
            function.beforeTransactionCompletion();
            txn = session.beginTransaction();
            session.doWork(function::execute);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    this.LOGGER.error("Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            function.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
    }

    protected void executeSync(VoidCallable callable) {
        try {
            List futures = this.executorService.invokeAll(Collections.singleton(callable));
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> T executeSync(Callable<T> callable) {
        try {
            return this.executorService.submit(callable).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected void awaitOnLatch(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String stringValue(Object value) {
        return value.toString();
    }

    public static int intValue(Object number) {
        return ((Number)number).intValue();
    }

    public static long longValue(Object number) {
        if (number instanceof String) {
            return Long.parseLong((String)number);
        }
        return ((Number)number).longValue();
    }

    public static double doubleValue(Object number) {
        return ((Number)number).doubleValue();
    }

    public static URL urlValue(String url) {
        try {
            return url != null ? new URL(url) : null;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static LocalDateTime localDateTimeValue(Object value) {
        return (LocalDateTime)value;
    }

    protected void executeStatement(String sql) {
        try (Connection connection = this.dataSource().getConnection();
             Statement statement = connection.createStatement();){
            statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.LOGGER.error("Statement failed", (Throwable)e);
        }
    }

    static {
        for (DataSourceProviderSupplier factory : DATA_SOURCE_PROVIDER_FACTORIES) {
            if (dataSourceProviderMap == null) {
                dataSourceProviderMap = (Map)factory.get();
                continue;
            }
            throw new IllegalStateException("Multiple DataSourceProviderFactory instances found!");
        }
        Thread.currentThread().setName("Alice");
    }

    public static class PersistenceUnitInfoImpl
    implements PersistenceUnitInfo {
        private final String persistenceUnitName;
        private final List<String> managedClassNames;
        private final List<String> mappingFileNames = new ArrayList<String>();
        private final Properties properties;
        private PersistenceUnitTransactionType transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        private DataSource jtaDataSource;
        private DataSource nonJtaDataSource;

        public PersistenceUnitInfoImpl(String persistenceUnitName, List<String> managedClassNames, Properties properties) {
            this.persistenceUnitName = persistenceUnitName;
            this.managedClassNames = managedClassNames;
            this.properties = properties;
        }

        public String getPersistenceUnitName() {
            return this.persistenceUnitName;
        }

        public String getPersistenceProviderClassName() {
            return HibernatePersistenceProvider.class.getName();
        }

        public PersistenceUnitTransactionType getTransactionType() {
            return this.transactionType;
        }

        public DataSource getJtaDataSource() {
            return this.jtaDataSource;
        }

        public PersistenceUnitInfoImpl setJtaDataSource(DataSource jtaDataSource) {
            this.jtaDataSource = jtaDataSource;
            this.nonJtaDataSource = null;
            this.transactionType = PersistenceUnitTransactionType.JTA;
            return this;
        }

        public DataSource getNonJtaDataSource() {
            return this.nonJtaDataSource;
        }

        public PersistenceUnitInfoImpl setNonJtaDataSource(DataSource nonJtaDataSource) {
            this.nonJtaDataSource = nonJtaDataSource;
            this.jtaDataSource = null;
            this.transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
            return this;
        }

        public List<String> getMappingFileNames() {
            return this.mappingFileNames;
        }

        public List<URL> getJarFileUrls() {
            return Collections.emptyList();
        }

        public URL getPersistenceUnitRootUrl() {
            return null;
        }

        public List<String> getManagedClassNames() {
            return this.managedClassNames;
        }

        public boolean excludeUnlistedClasses() {
            return false;
        }

        public SharedCacheMode getSharedCacheMode() {
            return SharedCacheMode.UNSPECIFIED;
        }

        public ValidationMode getValidationMode() {
            return ValidationMode.AUTO;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public String getPersistenceXMLSchemaVersion() {
            return "2.1";
        }

        public ClassLoader getClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }

        public void addTransformer(ClassTransformer transformer) {
        }

        public ClassLoader getNewTempClassLoader() {
            return null;
        }
    }
}

